/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.xmlmeta;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareDialog;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.compare.MapCompareBuilder;
import oracle.dbtools.crest.model.metadata.compare.MetaMapSelection;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertiesComparator;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertyHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.compare.xmlmeta.MetaMapCheckEditor;
import oracle.dbtools.crest.swingui.compare.xmlmeta.MetaMapRenderer;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.compare.CompareOptions;

public class XMLMetadataComparator
extends CustomDialog
implements TreeSelectionListener,
TreeExpansionListener,
AdjustmentListener {
    private static final String PROPERTY_X = "x";
    private static final String PROPERTY_Y = "y";
    private static final String PROPERTY_W = "w";
    private static final String PROPERTY_H = "h";
    private static final String PROPERTY_HPOS = "hpos";
    private static final String PROPERTY_VPOS = "vpos";
    private JPanel leftTreePanel;
    private JPanel rightTreePanel;
    private CompareTreeNavigationDesign leftNavDesign;
    private CompareTreeNavigationDesign rightNavDesign;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JScrollPane detailsSP;
    private MyJTree leftTree;
    private MyJTree rightTree;
    private JTable compareTable = new JTable();
    private SelectedCellRenderer selRenderer = new SelectedCellRenderer();
    private ModifiableCellRenderer propertyNamerenderer = new ModifiableCellRenderer();
    private ValueCellRenderer colorPropertyRenderer = new ValueCellRenderer();
    private JDialog dialog;
    private JPanel buttonPanel;
    private List eList;
    private int counter = 0;
    private JButton button;
    JCheckBoxMenuItem item = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowAllObjects"));
    JCheckBoxMenuItem item1 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowNewObjects"));
    JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowDeletedObjects"));
    JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowModifiedObjects"));
    private JPopupMenu menu;
    private JButton bnMerge;
    private JScrollBar leftSB;
    private JScrollBar rightSB;
    private MapCompareBuilder mcb;
    private JSplitPane vsp;
    private JSplitPane hsp;
    private Map mergedMap = null;
    private boolean mergeEnabled;
    private static final Logger LOGGER = new Logger(XMLMetadataComparator.class);
    MyJTree startTree = null;
    boolean started = false;
    boolean sb_started = false;
    boolean sel_started = false;
    List list = new ArrayList();

    public XMLMetadataComparator(Design design, StorageDesign storageDesign, InputStream leftStream, String leftRevision, InputStream rightStream, String rightRevision, boolean mergeEnabled) {
        super(ApplicationView.getInstance());
        this.mergeEnabled = mergeEnabled;
        try {
            this.mcb = new MapCompareBuilder(design, storageDesign, leftStream, leftRevision, rightStream, rightRevision);
            this.initLeftTreePanel(this.mcb.getLeftRoot());
            this.initRightTreePanel(this.mcb.getRightRoot());
            this.leftTreePanel.setPreferredSize(new Dimension(350, 400));
            this.rightTreePanel.setPreferredSize(new Dimension(350, 400));
            this.leftTreePanel.setMinimumSize(new Dimension(350, 200));
            this.rightTreePanel.setMinimumSize(new Dimension(350, 200));
            this.tabbedPane.setPreferredSize(new Dimension(700, 200));
            this.detailsSP = new JScrollPane(this.compareTable);
            this.compareTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int col;
                    if (e.getClickCount() == 2 && ((col = XMLMetadataComparator.this.compareTable.getSelectedColumn()) == 2 || col == 3)) {
                        String rightValue;
                        String leftValue;
                        int row = XMLMetadataComparator.this.compareTable.getSelectedRow();
                        CompareModel cm = (CompareModel)XMLMetadataComparator.this.compareTable.getModel();
                        MetaPropertyHolder ph = cm.getPropertyHolder(row);
                        ClassDescription.PropertyDescription pd = ph.getPropertyDescription();
                        String name = ph.getPresentationName();
                        boolean readonly = true;
                        if (pd != null && pd.isMergeCompare) {
                            leftValue = ph.getLeftValue();
                            rightValue = ph.getRightValue();
                            readonly = false;
                        } else {
                            leftValue = ph.getLeftValuePresentation();
                            rightValue = ph.getRightValue();
                        }
                        if (!"".equalsIgnoreCase(leftValue) || !"".equalsIgnoreCase(rightValue)) {
                            CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences()).setShowCharDifferences(true);
                            InputStream leftText = XMLMetadataComparator.this.getStream(leftValue);
                            InputStream rightText = XMLMetadataComparator.this.getStream(rightValue);
                            VCSTextCompareDialog dialog = new VCSTextCompareDialog(XMLMetadataComparator.this.getDialog(), null, leftText, "left", rightText, "right", true, readonly);
                            dialog.setTitle(name);
                            dialog.setVisible(true);
                            if (pd != null && pd.isMergeCompare && dialog.isOk()) {
                                String rtext = "";
                                ph.setRightValue(rtext);
                                ph.setMerged(true);
                                XMLMetadataComparator.this.compareTable.updateUI();
                            }
                        }
                    }
                }
            });
            this.detailsSP.setPreferredSize(new Dimension(700, 200));
            this.hsp = new JSplitPane(1);
            this.hsp.setLeftComponent(this.leftTreePanel);
            this.hsp.setRightComponent(this.rightTreePanel);
            this.hsp.setDividerLocation(-1);
            this.hsp.setResizeWeight(0.5);
            this.vsp = new JSplitPane(0, this.hsp, this.tabbedPane);
            this.initToolbar();
            this.add((Component)this.vsp, "Center");
            this.tabbedPane.add(Messages.getString("CompareModelsDialog.Details"), this.detailsSP);
            this.add((Component)this.getButtonPanel(), "South");
        }
        catch (Exception e) {
            LOGGER.error("XMLMetadataComparator:", e);
        }
    }

    private void initToolbar() {
        JPanel filterPanel = new JPanel(new FlowLayout(0));
        this.button = new JButton(Messages.getString("CompareModelsDialog.Filter"));
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu = XMLMetadataComparator.this.getPopupMenu();
                menu.show(XMLMetadataComparator.this.button, e.getPoint().x, e.getPoint().y);
            }
        });
        this.button.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        filterPanel.add(this.button);
        this.add((Component)filterPanel, "North");
    }

    private void setFilter(JTree tree, EngFilter filter) {
        MetaMapSelection rightRoot = (MetaMapSelection)tree.getModel().getRoot();
        rightRoot.setFilter(filter);
    }

    private JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.item.addActionListener(new ShowAllListener());
            this.item.setSelected(true);
            this.item.setEnabled(false);
            PopupMenuListener popupListener = new PopupMenuListener();
            this.item1.addActionListener(popupListener);
            this.item2.addActionListener(popupListener);
            this.item3.addActionListener(popupListener);
            this.menu.add(this.item);
            this.menu.add(this.item1);
            this.menu.add(this.item2);
            this.menu.add(this.item3);
        }
        return this.menu;
    }

    private void initLeftTreePanel(ModelIdObjectSelection root) {
        this.leftTreePanel = new JPanel(new BorderLayout());
        this.leftTree = new MyJTree();
        this.leftTree.setEditable(true);
        MetaMapRenderer renderer = new MetaMapRenderer(true);
        this.leftTree.setCellRenderer(renderer);
        MetaMapCheckEditor editor = new MetaMapCheckEditor(true);
        this.leftTree.setCellEditor(editor);
        JScrollPane jsp = new JScrollPane(this.leftTree);
        this.leftTreePanel.add((Component)jsp, "Center");
        this.leftTree.addTreeSelectionListener(this);
        this.leftTree.addTreeExpansionListener(this);
        this.leftSB = jsp.getVerticalScrollBar();
        this.leftSB.addAdjustmentListener(this);
        if (root != null) {
            this.resetLeftTree(root);
        } else {
            this.resetLeftTree(new CompareObjectSelection("Missing"));
        }
    }

    private void resetLeftTree(ModelIdObjectSelection root) {
        this.leftNavDesign = new CompareTreeNavigationDesign(root);
        this.leftTree.setModel(this.leftNavDesign);
    }

    private void initRightTreePanel(ModelIdObjectSelection root) {
        this.rightTreePanel = new JPanel(new BorderLayout());
        this.rightTree = new MyJTree();
        MetaMapRenderer renderer = new MetaMapRenderer(false);
        renderer.setShowCheckbox(false);
        this.rightTree.setCellRenderer(renderer);
        JScrollPane jsp = new JScrollPane(this.rightTree);
        this.rightTreePanel.add((Component)jsp, "Center");
        this.rightTree.addTreeSelectionListener(this);
        this.rightTree.addTreeExpansionListener(this);
        this.rightSB = jsp.getVerticalScrollBar();
        this.rightSB.addAdjustmentListener(this);
        if (root != null) {
            this.resetRightTree(root);
        } else {
            this.resetRightTree(new CompareObjectSelection("Missing"));
        }
    }

    private void resetRightTree(ModelIdObjectSelection root) {
        this.rightNavDesign = new CompareTreeNavigationDesign(root);
        this.rightTree.setModel(this.rightNavDesign);
    }

    private void unregisterListeners() {
        if (this.leftNavDesign != null) {
            this.leftNavDesign.unregisterAsListener();
        }
        if (this.rightNavDesign != null) {
            this.rightNavDesign.unregisterAsListener();
        }
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.synchroizeSelection(e);
        TreePath path = e.getPath();
        Object object = path.getLastPathComponent();
        if (object instanceof MetaMapSelection) {
            int[] wide = new int[]{0, 0, 0, 0};
            boolean exists = this.compareTable.getColumnModel() != null;
            int count = 4;
            if (exists) {
                count = this.compareTable.getColumnModel().getColumnCount();
                for (int i = 0; i < count; ++i) {
                    wide[i] = this.compareTable.getColumnModel().getColumn(i).getWidth();
                }
            }
            MetaPropertiesComparator pc = ((MetaMapSelection)object).getPropertiesComparator();
            this.compareTable.setModel(new CompareModel(pc));
            this.compareTable.getColumnModel().getColumn(1);
            TableColumn column = this.compareTable.getColumnModel().getColumn(1);
            column.setPreferredWidth(60);
            column.setWidth(60);
            column.setMaxWidth(70);
            column.setCellRenderer(this.selRenderer);
            column = this.compareTable.getColumnModel().getColumn(0);
            column.setCellRenderer(this.propertyNamerenderer);
            column = this.compareTable.getColumnModel().getColumn(2);
            column.setCellRenderer(this.colorPropertyRenderer);
            column = this.compareTable.getColumnModel().getColumn(3);
            column.setCellRenderer(this.colorPropertyRenderer);
            if (exists) {
                for (int i = 0; i < count; ++i) {
                    this.compareTable.getColumnModel().getColumn(i).setWidth(wide[i]);
                    this.compareTable.getColumnModel().getColumn(i).setPreferredWidth(wide[i]);
                }
            }
            this.compareTable.updateUI();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.processExpEvent(event, false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.processExpEvent(event, true);
    }

    void processExpEvent(TreeExpansionEvent event, boolean state) {
        Object source = event.getSource();
        if (source instanceof JTree && !this.started) {
            this.startTree = (MyJTree)source;
            this.started = true;
            TreePath tp = event.getPath();
            MetaMapSelection os = (MetaMapSelection)tp.getLastPathComponent();
            MyJTree other = this.getOtherTree(this.startTree);
            other.setExpandedState(new TreePath(os.getCorrespondentNode().getPath()), state);
            this.started = false;
        }
    }

    MyJTree getOtherTree(JTree tree) {
        if (tree == this.leftTree) {
            return this.rightTree;
        }
        return this.leftTree;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        if (source instanceof JScrollBar && !this.sb_started) {
            JScrollBar jsb = (JScrollBar)source;
            if (jsb == this.leftSB) {
                this.sb_started = true;
                this.rightSB.setValue(this.leftSB.getValue());
                this.sb_started = false;
            } else if (jsb == this.rightSB) {
                this.sb_started = true;
                this.leftSB.setValue(this.rightSB.getValue());
                this.sb_started = false;
            }
        }
    }

    private void synchroizeSelection(TreeSelectionEvent event) {
        Object source = event.getSource();
        if (source instanceof JTree && !this.sel_started) {
            this.startTree = (MyJTree)source;
            this.sel_started = true;
            TreePath tp = event.getPath();
            MetaMapSelection os = (MetaMapSelection)tp.getLastPathComponent();
            MyJTree other = this.getOtherTree(this.startTree);
            other.setSelectionPath(new TreePath(os.getCorrespondentNode().getPath()));
            this.sel_started = false;
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("XMLMetadataComparator.XMLMetadataComparator"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addWindowListener(new ClosingListener());
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = XMLMetadataComparator.this.dialog.getWidth();
                    int h = XMLMetadataComparator.this.dialog.getHeight();
                    w = Math.max(720, w);
                    h = Math.max(600, h);
                    XMLMetadataComparator.this.dialog.setSize(w, h);
                }
            });
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            Map map = this.getDesign().getAppView().getSettings().getCustomSettings(this.getClass().getName());
            if (map != null) {
                try {
                    int x = Integer.parseInt((String)map.get(PROPERTY_X));
                    int y = Integer.parseInt((String)map.get(PROPERTY_Y));
                    int w = Integer.parseInt((String)map.get(PROPERTY_W));
                    int h = Integer.parseInt((String)map.get(PROPERTY_H));
                    int hpos = Integer.parseInt((String)map.get(PROPERTY_HPOS));
                    int vpos = Integer.parseInt((String)map.get(PROPERTY_VPOS));
                    Rectangle rectangle = this.getDesign().getAppView().getSettings().fixScreenLocation(x, y, w, h);
                    if (rectangle == null) {
                        this.dialog.setSize(720, 600);
                        CommonUtil.centerOnScreen(this.dialog);
                    } else {
                        this.dialog.setSize(rectangle.getSize());
                        this.dialog.setLocation(rectangle.getLocation());
                    }
                    this.hsp.setDividerLocation(hpos);
                    this.vsp.setDividerLocation(vpos);
                }
                catch (Exception exception) {}
            } else {
                this.dialog.setSize(720, 600);
                CommonUtil.centerOnScreen(this.dialog);
            }
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        if (this.hsp != null && this.vsp != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PROPERTY_X, String.valueOf(this.getDialog().getLocation().x));
            map.put(PROPERTY_Y, String.valueOf(this.getDialog().getLocation().y));
            map.put(PROPERTY_W, String.valueOf(this.getDialog().getSize().width));
            map.put(PROPERTY_H, String.valueOf(this.getDialog().getSize().height));
            map.put(PROPERTY_HPOS, String.valueOf(this.hsp.getDividerLocation()));
            map.put(PROPERTY_VPOS, String.valueOf(this.vsp.getDividerLocation()));
            this.getDesign().getAppView().getSettings().setCustomSettings(this.getClass().getName(), map);
        }
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "XML_METADATA_COMPARATOR_DIALOG";
    }

    public void setModal(boolean modal) {
        ((JDialog)this.getDialog()).setModal(modal);
    }

    @Override
    public void show() {
        this.getDialog().setVisible(true);
    }

    public Map showModal() {
        try {
            this.setModal(true);
            this.show();
            Map map = this.getMergedMap();
            return map;
        }
        finally {
            this.setModal(false);
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.bnMerge = new JButton(Messages.getString("CompareModelsDialog.Merge"));
            this.bnMerge.setMnemonic(77);
            this.bnMerge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XMLMetadataComparator.this.merge();
                    XMLMetadataComparator.this.close();
                }
            });
            JButton bnCancel = new JButton("Close");
            bnCancel.setMnemonic(67);
            bnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XMLMetadataComparator.this.mergedMap = null;
                    XMLMetadataComparator.this.close();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setMnemonic(72);
            this.bnMerge.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(this.bnMerge);
            this.buttonPanel.add(bnCancel);
            this.buttonPanel.add(bnHelp);
            this.bnMerge.setEnabled(this.mergeEnabled);
        }
        return this.buttonPanel;
    }

    public void enableMergeButton(boolean enable) {
    }

    protected int generateNumber() {
        int newNumber = 0;
        int lastNumber = this.eList.size();
        if (lastNumber != 0) {
            newNumber = this.counter = lastNumber + 1;
        } else {
            ++this.counter;
            newNumber = this.counter;
        }
        while (this.numberExists(newNumber)) {
            newNumber = ++this.counter;
        }
        return newNumber;
    }

    private boolean numberExists(int number) {
        for (int i = 0; i < this.eList.size(); ++i) {
            DDLException ddlException = (DDLException)this.eList.get(i);
            if (number != ddlException.getNumber()) continue;
            return true;
        }
        return false;
    }

    protected JPanel createRow(String label, String value, JTextField textField) {
        JPanel newRow = new JPanel(new BorderLayout());
        JLabel caption = new JLabel(label);
        caption.setPreferredSize(new Dimension(110, 20));
        textField.setPreferredSize(new Dimension(250, 20));
        textField.setText(value);
        newRow.add((Component)caption, "West");
        newRow.add(textField);
        return newRow;
    }

    private void merge() {
        this.mcb.mergeToRightMap();
        this.mergedMap = this.mcb.getRightMap();
    }

    public Map getMergedMap() {
        return this.mergedMap;
    }

    public Map getLeftMap() {
        return this.mcb.getLefttMap();
    }

    private InputStream getStream(String text) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            is = new ByteArrayInputStream(text.getBytes());
        }
        return is;
    }

    class SelectedCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        SelectedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            if (table.getModel() instanceof CompareModel) {
                CompareModel cm = (CompareModel)table.getModel();
                EngPropertyHolder ph = (EngPropertyHolder)cm.getPropertiesList().get(row);
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(val);
                if (ph.isModified()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    class ModifiableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ModifiableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (table.getModel() instanceof CompareModel) {
                CompareModel cm = (CompareModel)table.getModel();
                MetaPropertyHolder ph = (MetaPropertyHolder)cm.getPropertiesList().get(row);
                this.setOpaque(true);
                this.setText(ph.getPresentationName());
                if (ph.isModified()) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(table.getForeground());
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    if (!ph.isModified()) {
                        this.setForeground(table.getSelectionForeground());
                    }
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class ValueCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (table.getModel() instanceof CompareModel) {
                boolean process;
                int color;
                CompareModel cm = (CompareModel)table.getModel();
                MetaPropertyHolder ph = cm.getPropertyHolder(row);
                ClassDescription.PropertyDescription pd = ph.getPropertyDescription();
                this.setOpaque(true);
                if (col == 2) {
                    this.setText(ph.getLeftValuePresentation());
                } else if (col == 3) {
                    this.setText(ph.getRightValuePresentation());
                }
                if (ph.isColorProperty()) {
                    color = 0;
                    process = true;
                    if (col == 2) {
                        try {
                            color = Integer.parseInt(ph.getLeftValue());
                        }
                        catch (Exception e) {
                            process = false;
                        }
                    } else if (col == 3) {
                        try {
                            color = Integer.parseInt(ph.getRightValue());
                        }
                        catch (Exception e) {
                            process = false;
                        }
                    }
                    if (process) {
                        this.setForeground(new Color(color, true));
                    }
                } else {
                    this.setForeground(table.getForeground());
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    if (ph.isColorProperty()) {
                        color = 0;
                        process = true;
                        if (col == 2) {
                            try {
                                color = Integer.parseInt(ph.getLeftValue());
                            }
                            catch (Exception e) {
                                process = false;
                            }
                        } else if (col == 3) {
                            try {
                                color = Integer.parseInt(ph.getRightValue());
                            }
                            catch (Exception e) {
                                process = false;
                            }
                        }
                        if (process) {
                            this.setForeground(new Color(color, true));
                        }
                    }
                } else {
                    this.setBackground(table.getBackground());
                }
                if (col == 3 && pd != null && pd.isMergeCompare && ph.isModified()) {
                    if (ph.isMerged()) {
                        if (isSelected) {
                            this.setForeground(Color.WHITE);
                        } else {
                            this.setForeground(Color.BLUE);
                        }
                    } else {
                        this.setForeground(Color.RED);
                    }
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class MyJTree
    extends JTree {
        public MyJTree(TreeModel model) {
            super(model);
        }

        public MyJTree() {
        }

        @Override
        protected void setExpandedState(TreePath path, boolean state) {
            super.setExpandedState(path, state);
        }
    }

    class ShowAllListener
    implements ActionListener {
        ShowAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (XMLMetadataComparator.this.item.isSelected()) {
                XMLMetadataComparator.this.item.setEnabled(false);
                XMLMetadataComparator.this.item1.setSelected(false);
                XMLMetadataComparator.this.item2.setSelected(false);
                XMLMetadataComparator.this.item3.setSelected(false);
                EngFilter filter = new EngFilter();
                filter.addFilter(EngFilter.NO_FILTER);
                XMLMetadataComparator.this.setFilter(XMLMetadataComparator.this.leftTree, filter);
                XMLMetadataComparator.this.setFilter(XMLMetadataComparator.this.rightTree, filter);
                XMLMetadataComparator.this.leftTree.updateUI();
                XMLMetadataComparator.this.rightTree.updateUI();
            } else {
                XMLMetadataComparator.this.item.setEnabled(true);
            }
            XMLMetadataComparator.this.item.setSelected(true);
        }
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EngFilter filter = new EngFilter();
            if (XMLMetadataComparator.this.item1.isSelected() || XMLMetadataComparator.this.item2.isSelected() || XMLMetadataComparator.this.item3.isSelected()) {
                XMLMetadataComparator.this.item.setSelected(false);
            }
            if (XMLMetadataComparator.this.item1.isSelected()) {
                filter.addFilter(EngFilter.STATE_NEW_FILTER);
            }
            if (XMLMetadataComparator.this.item2.isSelected()) {
                filter.addFilter(EngFilter.STATE_DELETED_FILTER);
            }
            if (XMLMetadataComparator.this.item3.isSelected()) {
                filter.addFilter(EngFilter.STATE_MODIFIED_FILTER);
            }
            XMLMetadataComparator.this.item.setEnabled(true);
            if (!(XMLMetadataComparator.this.item1.isSelected() || XMLMetadataComparator.this.item2.isSelected() || XMLMetadataComparator.this.item3.isSelected())) {
                filter.addFilter(EngFilter.NO_FILTER);
                XMLMetadataComparator.this.item.setSelected(true);
                XMLMetadataComparator.this.item.setEnabled(false);
            }
            XMLMetadataComparator.this.setFilter(XMLMetadataComparator.this.leftTree, filter);
            XMLMetadataComparator.this.setFilter(XMLMetadataComparator.this.rightTree, filter);
            XMLMetadataComparator.this.leftTree.updateUI();
            XMLMetadataComparator.this.rightTree.updateUI();
        }
    }

    public class CompareModel
    extends AbstractTableModel {
        private MetaPropertiesComparator comp;

        CompareModel(MetaPropertiesComparator comparator) {
            this.comp = comparator;
        }

        public List getPropertiesList() {
            return this.comp.getPropertiesList();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.comp.getPropertiesList().size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CompareModelsDialog.Property");
            }
            if (column == 1) {
                return Messages.getString("CompareModelsDialog.Selected");
            }
            if (column == 2) {
                return this.comp.getLeftName();
            }
            if (column == 3) {
                return this.comp.getRightName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                MetaPropertyHolder ph = (MetaPropertyHolder)this.comp.getPropertiesList().get(rowIndex);
                return ph.isEditable();
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            MetaPropertyHolder ph = (MetaPropertyHolder)this.comp.getPropertiesList().get(row);
            if (col == 0) {
                return ph.getPresentationName();
            }
            if (col == 1) {
                return ph.isSelected();
            }
            if (col == 2) {
                return ph.getLeftValuePresentation();
            }
            if (col == 3) {
                return ph.getRightValuePresentation();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == 1) {
                EngPropertyHolder ph = (EngPropertyHolder)this.comp.getPropertiesList().get(row);
                ph.setSelected((Boolean)aValue);
            }
        }

        public MetaPropertyHolder getPropertyHolder(int rowIndex) {
            MetaPropertyHolder ph = (MetaPropertyHolder)this.comp.getPropertiesList().get(rowIndex);
            return ph;
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            XMLMetadataComparator.this.unregisterListeners();
        }
    }
}

