/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.cwddesign;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareDialog;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.compare.EmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDFilter;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDFilteredSelection;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.cwddesign.DesignHandler;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.compare.cwddesign.CompareCWDCheckEditor;
import oracle.dbtools.crest.swingui.compare.cwddesign.CompareCWDTreeRenderer;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTabularView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.compare.CompareOptions;

public class CompareCWDDesignsDialog
extends CustomDialog
implements TreeSelectionListener,
TreeExpansionListener,
AdjustmentListener {
    private DesignHandler designHandler;
    private JPanel leftTreePanel;
    private JPanel rightTreePanel;
    private JDialog dialog;
    private JPanel buttonPanel;
    private JTabbedPane tabbedPane;
    private JScrollPane detailsSP;
    private JTable compareTable;
    private JButton button;
    private JCheckBoxMenuItem item;
    private JCheckBoxMenuItem item1;
    private JCheckBoxMenuItem item2;
    private JCheckBoxMenuItem item3;
    private JPopupMenu menu;
    private MyJTree leftTree;
    private MyJTree rightTree;
    private CompareTreeNavigationDesign leftNavDesign;
    private CompareTreeNavigationDesign rightNavDesign;
    private CompareCWDDesigns leftEngineer = null;
    private Map comparatorsMap;
    private Map objectsMap;
    JScrollBar leftSB;
    JScrollBar rightSB;
    private CompareCWDDesigns leftRoot;
    private MyJTree startTree = null;
    private boolean started = false;
    private boolean sel_started = false;
    private boolean sb_started = false;
    private SelectedCellRenderer selRenderer;
    private ModifiableCellRenderer propertyNameRenderer;
    private boolean result = false;
    private JPanel pnTreeWithFilter;
    private JPanel tabularView;
    private CompareTabularView compareTabularView;
    private JTabbedPane mainTabbedPane = new JTabbedPane();
    private JTable table;

    public CompareCWDDesignsDialog(ApplicationView appView, DesignHandler designHandler, ProgressDialog monitor) {
        super(appView);
        CompareCWDDesigns engineer;
        this.designHandler = designHandler;
        this.tabbedPane = new JTabbedPane();
        this.selRenderer = new SelectedCellRenderer();
        this.propertyNameRenderer = new ModifiableCellRenderer();
        this.leftEngineer = engineer = new CompareCWDDesigns(designHandler);
        this.comparatorsMap = engineer.getComparatorsMap();
        this.objectsMap = engineer.getObjectsMap();
        this.initLeftTreePanel(engineer.getRoot());
        this.initRightTreePanel(engineer.getRightRoot());
        this.resetLeftTree(engineer.getRoot());
        this.resetRightTree(engineer.getRightRoot());
        this.leftTreePanel.setPreferredSize(new Dimension(350, 430));
        this.rightTreePanel.setPreferredSize(new Dimension(350, 430));
        this.leftTreePanel.setMinimumSize(new Dimension(300, 300));
        this.rightTreePanel.setMinimumSize(new Dimension(300, 300));
        this.tabbedPane.setPreferredSize(new Dimension(750, 200));
        this.tabbedPane.setMinimumSize(new Dimension(720, 190));
        this.pnTreeWithFilter = new JPanel(new BorderLayout());
        this.initToolbar();
        JSplitPane sp1 = new JSplitPane(1);
        sp1.setLeftComponent(this.leftTreePanel);
        sp1.setRightComponent(this.rightTreePanel);
        sp1.setDividerLocation(-1);
        sp1.setResizeWeight(0.5);
        this.compareTable = new JTable();
        this.detailsSP = new JScrollPane(this.compareTable);
        this.compareTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int col;
                if (e.getClickCount() == 2 && ((col = CompareCWDDesignsDialog.this.compareTable.getSelectedColumn()) == 2 || col == 3)) {
                    CompareCWDDesignsDialog.this.showTextCompareDialog(CompareCWDDesignsDialog.this.compareTable);
                }
            }
        });
        this.detailsSP.setPreferredSize(new Dimension(750, 200));
        this.pnTreeWithFilter.add((Component)sp1, "Center");
        this.compareTabularView = new CompareTabularView(this.leftEngineer, true, appView);
        this.compareTabularView.setReportCaption(Messages.getString("CompareCWDDesignsDialog.CompareModelingDesigns"));
        this.compareTabularView.setDmdImport(true);
        this.tabularView = this.compareTabularView.getTabularView();
        this.mainTabbedPane.add((Component)this.pnTreeWithFilter, oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionDialog.TreeView"));
        this.mainTabbedPane.add((Component)this.tabularView, oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.TabularView"));
        JSplitPane splitPane = new JSplitPane(0, this.mainTabbedPane, this.tabbedPane);
        this.add((Component)splitPane, "Center");
        this.tabbedPane.add(Messages.getString("CompareCWDDesignsDialog.Details"), this.detailsSP);
        this.add((Component)this.getButtonPanel(), "South");
        this.compareTabularView.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CompareCWDDesignsDialog.this.table = CompareCWDDesignsDialog.this.compareTabularView.getTable();
                int row = CompareCWDDesignsDialog.this.table.getSelectedRow();
                ModelIdObjectSelection obj = null;
                if (row > -1 && row < CompareCWDDesignsDialog.this.table.getRowCount()) {
                    CompareTabularView.SelectionPair sp = (CompareTabularView.SelectionPair)CompareCWDDesignsDialog.this.table.getValueAt(row, 1);
                    obj = sp.leftSel;
                }
                CompareCWDDesignsDialog.this.updateCompareTable(obj);
            }
        });
    }

    private void showTextCompareDialog(JTable compareTable) {
        int col = compareTable.getSelectedColumn();
        if (col == 2 || col == 3) {
            int row = compareTable.getSelectedRow();
            TableModel tableModel = compareTable.getModel();
            String name = (String)tableModel.getValueAt(row, 0);
            Object leftValue = tableModel.getValueAt(row, 2);
            Object rightValue = tableModel.getValueAt(row, 3);
            if (leftValue instanceof String && rightValue instanceof String && (((String)leftValue).length() > 0 || ((String)rightValue).length() > 0)) {
                InputStream leftText = this.getStream((String)leftValue);
                InputStream rightText = this.getStream((String)rightValue);
                CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences()).setShowCharDifferences(true);
                VCSTextCompareDialog dialog = new VCSTextCompareDialog(this.getDialog(), null, leftText, (String)tableModel.getValueAt(0, 2), rightText, (String)tableModel.getValueAt(0, 3), true, true);
                dialog.setTitle(name);
                dialog.setVisible(true);
            }
        }
    }

    private InputStream getStream(String text) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            is = new ByteArrayInputStream(text.getBytes());
        }
        return is;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton bnApply = new JButton(Messages.getString("CompareCWDDesignsDialog.Apply"));
            bnApply.setMnemonic(69);
            bnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompareCWDDesignsDialog.this.apply();
                    CompareCWDDesignsDialog.this.result = true;
                    CompareCWDDesignsDialog.this.close();
                }
            });
            JButton bnCancel = new JButton(Messages.getString("CompareCWDDesignsDialog.Cancel"));
            bnCancel.setMnemonic(67);
            bnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompareCWDDesignsDialog.this.result = false;
                    CompareCWDDesignsDialog.this.removeNewRelationalModels();
                    CompareCWDDesignsDialog.this.close();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setMnemonic(72);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(bnApply);
            this.buttonPanel.add(bnCancel);
            this.buttonPanel.add(bnHelp);
        }
        return this.buttonPanel;
    }

    private void removeNewRelationalModels() {
        Design design = this.designHandler.getTargetDesign();
        for (RelationalDesign pd : this.designHandler.getModelsToDeleteOnCancel()) {
            pd.setIsDeleting(true);
            design.removeRelationalDesign(pd);
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.item = new JCheckBoxMenuItem(Messages.getString("CompareCWDDesignsDialog.ShowAllObjects"));
            this.item1 = new JCheckBoxMenuItem(Messages.getString("CompareCWDDesignsDialog.ShowNewObjects"));
            this.item2 = new JCheckBoxMenuItem(Messages.getString("CompareCWDDesignsDialog.ShowDeletedObjects"));
            this.item3 = new JCheckBoxMenuItem(Messages.getString("CompareCWDDesignsDialog.ShowModifiedObjects"));
            this.item.addActionListener(new ShowAllListener());
            this.item.setSelected(true);
            this.item.setEnabled(false);
            PopupMenuListener pmListener = new PopupMenuListener();
            this.item1.addActionListener(pmListener);
            this.item2.addActionListener(pmListener);
            this.item3.addActionListener(pmListener);
            this.menu.add(this.item);
            this.menu.add(this.item1);
            this.menu.add(this.item2);
            this.menu.add(this.item3);
        }
        return this.menu;
    }

    private void setFilter(JTree tree, CWDFilter filter) {
        CompareCWDDesigns rightRoot = (CompareCWDDesigns)tree.getModel().getRoot();
        int index = rightRoot.getNumberOfChildren();
        for (int i = 0; i < index; ++i) {
            ((CWDFilteredSelection)rightRoot.getChild(i)).setFilter(filter);
        }
    }

    private void initToolbar() {
        JPanel filterPanel = new JPanel(new FlowLayout(0));
        this.button = new JButton(Messages.getString("CompareCWDDesignsDialog.Filter"));
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu = CompareCWDDesignsDialog.this.getPopupMenu();
                menu.show(CompareCWDDesignsDialog.this.button, e.getPoint().x, e.getPoint().y);
            }
        });
        filterPanel.add(this.button);
        this.pnTreeWithFilter.add((Component)filterPanel, "North");
    }

    private void initLeftTreePanel(ModelIdObjectSelection root) {
        this.leftTreePanel = new JPanel(new BorderLayout());
        this.leftTree = new MyJTree();
        this.leftTree.setEditable(true);
        CompareCWDTreeRenderer renderer = new CompareCWDTreeRenderer(true);
        this.leftTree.setCellRenderer(renderer);
        CompareCWDCheckEditor editor = new CompareCWDCheckEditor(true);
        this.leftTree.setCellEditor(editor);
        JScrollPane jsp = new JScrollPane(this.leftTree);
        this.leftTreePanel.add((Component)jsp, "Center");
        this.leftTree.addTreeSelectionListener(this);
        this.leftTree.addTreeExpansionListener(this);
        this.leftSB = jsp.getVerticalScrollBar();
        this.leftSB.addAdjustmentListener(this);
    }

    private void initRightTreePanel(ModelIdObjectSelection root) {
        this.rightTreePanel = new JPanel(new BorderLayout());
        this.rightTree = new MyJTree();
        CompareCWDTreeRenderer renderer = new CompareCWDTreeRenderer(false);
        renderer.setShowCheckbox(false);
        this.rightTree.setCellRenderer(renderer);
        JScrollPane jsp = new JScrollPane(this.rightTree);
        this.rightTreePanel.add((Component)jsp, "Center");
        this.rightTree.addTreeSelectionListener(this);
        this.rightTree.addTreeExpansionListener(this);
        this.rightSB = jsp.getVerticalScrollBar();
        this.rightSB.addAdjustmentListener(this);
    }

    private void resetLeftTree(CompareCWDDesigns root) {
        this.leftRoot = root;
        root.resetModifiedStatus();
        this.leftNavDesign = new CompareTreeNavigationDesign(root);
        this.leftTree.setModel(this.leftNavDesign);
    }

    private void resetRightTree(CompareCWDDesigns root) {
        root.resetModifiedStatus();
        this.rightNavDesign = new CompareTreeNavigationDesign(root);
        this.rightTree.setModel(this.rightNavDesign);
    }

    private void apply() {
        this.deleteSelected(this.getDeletedMappings());
        this.leftRoot.applySelectionTo();
        this.unregisterListeners();
    }

    private List getDeletedMappings() {
        if (this.leftEngineer != null) {
            return this.leftEngineer.getDeletedMappings();
        }
        return new ArrayList();
    }

    private void deleteSelected(List deletedMappings) {
        for (CompareCWDDesigns sel : deletedMappings) {
            ModelIDObject obj;
            CompareCWDDesigns cor_sel;
            if (!sel.isSelected() || (cor_sel = sel.getCorrespondentNode()) == null || cor_sel.getObject() == null) continue;
            if (cor_sel.getObject() instanceof DesignObject) {
                obj = (DesignObject)cor_sel.getObject();
                if (obj == null) continue;
                ((DesignObject)obj).remove();
                continue;
            }
            if (!(cor_sel.getObject() instanceof StorageObject) || (obj = (StorageObject)cor_sel.getObject()) == null) continue;
            ((StorageObject)obj).remove();
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("CompareCWDDesignsDialog.CompareModelingDesigns"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addWindowListener(new ClosingListener());
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = CompareCWDDesignsDialog.this.dialog.getWidth();
                    int h = CompareCWDDesignsDialog.this.dialog.getHeight();
                    w = Math.max(720, w);
                    h = Math.max(600, h);
                    CompareCWDDesignsDialog.this.dialog.setSize(w, h);
                }
            });
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    private void unregisterListeners() {
        this.leftNavDesign.unregisterAsListener();
        this.rightNavDesign.unregisterAsListener();
    }

    @Override
    protected String getHelpIndex() {
        return "COMPARE_CWD4ALL_DESIGNS_DIALOG";
    }

    MyJTree getOtherTree(JTree tree) {
        if (tree == this.leftTree) {
            return this.rightTree;
        }
        return this.leftTree;
    }

    private void synchroizeSelection(TreeSelectionEvent event) {
        Object source = event.getSource();
        if (source instanceof JTree && !this.sel_started) {
            this.startTree = (MyJTree)source;
            this.sel_started = true;
            TreePath tp = event.getPath();
            CompareCWDDesigns os = (CompareCWDDesigns)tp.getLastPathComponent();
            MyJTree other = this.getOtherTree(this.startTree);
            other.setSelectionPath(new TreePath(os.getCorrespondentNode().getPath()));
            this.sel_started = false;
        }
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
        return this.result;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.synchroizeSelection(e);
        TreePath path = e.getPath();
        Object object = path.getLastPathComponent();
        this.updateCompareTable(object);
    }

    private void updateCompareTable(Object object) {
        if (object instanceof CompareCWDDesigns || object == null) {
            int[] wide = new int[]{0, 0, 0, 0};
            boolean exists = this.compareTable.getColumnModel() != null;
            int count = 4;
            if (exists) {
                count = this.compareTable.getColumnModel().getColumnCount();
                for (int i = 0; i < count; ++i) {
                    wide[i] = this.compareTable.getColumnModel().getColumn(i).getWidth();
                }
            }
            PropertiesComparator pc = null;
            pc = object == null ? new EmptyPropertiesComparator(null, null) : ((CompareCWDDesigns)object).getPropertiesComparator();
            this.compareTable.setModel(new CompareModel(pc));
            this.compareTable.getColumnModel().getColumn(1);
            TableColumn column = this.compareTable.getColumnModel().getColumn(1);
            column.setPreferredWidth(60);
            column.setWidth(60);
            column.setMaxWidth(70);
            column.setCellRenderer(this.selRenderer);
            column = this.compareTable.getColumnModel().getColumn(0);
            column.setCellRenderer(this.propertyNameRenderer);
            if (exists) {
                for (int i = 0; i < count; ++i) {
                    this.compareTable.getColumnModel().getColumn(i).setWidth(wide[i]);
                    this.compareTable.getColumnModel().getColumn(i).setPreferredWidth(wide[i]);
                }
            }
            this.compareTable.updateUI();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.processExpEvent(event, false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.processExpEvent(event, true);
    }

    void processExpEvent(TreeExpansionEvent event, boolean state) {
        Object source = event.getSource();
        if (source instanceof JTree && !this.started) {
            this.startTree = (MyJTree)source;
            this.started = true;
            TreePath tp = event.getPath();
            CompareCWDDesigns os = (CompareCWDDesigns)tp.getLastPathComponent();
            MyJTree other = this.getOtherTree(this.startTree);
            other.setExpandedState(new TreePath(os.getCorrespondentNode().getPath()), state);
            this.started = false;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        if (source instanceof JScrollBar && !this.sb_started) {
            JScrollBar jsb = (JScrollBar)source;
            if (jsb == this.leftSB) {
                this.sb_started = true;
                this.rightSB.setValue(this.leftSB.getValue());
                this.sb_started = false;
            } else if (jsb == this.rightSB) {
                this.sb_started = true;
                this.leftSB.setValue(this.rightSB.getValue());
                this.sb_started = false;
            }
        }
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public Map getObjectsMap() {
        return this.objectsMap;
    }

    class MyJTree
    extends JTree {
        public MyJTree(TreeModel model) {
            super(model);
        }

        public MyJTree() {
        }

        @Override
        protected void setExpandedState(TreePath path, boolean state) {
            super.setExpandedState(path, state);
        }
    }

    class SelectedCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        SelectedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            if (table.getModel() instanceof CompareModel) {
                CompareModel cm = (CompareModel)table.getModel();
                EngPropertyHolder ph = (EngPropertyHolder)cm.getPropertiesList().get(row);
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(val);
                if (ph.isModified()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    class ModifiableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ModifiableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (table.getModel() instanceof CompareModel) {
                CompareModel cm = (CompareModel)table.getModel();
                EngPropertyHolder ph = (EngPropertyHolder)cm.getPropertiesList().get(row);
                this.setOpaque(true);
                this.setText(ph.getName());
                if (ph.isModified()) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(table.getForeground());
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    if (!ph.isModified()) {
                        this.setForeground(table.getSelectionForeground());
                    }
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class ShowAllListener
    implements ActionListener {
        ShowAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CompareCWDDesignsDialog.this.item.isSelected()) {
                CompareCWDDesignsDialog.this.item.setEnabled(false);
                CompareCWDDesignsDialog.this.item1.setSelected(false);
                CompareCWDDesignsDialog.this.item2.setSelected(false);
                CompareCWDDesignsDialog.this.item3.setSelected(false);
                CWDFilter filter = new CWDFilter();
                filter.addFilter(EngFilter.NO_FILTER);
                CompareCWDDesignsDialog.this.setFilter(CompareCWDDesignsDialog.this.leftTree, filter);
                CompareCWDDesignsDialog.this.setFilter(CompareCWDDesignsDialog.this.rightTree, filter);
                CompareCWDDesignsDialog.this.leftTree.updateUI();
                CompareCWDDesignsDialog.this.rightTree.updateUI();
            } else {
                CompareCWDDesignsDialog.this.item.setEnabled(true);
            }
            CompareCWDDesignsDialog.this.item.setSelected(true);
        }
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CWDFilter filter = new CWDFilter();
            if (CompareCWDDesignsDialog.this.item1.isSelected() || CompareCWDDesignsDialog.this.item2.isSelected() || CompareCWDDesignsDialog.this.item3.isSelected()) {
                CompareCWDDesignsDialog.this.item.setSelected(false);
            }
            if (CompareCWDDesignsDialog.this.item1.isSelected()) {
                filter.addFilter(EngFilter.STATE_NEW_FILTER);
            }
            if (CompareCWDDesignsDialog.this.item2.isSelected()) {
                filter.addFilter(EngFilter.STATE_DELETED_FILTER);
            }
            if (CompareCWDDesignsDialog.this.item3.isSelected()) {
                filter.addFilter(EngFilter.STATE_MODIFIED_FILTER);
            }
            CompareCWDDesignsDialog.this.item.setEnabled(true);
            if (!(CompareCWDDesignsDialog.this.item1.isSelected() || CompareCWDDesignsDialog.this.item2.isSelected() || CompareCWDDesignsDialog.this.item3.isSelected())) {
                filter.addFilter(EngFilter.NO_FILTER);
                CompareCWDDesignsDialog.this.item.setSelected(true);
                CompareCWDDesignsDialog.this.item.setEnabled(false);
            }
            CompareCWDDesignsDialog.this.setFilter(CompareCWDDesignsDialog.this.leftTree, filter);
            CompareCWDDesignsDialog.this.setFilter(CompareCWDDesignsDialog.this.rightTree, filter);
            CompareCWDDesignsDialog.this.leftTree.updateUI();
            CompareCWDDesignsDialog.this.rightTree.updateUI();
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            CompareCWDDesignsDialog.this.unregisterListeners();
        }
    }

    public class CompareModel
    extends AbstractTableModel {
        private PropertiesComparator comp;
        List list;

        CompareModel(PropertiesComparator comparator) {
            this.comp = comparator;
            this.list = this.comp.getOrderedPropertiesList();
        }

        public List getPropertiesList() {
            return this.list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CompareCWDDesignsDialog.Property");
            }
            if (column == 1) {
                return Messages.getString("CompareCWDDesignsDialog.Selected");
            }
            if (column == 2) {
                return this.comp.getLeftName();
            }
            if (column == 3) {
                return this.comp.getRightName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                EngPropertyHolder ph = (EngPropertyHolder)this.list.get(rowIndex);
                return ph.isEditable();
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            EngPropertyHolder ph = (EngPropertyHolder)this.list.get(row);
            if (col == 0) {
                return ph.getName();
            }
            if (col == 1) {
                return new Boolean(ph.isSelected());
            }
            if (col == 2) {
                return ph.getLeftValue();
            }
            if (col == 3) {
                return ph.getRightValue();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == 1) {
                EngPropertyHolder ph = (EngPropertyHolder)this.list.get(row);
                ph.setSelected((Boolean)aValue);
            }
        }
    }
}

