/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.storage.ConstraintType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.editor.TextEditDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class CECheckConstraint
extends JDialog {
    private JDialog dialog;
    private CheckConstraint constraint;
    private CheckConstraint originalConstraint;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JButton btnCancel;
    private ApplicationView view;
    private boolean readOnly = false;
    private JButton editButton;
    private JTable constraintTable;
    private List constraintsList;
    private String description = "";
    private Dialog parent;
    KeyListener escKey = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                CECheckConstraint.this.btnCancel.doClick();
            }
        }
    };

    public CECheckConstraint(Dialog parent, ApplicationView view) {
        this(parent, view, false);
    }

    public CECheckConstraint(Dialog parent, ApplicationView view, boolean readOnly) {
        this.parent = parent;
        this.view = view;
        this.readOnly = readOnly;
    }

    public void configureEditComponentFor(CheckConstraint object) {
        this.originalConstraint = object;
        this.constraint = new CheckConstraint();
        this.constraint.setDesign(this.originalConstraint.getDesign());
        this.originalConstraint.copyTo(this.constraint);
        this.constraintsList = null;
    }

    public void doEditing(CheckConstraint object) {
        this.dialog = this.getDialog();
        this.dialog.setTitle(object.getName() + Messages.getString("CECheckConstraint.ConstraintS"));
        this.dialog.setVisible(true);
    }

    protected JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, Messages.getString("CECheckConstraint.Constraint"));
            this.dialog.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.dialog.setModal(true);
            this.dialog.setSize(new Dimension(600, 350));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = CECheckConstraint.this.dialog.getWidth();
                    int h = CECheckConstraint.this.dialog.getHeight();
                    w = Math.max(400, w);
                    h = Math.max(250, h);
                    CECheckConstraint.this.dialog.setSize(w, h);
                }
            });
        }
        this.getConstraintsList();
        CommonUtil.centerOnScreen(this.dialog);
        return this.dialog;
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.add(this.getEditButton());
            this.mainPanel.add((Component)toolBar, "North");
            this.constraintTable = new JTable(new ConstraintTableModel());
            this.constraintTable.setSelectionMode(0);
            this.constraintTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CECheckConstraint.this.showTextEditDialog();
                    }
                }
            });
            this.constraintTable.addKeyListener(this.escKey);
            this.constraintTable.updateUI();
            JScrollPane scrollPane = new JScrollPane(this.constraintTable);
            this.mainPanel.add((Component)scrollPane, "Center");
        }
        return this.mainPanel;
    }

    private void showTextEditDialog() {
        int selectedRow = this.constraintTable.getSelectedRow();
        if (this.constraintTable.getSelectedRow() != -1) {
            ConstraintObject selected = (ConstraintObject)this.constraintsList.get(selectedRow);
            TextEditDialog editDialog = new TextEditDialog(this, this.view, selected.getConstraintRule(), this.readOnly);
            editDialog.showDialog();
            this.constraintTable.repaint();
            selected.setConstraintRule(editDialog.getText());
            if (!this.constraint.getLongName().equalsIgnoreCase(editDialog.getText())) {
                this.constraint.add(selected, editDialog.getText());
            }
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            String cancelStr = Messages.getString("CECheckConstraint.Close");
            if (!this.readOnly) {
                JButton btnOK = new JButton(Messages.getString("CECheckConstraint.OK"));
                btnOK.setMnemonic(79);
                btnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                btnOK.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CECheckConstraint.this.setProperties();
                        CECheckConstraint.this.getDialog().setVisible(false);
                    }
                });
                this.buttonPanel.add(btnOK);
                JButton btnApply = new JButton(Messages.getString("CECheckConstraint.Apply"));
                btnApply.setMnemonic(65);
                btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                btnApply.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CECheckConstraint.this.setProperties();
                    }
                });
                btnApply.addKeyListener(this.escKey);
                this.buttonPanel.add(btnApply);
                cancelStr = Messages.getString("CECheckConstraint.Cancel");
            }
            this.btnCancel = new JButton(cancelStr);
            this.btnCancel.setMnemonic(67);
            this.btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CECheckConstraint.this.getDialog().setVisible(false);
                }
            });
            this.buttonPanel.add(this.btnCancel);
        }
        return this.buttonPanel;
    }

    protected List getConstraintsList() {
        if (this.constraintsList == null) {
            this.constraintsList = new ArrayList();
            GenericConstraint generic = new GenericConstraint();
            this.constraintsList.add(new ConstraintObject(generic.getTypeName(), this.constraint.getConstraintFor(generic)));
            Object[] data = this.constraint.getTypes();
            for (int i = 0; i < data.length; ++i) {
                RDBMSType type = (RDBMSType)data[i];
                String typeName = type.getTypeName();
                String constraintRule = this.constraint.getConstraintFor(type);
                this.constraintsList.add(new ConstraintObject(typeName, constraintRule));
            }
        }
        return this.constraintsList;
    }

    protected JButton getEditButton() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.editButton = new JButton(configuration.getIcon("EDIT_ICON", 16));
        this.editButton.setToolTipText(Messages.getString("CECheckConstraint.EditConstraint"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CECheckConstraint.this.showTextEditDialog();
            }
        });
        this.editButton.addKeyListener(this.escKey);
        return this.editButton;
    }

    private void setProperties() {
        int icol = this.constraintTable.getEditingColumn();
        int irow = this.constraintTable.getEditingRow();
        if (icol > -1 && irow > -1) {
            this.constraintTable.getCellEditor(irow, icol).stopCellEditing();
        }
        this.constraint.copyTo(this.originalConstraint);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    class ConstraintTableModel
    extends AbstractTableModel {
        ConstraintTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return CECheckConstraint.this.getConstraintsList().size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ConstraintObject constr = (ConstraintObject)CECheckConstraint.this.constraintsList.get(rowIndex);
            if (columnIndex == 0) {
                return constr.getTypeName();
            }
            if (columnIndex == 1) {
                return constr.getConstraintRule();
            }
            return new Integer(rowIndex * columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ConstraintObject con = (ConstraintObject)CECheckConstraint.this.constraintsList.get(rowIndex);
            con.setConstraintRule((String)aValue);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Messages.getString("CECheckConstraint.Type");
            }
            if (columnIndex == 1) {
                return Messages.getString("CECheckConstraint.Constraint");
            }
            return " ";
        }
    }

    class ConstraintObject
    implements ConstraintType {
        private String typeName;
        private String constraintRule;
        private Object typeConstraint;
        private List listOfConstraints = new ArrayList();

        ConstraintObject(String name, String constraintRule) {
            this.typeName = name;
            this.constraintRule = constraintRule;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        public String getConstraintRule() {
            return this.constraintRule;
        }

        public void setConstraintRule(String newConstraint) {
            this.constraintRule = newConstraint;
        }

        public List getConstraintsList() {
            return this.listOfConstraints;
        }

        @Override
        public RDBMSType getParentType() {
            return (RDBMSType)this.typeConstraint;
        }

        @Override
        public void setParentType(RDBMSType type) {
            this.typeConstraint = type;
        }
    }
}

