/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.DesignPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.SearchablePanel;
import oracle.dbtools.crest.swingui.editor.UDPLibrary;
import oracle.dbtools.crest.swingui.editor.UDPLibraryPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.glossary.GlossaryDialog;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.TopViewColorDialog;
import oracle.dbtools.crest.util.TreeUtils;
import oracle.dbtools.crest.util.compare.CompareMappingDialog;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;
import oracle.dbtools.crest.util.gui.swing.JLWComboBox;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.options.namingstandards.GlossaryFile;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class DesignLevelSettingsPropertiesDialog
extends CustomDialogML
implements AbstractEditorConstants {
    private final String NAME_PART = Messages.getString("DesignLevelSettingsPropertiesDialog.NamePart");
    private final String MANDATORY = Messages.getString("DesignLevelSettingsPropertiesDialog.Mandatory");
    private final String PRIME_WORD_L = Messages.getString("DesignLevelSettingsPropertiesDialog.PrimeWord");
    private final String CLASS_WORD_L = Messages.getString("DesignLevelSettingsPropertiesDialog.ClassWord");
    private final String MODIFIER_L = Messages.getString("DesignLevelSettingsPropertiesDialog.Modifier");
    private final String QUALIFIER_L = Messages.getString("DesignLevelSettingsPropertiesDialog.Qialifier");
    private final String btnName = Messages.getString("DesignLevelSettingsPropertiesDialog.AddVariable");
    private final String USE_DOMAN_NAME = Messages.getString("DesignLevelSettingsPropertiesDialog.DomainName");
    private final String USE_LOGICAL_TYPE = Messages.getString("DesignLevelSettingsPropertiesDialog.UsedLogicalType");
    private final String[] domain_presentation = new String[]{this.USE_DOMAN_NAME, this.USE_LOGICAL_TYPE};
    private String automaticIndexText = Messages.getString("DesignLevelSettingsPropertiesDialog.AutoIndex");
    private String sKeyConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.SurrogateKey");
    private String sKeyColConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.SurrogatekeyColumn");
    private String dColumnConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.DiscriminatorColumn");
    private String pkConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.PrimaryKey");
    private String fkConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.ForeignKey");
    private String chkConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.CheckConstraint");
    private String ukConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.UniqueConstraint");
    private String idxConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.Index");
    private String colChkConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnCheckConstraint");
    private String colNNConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnNotNullConstraint");
    private String colFKText = Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnForeignKey");
    private String prIDConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.PrimaryIdentifier");
    private String attrRelConstrText = Messages.getString("DesignLevelSettingsPropertiesDialog.AttributeRelation");
    private final String[] comboItems = new String[]{this.pkConstrText, this.fkConstrText, this.chkConstrText, this.ukConstrText, this.idxConstrText, this.automaticIndexText, this.colChkConstrText, this.colNNConstrText, this.colFKText, this.sKeyConstrText, this.sKeyColConstrText, this.dColumnConstrText, this.prIDConstrText, this.attrRelConstrText};
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JDialog dialog;
    private Design design;
    private DesignLevelSettings designLevelSettings;
    private JTree tree;
    private JPanel buttonsPanel;
    protected CardLayout cardLayout = new CardLayout(10, 10);
    private JPanel pnMain;
    private String globalDesignLevelSettingsPath;
    private File lastImpDirectory;
    private File lastExpDirectory;
    private File lastFolder;
    private StringBuffer buffer;
    private JPanel pnSettings;
    private JPanel pnDiagram;
    private JPanel pnCompareMappings;
    private JPanel pnDynamicProperties;
    private JPanel pnNamingStandard;
    private JPanel pnNamingStandardAttribute;
    private JPanel pnNamingStandardColumn;
    private JPanel pnNamingStandardDomain;
    private JPanel pnNamingStandardEntity;
    private JPanel pnNamingStandardTable;
    private JPanel pnNamingStandardTemplates;
    private JPanel pnUserDefinedProperties;
    private JPanel pnFormat;
    private JPanel pnClassificationTypes;
    private JPanel pnDiagramLogical;
    private JPanel pnDDL;
    private JPanel pnDDLMigration;
    private JCheckBox chbUseGlobalDLSettings;
    private JTable classificationTypeTable;
    private List classificationTypeList;
    private List localClassificationTypeList = new ArrayList();
    private List defaultFCList;
    private List localDefaultFCList;
    private JTable tbDefaultFC;
    private List defaultLWCList;
    private List localDefaultLWCList;
    private JCheckBox chAutomaticPKGeneration;
    private JCheckBox chAutomaticUKGeneration;
    private JCheckBox chAutomaticFKGeneration;
    private JCheckBox cbPreserveDDLGenerationOptions;
    private List substitutionList;
    private List localSubstitutionList;
    private JTable tbSubstituiton;
    private JButton btnRemoveAttributeNS;
    private JButton btnMoveUpAttribuiteNS;
    private JButton btnMoveDownAttribuiteNS;
    private JButton btnRemoveColumnNS;
    private JButton btnMoveUpColumnNS;
    private JButton btnMoveDownColumnNS;
    private JButton btnRemoveDomainNS;
    private JButton btnMoveUpDomainNS;
    private JButton btnMoveDownDomainNS;
    private JButton btnRemoveEntityNS;
    private JButton btnMoveUpEntityNS;
    private JButton btnMoveDownEntityNS;
    private JButton btnRemoveTableNS;
    private JButton btnMoveUpTableNS;
    private JButton btnMoveDownTableNS;
    private LinkedHashMap logicalModelSeparatorMap = new LinkedHashMap();
    private JComboBox separatorBox;
    private JCharField characterField;
    private JCharField dmsSeparator;
    private JCharField separatorText;
    private JCheckBox abbreviatedOnly;
    private List glossariesList = new ArrayList();
    private List nsAttributesList = new ArrayList();
    private JTable nsAttributesTable;
    private List nsColumnsList = new ArrayList();
    private JTable nsColumnsTable;
    private List nsDomainsList = new ArrayList();
    private JTable nsDomainsTable;
    private List nsEntitiesList = new ArrayList();
    private JTable nsEntitiesTable;
    private List nsTablesList = new ArrayList();
    private JTable nsTablesTable;
    private JTable tbDefaultLWC;
    private JComboBox cbDomainPresentation;
    private JButton bnEditLibrary;
    private JButton bnRemoveLibrary;
    private JButton btnRemoveGlossary;
    private JButton btnGlossaryProperties;
    private JTextField tfPrimaryKey;
    private JTextField tfCheckConstr;
    private JTextField tfUniqueConstr;
    private JTextField tfForeignKey;
    private JTextField tfIndex;
    private JTextField tfAutomaticIndex;
    private JTextField tfColCheckConstr;
    private JTextField tfColNNConstr;
    private JTextField tfColumnForeignKey;
    private JTextField tfSurrogateKey;
    private JTextField tfSurrogateKeyColumn;
    private JTextField tfDiscriminatorColumn;
    private JTextField tfPrimaryIdentifier;
    private JTextField tfAttributeRelation;
    private JTable dynamicPropertiesTable;
    private List dynamicPropertiesList;
    private JTable glossaryTable;
    private String pkConsr = "{table}_PK";
    private String fkConsr = "{child}_{parent}_FK";
    private String ckConsr = "{table}_CK";
    private String unConstr = "{table}_{column}_UN";
    private String idxConstr = "{table}_{column}_IDX";
    private String automaticIdxConstr = "{constraint}_IX";
    private String colckConstr = "CK_ {table}_{column}";
    private String colNNConstr = "NNC_{table abbr}_{column}";
    private String attrRelation = "{ref entity}_{ref attribute}";
    private String colForeignKey = "{ref table}_{ref column}";
    private String surrogateKey = "{table abbr}_PK";
    private String surrogateKeyCol = "{table abbr}_ID";
    private String discriminatorCol = "{table abbr}_TYPE";
    private String uiConsr = "{entity} PK";
    private JCheckBox chbUsePreferredClassificationTypes;
    private JTextField propertyNameFilter;
    private JList<UDPLibrary> udpLibraries;
    private JButton bnRemoveClassificationType;
    private JButton bnRemoveSubstitution;
    private JButton bnSelectAllSubstitutions;
    private JButton bnDeselectAllSubstitutions;
    private List usedClassTypes;
    private boolean inInitProperties = false;
    private JPanel logicalPanel;
    private JPanel relationalPanel;
    private JPanel domainPanel;
    private DefaultMutableTreeNode settingsNode;
    public LinkedHashMap namePartMap = new LinkedHashMap();
    private String oldObjectStatus;
    private String oldDLSettings;
    private String treePath = "";
    private final Logger LOGGER = new Logger(DesignLevelSettingsPropertiesDialog.class);

    public DesignLevelSettingsPropertiesDialog(ApplicationView appView, Design design) {
        super(appView);
        this.design = design;
        this.dialog.setTitle(MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.DesignLevelSettings"), design.getName()));
        this.globalDesignLevelSettingsPath = XMLTransformationManager.getDefaultSystemTypesPath(design.getAppView().getSettings()) + "/dl_settings.xml";
        this.initConstants();
        this.setLayout((LayoutManager)new MigLayout("fill", "[fill, grow]", "[fill,grow]"));
        JScrollPane scrollPane = new JScrollPane(this.getTree());
        scrollPane.setMinimumSize(new Dimension(170, 0));
        JSplitPane splitPane = new JSplitPane(1, scrollPane, this.getMainPanel());
        splitPane.setDividerLocation(150);
        splitPane.setDividerSize(3);
        this.add((Component)splitPane, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.initProperties(false);
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
            this.tree = new JTree(root);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(root);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    private void initTree(DefaultMutableTreeNode root) {
        JPanel settingsPanel = this.getSettingsPanel();
        this.settingsNode = new DefaultMutableTreeNode(settingsPanel);
        this.getMainPanel().add((Component)settingsPanel, settingsPanel.getName());
        this.addToTree(this.settingsNode, this.getCompareMappingsPanel());
        DefaultMutableTreeNode diagramNode = new DefaultMutableTreeNode(this.getDiagramPanel());
        this.getMainPanel().add((Component)this.getDiagramPanel(), this.getDiagramPanel().getName());
        this.addToTree(diagramNode, this.getDiagramClassificationTypesPanel());
        this.addToTree(diagramNode, this.getDiagramFormatPanel());
        this.addToTree(diagramNode, this.getDiagramLogicalPanel());
        this.settingsNode.add(diagramNode);
        DefaultMutableTreeNode settingsDDLNode = new DefaultMutableTreeNode(this.getDDLPanel());
        this.getMainPanel().add((Component)this.getDDLPanel(), this.getDDLPanel().getName());
        this.addToTree(settingsDDLNode, this.getDDLMIgrationPanel());
        this.settingsNode.add(settingsDDLNode);
        DefaultMutableTreeNode nsNode = new DefaultMutableTreeNode(this.getNamingStandardPanel());
        this.getMainPanel().add((Component)this.getNamingStandardPanel(), this.getNamingStandardPanel().getName());
        this.addToTree(nsNode, this.getNamingStandardAttributePanel());
        this.addToTree(nsNode, this.getNamingStandardColumnPanel());
        this.addToTree(nsNode, this.getNamingStandardDomainPanel());
        this.addToTree(nsNode, this.getNamingStandardEntityPanel());
        this.addToTree(nsNode, this.getNamingStandardTablePanel());
        this.addToTree(nsNode, this.getNamingStandardTemplatesPanel());
        this.settingsNode.add(nsNode);
        DefaultMutableTreeNode settingsDPNode = new DefaultMutableTreeNode(this.getDynamicPropertiesPanel());
        this.getMainPanel().add((Component)this.getDynamicPropertiesPanel(), this.getDynamicPropertiesPanel().getName());
        this.settingsNode.add(settingsDPNode);
        DefaultMutableTreeNode UDPNode = new DefaultMutableTreeNode(this.getUserDefinedPropertiesPanel());
        this.getMainPanel().add((Component)this.getUserDefinedPropertiesPanel(), this.getUserDefinedPropertiesPanel().getName());
        this.settingsNode.add(UDPNode);
        root.add(this.settingsNode);
    }

    public DefaultMutableTreeNode getFullTree() {
        return this.settingsNode;
    }

    public JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(200, 200));
        }
        return this.pnMain;
    }

    private JPanel getButtonPanel() {
        this.buttonsPanel = new JPanel(new FlowLayout(1));
        JButton btnApply = new JButton(Messages.getString("DesignLevelSettingsPropertiesDialog.OK"));
        btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnApply.addActionListener(new ApplyAction());
        btnApply.setMnemonic(65);
        JButton btnClose = new JButton(Messages.getString("DesignLevelSettingsPropertiesDialog.Cancel"));
        btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnClose.addActionListener(new CloseAction());
        btnClose.setMnemonic(67);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnHelp.setMnemonic(72);
        this.buttonsPanel.add(btnApply);
        this.buttonsPanel.add(btnClose);
        this.buttonsPanel.add(btnHelp);
        return this.buttonsPanel;
    }

    public JPanel getSettingsPanel() {
        if (this.pnSettings == null) {
            this.pnSettings = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Settings"));
            JPanel btnPanel = new JPanel(new FlowLayout(1));
            JButton bnImport = new JButton(Messages.getString("DesignLevelSettingsPropertiesDialog.Import"));
            bnImport.setMnemonic(73);
            bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnImport.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("DesignLevelSettingsPropertiesDialog.XMLFiles");
                        }
                    };
                    URLFileChooser fileChooser = new URLFileChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    fileChooser.setPathContext("dataModeler_Imports");
                    if (DesignLevelSettingsPropertiesDialog.this.lastImpDirectory != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((File)DesignLevelSettingsPropertiesDialog.this.lastImpDirectory));
                    } else {
                        String lastDir = DesignLevelSettingsPropertiesDialog.this.getApplicationView().getSettings().getDefaultImportPath();
                        if (lastDir != null && lastDir.length() > 0) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = DesignLevelSettingsPropertiesDialog.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                    }
                    int result = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DesignLevelSettingsPropertiesDialog.ImportDLS"));
                    if (result == 0) {
                        Reader in = null;
                        File file = null;
                        try {
                            file = new File(fileChooser.getSelectedURL().getPath());
                            if (file.exists()) {
                                int ch;
                                DesignLevelSettingsPropertiesDialog.this.lastImpDirectory = file.getParentFile();
                                DesignLevelSettingsPropertiesDialog.this.buffer = new StringBuffer();
                                FileInputStream fis = new FileInputStream(file);
                                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                                in = new BufferedReader(isr);
                                while ((ch = in.read()) > -1) {
                                    DesignLevelSettingsPropertiesDialog.this.buffer.append((char)ch);
                                }
                                in.close();
                                DesignLevelSettingsPropertiesDialog.this.designLevelSettings.loadDesignLevellSettingsFromString(DesignLevelSettingsPropertiesDialog.this.buffer.toString());
                                DesignLevelSettingsPropertiesDialog.this.initProperties(false);
                                DesignLevelSettingsPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                                MessageDialogs.showMessage(MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.DLSettingImportedSuccessfully"), file.getAbsolutePath()));
                            }
                        }
                        catch (Exception ex) {
                            DesignLevelSettingsPropertiesDialog.this.LOGGER.error("Unable to initialize design level settings from the imported file " + fileChooser.getSelectedURL().getPath() + " ", ex);
                            MessageDialogs.showMessage(MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.DLSettingImportError"), file.getAbsolutePath()));
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e1) {
                                    DesignLevelSettingsPropertiesDialog.this.LOGGER.error("Import design level settings. Unable to close the input reader ", e1);
                                }
                            }
                        }
                    }
                }
            });
            JButton bnExport = new JButton(Messages.getString("DesignLevelSettingsPropertiesDialog.Export"));
            bnExport.setMnemonic(69);
            bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("DesignLevelSettingsPropertiesDialog.XMLFiles");
                        }
                    };
                    URLFileChooser fileChooser = new URLFileChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    fileChooser.setPathContext("dataModeler_Exports");
                    if (DesignLevelSettingsPropertiesDialog.this.lastExpDirectory != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((File)DesignLevelSettingsPropertiesDialog.this.lastExpDirectory));
                    } else {
                        String lastDir = DesignLevelSettingsPropertiesDialog.this.getApplicationView().getSettings().getDefaultSavePath();
                        if (lastDir != null && lastDir.length() > 0) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = DesignLevelSettingsPropertiesDialog.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DesignLevelSettingsPropertiesDialog.ExportDLS"));
                    if (status == 0) {
                        File file = null;
                        try {
                            file = new File(fileChooser.getSelectedURL().getPath());
                            if (file != null) {
                                DesignLevelSettingsPropertiesDialog.this.designLevelSettings.saveDesignLevelLSettingsFile(file.getAbsolutePath(), DesignLevelSettingsPropertiesDialog.this.design.isGitVersioned());
                                MessageDialogs.showMessage(MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.DLSettingExportedSuccessfully"), file.getAbsolutePath()));
                            }
                        }
                        catch (Exception ex) {
                            DesignLevelSettingsPropertiesDialog.this.LOGGER.error("Unable to export design level settings in file " + fileChooser.getSelectedURL().getPath() + " ", ex);
                            MessageDialogs.showMessage(MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.DLSettingExportError"), file.getAbsolutePath()));
                        }
                    }
                }
            });
            JButton bnSave = new JButton(Messages.getString("DesignLevelSettingsPropertiesDialog.Save"));
            bnSave.setMnemonic(83);
            bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DesignLevelSettingsPropertiesDialog.this.chbUseGlobalDLSettings.isSelected()) {
                        int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.FileOverwriteAreUSure"), Messages.getString("DesignLevelSettingsPropertiesDialog.UseGlobalDLSettings")), Messages.getString("DesignLevelSettingsPropertiesDialog.FielOverwrite"), 0);
                        if (result == 0) {
                            try {
                                DesignLevelSettingsPropertiesDialog.this.setProperties();
                                DesignLevelSettingsPropertiesDialog.this.designLevelSettings.saveDesignLevelLSettingsFile(XMLTransformationManager.getDefaultSystemTypesPath() + "/dl_settings.xml", DesignLevelSettingsPropertiesDialog.this.design.isGitVersioned());
                                if (!DesignLevelSettingsPropertiesDialog.this.design.isNewDesign()) {
                                    Path globalDLPath = Paths.get(DesignLevelSettingsPropertiesDialog.this.globalDesignLevelSettingsPath, new String[0]);
                                    Path dlPath = Paths.get(DesignLevelSettingsPropertiesDialog.this.design.getDesignPath() + "/" + DesignLevelSettingsPropertiesDialog.this.design.getFileName() + "/dl_settings.xml", new String[0]);
                                    Files.copy(globalDLPath, dlPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                                    MessageDialogs.showMessage(Messages.getString("DesignLevelSettingsPropertiesDialog.GDLSettingSaved"));
                                }
                            }
                            catch (Exception ex) {
                                DesignLevelSettingsPropertiesDialog.this.LOGGER.error("Unable to save design level settings", ex);
                                MessageDialogs.showMessage(Messages.getString("DesignLevelSettingsPropertiesDialog.GDLSettingSaveError"));
                            }
                        }
                    } else {
                        try {
                            DesignLevelSettingsPropertiesDialog.this.setProperties();
                            DesignLevelSettingsPropertiesDialog.this.design.saveDesignLevelSettings();
                            MessageDialogs.showMessage(Messages.getString("DesignLevelSettingsPropertiesDialog.DLSettingSaved"));
                        }
                        catch (Exception ex) {
                            DesignLevelSettingsPropertiesDialog.this.LOGGER.error("Unable to save design level settings", ex);
                            MessageDialogs.showMessage(Messages.getString("DesignLevelSettingsPropertiesDialog.DLSettingSaveError"));
                        }
                    }
                }
            });
            this.chbUseGlobalDLSettings = new JCheckBox(Messages.getString("DesignLevelSettingsPropertiesDialog.UseGlobalDLSettings"));
            this.chbUseGlobalDLSettings.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DesignLevelSettingsPropertiesDialog.this.inInitProperties) {
                        int state = e.getStateChange();
                        if (state == 1) {
                            DesignLevelSettingsPropertiesDialog.this.getDLSettingsDataToBeMerged();
                            DesignLevelSettingsPropertiesDialog.this.design.loadDesignLevelSettings(true);
                            DesignLevelSettingsPropertiesDialog.this.mergeDLSettingsData();
                        } else {
                            DesignLevelSettingsPropertiesDialog.this.design.loadDesignLevelSettings(false);
                        }
                        DesignLevelSettingsPropertiesDialog.this.initProperties(true);
                    }
                }
            });
            btnPanel.add(bnImport);
            btnPanel.add(bnExport);
            btnPanel.add(bnSave);
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[fill]"));
            jp.add((Component)this.chbUseGlobalDLSettings, new CC().dockNorth());
            jp.add((Component)btnPanel, new CC().dockSouth());
            this.pnSettings.add((Component)jp, "Center");
        }
        return this.pnSettings;
    }

    public JPanel getCompareMappingsPanel() {
        if (this.pnCompareMappings == null) {
            this.pnCompareMappings = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.CompareMappings"));
            JPanel compareMappingsPanel = new CompareMappingDialog(this.getApplicationView(), this.design).getGeneralPane();
            this.pnCompareMappings.add((Component)compareMappingsPanel, "Center");
        }
        return this.pnCompareMappings;
    }

    public JPanel getDiagramPanel() {
        if (this.pnDiagram == null) {
            this.pnDiagram = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Diagram"));
        }
        return this.pnDiagram;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            int w;
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.DesignLevelSettings"), ""));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setIconImage(GUIConfiguration.getInstance().getImage("DL_SETTINGS_ICON"));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = DesignLevelSettingsPropertiesDialog.this.dialog.getWidth();
                    int h = DesignLevelSettingsPropertiesDialog.this.dialog.getHeight();
                    w = Math.max(DesignLevelSettingsPropertiesDialog.this.getMinimumWidth(), w);
                    h = Math.max(DesignLevelSettingsPropertiesDialog.this.getMinimumHeight(), h);
                    DesignLevelSettingsPropertiesDialog.this.dialog.setSize(w, h);
                }
            });
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                w = this.getMinimumWidth();
                int h = this.getMinimumHeight();
                this.dialog.setSize(w, h);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                w = Math.max(500, (int)ds.rec.getSize().getWidth());
                int h = Math.max(410, (int)ds.rec.getSize().getHeight());
                this.dialog.setSize(w, h);
                this.dialog.setLocation(ds.rec.getLocation());
            }
            Settings.DialogSettings dp = this.getApplicationView().getSettings().getDialogSettings(DesignPropertiesDialog.class.getName());
            if (dp != null) {
                this.treePath = dp.treePath;
            } else if (ds != null) {
                this.treePath = ds.treePath;
            }
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        String treePath = TreeUtils.createFilePath(this.getTree().getSelectionPath());
        this.design.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle, treePath);
        this.design.setDialogVisible(false, null);
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_PROPERTIES_DIALOG";
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        if (this.treePath.length() > 0) {
            String[] names = this.treePath.split("/");
            TreePath tp = TreeUtils.findByName(this.getTree(), names);
            if (tp != null) {
                this.getTree().setSelectionPath(tp);
            }
        }
        this.getDialog().setVisible(true);
    }

    public void setProperties() {
        try {
            this.designLevelSettings.setUseGlobalDesignLevelSettings(this.chbUseGlobalDLSettings.isSelected());
            if (this.classificationTypeTable.getCellEditor() != null) {
                this.classificationTypeTable.getCellEditor().stopCellEditing();
            }
            this.classificationTypeList.clear();
            for (ClassificationType classType : this.localClassificationTypeList) {
                this.classificationTypeList.add(classType);
            }
            this.defaultFCList.clear();
            for (DefaultFontAndColor dfc : this.localDefaultFCList) {
                this.defaultFCList.add(dfc);
            }
            this.defaultLWCList.clear();
            for (DefaultLineWidthAndColor dlwc : this.localDefaultLWCList) {
                this.defaultLWCList.add(dlwc);
            }
            if (!ApplicationView.IS_VIEWER && !this.getApplicationView().getCurrentDesign().isNewDesign()) {
                this.designLevelSettings.setLogicalTypeForDomainPresentation(this.cbDomainPresentation.getSelectedItem() == this.USE_LOGICAL_TYPE);
                this.design.getLogicalDesign().getMainView().updateDiagramSettings();
            }
            if (!ApplicationView.IS_VIEWER) {
                this.designLevelSettings.setAutomaticPKGeneration(this.chAutomaticPKGeneration.isSelected());
                this.designLevelSettings.setAutomaticUKGeneration(this.chAutomaticUKGeneration.isSelected());
                this.designLevelSettings.setAutomaticFKGeneration(this.chAutomaticFKGeneration.isSelected());
                this.designLevelSettings.setPreserveDDLGenerationOptions(this.cbPreserveDDLGenerationOptions.isSelected());
            }
            this.substitutionList.clear();
            for (SubstitutionPattern substPattern : this.localSubstitutionList) {
                this.substitutionList.add(substPattern);
            }
            this.tbSubstituiton.updateUI();
            String key = "";
            for (Map.Entry entry : this.logicalModelSeparatorMap.entrySet()) {
                if (!entry.getValue().equals(this.separatorBox.getSelectedItem().toString())) continue;
                key = (String)entry.getKey();
                break;
            }
            this.designLevelSettings.getNamingStandardRule().setLogicalSep(key);
            this.designLevelSettings.getNamingStandardRule().setLogicalChar(this.characterField.getText());
            this.designLevelSettings.getNamingStandardRule().setRelSep(this.separatorText.getText());
            this.designLevelSettings.getNamingStandardRule().setAbbreviatedOnly(this.abbreviatedOnly.isSelected());
            this.designLevelSettings.getNamingStandardRule().setDomainsSep(this.dmsSeparator.getText());
            this.designLevelSettings.getNamingStandardRule().getGlossariesList().clear();
            this.designLevelSettings.getNamingStandardRule().getGlossariesList().addAll(this.glossariesList);
            this.designLevelSettings.getNamingStandardRule().getAttributesList().clear();
            this.designLevelSettings.getNamingStandardRule().getAttributesList().addAll(this.nsAttributesList);
            this.designLevelSettings.getNamingStandardRule().getColumnsList().clear();
            this.designLevelSettings.getNamingStandardRule().getColumnsList().addAll(this.nsColumnsList);
            this.designLevelSettings.getNamingStandardRule().getDomainsList().clear();
            this.designLevelSettings.getNamingStandardRule().getDomainsList().addAll(this.nsDomainsList);
            this.designLevelSettings.getNamingStandardRule().getEntitiesList().clear();
            this.designLevelSettings.getNamingStandardRule().getEntitiesList().addAll(this.nsEntitiesList);
            this.designLevelSettings.getNamingStandardRule().getTablesList().clear();
            this.designLevelSettings.getNamingStandardRule().getTablesList().addAll(this.nsTablesList);
            this.designLevelSettings.getNamingStandardRule().setPkConstr(this.tfPrimaryKey.getText());
            this.designLevelSettings.getNamingStandardRule().setFkConstr(this.tfForeignKey.getText());
            this.designLevelSettings.getNamingStandardRule().setCkConstr(this.tfCheckConstr.getText());
            this.designLevelSettings.getNamingStandardRule().setUnConstr(this.tfUniqueConstr.getText());
            this.designLevelSettings.getNamingStandardRule().setIdxConstr(this.tfIndex.getText());
            this.designLevelSettings.getNamingStandardRule().setAutomaticIdxConstr(this.tfAutomaticIndex.getText());
            this.designLevelSettings.getNamingStandardRule().setColckConstr(this.tfColCheckConstr.getText());
            this.designLevelSettings.getNamingStandardRule().setColNNConstr(this.tfColNNConstr.getText());
            this.designLevelSettings.getNamingStandardRule().setUIConstr(this.tfPrimaryIdentifier.getText());
            this.designLevelSettings.getNamingStandardRule().setRelationAttribute(this.tfAttributeRelation.getText());
            this.designLevelSettings.getNamingStandardRule().setFkColumn(this.tfColumnForeignKey.getText());
            this.designLevelSettings.getNamingStandardRule().setSurrogateKey(this.tfSurrogateKey.getText());
            this.designLevelSettings.getNamingStandardRule().setSurrogateKeyColumn(this.tfSurrogateKeyColumn.getText());
            this.designLevelSettings.getNamingStandardRule().setDiscriminatorColumn(this.tfDiscriminatorColumn.getText());
            if (this.dynamicPropertiesTable.getCellEditor() != null) {
                this.dynamicPropertiesTable.getCellEditor().stopCellEditing();
            }
            List<DesignLevelSettings.DPObject> list = this.designLevelSettings.getDynamicPropertiesList();
            list.clear();
            for (DesignLevelSettings.DPObject o : this.getDynamicPropertiesList()) {
                if (o.getPresentationName().trim().equals("") && !o.isVisible()) continue;
                list.add(o);
            }
            for (DesignPartView dpv : this.design.getAllDPVs()) {
                dpv.updateLegendSize();
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Unable to set design level settings: ", e);
        }
    }

    public void initProperties(boolean manualInit, Design curDesign) {
        if (curDesign != null) {
            this.design = curDesign;
        }
        this.initProperties(manualInit);
    }

    private void initProperties(boolean manualInit) {
        try {
            this.designLevelSettings = this.design.getDesignLevelSettings();
            this.classificationTypeList = this.designLevelSettings.getClassificationTypeList();
            this.defaultFCList = this.designLevelSettings.getDefaultFCObjects();
            this.defaultLWCList = this.designLevelSettings.getDefaultLWCObjects();
            this.substitutionList = this.designLevelSettings.getSubstitutionList();
            this.inInitProperties = true;
            this.oldObjectStatus = this.design.getAppView().getXMLTransformationManager().getFilteredXMLString(this.design);
            this.oldDLSettings = this.design.getDesignLevelSettings().getDesignLevelSettingsAsString();
            this.localClassificationTypeList.clear();
            for (ClassificationType classificationType : this.classificationTypeList) {
                this.localClassificationTypeList.add(classificationType.copy());
            }
            this.classificationTypeTable.updateUI();
            this.localDefaultFCList.clear();
            for (DefaultFontAndColor dfc : this.defaultFCList) {
                this.localDefaultFCList.add(dfc.copy());
            }
            this.tbDefaultFC.updateUI();
            this.localDefaultLWCList.clear();
            for (DefaultLineWidthAndColor dlwc : this.defaultLWCList) {
                this.localDefaultLWCList.add(dlwc.copy());
            }
            this.tbDefaultLWC.updateUI();
            if (this.designLevelSettings.isLogicalTypeForDomainPresentation()) {
                this.cbDomainPresentation.setSelectedItem(this.USE_LOGICAL_TYPE);
            } else {
                this.cbDomainPresentation.setSelectedItem(this.USE_DOMAN_NAME);
            }
            this.chAutomaticPKGeneration.setSelected(this.designLevelSettings.isAutomaticPKGeneration());
            this.chAutomaticUKGeneration.setSelected(this.designLevelSettings.isAutomaticUKGeneration());
            this.chAutomaticFKGeneration.setSelected(this.designLevelSettings.isAutomaticFKGeneration());
            this.cbPreserveDDLGenerationOptions.setSelected(this.designLevelSettings.isPreserveDDLGenerationOptions());
            if (this.tbSubstituiton.getCellEditor() != null) {
                this.tbSubstituiton.getCellEditor().stopCellEditing();
            }
            this.localSubstitutionList.clear();
            for (SubstitutionPattern substPattern : this.substitutionList) {
                this.localSubstitutionList.add(substPattern.copy());
            }
            this.tbSubstituiton.updateUI();
            String lSeparator = (String)this.logicalModelSeparatorMap.get(this.designLevelSettings.getNamingStandardRule().getLogicalSep());
            this.separatorBox.setSelectedItem(lSeparator);
            this.characterField.setText(this.designLevelSettings.getNamingStandardRule().getLogicalChar());
            this.separatorText.setText(this.designLevelSettings.getNamingStandardRule().getRelSep());
            this.abbreviatedOnly.setSelected(this.designLevelSettings.getNamingStandardRule().isAbbreviatedOnly());
            this.dmsSeparator.setText(this.designLevelSettings.getNamingStandardRule().getDomainsSep());
            this.glossariesList.clear();
            for (GlossaryFile file : this.designLevelSettings.getNamingStandardRule().getGlossariesList()) {
                Glossary glossary = new Glossary(new File(file.getFilePath()));
                this.glossariesList.add(new GlossaryFile(glossary.getName(), glossary.getDescription(), glossary.getFileName()));
            }
            this.glossaryTable.updateUI();
            this.nsAttributesList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getAttributesList()) {
                this.nsAttributesList.add(wr.copy());
            }
            this.nsAttributesTable.updateUI();
            this.nsColumnsList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getColumnsList()) {
                this.nsColumnsList.add(wr.copy());
            }
            this.nsColumnsTable.updateUI();
            this.nsDomainsList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getDomainsList()) {
                this.nsDomainsList.add(wr.copy());
            }
            this.nsDomainsTable.updateUI();
            this.nsEntitiesList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getEntitiesList()) {
                this.nsEntitiesList.add(wr.copy());
            }
            this.nsEntitiesTable.updateUI();
            this.nsTablesList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getTablesList()) {
                this.nsTablesList.add(wr.copy());
            }
            this.nsTablesTable.updateUI();
            String value = this.designLevelSettings.getNamingStandardRule().getPkConstr();
            if (value == null || "null".equals(value)) {
                this.tfPrimaryKey.setText(this.pkConsr);
            } else {
                this.tfPrimaryKey.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getFkConstr();
            if (value == null || "null".equals(value)) {
                this.tfForeignKey.setText(this.fkConsr);
            } else {
                this.tfForeignKey.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getCkConstr();
            if (value == null || "null".equals(value)) {
                this.tfCheckConstr.setText(this.ckConsr);
            } else {
                this.tfCheckConstr.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getUnConstr();
            if (value == null || "null".equals(value)) {
                this.tfUniqueConstr.setText(this.unConstr);
            } else {
                this.tfUniqueConstr.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getIdxConstr();
            if (value == null || "null".equals(value)) {
                this.tfIndex.setText(this.idxConstr);
            } else {
                this.tfIndex.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getAutomaticIdxConstr();
            if (value == null || "null".equals(value)) {
                this.tfAutomaticIndex.setText(this.automaticIdxConstr);
            } else {
                this.tfAutomaticIndex.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getColckConstr();
            if (value == null || "null".equals(value)) {
                this.tfColCheckConstr.setText(this.colckConstr);
            } else {
                this.tfColCheckConstr.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getColNNConstr();
            if (value == null || "null".equals(value)) {
                this.tfColNNConstr.setText(this.colNNConstr);
            } else {
                this.tfColNNConstr.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getUIConstr();
            if (value == null || "null".equals(value)) {
                this.tfPrimaryIdentifier.setText(this.uiConsr);
            } else {
                this.tfPrimaryIdentifier.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getRelationAttribute();
            if (value == null || "null".equals(value)) {
                this.tfAttributeRelation.setText(this.attrRelation);
            } else {
                this.tfAttributeRelation.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getFkColumn();
            if (value == null || "null".equals(value)) {
                this.tfColumnForeignKey.setText(this.colForeignKey);
            } else {
                this.tfColumnForeignKey.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getSurrogateKey();
            if (value == null || "null".equals(value)) {
                this.tfSurrogateKey.setText(this.surrogateKey);
            } else {
                this.tfSurrogateKey.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getSurrogateKeyColumn();
            if (value == null || "null".equals(value)) {
                this.tfSurrogateKeyColumn.setText(this.surrogateKeyCol);
            } else {
                this.tfSurrogateKeyColumn.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getDiscriminatorColumn();
            if (value == null || "null".equals(value)) {
                this.tfDiscriminatorColumn.setText(this.discriminatorCol);
            } else {
                this.tfDiscriminatorColumn.setText(value);
            }
            this.initDynamicProperties();
            this.initUserDefinedLibraries();
            if (!manualInit) {
                this.chbUseGlobalDLSettings.setSelected(this.designLevelSettings.isUseGlobalDesignLevelSettings());
            }
            this.inInitProperties = false;
            this.chbUsePreferredClassificationTypes.setSelected(this.designLevelSettings.isUsePreferredClassificationTypes());
            if (this.designLevelSettings.isUsePreferredClassificationTypes()) {
                this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.UseAllClassificationTypes"));
            } else {
                this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.UsePreferredClassificationTypes"));
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Unable to init design properties: ", e);
        }
    }

    private JPanel createPage(String title) {
        SearchablePanel panel = new SearchablePanel(new BorderLayout(0, 10));
        panel.setName(title);
        JPanel caption = new JPanel();
        caption.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        caption.setBackground(Color.WHITE);
        JLabel lb = new JLabel("<html><body><b>" + title + "</b></body></html>");
        caption.add(lb);
        panel.add((Component)caption, "North");
        return panel;
    }

    private List getDynamicPropertiesList() {
        return this.dynamicPropertiesList;
    }

    private void getDLSettingsDataToBeMerged() {
        this.usedClassTypes = new ArrayList();
        Iterator it0 = this.design.getLogicalDesign().getEntitySet().iterator();
        while (it0.hasNext()) {
            ContainerWithKeyObject o = (ContainerWithKeyObject)it0.next();
            ArrayList<ClassificationType> l = new ArrayList<ClassificationType>();
            if (o.getClassificationType() != null) {
                l.add(o.getClassificationType());
            }
            Iterator<String> adCTIDs = o.getAdditionalClassificationTypes().iterator();
            while (adCTIDs.hasNext()) {
                ClassificationType ct = this.designLevelSettings.getClassificationTypeByID(adCTIDs.next());
                if (ct == null) continue;
                l.add(ct);
            }
            for (ClassificationType ct : l) {
                String tID = ct.getTypeID();
                if (tID.equals("1") || tID.equals("2") || tID.equals("3") || tID.equals("4") || tID.equals("5") || tID.equals("6") || this.usedClassTypes.contains(tID)) continue;
                this.usedClassTypes.add(ct);
            }
        }
        for (RelationalDesign rd : this.design.getRelationalDesigns()) {
            Iterator itTables = rd.getTableSet().iterator();
            while (itTables.hasNext()) {
                ContainerWithKeyObject o = (ContainerWithKeyObject)itTables.next();
                ArrayList<ClassificationType> l = new ArrayList<ClassificationType>();
                if (o.getClassificationType() != null) {
                    l.add(o.getClassificationType());
                }
                Iterator<String> adCTIDs = o.getAdditionalClassificationTypes().iterator();
                while (adCTIDs.hasNext()) {
                    ClassificationType ct = this.designLevelSettings.getClassificationTypeByID(adCTIDs.next());
                    if (ct == null) continue;
                    l.add(ct);
                }
                for (ClassificationType ct : l) {
                    String tID = ct.getTypeID();
                    if (tID.equals("1") || tID.equals("2") || tID.equals("3") || tID.equals("4") || tID.equals("5") || tID.equals("6") || this.usedClassTypes.contains(tID)) continue;
                    this.usedClassTypes.add(ct);
                }
            }
        }
    }

    private void mergeDLSettingsData() {
        this.designLevelSettings.getClassificationTypeList().addAll(this.usedClassTypes);
    }

    private void initDynamicProperties() {
        Object type;
        List<DesignLevelSettings.DPObject> dlDPList = this.designLevelSettings.getDynamicPropertiesList();
        HashMap<String, Object> allDPMap = new HashMap<String, Object>();
        Iterator eIt = this.design.getLogicalDesign().getEntitySet().iterator();
        while (eIt.hasNext()) {
            Entity obj = (Entity)eIt.next();
            Iterator itPN = obj.getPropertyNames();
            while (itPN.hasNext()) {
                String name = (String)itPN.next();
                type = (String)allDPMap.get(name);
                if (type != null) {
                    if ("table".equals(type)) {
                        type = (String)type + "/entity";
                        allDPMap.put(name, type);
                        continue;
                    }
                    if (!"".equals(type)) continue;
                    type = "entity";
                    allDPMap.put(name, type);
                    continue;
                }
                type = "entity";
                allDPMap.put(name, type);
            }
        }
        for (RelationalDesign rd : this.design.getRelationalDesigns()) {
            Iterator tIt = rd.getTableSet().iterator();
            while (tIt.hasNext()) {
                Table obj = (Table)tIt.next();
                Iterator itPN = obj.getPropertyNames();
                while (itPN.hasNext()) {
                    String name = (String)itPN.next();
                    Object type2 = (String)allDPMap.get(name);
                    if (type2 != null) {
                        if ("entity".equals(type2)) {
                            type2 = (String)type2 + "/table";
                            allDPMap.put(name, type2);
                            continue;
                        }
                        if (!"".equals(type2)) continue;
                        type2 = "table";
                        allDPMap.put(name, type2);
                        continue;
                    }
                    type2 = "table";
                    allDPMap.put(name, type2);
                }
            }
        }
        for (DesignLevelSettings.DPObject d : dlDPList) {
            type = d.getType();
            if (type == null || "".equals(type)) {
                type = (String)allDPMap.get(d.getName());
            }
            DesignLevelSettings designLevelSettings = this.designLevelSettings;
            Objects.requireNonNull(designLevelSettings);
            DesignLevelSettings.DPObject dpObject = designLevelSettings.new DesignLevelSettings.DPObject(d.getName(), (String)type, d.getPresentationName(), true);
            boolean exists = false;
            List dpList = this.getDynamicPropertiesList();
            for (DesignLevelSettings.DPObject dpo : dpList) {
                if (!dpo.getName().equals(dpObject.getName()) || !dpo.getType().equals(dpObject.getType()) || !dpo.getPresentationName().equals(dpObject.getPresentationName())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.getDynamicPropertiesList().add(dpObject);
        }
        for (Map.Entry pairs : allDPMap.entrySet()) {
            String name = (String)pairs.getKey();
            String type3 = (String)pairs.getValue();
            DesignLevelSettings.DPObject dpObject = null;
            boolean found = false;
            for (DesignLevelSettings.DPObject d : dlDPList) {
                if (!d.getName().equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            boolean notUDP = false;
            for (UserDefinedProperty p : this.design.getUserDefinedProperties()) {
                if (!name.equals(p.getName())) continue;
                notUDP = true;
                break;
            }
            if (notUDP) continue;
            DesignLevelSettings designLevelSettings = this.designLevelSettings;
            Objects.requireNonNull(designLevelSettings);
            dpObject = designLevelSettings.new DesignLevelSettings.DPObject(name, type3, "", false);
            boolean exists = false;
            List dpList = this.getDynamicPropertiesList();
            for (DesignLevelSettings.DPObject dpo : dpList) {
                if (!dpo.getName().equals(dpObject.getName()) || !dpo.getType().equals(dpObject.getType()) || !dpo.getPresentationName().equals(dpObject.getPresentationName())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.getDynamicPropertiesList().add(dpObject);
        }
        TableRowSorter trs = new TableRowSorter();
        if (this.getDynamicPropertiesList().size() > 0) {
            this.propertyNameFilter.setEnabled(true);
            this.dynamicPropertiesTable.setRowSorter(trs);
            this.dynamicPropertiesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.dynamicPropertiesTable, 0);
        } else {
            this.propertyNameFilter.setEnabled(false);
        }
    }

    public JPanel getDDLPanel() {
        if (this.pnDDL == null) {
            this.pnDDL = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.DDL"));
            JPanel pnIndexGeneration = new JPanel((LayoutManager)new MigLayout("fillx", "[]", "0[]0[]0[]0"));
            pnIndexGeneration.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.AutoIndexGeneration")));
            this.chAutomaticPKGeneration = new JCheckBox(Messages.getString("DesignLevelSettingsPropertiesDialog.PKConstraint"));
            pnIndexGeneration.add((Component)this.chAutomaticPKGeneration, new CC().growX().wrap());
            this.chAutomaticUKGeneration = new JCheckBox(Messages.getString("DesignLevelSettingsPropertiesDialog.UKConstraint"));
            pnIndexGeneration.add((Component)this.chAutomaticUKGeneration, new CC().wrap());
            this.chAutomaticFKGeneration = new JCheckBox(Messages.getString("DesignLevelSettingsPropertiesDialog.FKConstraint"));
            pnIndexGeneration.add((Component)this.chAutomaticFKGeneration, new CC().wrap());
            if (ApplicationView.IS_VIEWER) {
                this.chAutomaticPKGeneration.setEnabled(false);
                this.chAutomaticUKGeneration.setEnabled(false);
                this.chAutomaticFKGeneration.setEnabled(false);
            } else {
                this.chAutomaticPKGeneration.setEnabled(true);
                this.chAutomaticUKGeneration.setEnabled(true);
                this.chAutomaticFKGeneration.setEnabled(true);
            }
            JPanel pnPreserveCurrentDDLGenerationOptionsSelection = new JPanel((LayoutManager)new MigLayout("fillx", "[]", "0[]0[]0"));
            pnPreserveCurrentDDLGenerationOptionsSelection.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.PreserveCurrentDDLGenerationOptions")));
            this.cbPreserveDDLGenerationOptions = new JCheckBox(Messages.getString("DesignLevelSettingsPropertiesDialog.PreserveDDLGenerationOptions"));
            pnPreserveCurrentDDLGenerationOptionsSelection.add(this.cbPreserveDDLGenerationOptions);
            this.cbPreserveDDLGenerationOptions.setSelected(true);
            this.cbPreserveDDLGenerationOptions.setEnabled(true);
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fillx", "[]", "[][]"));
            jp.add((Component)pnIndexGeneration, new CC().grow().wrap());
            jp.add((Component)pnPreserveCurrentDDLGenerationOptionsSelection, new CC().grow());
            this.pnDDL.add((Component)jp, "Center");
        }
        return this.pnDDL;
    }

    public JPanel getDDLMIgrationPanel() {
        if (this.pnDDLMigration == null) {
            this.pnDDLMigration = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Migration"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.NameSubstitution")));
            this.localSubstitutionList = new ArrayList();
            this.tbSubstituiton = new JTable(new SubstitutionModel());
            this.tbSubstituiton.setSelectionMode(0);
            this.tbSubstituiton.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.getSelectedRow();
                    if (selRow == -1) {
                        DesignLevelSettingsPropertiesDialog.this.bnRemoveSubstitution.setEnabled(false);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.bnRemoveSubstitution.setEnabled(true);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.tbSubstituiton);
            JButton bnAddSubstitution = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            bnAddSubstitution.setToolTipText(BTN_ADD);
            bnAddSubstitution.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SubstitutionPattern substPattern = new SubstitutionPattern();
                    DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.add(substPattern);
                    DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.getSelectionModel().setSelectionInterval(DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.getRowCount() - 1, DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.getRowCount() - 1);
                    DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.updateUI();
                    DesignLevelSettingsPropertiesDialog.this.bnSelectAllSubstitutions.setEnabled(true);
                    DesignLevelSettingsPropertiesDialog.this.bnDeselectAllSubstitutions.setEnabled(true);
                }
            });
            this.bnRemoveSubstitution = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnRemoveSubstitution.setToolTipText(BTN_REMOVE);
            this.bnRemoveSubstitution.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.getSelectedRow();
                    if (objectNumber != -1 && DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.size() > 0 && objectNumber < DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.size()) {
                        SubstitutionPattern substPattern = (SubstitutionPattern)DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.get(objectNumber);
                        DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.remove(substPattern);
                        DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.updateUI();
                    }
                    if (DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.size() > 0) {
                        DesignLevelSettingsPropertiesDialog.this.bnRemoveSubstitution.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.bnSelectAllSubstitutions.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.bnDeselectAllSubstitutions.setEnabled(true);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.bnRemoveSubstitution.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.bnSelectAllSubstitutions.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.bnDeselectAllSubstitutions.setEnabled(false);
                    }
                }
            });
            this.bnRemoveSubstitution.setEnabled(false);
            this.bnSelectAllSubstitutions = new JButton(this.configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
            this.bnSelectAllSubstitutions.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.SelectAll"));
            this.bnSelectAllSubstitutions.addActionListener(new SelectAllSubstitutionAction());
            this.bnSelectAllSubstitutions.setEnabled(false);
            this.bnDeselectAllSubstitutions = new JButton(this.configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
            this.bnDeselectAllSubstitutions.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.DeselectAll"));
            this.bnDeselectAllSubstitutions.addActionListener(new DeselectAllSubstitutionAction());
            this.bnDeselectAllSubstitutions.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(bnAddSubstitution);
            toolBar.add(this.bnRemoveSubstitution);
            toolBar.addSeparator();
            toolBar.add(this.bnSelectAllSubstitutions);
            toolBar.add(this.bnDeselectAllSubstitutions);
            jp.add((Component)toolBar, new CC().dockNorth());
            jp.add((Component)scrollpane, new CC().grow());
            this.pnDDLMigration.add((Component)jp, "Center");
        }
        return this.pnDDLMigration;
    }

    public JPanel getDiagramClassificationTypesPanel() {
        if (this.pnClassificationTypes == null) {
            this.pnClassificationTypes = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.ClassificationTypes"));
            try {
                this.classificationTypeTable = new JTable(new ClassificationTypeModel());
                TableColumn classificationTypeColumn = this.classificationTypeTable.getColumnModel().getColumn(2);
                classificationTypeColumn.setCellEditor(new ClassificationTypeFormatCellEditor());
                classificationTypeColumn.setCellRenderer(new ClassificationTypeFormatCellRenderer());
                this.classificationTypeTable.setSelectionMode(0);
                JScrollPane scrollpane = new JScrollPane(this.classificationTypeTable);
                JButton bnAddClassificationType = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                bnAddClassificationType.setToolTipText(BTN_ADD);
                bnAddClassificationType.addActionListener(new AddClassificationTypeAction());
                this.bnRemoveClassificationType = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.bnRemoveClassificationType.setToolTipText(BTN_REMOVE);
                this.bnRemoveClassificationType.addActionListener(new RemoveClassificationType());
                this.bnRemoveClassificationType.setEnabled(false);
                this.classificationTypeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            int objectNumber = DesignLevelSettingsPropertiesDialog.this.classificationTypeTable.getSelectedRow();
                            if (objectNumber != -1) {
                                if (DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.size() > 0 && objectNumber < DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.size()) {
                                    ClassificationType classType = (ClassificationType)DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.get(objectNumber);
                                    DesignLevelSettingsPropertiesDialog.this.bnRemoveClassificationType.setEnabled(!classType.isReadOnly());
                                }
                            } else if (objectNumber == -1) {
                                DesignLevelSettingsPropertiesDialog.this.bnRemoveClassificationType.setEnabled(false);
                            }
                        }
                    }
                });
                this.classificationTypeTable.getTableHeader().setReorderingAllowed(false);
                TableColumn col3 = this.classificationTypeTable.getColumnModel().getColumn(3);
                col3.setMinWidth(70);
                col3.setMaxWidth(70);
                this.chbUsePreferredClassificationTypes = new JCheckBox(Messages.getString("DesignLevelSettingsPropertiesDialog.Preferred"));
                this.chbUsePreferredClassificationTypes.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            DesignLevelSettingsPropertiesDialog.this.designLevelSettings.setUsePreferredClassificationTypes(true);
                            DesignLevelSettingsPropertiesDialog.this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.UseAllClassificationTypes"));
                        } else if (e.getStateChange() == 2) {
                            DesignLevelSettingsPropertiesDialog.this.designLevelSettings.setUsePreferredClassificationTypes(false);
                            DesignLevelSettingsPropertiesDialog.this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.UsePreferredClassificationTypes"));
                        }
                    }
                });
                JToolBar toolBar = new JToolBar(0);
                toolBar.setFloatable(false);
                toolBar.add(bnAddClassificationType);
                toolBar.add(this.bnRemoveClassificationType);
                toolBar.addSeparator();
                toolBar.add(this.chbUsePreferredClassificationTypes);
                JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
                jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.Type")));
                jp.add((Component)toolBar, new CC().dockNorth());
                jp.add((Component)scrollpane, new CC().grow());
                this.pnClassificationTypes.add((Component)jp, "Center");
            }
            catch (Exception e) {
                this.LOGGER.error("Unable to create Diagram -> Classification Types panel: ", e);
            }
        }
        return this.pnClassificationTypes;
    }

    public JPanel getDiagramFormatPanel() {
        if (this.pnFormat == null) {
            this.pnFormat = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Format"));
            JTabbedPane tabbed = new JTabbedPane();
            this.localDefaultFCList = new ArrayList();
            this.tbDefaultFC = new JTable(new DefaultFCModel());
            this.tbDefaultFC.setSelectionMode(0);
            FontsAndColorsCellRenderer dfcRenderer = new FontsAndColorsCellRenderer();
            TableColumn tvColumn = this.tbDefaultFC.getColumnModel().getColumn(1);
            tvColumn.setCellRenderer(dfcRenderer);
            tvColumn = this.tbDefaultFC.getColumnModel().getColumn(2);
            tvColumn.setCellRenderer(dfcRenderer);
            this.tbDefaultFC.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int objectNumber;
                    if (e.getClickCount() == 2 && (objectNumber = DesignLevelSettingsPropertiesDialog.this.tbDefaultFC.getSelectedRow()) != -1 && DesignLevelSettingsPropertiesDialog.this.localDefaultFCList.size() > 0 && objectNumber < DesignLevelSettingsPropertiesDialog.this.localDefaultFCList.size()) {
                        DefaultFontAndColor dfc = (DefaultFontAndColor)DesignLevelSettingsPropertiesDialog.this.localDefaultFCList.get(objectNumber);
                        new TopViewColorDialog(dfc).setVisible(true);
                        DesignLevelSettingsPropertiesDialog.this.tbDefaultFC.updateUI();
                        DesignLevelSettingsPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.tbDefaultFC);
            JButton bnEdit = new JButton(this.configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            bnEdit.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.Modify"));
            bnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = DesignLevelSettingsPropertiesDialog.this.tbDefaultFC.getSelectedRow();
                    if (objectNumber != -1 && DesignLevelSettingsPropertiesDialog.this.localDefaultFCList.size() > 0 && objectNumber < DesignLevelSettingsPropertiesDialog.this.localDefaultFCList.size()) {
                        DefaultFontAndColor dfc = (DefaultFontAndColor)DesignLevelSettingsPropertiesDialog.this.localDefaultFCList.get(objectNumber);
                        new TopViewColorDialog(dfc).setVisible(true);
                        DesignLevelSettingsPropertiesDialog.this.tbDefaultFC.updateUI();
                        DesignLevelSettingsPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(bnEdit);
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            jp.add((Component)toolBar, new CC().dockNorth());
            jp.add((Component)scrollpane, new CC().grow());
            tabbed.add(Messages.getString("DesignLevelSettingsPropertiesDialog.DefaultObjectFOC"), jp);
            this.localDefaultLWCList = new ArrayList();
            this.tbDefaultLWC = new JTable(new DefaultLWCModel());
            this.tbDefaultLWC.setSelectionMode(0);
            TableColumn tcColor = this.tbDefaultLWC.getColumnModel().getColumn(1);
            tcColor.setCellRenderer(new LineColorCellRenderer());
            tcColor.setCellEditor(new ColorEditor());
            TableColumn tcWidth = this.tbDefaultLWC.getColumnModel().getColumn(2);
            tcWidth.setCellRenderer(new LineWidthCellRenderer());
            tcWidth.setCellEditor(new LWCCellEditor());
            tcWidth.setMinWidth(130);
            tcWidth.setMaxWidth(130);
            JScrollPane scrollpane1 = new JScrollPane(this.tbDefaultLWC);
            JPanel jp1 = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            jp1.add((Component)scrollpane1, new CC().grow());
            tabbed.add(Messages.getString("DesignLevelSettingsPropertiesDialog.DefaultLWC"), jp1);
            this.pnFormat.add((Component)tabbed, "Center");
        }
        return this.pnFormat;
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    public JPanel getDiagramLogicalPanel() {
        if (this.pnDiagramLogical == null) {
            this.pnDiagramLogical = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.LogicalModel"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("", "[]", "[]"));
            JLabel lbDomainPresentation = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.DomainsPresentation"));
            this.cbDomainPresentation = new JComboBox<String>(new DefaultComboBoxModel<String>(this.domain_presentation));
            if (ApplicationView.IS_VIEWER && !this.getApplicationView().getCurrentDesign().isNewDesign()) {
                this.cbDomainPresentation.setEnabled(false);
            } else {
                this.cbDomainPresentation.setEnabled(true);
            }
            jp.add(lbDomainPresentation);
            jp.add(this.cbDomainPresentation);
            this.pnDiagramLogical.add((Component)jp, "Center");
        }
        return this.pnDiagramLogical;
    }

    public JPanel getNamingStandardAttributePanel() {
        if (this.pnNamingStandardAttribute == null) {
            this.pnNamingStandardAttribute = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Attribute"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            JButton btnAddAttributeNS = new JButton(this.configuration.getIcon("ADD_ICON", 16));
            btnAddAttributeNS.setToolTipText(BTN_ADD);
            this.btnRemoveAttributeNS = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
            this.btnRemoveAttributeNS.setEnabled(false);
            this.btnRemoveAttributeNS.setToolTipText(BTN_REMOVE);
            this.btnMoveUpAttribuiteNS = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
            this.btnMoveUpAttribuiteNS.setEnabled(false);
            this.btnMoveUpAttribuiteNS.setToolTipText(BTN_UP);
            this.btnMoveDownAttribuiteNS = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
            this.btnMoveDownAttribuiteNS.setEnabled(false);
            this.btnMoveDownAttribuiteNS.setToolTipText(BTN_DOWN);
            btnAddAttributeNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.addToNSTable(DesignLevelSettingsPropertiesDialog.this.nsAttributesTable, DesignLevelSettingsPropertiesDialog.this.nsAttributesList);
                }
            });
            this.btnRemoveAttributeNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rows = DesignLevelSettingsPropertiesDialog.this.removeFromNSTable(DesignLevelSettingsPropertiesDialog.this.nsAttributesTable, DesignLevelSettingsPropertiesDialog.this.nsAttributesList);
                    if (rows == 0) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveAttributeNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpAttribuiteNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownAttribuiteNS.setEnabled(false);
                    }
                }
            });
            this.btnMoveUpAttribuiteNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementUp(DesignLevelSettingsPropertiesDialog.this.nsAttributesTable, DesignLevelSettingsPropertiesDialog.this.nsAttributesList);
                }
            });
            this.btnMoveDownAttribuiteNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementDown(DesignLevelSettingsPropertiesDialog.this.nsAttributesTable, DesignLevelSettingsPropertiesDialog.this.nsAttributesList);
                }
            });
            toolBar.add(btnAddAttributeNS);
            toolBar.add(this.btnRemoveAttributeNS);
            toolBar.addSeparator();
            toolBar.add(this.btnMoveUpAttribuiteNS);
            toolBar.add(this.btnMoveDownAttribuiteNS);
            this.nsAttributesTable = new JTable(new AttributeTableModel());
            JTableHeader header = this.nsAttributesTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsAttributesTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this.namePartMap.values().toArray())));
            this.nsAttributesTable.setSelectionMode(0);
            this.nsAttributesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = DesignLevelSettingsPropertiesDialog.this.nsAttributesTable.getSelectedRow();
                    if (selRow == -1) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveAttributeNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpAttribuiteNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownAttribuiteNS.setEnabled(false);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveAttributeNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpAttribuiteNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownAttribuiteNS.setEnabled(true);
                    }
                }
            });
            jp.add((Component)toolBar, new CC().dockNorth());
            jp.add((Component)new JScrollPane(this.nsAttributesTable), new CC().grow());
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsAttributesTable.setEnabled(false);
            }
            this.pnNamingStandardAttribute.add((Component)jp, "Center");
        }
        return this.pnNamingStandardAttribute;
    }

    public JPanel getNamingStandardColumnPanel() {
        if (this.pnNamingStandardColumn == null) {
            this.pnNamingStandardColumn = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Column"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            JButton btnAddColumnNS = new JButton(this.configuration.getIcon("ADD_ICON", 16));
            btnAddColumnNS.setToolTipText(BTN_ADD);
            this.btnRemoveColumnNS = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
            this.btnRemoveColumnNS.setEnabled(false);
            this.btnRemoveColumnNS.setToolTipText(BTN_REMOVE);
            this.btnMoveUpColumnNS = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
            this.btnMoveUpColumnNS.setEnabled(false);
            this.btnMoveUpColumnNS.setToolTipText(BTN_UP);
            this.btnMoveDownColumnNS = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
            this.btnMoveDownColumnNS.setEnabled(false);
            this.btnMoveDownColumnNS.setToolTipText(BTN_DOWN);
            btnAddColumnNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.addToNSTable(DesignLevelSettingsPropertiesDialog.this.nsColumnsTable, DesignLevelSettingsPropertiesDialog.this.nsColumnsList);
                }
            });
            this.btnRemoveColumnNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rows = DesignLevelSettingsPropertiesDialog.this.removeFromNSTable(DesignLevelSettingsPropertiesDialog.this.nsColumnsTable, DesignLevelSettingsPropertiesDialog.this.nsColumnsList);
                    if (rows == 0) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveColumnNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpColumnNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownColumnNS.setEnabled(false);
                    }
                }
            });
            this.btnMoveUpColumnNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementUp(DesignLevelSettingsPropertiesDialog.this.nsColumnsTable, DesignLevelSettingsPropertiesDialog.this.nsColumnsList);
                }
            });
            this.btnMoveDownColumnNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementDown(DesignLevelSettingsPropertiesDialog.this.nsColumnsTable, DesignLevelSettingsPropertiesDialog.this.nsColumnsList);
                }
            });
            toolBar.add(btnAddColumnNS);
            toolBar.add(this.btnRemoveColumnNS);
            toolBar.addSeparator();
            toolBar.add(this.btnMoveUpColumnNS);
            toolBar.add(this.btnMoveDownColumnNS);
            this.nsColumnsTable = new JTable(new ColumnTableModel());
            JTableHeader header = this.nsColumnsTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsColumnsTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this.namePartMap.values().toArray())));
            this.nsColumnsTable.setSelectionMode(0);
            this.nsColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = DesignLevelSettingsPropertiesDialog.this.nsColumnsTable.getSelectedRow();
                    if (selRow == -1) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveColumnNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpColumnNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownColumnNS.setEnabled(false);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveColumnNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpColumnNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownColumnNS.setEnabled(true);
                    }
                }
            });
            jp.add((Component)toolBar, new CC().dockNorth());
            jp.add((Component)new JScrollPane(this.nsColumnsTable), new CC().grow());
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsColumnsTable.setEnabled(false);
            }
            this.pnNamingStandardColumn.add((Component)jp, "Center");
        }
        return this.pnNamingStandardColumn;
    }

    public JPanel getNamingStandardDomainPanel() {
        if (this.pnNamingStandardDomain == null) {
            this.pnNamingStandardDomain = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Domain"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            JButton btnAddDomainNS = new JButton(this.configuration.getIcon("ADD_ICON", 16));
            btnAddDomainNS.setToolTipText(BTN_ADD);
            this.btnRemoveDomainNS = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
            this.btnRemoveDomainNS.setEnabled(false);
            this.btnRemoveDomainNS.setToolTipText(BTN_REMOVE);
            this.btnMoveUpDomainNS = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
            this.btnMoveUpDomainNS.setEnabled(false);
            this.btnMoveUpDomainNS.setToolTipText(BTN_UP);
            this.btnMoveDownDomainNS = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
            this.btnMoveDownDomainNS.setEnabled(false);
            this.btnMoveDownDomainNS.setToolTipText(BTN_DOWN);
            btnAddDomainNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.addToNSTable(DesignLevelSettingsPropertiesDialog.this.nsDomainsTable, DesignLevelSettingsPropertiesDialog.this.nsDomainsList);
                }
            });
            this.btnRemoveDomainNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rows = DesignLevelSettingsPropertiesDialog.this.removeFromNSTable(DesignLevelSettingsPropertiesDialog.this.nsDomainsTable, DesignLevelSettingsPropertiesDialog.this.nsDomainsList);
                    if (rows == 0) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveDomainNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpDomainNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownDomainNS.setEnabled(false);
                    }
                }
            });
            this.btnMoveUpDomainNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementUp(DesignLevelSettingsPropertiesDialog.this.nsDomainsTable, DesignLevelSettingsPropertiesDialog.this.nsDomainsList);
                }
            });
            this.btnMoveDownDomainNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementDown(DesignLevelSettingsPropertiesDialog.this.nsDomainsTable, DesignLevelSettingsPropertiesDialog.this.nsDomainsList);
                }
            });
            toolBar.add(btnAddDomainNS);
            toolBar.add(this.btnRemoveDomainNS);
            toolBar.addSeparator();
            toolBar.add(this.btnMoveUpDomainNS);
            toolBar.add(this.btnMoveDownDomainNS);
            this.nsDomainsTable = new JTable(new DomainTableModel());
            JTableHeader header = this.nsDomainsTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsDomainsTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this.namePartMap.values().toArray())));
            this.nsDomainsTable.setSelectionMode(0);
            this.nsDomainsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = DesignLevelSettingsPropertiesDialog.this.nsDomainsTable.getSelectedRow();
                    if (selRow == -1) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveDomainNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpDomainNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownDomainNS.setEnabled(false);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveDomainNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpDomainNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownDomainNS.setEnabled(true);
                    }
                }
            });
            jp.add((Component)toolBar, new CC().dockNorth());
            jp.add((Component)new JScrollPane(this.nsDomainsTable), new CC().grow());
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsDomainsTable.setEnabled(false);
            }
            this.pnNamingStandardDomain.add((Component)jp, "Center");
        }
        return this.pnNamingStandardDomain;
    }

    public JPanel getNamingStandardEntityPanel() {
        if (this.pnNamingStandardEntity == null) {
            this.pnNamingStandardEntity = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Entity"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            JButton btnAddEntityNS = new JButton(this.configuration.getIcon("ADD_ICON", 16));
            btnAddEntityNS.setToolTipText(BTN_ADD);
            this.btnRemoveEntityNS = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
            this.btnRemoveEntityNS.setEnabled(false);
            this.btnRemoveEntityNS.setToolTipText(BTN_REMOVE);
            this.btnMoveUpEntityNS = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
            this.btnMoveUpEntityNS.setEnabled(false);
            this.btnMoveUpEntityNS.setToolTipText(BTN_UP);
            this.btnMoveDownEntityNS = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
            this.btnMoveDownEntityNS.setEnabled(false);
            this.btnMoveDownEntityNS.setToolTipText(BTN_DOWN);
            btnAddEntityNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.addToNSTable(DesignLevelSettingsPropertiesDialog.this.nsEntitiesTable, DesignLevelSettingsPropertiesDialog.this.nsEntitiesList);
                }
            });
            this.btnRemoveEntityNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rows = DesignLevelSettingsPropertiesDialog.this.removeFromNSTable(DesignLevelSettingsPropertiesDialog.this.nsEntitiesTable, DesignLevelSettingsPropertiesDialog.this.nsEntitiesList);
                    if (rows == 0) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveEntityNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpEntityNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownEntityNS.setEnabled(false);
                    }
                }
            });
            this.btnMoveUpEntityNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementUp(DesignLevelSettingsPropertiesDialog.this.nsEntitiesTable, DesignLevelSettingsPropertiesDialog.this.nsEntitiesList);
                }
            });
            this.btnMoveDownEntityNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementDown(DesignLevelSettingsPropertiesDialog.this.nsEntitiesTable, DesignLevelSettingsPropertiesDialog.this.nsEntitiesList);
                }
            });
            toolBar.add(btnAddEntityNS);
            toolBar.add(this.btnRemoveEntityNS);
            toolBar.addSeparator();
            toolBar.add(this.btnMoveUpEntityNS);
            toolBar.add(this.btnMoveDownEntityNS);
            this.nsEntitiesTable = new JTable(new EntityTableModel());
            JTableHeader header = this.nsEntitiesTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsEntitiesTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this.namePartMap.values().toArray())));
            this.nsEntitiesTable.setSelectionMode(0);
            this.nsEntitiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = DesignLevelSettingsPropertiesDialog.this.nsEntitiesTable.getSelectedRow();
                    if (selRow == -1) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveEntityNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpEntityNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownEntityNS.setEnabled(false);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveEntityNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpEntityNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownEntityNS.setEnabled(true);
                    }
                }
            });
            jp.add((Component)toolBar, new CC().dockNorth());
            jp.add((Component)new JScrollPane(this.nsEntitiesTable), new CC().grow());
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsEntitiesTable.setEnabled(false);
            }
            this.pnNamingStandardEntity.add((Component)jp, "Center");
        }
        return this.pnNamingStandardEntity;
    }

    public JPanel getNamingStandardTablePanel() {
        if (this.pnNamingStandardTable == null) {
            this.pnNamingStandardTable = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Table"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            JButton btnAddTableNS = new JButton(this.configuration.getIcon("ADD_ICON", 16));
            btnAddTableNS.setToolTipText(BTN_ADD);
            this.btnRemoveTableNS = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
            this.btnRemoveTableNS.setEnabled(false);
            this.btnRemoveTableNS.setToolTipText(BTN_REMOVE);
            this.btnMoveUpTableNS = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
            this.btnMoveUpTableNS.setEnabled(false);
            this.btnMoveUpTableNS.setToolTipText(BTN_UP);
            this.btnMoveDownTableNS = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
            this.btnMoveDownTableNS.setEnabled(false);
            this.btnMoveDownTableNS.setToolTipText(BTN_DOWN);
            btnAddTableNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.addToNSTable(DesignLevelSettingsPropertiesDialog.this.nsTablesTable, DesignLevelSettingsPropertiesDialog.this.nsTablesList);
                }
            });
            this.btnRemoveTableNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rows = DesignLevelSettingsPropertiesDialog.this.removeFromNSTable(DesignLevelSettingsPropertiesDialog.this.nsTablesTable, DesignLevelSettingsPropertiesDialog.this.nsTablesList);
                    if (rows == 0) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveTableNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpTableNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownTableNS.setEnabled(false);
                    }
                }
            });
            this.btnMoveUpTableNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementUp(DesignLevelSettingsPropertiesDialog.this.nsTablesTable, DesignLevelSettingsPropertiesDialog.this.nsTablesList);
                }
            });
            this.btnMoveDownTableNS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignLevelSettingsPropertiesDialog.this.moveNSElementDown(DesignLevelSettingsPropertiesDialog.this.nsTablesTable, DesignLevelSettingsPropertiesDialog.this.nsTablesList);
                }
            });
            toolBar.add(btnAddTableNS);
            toolBar.add(this.btnRemoveTableNS);
            toolBar.addSeparator();
            toolBar.add(this.btnMoveUpTableNS);
            toolBar.add(this.btnMoveDownTableNS);
            this.nsTablesTable = new JTable(new TableElementModel());
            JTableHeader header = this.nsTablesTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsTablesTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this.namePartMap.values().toArray())));
            this.nsTablesTable.setSelectionMode(0);
            this.nsTablesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = DesignLevelSettingsPropertiesDialog.this.nsTablesTable.getSelectedRow();
                    if (selRow == -1) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveTableNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpTableNS.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownTableNS.setEnabled(false);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveTableNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveUpTableNS.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnMoveDownTableNS.setEnabled(true);
                    }
                }
            });
            jp.add((Component)toolBar, new CC().dockNorth());
            jp.add((Component)new JScrollPane(this.nsTablesTable), new CC().grow());
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsTablesTable.setEnabled(false);
            }
            this.pnNamingStandardTable.add((Component)jp, "Center");
        }
        return this.pnNamingStandardTable;
    }

    public JPanel getNamingStandardTemplatesPanel() {
        if (this.pnNamingStandardTemplates == null) {
            this.pnNamingStandardTemplates = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.Templates"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fillx", "[]", "[]"));
            JPanel constraintsPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[130::][grow,fill][]", "0[]0[]0[]0[]0[]0[]0[]0[]0[]0[]0[]0[]0"));
            constraintsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.TableConstraints")));
            JLabel pkLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.PrimaryKey"));
            this.tfPrimaryKey = new JTextField();
            this.tfPrimaryKey.setText(this.pkConsr);
            JButton addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] namePK = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnAbbreviation")}, {"{model}", Messages.getString("DesignLevelSettingsPropertiesDialog.ModelName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(namePK, DesignLevelSettingsPropertiesDialog.this.tfPrimaryKey);
                }
            });
            constraintsPanel.add(pkLabel);
            constraintsPanel.add((Component)this.tfPrimaryKey, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel fkLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.FK"));
            this.tfForeignKey = new JTextField();
            this.tfForeignKey.setText(this.fkConsr);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameFK = new String[][]{{"{parent}", Messages.getString("DesignLevelSettingsPropertiesDialog.ParentTableName")}, {"{parent abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ParentTableAbbreviation")}, {"{child}", Messages.getString("DesignLevelSettingsPropertiesDialog.ChildTableName")}, {"{child abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ChildTableAbbreviation")}, {"{seq nr}", Messages.getString("DesignLevelSettingsPropertiesDialog.SeqNumber")}, {"{model}", Messages.getString("DesignLevelSettingsPropertiesDialog.ModelName")}, {"{relationship}", Messages.getString("DesignLevelSettingsPropertiesDialog.RelationshipName")}, {"{ref column}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefColName")}, {"{ref column abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefColAbbreviation")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameFK, DesignLevelSettingsPropertiesDialog.this.tfForeignKey);
                }
            });
            constraintsPanel.add(fkLabel);
            constraintsPanel.add((Component)this.tfForeignKey, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel ccLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.CheckConstraint"));
            this.tfCheckConstr = new JTextField();
            this.tfCheckConstr.setText(this.ckConsr);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameCK = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{seq nr}", Messages.getString("DesignLevelSettingsPropertiesDialog.SeqNumber")}, {"{model}", Messages.getString("DesignLevelSettingsPropertiesDialog.ModelName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameCK, DesignLevelSettingsPropertiesDialog.this.tfCheckConstr);
                }
            });
            constraintsPanel.add(ccLabel);
            constraintsPanel.add((Component)this.tfCheckConstr, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel unLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.UK"));
            this.tfUniqueConstr = new JTextField();
            this.tfUniqueConstr.setText(this.unConstr);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameUC = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnAbbreviation")}, {"{seq nr}", Messages.getString("DesignLevelSettingsPropertiesDialog.SeqNumber")}, {"{model}", Messages.getString("DesignLevelSettingsPropertiesDialog.ModelName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameUC, DesignLevelSettingsPropertiesDialog.this.tfUniqueConstr);
                }
            });
            constraintsPanel.add(unLabel);
            constraintsPanel.add((Component)this.tfUniqueConstr, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel idxLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.Index"));
            this.tfIndex = new JTextField();
            this.tfIndex.setText(this.idxConstr);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] index = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnAbbreviation")}, {"{seq nr}", Messages.getString("DesignLevelSettingsPropertiesDialog.SeqNumber")}, {"{model}", Messages.getString("DesignLevelSettingsPropertiesDialog.ModelName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(index, DesignLevelSettingsPropertiesDialog.this.tfIndex);
                }
            });
            constraintsPanel.add(idxLabel);
            constraintsPanel.add((Component)this.tfIndex, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel automaticIndexLabel = new JLabel(this.automaticIndexText);
            this.tfAutomaticIndex = new JTextField();
            this.tfAutomaticIndex.setText(this.idxConstr);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] automaticIndex = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnAbbreviation")}, {"{constraint}", Messages.getString("DesignLevelSettingsPropertiesDialog.Constraint")}, {"{model}", Messages.getString("DesignLevelSettingsPropertiesDialog.ModelName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(automaticIndex, DesignLevelSettingsPropertiesDialog.this.tfAutomaticIndex);
                }
            });
            constraintsPanel.add(automaticIndexLabel);
            constraintsPanel.add((Component)this.tfAutomaticIndex, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel cccLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnCheckConstraint"));
            this.tfColCheckConstr = new JTextField();
            this.tfColCheckConstr.setText(this.colckConstr);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameCC = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnAbbreviation")}, {"{model}", Messages.getString("DesignLevelSettingsPropertiesDialog.ModelName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameCC, DesignLevelSettingsPropertiesDialog.this.tfColCheckConstr);
                }
            });
            constraintsPanel.add(cccLabel);
            constraintsPanel.add((Component)this.tfColCheckConstr, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel colNNLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnNotNullConstraint"));
            this.tfColNNConstr = new JTextField();
            this.tfColNNConstr.setText(this.colNNConstr);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameCC = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnAbbreviation")}, {"{model}", Messages.getString("DesignLevelSettingsPropertiesDialog.ModelName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameCC, DesignLevelSettingsPropertiesDialog.this.tfColNNConstr);
                }
            });
            constraintsPanel.add(colNNLabel);
            constraintsPanel.add((Component)this.tfColNNConstr, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel cfkLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.ColumnFK"));
            this.tfColumnForeignKey = new JTextField();
            this.tfColumnForeignKey.setText(this.colForeignKey);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameCC = new String[][]{{"{ref table}", Messages.getString("DesignLevelSettingsPropertiesDialog.ReftableName")}, {"{ref table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.ReftableAbbreviation")}, {"{ref table singular}", Messages.getString("DesignLevelSettingsPropertiesDialog.ReftableSingularName")}, {"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{relationship}", Messages.getString("DesignLevelSettingsPropertiesDialog.RelMappedToFK")}, {"{FK role}", Messages.getString("DesignLevelSettingsPropertiesDialog.FKRoleName")}, {"{foreign key}", Messages.getString("DesignLevelSettingsPropertiesDialog.FKName")}, {"{ref column}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefColumnName")}, {"{ref column abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefColumnAbbreviation")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameCC, DesignLevelSettingsPropertiesDialog.this.tfColumnForeignKey);
                }
            });
            constraintsPanel.add(cfkLabel);
            constraintsPanel.add((Component)this.tfColumnForeignKey, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel skLabel = new JLabel(this.sKeyConstrText);
            this.tfSurrogateKey = new JTextField();
            this.tfSurrogateKey.setText(this.surrogateKey);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameSK = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameSK, DesignLevelSettingsPropertiesDialog.this.tfSurrogateKey);
                }
            });
            constraintsPanel.add(skLabel);
            constraintsPanel.add((Component)this.tfSurrogateKey, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel skcLabel = new JLabel(this.sKeyColConstrText);
            this.tfSurrogateKeyColumn = new JTextField();
            this.tfSurrogateKeyColumn.setText(this.surrogateKeyCol);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameSKC = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}, {"{table singular}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableSingularName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameSKC, DesignLevelSettingsPropertiesDialog.this.tfSurrogateKeyColumn);
                }
            });
            constraintsPanel.add(skcLabel);
            constraintsPanel.add((Component)this.tfSurrogateKeyColumn, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JLabel dcLabel = new JLabel(this.dColumnConstrText);
            this.tfDiscriminatorColumn = new JTextField();
            this.tfDiscriminatorColumn.setText(this.discriminatorCol);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameDC = new String[][]{{"{table}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.TableAbbreviation")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(nameDC, DesignLevelSettingsPropertiesDialog.this.tfDiscriminatorColumn);
                }
            });
            constraintsPanel.add(dcLabel);
            constraintsPanel.add((Component)this.tfDiscriminatorColumn, new CC().growX());
            constraintsPanel.add((Component)addVariables, new CC().wrap());
            JPanel pnEntity = new JPanel((LayoutManager)new MigLayout("fillx", "[130::][grow,fill][]", "0[]0[]0"));
            pnEntity.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.EntityIdentifier")));
            JLabel identifierLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.PrimaryIdentifier"));
            this.tfPrimaryIdentifier = new JTextField();
            this.tfPrimaryIdentifier.setText(this.uiConsr);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] namePK = new String[][]{{"{entity}", Messages.getString("DesignLevelSettingsPropertiesDialog.EntityName")}, {"{ent short name}", Messages.getString("DesignLevelSettingsPropertiesDialog.EntityShortName")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(namePK, DesignLevelSettingsPropertiesDialog.this.tfPrimaryIdentifier);
                }
            });
            pnEntity.add(identifierLabel);
            pnEntity.add((Component)this.tfPrimaryIdentifier, new CC().growX());
            pnEntity.add((Component)addVariables, new CC().wrap());
            JLabel relationLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.AttributeRelation"));
            this.tfAttributeRelation = new JTextField();
            this.tfAttributeRelation.setText(this.attrRelation);
            addVariables = new JButton(this.btnName);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] values = new String[][]{{"{ref entity}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefEntityName")}, {"{ref entity short name}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefEntityShortName")}, {"{ref entity pref abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefEntityPrefAbbreviation")}, {"{relationship}", Messages.getString("DesignLevelSettingsPropertiesDialog.RelName")}, {"{ref attribute}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefAttributeName")}, {"{ref attribute pref abbr}", Messages.getString("DesignLevelSettingsPropertiesDialog.RefAttributePrefAbbreviation")}};
                    DesignLevelSettingsPropertiesDialog.this.createDialog(values, DesignLevelSettingsPropertiesDialog.this.tfAttributeRelation);
                }
            });
            pnEntity.add(relationLabel);
            pnEntity.add((Component)this.tfAttributeRelation, new CC().growX());
            pnEntity.add(addVariables);
            JPanel pnSample = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow,fill][]", "0[]0"));
            pnSample.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.Example")));
            JLabel exampleLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.Example"));
            final JTextField exampleTextField = new JTextField();
            exampleTextField.setEditable(false);
            final JLNComboBox exampleBox = new JLNComboBox(this.comboItems);
            pnSample.add(exampleLabel);
            pnSample.add((Component)exampleTextField, new CC().growX());
            pnSample.add(exampleBox);
            exampleBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s;
                    String oldString;
                    String choice = (String)exampleBox.getSelectedItem();
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.pkConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfPrimaryKey.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.fkConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfForeignKey.getText();
                        s = oldString.replaceAll("\\{parent\\}", "parentTable");
                        s = s.replaceAll("\\{child\\}", "childTable");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.chkConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfCheckConstr.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.ukConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfUniqueConstr.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.idxConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfIndex.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        s = s.replaceAll("\\{model\\}", "myModel");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.automaticIndexText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfAutomaticIndex.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        s = s.replaceAll("\\{constraint\\}", "myConstraint");
                        s = s.replaceAll("\\{model\\}", "myModel");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.colChkConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfColCheckConstr.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.colNNConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfColNNConstr.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.colFKText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfColumnForeignKey.getText();
                        s = oldString.replaceAll("\\{ref table\\}", "referencedTable");
                        s = s.replaceAll("\\{ref table abbr\\}", "referencedTableAbbreviation");
                        s = s.replaceAll("\\{ref column\\}", "referencedColumn");
                        s = s.replaceAll("\\{ref column abbr\\}", "referencedColumnAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.prIDConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfPrimaryIdentifier.getText();
                        s = oldString.replaceAll("\\{entity\\}", "myEntity");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignLevelSettingsPropertiesDialog.this.attrRelConstrText)) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfAttributeRelation.getText();
                        s = oldString.replaceAll("\\{ref entity\\}", "referencedEntity");
                        s = s.replaceAll("\\{ref entity short name\\}", "referencedEntityShortName");
                        s = s.replaceAll("\\{ref entity pref abr\\}", "referencedEntityPreferredAbbreviation");
                        s = s.replaceAll("\\{ref attribute\\}", "referencedAttribute");
                        s = s.replaceAll("\\{ref attribute pref abbr\\}", "referencedAttributePreferredAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase("Surrogate Key")) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfSurrogateKey.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase("Surrogate Key Column")) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfSurrogateKeyColumn.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase("Discriminator Column")) {
                        oldString = DesignLevelSettingsPropertiesDialog.this.tfDiscriminatorColumn.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        exampleTextField.setText(s);
                    }
                }
            });
            jp.add((Component)constraintsPanel, new CC().growX().wrap());
            jp.add((Component)pnEntity, new CC().growX().wrap());
            jp.add((Component)pnSample, new CC().growX());
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = constraintsPanel.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                constraintsPanel.validate();
                Component[] comp1 = pnEntity.getComponents();
                for (int x = 0; x < comp1.length; ++x) {
                    Component c = comp1[x];
                    c.setEnabled(false);
                }
                pnEntity.validate();
                Component[] comp2 = pnSample.getComponents();
                for (int x = 0; x < comp2.length; ++x) {
                    Component c = comp2[x];
                    c.setEnabled(false);
                }
                pnSample.validate();
            }
            this.pnNamingStandardTemplates.add((Component)jp, "Center");
        }
        return this.pnNamingStandardTemplates;
    }

    private void addToNSTable(JTable table, List list) {
        WordRule type;
        int row = table.getSelectedRow();
        String rule_type = "Prime Word";
        if (row > -1 && row < list.size()) {
            type = (WordRule)list.get(row);
            rule_type = type.getWordType();
        }
        type = new WordRule(rule_type, false);
        list.add(type);
        table.clearSelection();
        int lastRow = table.convertRowIndexToView(table.getModel().getRowCount() - 1);
        table.setRowSelectionInterval(lastRow, lastRow);
        table.updateUI();
    }

    private int removeFromNSTable(JTable table, List list) {
        int result;
        int selected = table.getSelectedRow();
        if (selected != -1 && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("DesignLevelSettingsPropertiesDialog.AreUSureUWantToDeleteSelRow"), Messages.getString("DesignLevelSettingsPropertiesDialog.DeleteConfirmation"), 0)) == 0) {
            WordRule type = (WordRule)list.get(selected);
            list.remove(type);
            table.updateUI();
        }
        return list.size();
    }

    private void moveNSElementUp(JTable table, List list) {
        int objectNumber = table.getSelectedRow();
        if (objectNumber > 0) {
            WordRule type = (WordRule)list.get(objectNumber);
            this.moveToIndex(list, type, objectNumber - 1);
            table.changeSelection(objectNumber - 1, 0, false, false);
        }
    }

    private void moveNSElementDown(JTable table, List list) {
        int objectNumber = table.getSelectedRow();
        if (objectNumber > -1 && objectNumber + 1 < list.size()) {
            WordRule type = (WordRule)list.get(objectNumber);
            this.moveToIndex(list, type, objectNumber + 1);
            table.changeSelection(objectNumber + 1, 0, false, false);
            table.updateUI();
        }
    }

    private boolean moveToIndex(List list, WordRule object, int index) {
        if (list.contains(object) && list.size() > index && index >= 0) {
            list.remove(object);
            list.add(index, object);
            return true;
        }
        return false;
    }

    private void createDialog(String[][] value, JTextField field) {
        AbstractPP.KeyDialog keyDialog = new AbstractPP.KeyDialog(this.getApplicationView(), null);
        keyDialog.setValues(value);
        keyDialog.setVisible(true);
        StringBuffer buffer = new StringBuffer();
        int cursorPos = field.getCaretPosition();
        int tfSize = field.getText().length();
        if (cursorPos == 0) {
            buffer.append(keyDialog.getProviderName());
        }
        if (tfSize != 0) {
            for (int i = 0; i < tfSize; ++i) {
                String providerName;
                buffer.append(field.getText().charAt(i));
                if (cursorPos != i + 1 || (providerName = keyDialog.getProviderName()) == null) continue;
                buffer.append(providerName);
            }
            field.setText(buffer.toString());
        } else {
            field.setText(keyDialog.getProviderName());
        }
    }

    public JPanel getDynamicPropertiesPanel() {
        if (this.pnDynamicProperties == null) {
            this.pnDynamicProperties = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.DynamicProperties"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]3"));
            jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.DynamicProperties")));
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.setRollover(true);
            toolBar.setBorder(null);
            this.propertyNameFilter = new JTextField();
            this.propertyNameFilter.setEnabled(false);
            this.propertyNameFilter.setPreferredSize(new Dimension(200, 20));
            this.propertyNameFilter.setMinimumSize(new Dimension(200, 20));
            this.propertyNameFilter.setMaximumSize(new Dimension(200, 20));
            JLabel propertyNameFilterLabel = new JLabel(Messages.getString("DesignLevelSettingsPropertiesDialog.Filter"));
            propertyNameFilterLabel.setPreferredSize(new Dimension(50, 20));
            propertyNameFilterLabel.setMinimumSize(new Dimension(50, 20));
            propertyNameFilterLabel.setMaximumSize(new Dimension(50, 20));
            toolBar.add(propertyNameFilterLabel);
            toolBar.add(this.propertyNameFilter);
            this.dynamicPropertiesList = new ArrayList();
            this.dynamicPropertiesTable = new JTable(new DynamicPropertiesTableModel());
            this.propertyNameFilter.getDocument().addDocumentListener(new DynamicPropertyFilterListener());
            this.dynamicPropertiesTable.getColumnModel().getColumn(2).setCellEditor(new PNameCellEditor(new JTextField()));
            TableColumn col1 = this.dynamicPropertiesTable.getColumnModel().getColumn(1);
            col1.setMinWidth(50);
            col1.setPreferredWidth(70);
            col1.setMaxWidth(100);
            TableColumn col3 = this.dynamicPropertiesTable.getColumnModel().getColumn(3);
            col3.setMinWidth(50);
            col3.setPreferredWidth(50);
            col3.setMaxWidth(50);
            JTableHeader header = this.dynamicPropertiesTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            JScrollPane scrollpane = new JScrollPane(this.dynamicPropertiesTable);
            jp.add((Component)toolBar, new CC().dockNorth().pad(0, 0, -3, 0));
            jp.add((Component)scrollpane, new CC().grow());
            this.pnDynamicProperties.add((Component)jp, "Center");
        }
        return this.pnDynamicProperties;
    }

    public JPanel getNamingStandardPanel() {
        if (this.pnNamingStandard == null) {
            this.pnNamingStandard = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.NamingStandard"));
            String separator = Messages.getString("DesignLevelSettingsPropertiesDialog.Separator");
            String space = Messages.getString("DesignLevelSettingsPropertiesDialog.Space");
            String titleCase = Messages.getString("DesignLevelSettingsPropertiesDialog.TitleCase");
            final String character = Messages.getString("DesignLevelSettingsPropertiesDialog.Character");
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            this.logicalPanel = new JPanel((LayoutManager)new MigLayout("", "[]", "0[]0"));
            this.logicalPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.LogicalModel")));
            JLabel logSeparatorLabel = new JLabel(separator);
            this.logicalModelSeparatorMap.put("Space", space);
            this.logicalModelSeparatorMap.put("Title Case", titleCase);
            this.logicalModelSeparatorMap.put("Character", character);
            this.separatorBox = new JComboBox<Object>(this.logicalModelSeparatorMap.values().toArray());
            this.separatorBox.setEditable(false);
            this.separatorBox.setSelectedItem(space);
            this.characterField = new JCharField();
            this.characterField.setText(" ");
            this.logicalPanel.add(logSeparatorLabel);
            this.logicalPanel.add(this.separatorBox);
            this.logicalPanel.add(this.characterField);
            this.separatorBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DesignLevelSettingsPropertiesDialog.this.separatorBox.getSelectedItem().equals(character)) {
                        DesignLevelSettingsPropertiesDialog.this.characterField.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.characterField.setEditable(true);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.characterField.setText(" ");
                        DesignLevelSettingsPropertiesDialog.this.characterField.setEnabled(false);
                    }
                }
            });
            this.relationalPanel = new JPanel((LayoutManager)new MigLayout("", "[]", "0[]0"));
            this.relationalPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.RelationalModel")));
            JLabel relSeparatorLabel = new JLabel(separator);
            this.separatorText = new JCharField();
            this.separatorText.setText("_");
            this.separatorText.setEditable(true);
            this.abbreviatedOnly = new JCheckBox(Messages.getString("DesignLevelSettingsPropertiesDialog.AbbreviatedOnly"));
            this.relationalPanel.add(relSeparatorLabel);
            this.relationalPanel.add(this.separatorText);
            this.relationalPanel.add(this.abbreviatedOnly);
            this.domainPanel = new JPanel((LayoutManager)new MigLayout("", "[]", "0[]0"));
            this.domainPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.Domain")));
            JLabel dmsSeparatorLabel = new JLabel(separator);
            this.dmsSeparator = new JCharField();
            this.dmsSeparator.setText(" ");
            this.dmsSeparator.setEditable(true);
            this.domainPanel.add(dmsSeparatorLabel);
            this.domainPanel.add(this.dmsSeparator);
            JPanel pnGlossary = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            pnGlossary.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.Glossary")));
            JPanel filePanel = new JPanel(new GridBagLayout());
            filePanel.setBackground(Color.WHITE);
            GlossaryTableModel glossaryTableModel = new GlossaryTableModel();
            this.glossaryTable = new JTable(glossaryTableModel);
            this.glossaryTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ((GlossaryFile)DesignLevelSettingsPropertiesDialog.this.glossariesList.get(DesignLevelSettingsPropertiesDialog.this.glossaryTable.getSelectedRow())).getFilePath();
                        Glossary glossary = new Glossary(new File(((GlossaryFile)DesignLevelSettingsPropertiesDialog.this.glossariesList.get(DesignLevelSettingsPropertiesDialog.this.glossaryTable.getSelectedRow())).getFilePath()));
                        GlossaryDialog dialog = new GlossaryDialog((Window)Ide.getMainWindow(), glossary);
                        dialog.showDialog();
                    }
                }
            });
            this.glossaryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = DesignLevelSettingsPropertiesDialog.this.glossaryTable.getSelectedRow();
                    if (selRow == -1) {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveGlossary.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.btnGlossaryProperties.setEnabled(false);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.btnRemoveGlossary.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.btnGlossaryProperties.setEnabled(true);
                    }
                }
            });
            JTableHeader header = this.glossaryTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            JButton addButton = new JButton(this.configuration.getIcon("ADD_ICON", 16));
            addButton.setToolTipText(BTN_ADD);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        File file;
                        URLFilter fileFilter = new URLFilter(){

                            public boolean accept(URL url) {
                                File file = new File(url.getPath());
                                return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                            }

                            public String toString() {
                                return Messages.getString("DesignLevelSettingsPropertiesDialog.GlossaryFile");
                            }
                        };
                        URLFileChooser fileChooser = new URLFileChooser();
                        fileChooser.clearChooseableURLFilters();
                        fileChooser.setSelectionScope(0);
                        fileChooser.setSelectionMode(0);
                        fileChooser.setShowJarsAsDirs(false);
                        fileChooser.setURLFilter(fileFilter);
                        fileChooser.setPathContext("dataModeler_OpenDesign");
                        if (DesignLevelSettingsPropertiesDialog.this.lastFolder != null) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((File)DesignLevelSettingsPropertiesDialog.this.lastFolder));
                        } else {
                            String lastDir = DesignLevelSettingsPropertiesDialog.this.getApplicationView().getSettings().getDefaultImportPath();
                            if (lastDir != null && lastDir.length() > 0) {
                                fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                            } else {
                                URL url = DesignLevelSettingsPropertiesDialog.this.getApplicationView().getUserHomeDirectory();
                                if (url != null) {
                                    fileChooser.setSelectedURL(url);
                                }
                            }
                        }
                        int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DesignLevelSettingsPropertiesDialog.SelectGlossaryFile"));
                        if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                            DesignLevelSettingsPropertiesDialog.this.lastFolder = file.getParentFile();
                            Glossary selected = new Glossary(file);
                            DesignLevelSettingsPropertiesDialog.this.glossariesList.add(new GlossaryFile(selected.getName(), selected.getDescription(), file.getAbsolutePath()));
                            DesignLevelSettingsPropertiesDialog.this.glossaryTable.updateUI();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            toolBar.add(addButton);
            this.btnRemoveGlossary = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
            this.btnRemoveGlossary.setEnabled(false);
            this.btnRemoveGlossary.setToolTipText(BTN_REMOVE);
            this.btnRemoveGlossary.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selected = DesignLevelSettingsPropertiesDialog.this.glossaryTable.getSelectedRows();
                    if (selected.length > 0) {
                        int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("DesignLevelSettingsPropertiesDialog.AreUSureUWantToDelete"), Messages.getString("DesignLevelSettingsPropertiesDialog.GlossaryDeletion"), 0);
                        ArrayList<GlossaryFile> temp = new ArrayList<GlossaryFile>();
                        if (result == 0) {
                            for (int i = 0; i < selected.length; ++i) {
                                GlossaryFile file = (GlossaryFile)DesignLevelSettingsPropertiesDialog.this.glossariesList.get(selected[i]);
                                temp.add(file);
                            }
                            DesignLevelSettingsPropertiesDialog.this.glossariesList.removeAll(temp);
                            DesignLevelSettingsPropertiesDialog.this.glossaryTable.updateUI();
                        }
                    }
                }
            });
            toolBar.add(this.btnRemoveGlossary);
            toolBar.addSeparator();
            this.btnGlossaryProperties = new JButton(this.configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnGlossaryProperties.setEnabled(false);
            this.btnGlossaryProperties.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.GlossaryProperties"));
            toolBar.add(this.btnGlossaryProperties);
            this.btnGlossaryProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((GlossaryFile)DesignLevelSettingsPropertiesDialog.this.glossariesList.get(DesignLevelSettingsPropertiesDialog.this.glossaryTable.getSelectedRow())).getFilePath();
                    Glossary glossary = new Glossary(new File(((GlossaryFile)DesignLevelSettingsPropertiesDialog.this.glossariesList.get(DesignLevelSettingsPropertiesDialog.this.glossaryTable.getSelectedRow())).getFilePath()));
                    GlossaryDialog dialog = new GlossaryDialog((Window)Ide.getMainWindow(), glossary);
                    dialog.showDialog();
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.glossaryTable);
            pnGlossary.add((Component)toolBar, new CC().dockNorth());
            pnGlossary.add((Component)scrollpane, new CC().grow());
            jp.add((Component)this.logicalPanel, new CC().growX().wrap());
            jp.add((Component)this.relationalPanel, new CC().growX().wrap());
            jp.add((Component)this.domainPanel, new CC().growX().wrap());
            jp.add((Component)pnGlossary, new CC().grow().wrap());
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = this.logicalPanel.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                this.logicalPanel.validate();
                Component[] comp1 = this.relationalPanel.getComponents();
                for (int x = 0; x < comp1.length; ++x) {
                    Component c = comp1[x];
                    c.setEnabled(false);
                }
                this.relationalPanel.validate();
                Component[] comp2 = this.domainPanel.getComponents();
                for (int x = 0; x < comp2.length; ++x) {
                    Component c = comp2[x];
                    c.setEnabled(false);
                }
                this.domainPanel.validate();
                Component[] comp3 = toolBar.getComponents();
                for (int x = 0; x < comp3.length; ++x) {
                    Component c = comp3[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.glossaryTable.setEnabled(false);
            }
            this.pnNamingStandard.add((Component)jp, "Center");
        }
        return this.pnNamingStandard;
    }

    public JPanel getUserDefinedPropertiesPanel() {
        if (this.pnUserDefinedProperties == null) {
            this.pnUserDefinedProperties = this.createPage(Messages.getString("DesignLevelSettingsPropertiesDialog.UserDefinedProperties"));
            JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]"));
            jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignLevelSettingsPropertiesDialog.Libraries")));
            this.udpLibraries = new JList(new DefaultListModel());
            this.udpLibraries.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = DesignLevelSettingsPropertiesDialog.this.udpLibraries.getSelectedIndex();
                    if (index == -1) {
                        DesignLevelSettingsPropertiesDialog.this.bnEditLibrary.setEnabled(false);
                        DesignLevelSettingsPropertiesDialog.this.bnRemoveLibrary.setEnabled(false);
                    } else {
                        DesignLevelSettingsPropertiesDialog.this.bnEditLibrary.setEnabled(true);
                        DesignLevelSettingsPropertiesDialog.this.bnRemoveLibrary.setEnabled(true);
                    }
                }
            });
            this.udpLibraries.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        UDPLibrary lib = DesignLevelSettingsPropertiesDialog.this.udpLibraries.getSelectedValue();
                        UDPLibraryPropertiesDialog dialog = new UDPLibraryPropertiesDialog(DesignLevelSettingsPropertiesDialog.this.design.getAppView(), lib, (DefaultListModel)DesignLevelSettingsPropertiesDialog.this.udpLibraries.getModel(), DesignLevelSettingsPropertiesDialog.this.design);
                        dialog.showDialog();
                    }
                }
            });
            this.udpLibraries.setCellRenderer(new UDPLibraryRenderer());
            JScrollPane scrollpane = new JScrollPane(this.udpLibraries);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.setRollover(true);
            toolBar.setBorder(null);
            JButton bnAddLibrary = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            bnAddLibrary.setToolTipText(BTN_ADD);
            bnAddLibrary.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UDPLibraryPropertiesDialog dialog = new UDPLibraryPropertiesDialog(DesignLevelSettingsPropertiesDialog.this.design.getAppView(), null, (DefaultListModel)DesignLevelSettingsPropertiesDialog.this.udpLibraries.getModel(), DesignLevelSettingsPropertiesDialog.this.design);
                    dialog.showDialog();
                }
            });
            this.bnRemoveLibrary = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnRemoveLibrary.setToolTipText(BTN_REMOVE);
            this.bnRemoveLibrary.setEnabled(false);
            this.bnRemoveLibrary.addActionListener(new RemoveUDPLibraryAction());
            this.bnEditLibrary = new JButton(this.configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.bnEditLibrary.setEnabled(false);
            this.bnEditLibrary.setToolTipText(BTN_EDIT);
            this.bnEditLibrary.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UDPLibrary lib = DesignLevelSettingsPropertiesDialog.this.udpLibraries.getSelectedValue();
                    UDPLibraryPropertiesDialog dialog = new UDPLibraryPropertiesDialog(DesignLevelSettingsPropertiesDialog.this.design.getAppView(), lib, (DefaultListModel)DesignLevelSettingsPropertiesDialog.this.udpLibraries.getModel(), DesignLevelSettingsPropertiesDialog.this.design);
                    dialog.showDialog();
                }
            });
            toolBar.add(bnAddLibrary);
            toolBar.add(this.bnRemoveLibrary);
            toolBar.add(this.bnEditLibrary);
            jp.add((Component)toolBar, new CC().dockNorth());
            jp.add((Component)scrollpane, new CC().grow());
            this.pnUserDefinedProperties.add((Component)jp, "Center");
        }
        return this.pnUserDefinedProperties;
    }

    private void initUserDefinedLibraries() {
        DefaultListModel model = (DefaultListModel)this.udpLibraries.getModel();
        model.removeAllElements();
        Iterator<UDPLibrary> it = this.design.getUserDefinedLibraries().iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
    }

    private void initConstants() {
        this.namePartMap.put("Prime Word", this.PRIME_WORD_L);
        this.namePartMap.put("Class Word", this.CLASS_WORD_L);
        this.namePartMap.put("Modifier", this.MODIFIER_L);
        this.namePartMap.put("Qualifier", this.QUALIFIER_L);
    }

    protected void addToTree(DefaultMutableTreeNode node, JPanel panel) {
        node.add(new DefaultMutableTreeNode(panel));
        this.getMainPanel().add((Component)panel, panel.getName());
    }

    public final int getPreferredIconSize() {
        return 16;
    }

    @Override
    protected int getMinimumWidth() {
        return 670;
    }

    @Override
    protected int getMinimumHeight() {
        return 560;
    }

    public void setDesign(Design newDesign) {
        this.design = newDesign;
        this.initConstants();
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    public class TreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof Component) {
                Component c = (Component)node.getUserObject();
                this.setText(c.getName());
            }
            return this;
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)DesignLevelSettingsPropertiesDialog.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Component) {
                DesignLevelSettingsPropertiesDialog.this.cardLayout.show(DesignLevelSettingsPropertiesDialog.this.getMainPanel(), ((Component)obj).getName());
            }
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignLevelSettingsPropertiesDialog.this.setProperties();
            String status = DesignLevelSettingsPropertiesDialog.this.design.getAppView().getXMLTransformationManager().getFilteredXMLString(DesignLevelSettingsPropertiesDialog.this.design);
            if (DesignLevelSettingsPropertiesDialog.this.oldObjectStatus != null) {
                if (!DesignLevelSettingsPropertiesDialog.this.oldObjectStatus.equals(status)) {
                    DesignLevelSettingsPropertiesDialog.this.design.setDirty(true);
                    DesignLevelSettingsPropertiesDialog.this.oldObjectStatus = status;
                }
            } else {
                DesignLevelSettingsPropertiesDialog.this.design.setDirty(true);
            }
            String newDLSettings = DesignLevelSettingsPropertiesDialog.this.design.getDesignLevelSettings().getDesignLevelSettingsAsString();
            if (DesignLevelSettingsPropertiesDialog.this.oldDLSettings != null) {
                if (!DesignLevelSettingsPropertiesDialog.this.oldDLSettings.equals(newDLSettings)) {
                    DesignLevelSettingsPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                    DesignLevelSettingsPropertiesDialog.this.oldDLSettings = newDLSettings;
                }
            } else {
                DesignLevelSettingsPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
            }
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DesignLevelSettingsPropertiesDialog.DesignLevelSettingsApplied"), MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.DesignLevelSettings"), DesignLevelSettingsPropertiesDialog.this.design.getName()), 1);
            DesignLevelSettingsPropertiesDialog.this.close();
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignLevelSettingsPropertiesDialog.this.close();
        }
    }

    private class SubstitutionModel
    extends AbstractTableModel {
        private SubstitutionModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.CaseSensitive");
            }
            if (column == 2) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Oid");
            }
            if (column == 3) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.New");
            }
            if (column == 4) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SubstitutionPattern substPattern = (SubstitutionPattern)DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.get(row);
            if (col == 0) {
                return substPattern.isSelected();
            }
            if (col == 1) {
                return substPattern.isCaseSensitive();
            }
            if (col == 2) {
                return substPattern.getSourceString();
            }
            if (col == 3) {
                return substPattern.getReplacementString();
            }
            if (col == 4) {
                return substPattern.getComments();
            }
            return row * col;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            SubstitutionPattern substPattern = (SubstitutionPattern)DesignLevelSettingsPropertiesDialog.this.localSubstitutionList.get(row);
            if (col == 0) {
                substPattern.setSelected((Boolean)aValue);
            } else if (col == 1) {
                substPattern.setCaseSensitive((Boolean)aValue);
            } else if (col == 2) {
                substPattern.setSourceString(this.checkValue((String)aValue, true));
            } else if (col == 3) {
                substPattern.setReplacementString(this.checkValue((String)aValue, false));
            } else if (col == 4) {
                substPattern.setComments((String)aValue);
            }
        }

        private String checkValue(String value, boolean isSource) {
            block4: {
                if (value.trim().equals("")) break block4;
                if (isSource) {
                    for (SubstitutionPattern pattern : DesignLevelSettingsPropertiesDialog.this.localSubstitutionList) {
                        if (pattern.getReplacementString().indexOf(value) <= -1) continue;
                        JOptionPane.showMessageDialog(new JDialog(DesignLevelSettingsPropertiesDialog.this.getApplicationView().getFrame()), new Object[]{""}, "", 0);
                        return "";
                    }
                } else {
                    for (SubstitutionPattern pattern : DesignLevelSettingsPropertiesDialog.this.localSubstitutionList) {
                        if (pattern.getSourceString().indexOf(value) <= -1) continue;
                        JOptionPane.showMessageDialog(DesignLevelSettingsPropertiesDialog.this.getApplicationView().getFrame(), new Object[]{""}, "", 0);
                        return "";
                    }
                }
            }
            return value;
        }
    }

    private class SelectAllSubstitutionAction
    implements ActionListener {
        private SelectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SubstitutionPattern substPattern : DesignLevelSettingsPropertiesDialog.this.localSubstitutionList) {
                substPattern.setSelected(true);
            }
            DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.updateUI();
        }
    }

    private class DeselectAllSubstitutionAction
    implements ActionListener {
        private DeselectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SubstitutionPattern substPattern : DesignLevelSettingsPropertiesDialog.this.localSubstitutionList) {
                substPattern.setSelected(false);
            }
            DesignLevelSettingsPropertiesDialog.this.tbSubstituiton.updateUI();
        }
    }

    public class ClassificationTypeModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Name");
            }
            if (column == 1) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Prefix");
            }
            if (column == 2) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Format");
            }
            return Messages.getString("DesignLevelSettingsPropertiesDialog.Preferred");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ClassificationType classType = (ClassificationType)DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.get(rowIndex);
            if (columnIndex == 0) {
                return !classType.isReadOnly();
            }
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ClassificationType classType = (ClassificationType)DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.get(row);
            if (column == 0) {
                return String.valueOf(classType.getTypeName());
            }
            if (column == 1) {
                return String.valueOf(classType.getTypePrefix());
            }
            if (column == 2) {
                return classType;
            }
            if (column == 3) {
                return classType.isPreferred();
            }
            return row * column;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            ClassificationType classType = (ClassificationType)DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.get(row);
            if (column == 0) {
                classType.setTypeName((String)value);
            } else if (column == 1) {
                classType.setTypePrefix((String)value);
            } else if (column == 3) {
                classType.setPreferred((Boolean)value);
            }
        }
    }

    public class ClassificationTypeFormatCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton formatButton = new JButton();
        ClassificationType classificationType;

        ClassificationTypeFormatCellEditor() {
            this.formatButton.setOpaque(true);
            this.formatButton.addActionListener(this);
            this.formatButton.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new TopViewColorDialog(this.classificationType.getDefaultFCObject()).setVisible(true);
            this.formatButton.setBackground(this.classificationType.getDefaultFCObject().getBackgroundColor());
            this.classificationType.setTypeColor(this.classificationType.getDefaultFCObject().getBackgroundColor());
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.classificationType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.classificationType = (ClassificationType)value;
            return this.formatButton;
        }
    }

    class ClassificationTypeFormatCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ClassificationTypeFormatCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            ClassificationType classificationType = (ClassificationType)value;
            this.setOpaque(true);
            this.setBackground(classificationType.getTypeColor());
            this.setToolTipText(Messages.getString("DesignLevelSettingsPropertiesDialog.ClickToEdit"));
            return this;
        }
    }

    private class AddClassificationTypeAction
    implements ActionListener {
        private AddClassificationTypeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassificationType addType = new ClassificationType("Type_" + DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.size(), Color.BLACK, Color.BLUE, new GUID().toString(), "");
            DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.add(addType);
            DesignLevelSettingsPropertiesDialog.this.classificationTypeTable.updateUI();
            DesignLevelSettingsPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
        }
    }

    private class RemoveClassificationType
    implements ActionListener {
        private RemoveClassificationType() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassificationType classType;
            int objectNumber = DesignLevelSettingsPropertiesDialog.this.classificationTypeTable.getSelectedRow();
            if (objectNumber != -1 && DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.size() > 0 && objectNumber < DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.size() && !(classType = (ClassificationType)DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.get(objectNumber)).isReadOnly()) {
                DesignLevelSettingsPropertiesDialog.this.localClassificationTypeList.remove(classType);
                DesignLevelSettingsPropertiesDialog.this.classificationTypeTable.updateUI();
                DesignLevelSettingsPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
            }
        }
    }

    public class DefaultFCModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.localDefaultFCList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.DesignObject");
            }
            if (column == 1) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Background");
            }
            if (column == 2) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Foreground");
            }
            if (column == 3) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.TitleFont");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DefaultFontAndColor dfc = (DefaultFontAndColor)DesignLevelSettingsPropertiesDialog.this.localDefaultFCList.get(row);
            if (col == 0) {
                return dfc.getClassName();
            }
            if (col == 1 || col == 2) {
                return dfc;
            }
            if (col == 3) {
                return ((FontObject)dfc.getEditableFonts().get(0)).getFont().getName();
            }
            return row * col;
        }
    }

    class FontsAndColorsCellRenderer
    extends JLabel
    implements TableCellRenderer {
        FontsAndColorsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            DefaultFontAndColor dfc = (DefaultFontAndColor)value;
            this.setOpaque(true);
            if (col == 1) {
                this.setBackground(dfc.getBackgroundColor());
            } else {
                this.setBackground(dfc.getForegroundColor());
            }
            return this;
        }
    }

    public class DefaultLWCModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.localDefaultLWCList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.DesignObject");
            }
            if (column == 1) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Color");
            }
            if (column == 2) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Width");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)DesignLevelSettingsPropertiesDialog.this.localDefaultLWCList.get(row);
            if (col == 0) {
                return dlwc.getClassName();
            }
            if (col == 1 || col == 2) {
                return dlwc;
            }
            return row * col;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)DesignLevelSettingsPropertiesDialog.this.localDefaultLWCList.get(rowIndex);
            if (columnIndex == 1) {
                dlwc.setColor((Color)aValue);
            } else if (columnIndex == 2) {
                dlwc.setWidth(JLWComboBox.IndexOf(aValue) + 1);
            }
        }
    }

    class LineColorCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LineColorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)value;
            this.setOpaque(true);
            this.setBackground(dlwc.getColor());
            return this;
        }
    }

    public class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        protected final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand("edit");
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("edit".equals(e.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                ColorChooserDialog colorDialog = new ColorChooserDialog(null, Messages.getString("DesignLevelSettingsPropertiesDialog.PickColor"), this.currentColor);
                Color newColor = colorDialog.showDialog();
                if (newColor != null) {
                    this.currentColor = newColor;
                }
                this.fireEditingStopped();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentColor = ((DefaultLineWidthAndColor)value).getColor();
            return this.button;
        }
    }

    class LineWidthCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LineWidthCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)value;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBackground(Color.WHITE);
            switch (dlwc.getWidth()) {
                case 1: {
                    this.setIcon(JLWComboBox.ICON_1);
                    break;
                }
                case 2: {
                    this.setIcon(JLWComboBox.ICON_2);
                    break;
                }
                case 3: {
                    this.setIcon(JLWComboBox.ICON_3);
                    break;
                }
                case 4: {
                    this.setIcon(JLWComboBox.ICON_4);
                    break;
                }
                case 5: {
                    this.setIcon(JLWComboBox.ICON_5);
                    break;
                }
                case 6: {
                    this.setIcon(JLWComboBox.ICON_6);
                }
            }
            return this;
        }
    }

    class LWCCellEditor
    extends DefaultCellEditor {
        JLWComboBox cbox;

        LWCCellEditor() {
            super(new JLWComboBox());
            this.cbox = (JLWComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<Object>(JLWComboBox.getItems().toArray()));
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)value;
            switch (dlwc.getWidth()) {
                case 1: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_1);
                    break;
                }
                case 2: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_2);
                    break;
                }
                case 3: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_3);
                    break;
                }
                case 4: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_4);
                    break;
                }
                case 5: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_5);
                    break;
                }
                case 6: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_6);
                }
            }
            return this.cbox;
        }
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private AttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.nsAttributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return DesignLevelSettingsPropertiesDialog.this.NAME_PART;
            }
            return DesignLevelSettingsPropertiesDialog.this.MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsAttributesList.get(rowIndex);
            if (columnIndex == 0) {
                return DesignLevelSettingsPropertiesDialog.this.namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignLevelSettingsPropertiesDialog.this.nsAttributesTable.getRowCount()) {
                WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsAttributesList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : DesignLevelSettingsPropertiesDialog.this.namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    private class ColumnTableModel
    extends AbstractTableModel {
        private ColumnTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.nsColumnsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return DesignLevelSettingsPropertiesDialog.this.NAME_PART;
            }
            return DesignLevelSettingsPropertiesDialog.this.MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsColumnsList.get(rowIndex);
            if (columnIndex == 0) {
                return DesignLevelSettingsPropertiesDialog.this.namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignLevelSettingsPropertiesDialog.this.nsColumnsTable.getRowCount()) {
                WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsColumnsList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : DesignLevelSettingsPropertiesDialog.this.namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    private class DomainTableModel
    extends AbstractTableModel {
        private DomainTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.nsDomainsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return DesignLevelSettingsPropertiesDialog.this.NAME_PART;
            }
            return DesignLevelSettingsPropertiesDialog.this.MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsDomainsList.get(rowIndex);
            if (columnIndex == 0) {
                return DesignLevelSettingsPropertiesDialog.this.namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignLevelSettingsPropertiesDialog.this.nsDomainsTable.getRowCount()) {
                WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsDomainsList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : DesignLevelSettingsPropertiesDialog.this.namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    private class EntityTableModel
    extends AbstractTableModel {
        private EntityTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.nsEntitiesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return DesignLevelSettingsPropertiesDialog.this.NAME_PART;
            }
            return DesignLevelSettingsPropertiesDialog.this.MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsEntitiesList.get(rowIndex);
            if (columnIndex == 0) {
                return DesignLevelSettingsPropertiesDialog.this.namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignLevelSettingsPropertiesDialog.this.nsEntitiesTable.getRowCount()) {
                WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsEntitiesList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : DesignLevelSettingsPropertiesDialog.this.namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    private class TableElementModel
    extends AbstractTableModel {
        private TableElementModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.nsTablesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return DesignLevelSettingsPropertiesDialog.this.NAME_PART;
            }
            return DesignLevelSettingsPropertiesDialog.this.MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsTablesList.get(rowIndex);
            if (columnIndex == 0) {
                return DesignLevelSettingsPropertiesDialog.this.namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignLevelSettingsPropertiesDialog.this.nsTablesTable.getRowCount()) {
                WordRule type = (WordRule)DesignLevelSettingsPropertiesDialog.this.nsTablesList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : DesignLevelSettingsPropertiesDialog.this.namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    private class DynamicPropertiesTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("DesignLevelSettingsPropertiesDialog.Name"), Messages.getString("DesignLevelSettingsPropertiesDialog.Type"), Messages.getString("DesignLevelSettingsPropertiesDialog.PresentationName"), Messages.getString("DesignLevelSettingsPropertiesDialog.Visible")};

        private DynamicPropertiesTableModel() {
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.dynamicPropertiesList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0 && columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignLevelSettings.DPObject dpObject = (DesignLevelSettings.DPObject)DesignLevelSettingsPropertiesDialog.this.dynamicPropertiesList.get(rowIndex);
            if (columnIndex == 0) {
                return dpObject.getName();
            }
            if (columnIndex == 1) {
                return dpObject.getType();
            }
            if (columnIndex == 2) {
                return dpObject.getPresentationName();
            }
            if (columnIndex == 3) {
                return dpObject.isVisible();
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            DesignLevelSettings.DPObject dpObject = (DesignLevelSettings.DPObject)DesignLevelSettingsPropertiesDialog.this.dynamicPropertiesList.get(rowIndex);
            if (columnIndex == 2) {
                dpObject.setPresentationName((String)aValue);
            } else if (columnIndex == 3) {
                dpObject.setVisible((Boolean)aValue);
            }
        }
    }

    private class DynamicPropertyFilterListener
    implements DocumentListener {
        private DynamicPropertyFilterListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DesignLevelSettingsPropertiesDialog.this.newFilter(DesignLevelSettingsPropertiesDialog.this.propertyNameFilter, DesignLevelSettingsPropertiesDialog.this.dynamicPropertiesTable);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DesignLevelSettingsPropertiesDialog.this.newFilter(DesignLevelSettingsPropertiesDialog.this.propertyNameFilter, DesignLevelSettingsPropertiesDialog.this.dynamicPropertiesTable);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DesignLevelSettingsPropertiesDialog.this.newFilter(DesignLevelSettingsPropertiesDialog.this.propertyNameFilter, DesignLevelSettingsPropertiesDialog.this.dynamicPropertiesTable);
        }
    }

    private class PNameCellEditor
    extends DefaultCellEditor {
        public PNameCellEditor(JTextField textField) {
            super(textField);
            super.setClickCountToStart(1);
        }
    }

    private class GlossaryTableModel
    extends AbstractTableModel {
        private GlossaryTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DesignLevelSettingsPropertiesDialog.this.glossariesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Name");
            }
            if (column == 1) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.Description");
            }
            if (column == 2) {
                return Messages.getString("DesignLevelSettingsPropertiesDialog.File");
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            GlossaryFile glFile = (GlossaryFile)DesignLevelSettingsPropertiesDialog.this.glossariesList.get(rowIndex);
            if (columnIndex == 0) {
                return glFile.getFileName();
            }
            if (columnIndex == 1) {
                return glFile.getDescription();
            }
            if (columnIndex == 2) {
                return glFile.getFilePath();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private class UDPLibraryRenderer
    extends JLabel
    implements ListCellRenderer {
        private UDPLibraryRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            UDPLibrary udpl = (UDPLibrary)value;
            this.setText(udpl.getFileName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class RemoveUDPLibraryAction
    implements ActionListener {
        private RemoveUDPLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UDPLibrary library = DesignLevelSettingsPropertiesDialog.this.udpLibraries.getSelectedValue();
            Object path = "";
            String dir = library.getDirectory();
            if (dir == null || dir.isEmpty()) {
                dir = DesignLevelSettingsPropertiesDialog.this.design.getDesignPath().equals("") ? XMLTransformationManager.getDefaultSystemTypesPath() : DesignLevelSettingsPropertiesDialog.this.design.getAdditionalFilesDirectory().getPath();
            }
            path = dir + File.separator + library.getFileName();
            int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.AreYouSure"), path), "", 0);
            if (result == 0) {
                File file = null;
                try {
                    file = new File((String)path);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DesignLevelSettingsPropertiesDialog.CanNotBeDeleted"), file.getAbsolutePath()), "Error", 0);
                }
                DefaultListModel model = (DefaultListModel)DesignLevelSettingsPropertiesDialog.this.udpLibraries.getModel();
                int selectedIndex = DesignLevelSettingsPropertiesDialog.this.udpLibraries.getSelectedIndex();
                if (selectedIndex != -1) {
                    model.remove(selectedIndex);
                }
            }
        }
    }
}

