/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.fcp.preferences.ModelingPreferences;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DMDOpenObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.OpenDesignDialogPersistence;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class OpenDesignDialog
extends CustomDialog {
    private final Preferences p = Preferences.getPreferences();
    private ApplicationView view;
    private JDialog dialog;
    private Design design;
    private JPanel mainPanel = new JPanel();
    private JPanel buttonsPanel;
    private JButton okButton = new JButton(Messages.getString("OpenDesignDialog.OK"));
    private JCheckBox chbDontShowAgain;
    private JButton btnSelectAllOpen;
    private JButton btnDeselectAllOpen;
    private JButton btnSelectAllOpenPM;
    private JButton btnDeselectAllOpenPM;
    private JScrollPane modelsSP;
    private JTable modelsTable;
    private ModelsModel modelsModel;
    private List currentModelsList;
    private JTextField tfModelsFilter;
    private OpenDesignDialogPersistence persistence;

    public OpenDesignDialog(ApplicationView appView, Design design, OpenDesignDialogPersistence persistence) {
        super(appView);
        this.view = appView;
        this.design = design;
        this.persistence = persistence;
        this.initDialog();
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private void initDialog() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(500, 300));
        this.initFilter();
        this.initRelational();
        this.initButtons();
        this.add(this.mainPanel);
    }

    private void initFilter() {
        JPanel objectsFilterPanel = new JPanel(new SpringLayout());
        objectsFilterPanel.setPreferredSize(new Dimension(500, 23));
        JLabel selectedObjectsFilterLabel = new JLabel(Messages.getString("OpenDesignDialog.Filter"));
        selectedObjectsFilterLabel.setPreferredSize(new Dimension(50, 20));
        selectedObjectsFilterLabel.setMinimumSize(new Dimension(50, 20));
        selectedObjectsFilterLabel.setMaximumSize(new Dimension(50, 20));
        this.tfModelsFilter = new JTextField();
        this.tfModelsFilter.setEnabled(false);
        this.tfModelsFilter.setPreferredSize(new Dimension(148, 20));
        this.tfModelsFilter.getDocument().addDocumentListener(new FilterObjectListener());
        this.tfModelsFilter.setPreferredSize(new Dimension(200, 20));
        this.tfModelsFilter.setMinimumSize(new Dimension(200, 20));
        this.tfModelsFilter.setMaximumSize(new Dimension(200, 20));
        JLabel selectedPhysicalLabel = new JLabel(Messages.getString("OpenDesignDialog.OpenPM"));
        selectedPhysicalLabel.setPreferredSize(new Dimension(50, 20));
        selectedPhysicalLabel.setMinimumSize(new Dimension(50, 20));
        selectedPhysicalLabel.setMaximumSize(new Dimension(50, 20));
        this.btnSelectAllOpenPM = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        this.btnSelectAllOpenPM.setEnabled(false);
        this.btnSelectAllOpenPM.setMnemonic(83);
        this.btnSelectAllOpenPM.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllOpenPM.setToolTipText(Messages.getString("OpenDesignDialog.SelectAll_OPM"));
        this.btnSelectAllOpenPM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDesignDialog.this.checkAll(OpenDesignDialog.this.modelsTable, OpenDesignDialog.this.currentModelsList, true, 2);
                OpenDesignDialog.this.modelsTable.updateUI();
            }
        });
        this.btnDeselectAllOpenPM = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        this.btnDeselectAllOpenPM.setEnabled(false);
        this.btnDeselectAllOpenPM.setMnemonic(68);
        this.btnDeselectAllOpenPM.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAllOpenPM.setToolTipText(Messages.getString("OpenDesignDialog.DeelectAll_OPM"));
        this.btnDeselectAllOpenPM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDesignDialog.this.checkAll(OpenDesignDialog.this.modelsTable, OpenDesignDialog.this.currentModelsList, false, 2);
                OpenDesignDialog.this.modelsTable.updateUI();
            }
        });
        this.btnSelectAllOpen = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        this.btnSelectAllOpen.setEnabled(false);
        this.btnSelectAllOpen.setMnemonic(83);
        this.btnSelectAllOpen.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllOpen.setToolTipText(Messages.getString("OpenDesignDialog.SelectAll_ORM"));
        this.btnSelectAllOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDesignDialog.this.checkAll(OpenDesignDialog.this.modelsTable, OpenDesignDialog.this.currentModelsList, true, 1);
                OpenDesignDialog.this.modelsTable.updateUI();
            }
        });
        this.btnDeselectAllOpen = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        this.btnDeselectAllOpen.setEnabled(false);
        this.btnDeselectAllOpen.setMnemonic(68);
        this.btnDeselectAllOpen.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAllOpen.setToolTipText(Messages.getString("OpenDesignDialog.DeSelectAll_ORM"));
        this.btnDeselectAllOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDesignDialog.this.checkAll(OpenDesignDialog.this.modelsTable, OpenDesignDialog.this.currentModelsList, false, 1);
                OpenDesignDialog.this.modelsTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.setMaximumSize(new Dimension(500, 20));
        toolBar.setMinimumSize(new Dimension(500, 20));
        toolBar.setSize(new Dimension(500, 20));
        toolBar.add(this.btnSelectAllOpen);
        toolBar.add(this.btnDeselectAllOpen);
        toolBar.addSeparator();
        toolBar.add(selectedObjectsFilterLabel);
        toolBar.add(this.tfModelsFilter);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.addSeparator();
        toolBar.add(selectedPhysicalLabel);
        toolBar.add(this.btnSelectAllOpenPM);
        toolBar.add(this.btnDeselectAllOpenPM);
        objectsFilterPanel.add(toolBar);
        this.mainPanel.add((Component)objectsFilterPanel, "North");
    }

    private void initRelational() {
        this.currentModelsList = new ArrayList();
        this.modelsModel = new ModelsModel();
        this.modelsTable = new JTable(this.modelsModel);
        this.modelsTable.setEnabled(false);
        JTableHeader header = this.modelsTable.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        tips.setToolTip(this.modelsTable.getColumnModel().getColumn(0), Messages.getString("OpenDesignDialog.RelModelName"));
        tips.setToolTip(this.modelsTable.getColumnModel().getColumn(1), Messages.getString("OpenDesignDialog.OpenRModel"));
        tips.setToolTip(this.modelsTable.getColumnModel().getColumn(2), Messages.getString("OpenDesignDialog.OpenDefaultPModel"));
        header.addMouseMotionListener(tips);
        TableColumn col1 = this.modelsTable.getColumnModel().getColumn(1);
        col1.setCellRenderer(new CheckBoxRenderer());
        col1.setMinWidth(100);
        col1.setWidth(100);
        col1.setMaxWidth(100);
        TableColumn col2 = this.modelsTable.getColumnModel().getColumn(2);
        col2.setCellRenderer(new CheckBoxRenderer());
        col2.setMinWidth(100);
        col2.setWidth(100);
        col2.setMaxWidth(100);
        this.modelsSP = new JScrollPane(this.modelsTable);
        this.mainPanel.add((Component)this.modelsSP, "Center");
        this.modelsModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    DMDOpenObject oo = (DMDOpenObject)OpenDesignDialog.this.currentModelsList.get(e.getFirstRow());
                    if (e.getColumn() == 1) {
                        if (oo.isOpenDefaultPhysicalModel() && !oo.isOpen()) {
                            OpenDesignDialog.this.modelsModel.setValueAt(false, e.getFirstRow(), 2);
                        }
                    } else if (e.getColumn() == 2 && oo.isOpenDefaultPhysicalModel() && !oo.isOpen()) {
                        OpenDesignDialog.this.modelsModel.setValueAt(true, e.getFirstRow(), 1);
                    }
                }
            }
        });
        this.currentModelsList.clear();
        RelationalDesign[] rds = (RelationalDesign[])this.design.getRelationalDesigns().toArray();
        for (int i = 0; i < rds.length; ++i) {
            RelationalDesign rd = rds[i];
            if (this.persistence.getLoadedRModelsList().size() > 0) {
                boolean found = false;
                for (DMDOpenObject oo : this.persistence.getLoadedRModelsList()) {
                    if (!rd.getObjectID().equals(oo.getModelObjId())) continue;
                    DMDOpenObject mo = new DMDOpenObject(rd.getObjectID(), rd.getName(), oo.isOpenDefaultPhysicalModel(), oo.isOpen());
                    this.currentModelsList.add(mo);
                    found = true;
                    break;
                }
                if (found) continue;
                DMDOpenObject mo = new DMDOpenObject(rd.getObjectID(), rd.getName(), false, true);
                this.currentModelsList.add(mo);
                continue;
            }
            DMDOpenObject mo = new DMDOpenObject(rd.getObjectID(), rd.getName(), false, true);
            this.currentModelsList.add(mo);
        }
        if (this.currentModelsList.size() > 0) {
            this.tfModelsFilter.setEnabled(true);
            this.btnSelectAllOpen.setEnabled(true);
            this.btnDeselectAllOpen.setEnabled(true);
            this.btnSelectAllOpenPM.setEnabled(true);
            this.btnDeselectAllOpenPM.setEnabled(true);
            this.modelsTable.setEnabled(true);
            this.modelsTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.modelsTable, 0);
        }
    }

    private void initButtons() {
        this.buttonsPanel = new JPanel(new BorderLayout());
        JPanel pn1 = new JPanel(new FlowLayout(1));
        JPanel pn2 = new JPanel(new FlowLayout(0));
        this.buttonsPanel.add((Component)pn1, "North");
        this.buttonsPanel.add((Component)pn2, "South");
        this.okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationalDesign[] rds = (RelationalDesign[])OpenDesignDialog.this.design.getRelationalDesigns().toArray();
                block0: for (int i = 0; i < rds.length; ++i) {
                    RelationalDesign rd = rds[i];
                    for (DMDOpenObject mo : OpenDesignDialog.this.currentModelsList) {
                        if (!rd.getObjectID().equals(mo.getModelObjId())) continue;
                        if (mo.isOpen()) {
                            rd.setShouldBeOpen(true);
                            continue block0;
                        }
                        rd.setShouldBeOpen(false);
                        continue block0;
                    }
                }
                OpenDesignDialog.this.persistence.save(OpenDesignDialog.this.currentModelsList);
                OpenDesignDialog.this.close();
            }
        });
        pn1.add(this.okButton);
        this.chbDontShowAgain = new JCheckBox(Messages.getString("OpenDesignDialog.DontShowDialogAgain"));
        this.chbDontShowAgain.setSelected(!this.view.getSettings().showSelectRelModelDialog());
        this.chbDontShowAgain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDesignDialog.this.view.getSettings().setShowSelectRelModelDialog(!OpenDesignDialog.this.chbDontShowAgain.isSelected());
                ModelingPreferences mp = ModelingPreferences.getInstance((PropertyStorage)OpenDesignDialog.this.p);
                mp.setShowSelectRelModelDialog(!OpenDesignDialog.this.chbDontShowAgain.isSelected());
            }
        });
        pn2.add(this.chbDontShowAgain);
        this.mainPanel.add((Component)this.buttonsPanel, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("OpenDesignDialog.SelectRelationalModels"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.requestFocus();
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.design = null;
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), 0);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private void checkAll(JTable table, List<DMDOpenObject> objects, boolean checked, int column) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.selectAll(table, objects, checked, column);
        } else {
            for (int i = 0; i < objects.size(); ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                if (column == 1) {
                    objects.get(i).setOpen(checked);
                } else if (column == 2) {
                    objects.get(i).setOpenDefaultPhysicalModel(checked);
                }
                int index = table.convertRowIndexToModel(i);
                this.modelsModel.fireTableCellUpdated(index, column);
            }
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List<DMDOpenObject> objects, boolean selected, int column) {
        if (selected) {
            this.selectAll(table, objects, column);
        } else {
            this.deselectAll(table, objects, column);
        }
    }

    private void selectAll(JTable table, List list, int column) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                DMDOpenObject o = (DMDOpenObject)list.get(index);
                this.setSelected(o, true, column);
                this.modelsModel.fireTableCellUpdated(index, column);
            }
        } else {
            Iterator it = list.iterator();
            int r = 0;
            while (it.hasNext()) {
                DMDOpenObject o = (DMDOpenObject)it.next();
                this.setSelected(o, true, column);
                this.modelsModel.fireTableCellUpdated(r, column);
                ++r;
            }
        }
    }

    private void deselectAll(JTable table, List list, int column) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                DMDOpenObject o = (DMDOpenObject)list.get(index);
                this.setSelected(o, false, column);
                this.modelsModel.fireTableCellUpdated(index, column);
            }
        } else {
            Iterator it = list.iterator();
            int r = 0;
            while (it.hasNext()) {
                DMDOpenObject o = (DMDOpenObject)it.next();
                this.setSelected(o, false, column);
                this.modelsModel.fireTableCellUpdated(r, column);
                ++r;
            }
        }
    }

    private void setSelected(DMDOpenObject obj, boolean selected, int column) {
        if (obj != null) {
            if (column == 1) {
                obj.setOpen(selected);
            } else if (column == 2) {
                obj.setOpenDefaultPhysicalModel(selected);
            }
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        private FilterObjectListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            OpenDesignDialog.this.newFilter(OpenDesignDialog.this.tfModelsFilter, OpenDesignDialog.this.modelsTable);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            OpenDesignDialog.this.newFilter(OpenDesignDialog.this.tfModelsFilter, OpenDesignDialog.this.modelsTable);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            OpenDesignDialog.this.newFilter(OpenDesignDialog.this.tfModelsFilter, OpenDesignDialog.this.modelsTable);
        }
    }

    private class ModelsModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("OpenDesignDialog.Model"), Messages.getString("OpenDesignDialog.OpenRM"), Messages.getString("OpenDesignDialog.OpenPM")};

        private ModelsModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public int getRowCount() {
            return OpenDesignDialog.this.currentModelsList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DMDOpenObject o = (DMDOpenObject)OpenDesignDialog.this.currentModelsList.get(rowIndex);
            if (columnIndex == 0) {
                return o.getModelName();
            }
            if (columnIndex == 1) {
                return o.isOpen();
            }
            if (columnIndex == 2) {
                return o.isOpenDefaultPhysicalModel();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            DMDOpenObject o = (DMDOpenObject)OpenDesignDialog.this.currentModelsList.get(row);
            if (col == 1) {
                o.setOpen((Boolean)value);
            } else if (col == 2) {
                o.setOpenDefaultPhysicalModel((Boolean)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map tips = new HashMap();

        ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            TableColumn col = null;
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText((String)this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    public class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean val = (Boolean)value;
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

