/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLTransformationTask
extends AbstractXMLWriter {
    private TransformationTask design = null;

    public WXMLTransformationTask(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof TransformationTask;
        if (result) {
            this.design = (TransformationTask)object;
        }
        return result;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (TransformationTask)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            Document doc = this.createDocument("design");
            Element designElm = doc.getDocumentElement();
            designElm.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            if (this.design.getMainView() != null) {
                designElm.setAttribute("main_view_id", this.design.getMainView().getDPVId());
            } else {
                designElm.setAttribute("main_view_id", "null");
            }
            Element inputParams = doc.createElement("input_parameters");
            Element outputParams = doc.createElement("output_parameters");
            designElm.appendChild(inputParams);
            designElm.appendChild(outputParams);
            this.appendParameterElement(inputParams, this.design.getInputParamsObject());
            this.appendParameterElement(outputParams, this.design.getOutputParamsObject());
            Element referenced = doc.createElement("ref");
            designElm.appendChild(referenced);
            this.appendSources(doc, designElm);
            this.appendTargets(doc, designElm);
            Element vGlobals = doc.createElement("synonyms_for_globals");
            designElm.appendChild(vGlobals);
            Element vFlows = doc.createElement("view_flows");
            designElm.appendChild(vFlows);
            Collection all = this.design.getStorableDesignObjects();
            Iterator it = all.iterator();
            DesignObject designObject = null;
            while (it.hasNext()) {
                designObject = (DesignObject)it.next();
                this.handleDesignObject(referenced, designObject);
            }
            this.handleSynonymsForGlobals(this.design, vGlobals);
            this.handleFlows(this.design, vFlows);
            this.appendDisplayProperties(designElm, this.design.getMainView());
            this.appendDiagramViews(doc, designElm, this.design);
            this.design.setDirty(false);
            return doc;
        }
        return null;
    }

    private void appendSources(Document doc, Element designElm) {
        Element sources = doc.createElement("source_stores");
        Iterator it = this.design.getSources().iterator();
        StringBuffer ids = new StringBuffer();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                ids.append(", ");
            } else {
                first = false;
            }
            ids.append(StringUtilities.encodeAttributeValue(((DesignObject)it.next()).getObjectID()));
        }
        sources.setAttribute("id", ids.toString());
        designElm.appendChild(sources);
    }

    private void appendTargets(Document doc, Element designElm) {
        Element targets = doc.createElement("target_stores");
        Iterator it = this.design.getTargets().iterator();
        StringBuffer ids = new StringBuffer();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                ids.append(", ");
            } else {
                first = false;
            }
            ids.append(StringUtilities.encodeAttributeValue(((DesignObject)it.next()).getObjectID()));
        }
        targets.setAttribute("id", ids.toString());
        designElm.appendChild(targets);
    }

    private void handleDesignObject(Element referenced, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            if (this.getPersistenceManager().isCheckDirty()) {
                if (designObject.isDirty()) {
                    this.getPersistenceManager().write(designObject);
                }
            } else {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(referenced, designObject);
    }

    private void appendReferencedObjectElement(Element parentNode, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        this.appendGraphicalInfo(objInfo, designObject);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(designObject);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        DesignPart dsn = (DesignPart)object;
        return dsn.getPathIDString();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String designName = this.design.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append(TRPACKAGE_PATH).append('/').append(StringUtilities.encodeAttributeValue(this.design.getTransformationPackage().getObjectID())).append('/');
            return buffer.toString();
        }
        return TRPACKAGE_PATH + "/tasks/";
    }

    public void handleFlows(TransformationTask dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            DesignPartView dpv = dsn.getMainView();
            Iterator it = dsn.getFlowSet().iterator();
            while (it.hasNext()) {
                Flow flow = (Flow)it.next();
                if (flow.getSourceTV(dpv) == null && flow.getTargetTV(dpv) == null) continue;
                this.appendFlowObjectElement(dsn, designElm, flow);
            }
        }
    }

    public void handleSynonymsForGlobals(TransformationTask dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            ArrayList collection = new ArrayList();
            dsn.getStores().addAllElementsTo(collection);
            DesignPartView dpv = dsn.getMainView();
            for (DesignObjectPlaceHolder dph : collection) {
                AbstractProcessObject obj = (AbstractProcessObject)dph.getDesignObject();
                this.appendSynonymForGlobalElement(designElm, obj, dpv);
            }
        }
    }

    private void appendSynonymForGlobalElement(Element parentNode, AbstractProcessObject designObject, DesignPartView dpv) {
        Document doc = parentNode.getOwnerDocument();
        TopView tv = (TopView)designObject.getViewsForDPV(dpv).get(0);
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        this.appendGraphicalInfo(objInfo, designObject, tv);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject, TopView tv) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(tv);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    private void appendFlowObjectElement(TransformationTask dsn, Element parentNode, Flow flow) {
        Document doc = parentNode.getOwnerDocument();
        DesignPartView dpv = dsn.getMainView();
        TVFlow tv = (TVFlow)flow.getViewFor(dpv);
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(flow.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(flow.getObjectID()));
        objInfo.setAttribute("viewid_source", flow.getSourceTV(dpv) != null ? flow.getSourceTV(dpv).getViewID() : "null");
        objInfo.setAttribute("viewid_target", flow.getTargetTV(dpv) != null ? flow.getTargetTV(dpv).getViewID() : "null");
        Element points = doc.createElement("points");
        if (tv != null) {
            EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
            List edgePoints = acv.getPoints();
            for (int i = 0; i < edgePoints.size(); ++i) {
                Object obj = edgePoints.get(i);
                Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        }
        objInfo.appendChild(points);
        if (tv != null) {
            EdgeView edgeView = (EdgeView)tv.getCellView();
            if (edgeView != null) {
                Element labels = doc.createElement("labels");
                Element lbl = doc.createElement("main_label");
                lbl.setAttribute("x_coordinate", Double.toString(tv.getLabelBounds().getX()));
                lbl.setAttribute("y_coordinate", Double.toString(tv.getLabelBounds().getY()));
                lbl.setAttribute("width", Double.toString(tv.getLabelBounds().getWidth()));
                lbl.setAttribute("height", Double.toString(tv.getLabelBounds().getHeight()));
                labels.appendChild(lbl);
                Label label = tv.getLabel(1);
                if (label != null) {
                    this.appendDesignObjectColor(lbl, label);
                    this.appendDesignObjectFonts(lbl, label);
                }
                objInfo.appendChild(labels);
            }
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : "null");
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }

    private void appendParameterElement(Element parentNode, DesignObject designObject) {
        Document doc = parentNode.getOwnerDocument();
        InOutParams params = (InOutParams)designObject;
        parentNode.setAttribute("parameters_multiplicity", params.getParametersMultiplicity());
        Element child = doc.createElement("comment");
        Text content = doc.createTextNode(StringUtilities.encodeAttributeValue(designObject.getComment()));
        child.appendChild(content);
        parentNode.appendChild(child);
        child = doc.createElement("notes");
        content = doc.createTextNode(designObject.getNotes());
        child.appendChild(content);
        parentNode.appendChild(child);
        this.appendDesignObjectColor(parentNode, designObject);
        this.appendDesignObjectFonts(parentNode, designObject);
        for (ParameterObject param : params.getParams()) {
            this.appendParamInfo(parentNode, param);
        }
        this.appendGraphicalInfo(parentNode, designObject);
    }

    public void appendParamInfo(Element objInfo, ParameterObject designObject) {
        Element parInfo = objInfo.getOwnerDocument().createElement("inout_parameter");
        parInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        parInfo.setAttribute("name", StringUtilities.encodeAttributeValue(designObject.getName()));
        parInfo.setAttribute("dttype", StringUtilities.encodeAttributeValue(designObject.getLogicalDatatype().getName()));
        objInfo.appendChild(parInfo);
    }
}

