/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLProcessModel
extends AbstractXMLWriter {
    private ProcessModel processModel = null;

    public WXMLProcessModel(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof ProcessModel;
    }

    @Override
    public Document writeDocument(Object object) {
        this.processModel = (ProcessModel)object;
        Document doc = this.createDocument("design");
        Element designElm = doc.getDocumentElement();
        designElm.setAttribute("id", StringUtilities.encodeAttributeValue(this.processModel.getObjectID()));
        Element referenced = doc.createElement("ref");
        designElm.appendChild(referenced);
        Collection all = this.processModel.getStorableDesignObjects();
        Iterator it = all.iterator();
        DesignObject designObject = null;
        while (it.hasNext()) {
            designObject = (DesignObject)it.next();
            this.handleDesignObject(referenced, designObject);
        }
        if (this.processModel.getMainView() != null) {
            this.appendDisplayProperties(designElm, this.processModel.getMainView());
        }
        this.processModel.setDirty(false);
        return doc;
    }

    private void handleDesignObject(Element referenced, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            this.getPersistenceManager().write(designObject);
        }
        this.appendReferencedObjectElement(referenced, designObject);
    }

    private void appendReferencedObjectElement(Element parentNode, DesignObject designObject) {
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        if (designObject.hasGUIView()) {
            this.appendGraphicalInfo(objInfo, designObject);
        }
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(designObject);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        ProcessModel processModel = (ProcessModel)object;
        return StringUtilities.encodeAttributeValue(processModel.getObjectID());
    }

    @Override
    public String getRelativePath() {
        if (this.processModel != null && this.processModel.getAppView() != null) {
            String designName = this.processModel.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append('/').append(designName).append('/').append("pm");
            return buffer.toString();
        }
        return "pm";
    }
}

