/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLSlice
extends AbstractWXMLDesignObject
implements MDConstants {
    private Slice slice = null;

    public WXMLSlice(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Slice;
        if (result) {
            this.slice = (Slice)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.slice != null) {
            String designName = this.slice.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.slice.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("slicePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Slice) {
            Slice slice = (Slice)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(slice.getDescription()));
            map.put("readonly", String.valueOf(slice.isReadOnlySlice()));
            map.put("fullyrealized", String.valueOf(slice.isFullyRealized()));
            map.put("entity", String.valueOf(slice.getEntity() != null ? StringUtilities.encodeAttributeValue(slice.getEntity().getObjectID()) : "null"));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, slice.getLevels().toArray(), "levels");
            this.appendObjects(objectInfoNode, slice.getSelectionCriterias().toArray(), "selectioncriterias");
            Element mwrappers = objectInfoNode.getOwnerDocument().createElement("measure_wrappers");
            this.appendMeasureWrappers(mwrappers, slice);
            objectInfoNode.appendChild(mwrappers);
            Element slevels = objectInfoNode.getOwnerDocument().createElement("selected_levels");
            this.appendSelectedLevels(slevels, slice);
            objectInfoNode.appendChild(slevels);
            this.appendSliceMappings(objectInfoNode, slice);
        }
    }

    private void appendMeasureWrappers(Element parent, Slice slice) {
        for (Slice.MeasureWrapper mw : slice.getSelectedMeasureWrappers()) {
            Element felem = parent.getOwnerDocument().createElement("measure_wrapper");
            if (mw.getMeasure() != null) {
                felem.setAttribute("measure_id", StringUtilities.encodeAttributeValue(mw.getMeasure().getObjectID()));
            }
            if (mw.getAggrFunction() != null) {
                felem.setAttribute("aggr_function_id", StringUtilities.encodeAttributeValue(mw.getAggrFunction().getObjectID()));
            }
            this.appendSummaryLevels(felem, mw);
            parent.appendChild(felem);
        }
    }

    private void appendSummaryLevels(Element parent, Slice.MeasureWrapper mw) {
        for (Level level : mw.levels) {
            Element felem = parent.getOwnerDocument().createElement("summary_level");
            felem.setAttribute("level_id", StringUtilities.encodeAttributeValue(level.getObjectID()));
            parent.appendChild(felem);
        }
    }

    private void appendSelectedLevels(Element parent, Slice slice) {
        for (Slice.SelectedLevel sl : slice.getSelectedLevels()) {
            Element felem = parent.getOwnerDocument().createElement("selected_level");
            felem.setAttribute("dimension_id", StringUtilities.encodeAttributeValue(sl.getDimension().getObjectID()));
            felem.setAttribute("hierarchy_id", StringUtilities.encodeAttributeValue(sl.getHierarchy().getObjectID()));
            felem.setAttribute("level_id", StringUtilities.encodeAttributeValue(sl.getLevel().getObjectID()));
            felem.setAttribute("selected_attributes", sl.getSelAttrIDs());
            if (sl.rollupLink != null) {
                felem.setAttribute("rolluplink", StringUtilities.encodeAttributeValue(sl.rollupLink.getObjectID()));
            }
            parent.appendChild(felem);
        }
    }

    private void appendSliceMappings(Element parentNode, Slice slice) {
        Document doc = parentNode.getOwnerDocument();
        Element list = doc.createElement("slice_mappings");
        for (Slice.SliceMapping sm : slice.getSliceMappings()) {
            Element attr = doc.createElement("contained");
            attr.setAttribute("oid", StringUtilities.encodeAttributeValue(sm.getAttribute().getObjectID()));
            attr.setAttribute("mappingid", sm.getMapping() != null ? StringUtilities.encodeAttributeValue(sm.getMapping().getObjectID()) : "");
            list.appendChild(attr);
        }
        parentNode.appendChild(list);
    }
}

