/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLRollupLink
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLRollupLink(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getRollupLinkSet().createRollupLink(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String aggrOp;
        String sparse;
        String rolePlaying;
        AbstractMDObject level;
        String parentLevelID;
        String factEntId;
        Level level2;
        RollupLink rollupLink = (RollupLink)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        rollupLink.setDescription((String)map.get("description"));
        String childLevelID = (String)map.get("childlevel");
        if (!"null".equalsIgnoreCase(childLevelID) && (level2 = (Level)rollupLink.getDesign().getDesignObject(childLevelID)) != null) {
            rollupLink.setChildLevel(level2);
        }
        if ((factEntId = (String)map.get("factentity")) != null && !"null".equalsIgnoreCase(factEntId)) {
            ContainerObject ent = (ContainerObject)rollupLink.getDesign().getLogicalDesign().getEntitySet().getObjectByID(factEntId);
            if (ent == null) {
                ent = (ContainerObject)rollupLink.getDesign().getLogicalDesign().getEntityViewSet().getObjectByID(factEntId);
            }
            if (ent != null) {
                rollupLink.setFactEntity(ent);
            }
        }
        if (!"null".equalsIgnoreCase(parentLevelID = (String)map.get("parentlevel")) && (level = (AbstractMDObject)rollupLink.getDesign().getDesignObject(parentLevelID)) != null) {
            rollupLink.setParentLevel(level);
        }
        if ((rolePlaying = (String)map.get("roleplaying")) != null && "true".equalsIgnoreCase(rolePlaying)) {
            rollupLink.setRolePlaying(true);
        }
        if ((sparse = (String)map.get("sparse_dimension")) != null && "true".equalsIgnoreCase(sparse)) {
            rollupLink.setSparseDimension(true);
        }
        if ((aggrOp = (String)map.get("default_aggr_operator")) != null) {
            rollupLink.setDefaultAggregationOperator(aggrOp);
        }
        Map objMap = this.getProperties(objInfo, "attributes_list");
        Object[] objects = objMap.keySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            ContainedObject attribute = (ContainedObject)rollupLink.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(aID);
            if (attribute == null) {
                attribute = (ContainedObject)rollupLink.getDesign().getLogicalDesign().getAttributeViewSet().getObjectByID(aID);
            }
            if (attribute == null) continue;
            rollupLink.addChildToParentAttribute(attribute);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(rollupLink.getObjectID())).append(".dmd");
        rollupLink.setFilePath(buffer.toString());
        return rollupLink;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("rolluplinkPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == RollupLink.class;
    }
}

