/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLForeignKey
extends AbstractRXMLDesignObject {
    public RXMLForeignKey(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        FKIndexAssociation association = new FKIndexAssociation(design.getRelationalDesign());
        association.setObjectID(StringUtilities.decodeAttributeValue(objectID));
        return association;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                String relDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID();
                buffer.append("relational").append('/').append(StringUtilities.decodeAttributeValue(relDesName)).append('/');
            } else {
                String relDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString();
                buffer.append("rel").append('/').append(relDesName).append('/');
            }
        }
        buffer.append(this.getConfiguration().get("fkeyPath"));
        return buffer.toString();
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)desObject;
            String tableId = objInfo.getAttribute("tableid");
            String referencedTableId = objInfo.getAttribute("reftableid");
            String referencedIndexId = objInfo.getAttribute("references");
            String localIndexId = objInfo.getAttribute("localindexid");
            String deleteRule = objInfo.getAttribute("delrule");
            String mandatory = objInfo.getAttribute("mandatory");
            String transferable = objInfo.getAttribute("transferable");
            Table table = (Table)desObject.getDesign().getDesignObject(tableId);
            Table refTable = (Table)desObject.getDesign().getDesignObject(referencedTableId);
            if (table != null && refTable != null) {
                Index index = (Index)refTable.getKeyObject(referencedIndexId);
                table.recreateFK(fk, index, localIndexId, deleteRule);
                if (mandatory != null && "true".equalsIgnoreCase(mandatory)) {
                    fk.setMandatory(true);
                } else if ("".equals(mandatory)) {
                    fk.resetMandatoryUsingColumns();
                } else {
                    fk.setMandatory(false);
                }
                if (transferable != null && ("true".equalsIgnoreCase(transferable) || "".equals(transferable))) {
                    fk.setTransferable(true);
                } else {
                    fk.setTransferable(false);
                }
                fk.resetEdgeParams();
            }
        }
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        FKIndexAssociation relation = (FKIndexAssociation)super.recreateObject(objInfo, design, tryReadWriteLocking);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(relation.getObjectID())).append(".dmd");
        relation.setFilePath(buffer.toString());
        return relation;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == FKIndexAssociation.class;
    }
}

