/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Map;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLEntity
extends AbstractRXMLDesignObject {
    public RXMLEntity(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("entityPath"));
        return buffer.toString();
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getLogicalDesign().recreateEntity(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof Entity) {
            String typesubst;
            String shortName;
            String abbr;
            String structuredTypeID;
            String scope;
            String type;
            String normalForm;
            String growthType;
            String growthPercent;
            String maxVolumes;
            String expectedVolumes;
            String minVolumes;
            String source;
            String dsynonym;
            String synonym;
            String owner;
            Entity entity = (Entity)desObject;
            String strategyName = objInfo.getAttribute("strategy");
            if (strategyName != null) {
                entity.setFwdEngineeringStrategyName(strategyName);
            }
            if ((owner = objInfo.getAttribute("owner")) != null && !"".equalsIgnoreCase(owner)) {
                entity.setOwner(StringUtilities.decodeAttributeValue(owner));
            }
            if ((synonym = objInfo.getAttribute("synonym")) != null && !"".equalsIgnoreCase(synonym)) {
                entity.setSynonym(StringUtilities.decodeAttributeValue(synonym));
            }
            if ((dsynonym = objInfo.getAttribute("synonym_to_display")) != null && !"".equalsIgnoreCase(dsynonym)) {
                entity.setSynonymToDisplay(StringUtilities.decodeAttributeValue(dsynonym));
            }
            if ((source = objInfo.getAttribute("entsource")) != null && !"".equalsIgnoreCase(source)) {
                entity.setSource(StringUtilities.decodeAttributeValue(source));
            }
            if ((minVolumes = objInfo.getAttribute("minVolumes")) != null) {
                entity.setMinVolumes(minVolumes);
            }
            if ((expectedVolumes = objInfo.getAttribute("expectedVolumes")) != null) {
                entity.setExpectedVolumes(expectedVolumes);
            }
            if ((maxVolumes = objInfo.getAttribute("maxVolumes")) != null) {
                entity.setMaxVolumes(maxVolumes);
            }
            if ((growthPercent = objInfo.getAttribute("growthPercent")) != null) {
                entity.setGrowthPercent(growthPercent);
            }
            if ((growthType = objInfo.getAttribute("growthType")) != null) {
                entity.setGrowthType(growthType);
            }
            if ((normalForm = objInfo.getAttribute("normalForm")) != null) {
                entity.setNormalForm(normalForm);
            }
            if ((type = objInfo.getAttribute("entitytype")) != null) {
                if (ContainerObject.TYPE_CONSOLIDATED.equalsIgnoreCase(type)) {
                    entity.setTypeID("4");
                } else if (entity.getDesign().getLoadedVersion() < 2.2f) {
                    if (entity.getDesign().getDesignLevelSettings().getClassificationTypeByName(type) != null) {
                        entity.setTypeID(entity.getDesign().getDesignLevelSettings().getClassificationTypeByName(type).getTypeID());
                    } else {
                        entity.setTypeID("");
                    }
                } else if (entity.getDesign().getDesignLevelSettings().getClassificationTypeByID(type) != null) {
                    entity.setTypeID(type);
                } else {
                    entity.setTypeID("");
                }
            }
            if ((scope = objInfo.getAttribute("scope")) != null && !"".equalsIgnoreCase(scope)) {
                entity.setScope(StringUtilities.decodeAttributeValue(scope));
            }
            if ((structuredTypeID = objInfo.getAttribute("structuredType")) != null) {
                StructuredType structuredType = (StructuredType)desObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(structuredTypeID);
                entity.setBasedOnStructuredType(structuredType);
            }
            if ((abbr = objInfo.getAttribute("pref_abbreviation")) != null && !"".equalsIgnoreCase(abbr)) {
                entity.setPreferredAbbreviation(StringUtilities.decodeAttributeValue(abbr));
            }
            if ((shortName = objInfo.getAttribute("short_name")) != null && !"".equalsIgnoreCase(shortName)) {
                entity.setShortName(StringUtilities.decodeAttributeValue(shortName));
            }
            if ((typesubst = objInfo.getAttribute("allow_type_substitution")) != null) {
                entity.setAllowTypeSubstitution(Boolean.valueOf(typesubst));
            }
            if (entity.getLoadedVersion() < 1.0f) {
                NodeList list = objInfo.getElementsByTagName("parent");
                int length = list.getLength();
                for (int i = 0; i < length; ++i) {
                    Element hierarchyElm = (Element)list.item(i);
                    if (!VALUE_TRUE.equals(hierarchyElm.getAttribute("inherits"))) continue;
                    String parentId = hierarchyElm.getAttribute("id");
                    ConnectHierarchicalParentTask task = new ConnectHierarchicalParentTask(entity, parentId);
                    this.getPersistenceManager().addTask(task);
                }
            }
        }
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("entity id prefix");
    }

    @Override
    protected void readContainedObjectInfo(Element objInfo, ContainedObject contObject, boolean tryReadWriteLocking) {
        String source;
        Element sourceElm;
        String oid;
        Element scopeElm;
        String restriction;
        Element restrElm;
        String substitution;
        Element substitutionElm;
        String abbr;
        Element abbreviation;
        String formulaDesc;
        Element formulaDescElm;
        String sourceType;
        Element sourceTypeElm;
        Element datatypeElm;
        Element logTypeElm;
        String ref;
        Attribute col = (Attribute)contObject;
        Element useDomainElm = RXMLEntity.getFirstChildByTagName(objInfo, "use");
        if (useDomainElm != null) {
            String use = useDomainElm.getAttribute("value");
            if (use != null) {
                if (use.equalsIgnoreCase("domain")) {
                    col.setUse((short)0);
                } else if (use.equalsIgnoreCase("logical type")) {
                    col.setUse((short)1);
                } else if (use.equalsIgnoreCase("distinct type")) {
                    col.setUse((short)2);
                } else if (use.equalsIgnoreCase("structured type")) {
                    col.setUse((short)3);
                } else if (use.equalsIgnoreCase("collection type")) {
                    col.setUse((short)4);
                }
            }
        } else {
            String useDomainType;
            useDomainElm = RXMLEntity.getFirstChildByTagName(objInfo, "usedomain");
            if (useDomainElm != null && (useDomainType = useDomainElm.getAttribute("value")) != null) {
                if (Boolean.valueOf(useDomainType).booleanValue()) {
                    col.setUse((short)0);
                } else {
                    col.setUse((short)1);
                }
            }
        }
        Element refElm = RXMLEntity.getFirstChildByTagName(objInfo, "reference");
        if (refElm != null && (ref = refElm.getAttribute("value")) != null) {
            col.setReference(Boolean.valueOf(ref));
        }
        if ((logTypeElm = RXMLEntity.getFirstChildByTagName(objInfo, "logicaltype")) != null) {
            String logType = logTypeElm.getAttribute("dttype");
            String lid = logTypeElm.getAttribute("oid");
            if (logType != null || lid != null) {
                LogicalDatatype type = LogicalDatatype.getLogicalDatatype(contObject.getDesign(), logType, lid);
                col.setLogicalDatatype(type);
            }
        }
        if ((datatypeElm = RXMLEntity.getFirstChildByTagName(objInfo, "datatype")) != null) {
            String type = datatypeElm.getAttribute("dttype");
            String name = datatypeElm.getAttribute("typename");
            if (type != null && type.equalsIgnoreCase("distinct")) {
                col.setDistinctType((DistinctType)contObject.getDesign().getDataTypesDesign().getDistinctTypeSet().getObjectByID(name));
            } else if (type != null && type.equalsIgnoreCase("structured")) {
                col.setStructuredType((StructuredType)contObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(name));
            } else if (type != null && type.equalsIgnoreCase("collection")) {
                col.setCollectionType((CollectionType)contObject.getDesign().getDataTypesDesign().getCollectionTypeSet().getObjectByID(name));
            } else {
                String scale;
                String precision;
                String size = datatypeElm.getAttribute("size");
                if (size != null && !size.equalsIgnoreCase("")) {
                    col.setDataTypeParameter("size", size);
                }
                if ((precision = datatypeElm.getAttribute("precision")) != null && !precision.equalsIgnoreCase("")) {
                    col.setDataTypeParameter("precision", precision);
                }
                if ((scale = datatypeElm.getAttribute("scale")) != null && !scale.equalsIgnoreCase("")) {
                    col.setDataTypeParameter("scale", scale);
                }
            }
        }
        if ((sourceTypeElm = RXMLEntity.getFirstChildByTagName(objInfo, "sourcetype")) != null && (sourceType = sourceTypeElm.getAttribute("sort")) != null) {
            col.setSourceType(sourceType);
        }
        if ((formulaDescElm = RXMLEntity.getFirstChildByTagName(objInfo, "formula")) != null && (formulaDesc = formulaDescElm.getAttribute("desc")) != null) {
            col.setFormulaDesc(StringUtilities.decodeAttributeValue(formulaDesc));
        }
        if ((abbreviation = RXMLEntity.getFirstChildByTagName(objInfo, "pref_abbreviation")) != null && (abbr = abbreviation.getAttribute("abbreviation")) != null) {
            col.setPreferredAbbreviation(StringUtilities.decodeAttributeValue(abbr));
        }
        if ((substitutionElm = RXMLEntity.getFirstChildByTagName(objInfo, "subtypeSubstitution")) != null && (substitution = substitutionElm.getAttribute("value")) != null) {
            col.setAllowSubtypeSubstitution(Boolean.valueOf(substitution));
        }
        if ((restrElm = RXMLEntity.getFirstChildByTagName(objInfo, "restricted_substitution")) != null && (restriction = restrElm.getAttribute("value")) != null) {
            col.setRestrictedTypeSubstitution(Boolean.valueOf(restriction));
            if (col.isRestrictedTypeSubstitution()) {
                Map objMap = this.getProperties(restrElm, "permitted_types");
                Object[] objects = objMap.keySet().toArray();
                for (int i = 0; i < objects.length; ++i) {
                    String aID = (String)objMap.get(objects[i]);
                    StructuredType st = (StructuredType)col.getDesign().getDesignObject(aID);
                    if (st == null) continue;
                    col.getPermittedSubTypes().add(st);
                }
            }
        }
        if ((scopeElm = RXMLEntity.getFirstChildByTagName(objInfo, "scope")) != null && (oid = scopeElm.getAttribute("objectid")) != null) {
            col.setScopeId(oid);
        }
        if ((sourceElm = RXMLEntity.getFirstChildByTagName(objInfo, "source")) != null && (source = sourceElm.getAttribute("value")) != null) {
            col.setSource(source);
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Entity entity = (Entity)super.recreateObject(objInfo, design, tryReadWriteLocking);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(entity.getObjectID())).append(".dmd");
        entity.setFilePath(buffer.toString());
        return entity;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Entity.class;
    }

    public static class ConnectHierarchicalParentTask
    implements Task {
        private Entity child;
        private String parentId;

        ConnectHierarchicalParentTask(Entity child, String parentId) {
            if (child == null) {
                throw new IllegalArgumentException(Messages.getString("RXMLEntity.ChildEntityCanNotBeNull"));
            }
            if (parentId == null) {
                throw new IllegalArgumentException(Messages.getString("RXMLEntity.ParentIdCanNotBeNull"));
            }
            this.child = child;
            this.parentId = parentId;
        }

        @Override
        public boolean execute() {
            if (this.child != null && this.parentId != null) {
                Entity parent = (Entity)this.child.getDesign().getDesignObject(this.parentId);
                if (parent != null) {
                    this.child.setHierarchicalParent(parent);
                    this.child = null;
                    this.parentId = null;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

