/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.Deflater;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.oracle.WriteManager;
import oracle.sql.BLOB;

public abstract class AbstractDBWriter {
    protected OracleRepositoryManager repositoryManager;

    public AbstractDBWriter(OracleRepositoryManager repManager) {
        this.repositoryManager = repManager;
    }

    public OracleRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public Connection getConnection() {
        if (this.repositoryManager.isConnected()) {
            if (this.repositoryManager.isRepositoryExists()) {
                return this.repositoryManager.getConnection();
            }
            throw new RuntimeException("Repository is not created");
        }
        throw new RuntimeException("Repository Manger is not connected to repository");
    }

    public void writeObject(Object object) {
        if (this.canHandle(object)) {
            try {
                this.writeObjectToDB(object);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void writeObjects(List objects) {
        Object object;
        if (objects.size() > 0 && this.canHandle(object = objects.get(0))) {
            try {
                this.writeObjectsToDB(objects);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected String getTableName(Object object) {
        return this.repositoryManager.getTableName(object);
    }

    protected abstract void writeObjectToDB(Object var1) throws SQLException;

    public abstract void writeObjectsToDB(List var1) throws SQLException;

    public abstract boolean canHandle(Object var1);

    public static BLOB getBLOB(String xmlData, Connection conn) throws SQLException {
        BLOB tempClob;
        block4: {
            tempClob = null;
            try {
                byte[] input = null;
                input = xmlData.getBytes("UTF-8");
                byte[] output = new byte[input.length];
                Deflater compresser = new Deflater();
                compresser.setInput(input);
                compresser.finish();
                int compressedDataLength = compresser.deflate(output);
                tempClob = BLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
                tempClob.open(1);
                OutputStream tempClobWriter = tempClob.setBinaryStream(1L);
                tempClobWriter.write(output, 0, compressedDataLength);
                tempClobWriter.flush();
                tempClobWriter.close();
                tempClob.close();
            }
            catch (SQLException sqlexp) {
                if (tempClob != null) {
                    tempClob.freeTemporary();
                }
            }
            catch (Exception exp) {
                if (tempClob == null) break block4;
                tempClob.freeTemporary();
            }
        }
        return tempClob;
    }

    public WriteManager getWriteManager() {
        return this.getRepositoryManager().getWriteManager();
    }

    public void assignRepositoryIDs(RepositoryObject object, String oid, String ovid) {
        this.getWriteManager().assignRepositoryIDs(object, oid, ovid);
    }

    public void clearDirtyFlag(RepositoryObject object) {
        this.getWriteManager().clearDirtyFlag(object);
    }
}

