/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRStoGroupWithoutVolumes
extends AbstractDRStorageDesign {
    private final String RULE_ID = "F46DE5DF-7D90-679A-5EB4-32A453F54AF3";

    public DRStoGroupWithoutVolumes(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRStoGroupWithoutVolumes.IdentifyStoGroupWithoutVolumes"));
        this.setDescription(Messages.getString("DRStoGroupWithoutVolumes.StorageGroupsWithoutVolumnesNotValid"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        StorageGroupDB2 gr = (StorageGroupDB2)object;
        if (!"SYSDEFLT".equalsIgnoreCase(gr.getName())) {
            if (gr.getVolumes() == null || "".equalsIgnoreCase(gr.getVolumes().trim()) || "???".equalsIgnoreCase(gr.getVolumes().trim())) {
                return CheckResult.createWarning(object, this, Messages.getString("DRStoGroupWithoutVolumes.InvalidStorageGroupWithoutVolumes"));
            }
            return CheckResult.createOk(object, this, Messages.getString("DRStoGroupWithoutVolumes.StorageGroupHasVolumes"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRStoGroupWithoutVolumes.DefaultStorageGroup"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "F46DE5DF-7D90-679A-5EB4-32A453F54AF3";
    }
}

