/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRIndexProxyNoGenerate
extends AbstractDRStorageDesign {
    private final String RULE_ID = "BC535ACE-3767-F987-2F9B-B1D6199ED6BC";

    public DRIndexProxyNoGenerate(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRIndexProxyNoGenerate.IdentifyPKMarkedGenerate"));
        this.setDescription(Messages.getString("DRIndexProxyNoGenerate.GenerateDDLForThisPK"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexProxy index = (IndexProxy)object;
        if (((Index)index.getObject()).isPK()) {
            if (index.isMarkedGenerate()) {
                return CheckResult.createOk(object, this, Messages.getString("DRIndexProxyNoGenerate.PKMarkedGenerate"));
            }
            return CheckResult.createWarning(object, this, Messages.getString("DRIndexProxyNoGenerate.PKNotMarkedGenerate"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRIndexProxyNoGenerate.IndexNotPK"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "BC535ACE-3767-F987-2F9B-B1D6199ED6BC";
    }
}

