/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRViewNoColumns
extends DesignRule {
    private final String RULE_ID = "248F20AE-A9CA-7386-BEF7-F850ECBEB3EE";

    public DRViewNoColumns() {
        this.setName(Messages.getString("DRViewNoColumns.IdentifyViewsWithoutColumns"));
        this.setDescription(Messages.getString("DRViewNoColumns.ViewHasNoColumns"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableView view = (TableView)object;
        if (view.size() > 0) {
            return CheckResult.createOk(object, this, Messages.getString("DRViewNoColumns.ViewHasColumns"));
        }
        if (view.getUserDefined()) {
            return CheckResult.createWarning(object, this, this.getDescription());
        }
        return CheckResult.createFailed(object, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "248F20AE-A9CA-7386-BEF7-F850ECBEB3EE";
    }
}

