/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRColumnUnknown
extends DesignRule {
    private final String RULE_ID = "53879DD6-3AC5-D40E-2E50-5C288B8F1DB4";

    public DRColumnUnknown() {
        this.setName(Messages.getString("DRColumnUnknown.IdentifyColumnsWithoutDatatype"));
        this.setDescription(Messages.getString("DRColumnUnknown.ColumnWithDatatypeUNKNOWNIsNotAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Column column = (Column)object;
        Datatype dataType = column.getDataType(column.getSelectedRDBMSType().toString());
        if (dataType.getName().equalsIgnoreCase("unknown") && !column.isComputed().booleanValue()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRColumnUnknown.ColumnDatatypeUnknown"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRColumnUnknown.ColumnDatatypeKnown"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "53879DD6-3AC5-D40E-2E50-5C288B8F1DB4";
    }
}

