/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRAttributeCheckDefaultAndPermittedValue
extends DesignRule {
    private final String RULE_ID = "2265D44D-6FBF-D640-B35C-C59DBCEE62F4";
    Attribute attribute;
    String beginValue;
    String endValue;
    boolean result = false;
    double doubleValue = 0.0;
    Double d = null;

    public DRAttributeCheckDefaultAndPermittedValue() {
        this.setName(Messages.getString("DRAttributeCheckDefaultAndPermittedValue.CheckAttributeDefaultvalues"));
        this.setDescription(Messages.getString("DRAttributeCheckDefaultAndPermittedValue.AttributeDefaultValuesWithoutPermittedValuesNotAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        try {
            this.attribute = (Attribute)object;
            String defaultValue = this.attribute.getDefaultValue();
            if (defaultValue.startsWith("'")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            try {
                this.doubleValue = Double.parseDouble(defaultValue);
                this.d = new Double(this.doubleValue);
            }
            catch (NumberFormatException o) {
                this.d = null;
            }
            this.result = this.checkValue(defaultValue);
            if (!this.result) {
                return CheckResult.createFailed(this.attribute, this, Messages.getString("DRAttributeCheckDefaultAndPermittedValue.DefaultValueViolatedPermittedValues"));
            }
            return CheckResult.createOk(this.attribute, this, Messages.getString("DRAttributeCheckDefaultAndPermittedValue.AttributeDefaultValueIsPermitted"));
        }
        catch (Exception e) {
            System.out.println("Error: DRAttributeCheckDefaultAndPermittedValue.doCheck");
            return CheckResult.createFailed(this.attribute, this, Messages.getString("DRAttributeCheckDefaultAndPermittedValue.DefaultValueViolatedPrmittedValues"));
        }
    }

    public boolean checkValue(String defaultValue) {
        Iterator it;
        if ("".equals(defaultValue)) {
            return true;
        }
        boolean valid = true;
        if (!this.attribute.getAVTs().isEmpty()) {
            it = this.attribute.getAVTs().iterator();
            while (it.hasNext()) {
                valid = false;
                AVT avt = (AVT)it.next();
                this.beginValue = avt.getBeginValue();
                if (this.beginValue.startsWith("'")) {
                    this.beginValue = this.beginValue.substring(1, this.beginValue.length() - 1);
                }
                this.endValue = avt.getEndValue();
                if (this.endValue.startsWith("'")) {
                    this.endValue = this.endValue.substring(1, this.endValue.length() - 1);
                }
                if (this.d == null) {
                    if (!(!"".equals(this.endValue) ? defaultValue.compareTo(this.beginValue) >= 0 && defaultValue.compareTo(this.endValue) <= 0 : defaultValue.equals(this.beginValue))) continue;
                    return true;
                }
                boolean number = true;
                double bvalue = 0.0;
                double evalue = 0.0;
                try {
                    bvalue = Double.parseDouble(this.beginValue);
                    evalue = Double.parseDouble(this.endValue);
                }
                catch (NumberFormatException o) {
                    number = false;
                }
                try {
                    if (!(!"".equals(this.endValue) ? (number ? this.doubleValue >= bvalue && this.doubleValue <= evalue : defaultValue.compareTo(this.beginValue) >= 0 && defaultValue.compareTo(this.endValue) <= 0) : (number ? this.doubleValue == bvalue : defaultValue.equals(this.beginValue)))) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        if (this.attribute.getValueList() != null) {
            it = this.attribute.getValueList().values();
            while (it.hasNext()) {
                valid = false;
                String value = (String)it.next();
                if (value.startsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (this.d == null) {
                    if (!defaultValue.equals(value)) continue;
                    return true;
                }
                try {
                    if (this.doubleValue != Double.parseDouble(value)) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return valid;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "2265D44D-6FBF-D640-B35C-C59DBCEE62F4";
    }
}

