/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.designrules.CRFailed;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class CRAdapter
extends CheckResult {
    private CheckResult delegate;

    public CRAdapter() {
        this.delegate = new CRFailed();
    }

    public CRAdapter(CheckResult result) {
        this.delegate = result;
    }

    @Override
    public boolean isWarning() {
        return this.delegate.isWarning();
    }

    @Override
    public boolean isCustom() {
        return this.delegate.isCustom();
    }

    @Override
    public void setAffected(Object affected) {
        this.delegate.setAffected(affected);
    }

    @Override
    public Object getAffected() {
        return this.delegate.getAffected();
    }

    @Override
    public void setSubName(String message) {
        this.delegate.setSubName(message);
    }

    @Override
    public String getSubName() {
        return this.delegate.getSubName();
    }

    @Override
    public void setMessage(String message) {
        this.delegate.setMessage(message);
    }

    @Override
    public String getMessage() {
        return this.delegate.getMessage();
    }

    @Override
    public void setRule(DesignRule rule) {
        this.delegate.setRule(rule);
    }

    @Override
    public DesignRule getRule() {
        return this.delegate.getRule();
    }

    @Override
    public CheckResult reCheck() {
        this.delegate = this.delegate.reCheck();
        this.fireChange();
        return this;
    }

    @Override
    public boolean isOk() {
        return this.delegate.isOk();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.delegate.isOk()) {
            buffer.append(Messages.getString("CRAdapter.OK"));
        } else if (this.delegate.isWarning()) {
            buffer.append(Messages.getString("CRAdapter.Warning"));
        } else if (this.delegate.isCustom()) {
            buffer.append(this.getCustomErrType());
        } else {
            buffer.append(Messages.getString("CRAdapter.Error"));
        }
        Object affected = this.delegate.getAffected();
        if (affected instanceof ModelIDObject) {
            buffer.append(((ModelIDObject)affected).getLongName());
        } else {
            buffer.append(affected.toString());
        }
        if (this.delegate.getSubName() != null) {
            buffer.append(".").append(this.delegate.getSubName());
        }
        buffer.append(": ");
        buffer.append(this.delegate.getMessage());
        return buffer.toString();
    }
}

