/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational.memento;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.memento.Memento;

public class IndexMemento
extends Memento {
    public String comments = "";
    public String notes = "";
    public String comments_in_rdbms;
    public String name;
    public String id;
    public boolean generate_in_DDL;
    public boolean deprecated;
    public Table table;
    public Index index;
    public List<ColWr> columns = new ArrayList<ColWr>();
    public boolean spatial;
    public boolean engineer;
    public String expression = "";
    public String index_state;
    public String is_geodetic;
    public String layer_type;
    public String supportingIndexID;
    public String supportedConstraintID;
    public SchemaObject schemaObject;
    public int dimensionsNumber = 2;
    public boolean isOidKey = false;
    public boolean isSurrogateKey = false;
    public DesignObject.BackupDesignObject dobj;

    public IndexMemento(Index index) {
        this.index = index;
        this.dobj = new DesignObject.BackupDesignObject(index.getDesignPart());
        index.copyDynamicProperties(this.dobj);
        this.name = index.getName();
        this.id = index.getObjectID();
        this.comments = index.getComment();
        this.comments_in_rdbms = index.getCommentInRDBMS();
        this.notes = index.getNotes();
        this.generate_in_DDL = index.isMarkedGenerate();
        this.deprecated = index.isDeprecated();
        this.table = (Table)index.getContainerWithKeyObject();
        this.spatial = index.isSpatialIndex();
        this.engineer = index.getShouldEngineer();
        this.index_state = index.getIndexState();
        this.schemaObject = index.getSchemaObject();
        this.expression = index.getIndexExpression();
        this.is_geodetic = index.getGeodetic();
        this.layer_type = index.getLayerType();
        this.supportingIndexID = index.getSupportingIndexID();
        this.supportedConstraintID = index.getSupportedConstraintID();
        this.dimensionsNumber = index.getDimensionsNumber();
        this.isOidKey = index.isOidKey();
        this.isSurrogateKey = index.isSurrogateKey();
        for (Column column : index.getElementsCollection()) {
            ColWr wr = new ColWr();
            wr.col_id = column.getObjectID();
            wr.sort_order = index.getColumnSortOrder(column);
            this.columns.add(wr);
        }
    }

    public void copyto(IndexMemento mem) {
        if (this.dobj != null) {
            this.dobj.copyDynamicProperties(mem.dobj);
        }
        mem.name = this.name;
        mem.id = this.id;
        mem.comments = this.comments;
        mem.comments_in_rdbms = this.comments_in_rdbms;
        mem.notes = this.notes;
        mem.generate_in_DDL = this.generate_in_DDL;
        mem.deprecated = this.deprecated;
        mem.spatial = this.spatial;
        mem.engineer = this.engineer;
        mem.index_state = this.index_state;
        mem.schemaObject = this.schemaObject;
        mem.expression = this.expression;
        mem.is_geodetic = this.is_geodetic;
        mem.layer_type = this.layer_type;
        mem.supportingIndexID = this.supportingIndexID;
        mem.dimensionsNumber = this.dimensionsNumber;
        mem.isOidKey = this.isOidKey;
        mem.columns.clear();
        for (ColWr wr : this.columns) {
            ColWr newWr = new ColWr();
            newWr.col_id = wr.col_id;
            newWr.sort_order = wr.sort_order;
            mem.columns.add(newWr);
        }
    }

    public boolean contains(Column column) {
        return this.get(column) != null;
    }

    public ColWr get(Column column) {
        String col_id = column.getObjectID();
        for (ColWr colWr : this.columns) {
            if (!colWr.col_id.equals(col_id)) continue;
            return colWr;
        }
        return null;
    }

    public void remove(Column column) {
        this.columns.remove(this.get(column));
    }

    public void add(Column column) {
        this.columns.add(new ColWr(column.getObjectID(), this.index.getColumnSortOrder(column)));
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public List getColumns() {
        return this.columns;
    }

    public class ColWr {
        public String col_id;
        public String sort_order;

        public ColWr() {
        }

        public ColWr(String col_id, String sort_order) {
            this.col_id = col_id;
            this.sort_order = sort_order;
        }
    }
}

