/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DistinctTypeProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.ColumnProxyPropertyDialogSqlServerv2k5;

public class ColumnProxySqlServerv2k5
extends ColumnProxySqlServer {
    private String persistedProp = "NO";
    private XMLSchemaCollectionSqlServerv2k5 xmlSchemaCollection;
    public static final String CONTENT = "CONTENT";
    public static final String DOCUMENT = "DOCUMENT";
    private String collectionType = "CONTENT";
    private static final String[] collectionTypeChoices = new String[]{"CONTENT", "DOCUMENT"};

    public ColumnProxySqlServerv2k5(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public ColumnProxySqlServerv2k5(Column column, StorageDesign storage) {
        super(column, storage);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnProxyPropertyDialogSqlServerv2k5 dialog = new ColumnProxyPropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getPersistedProp() {
        return this.persistedProp;
    }

    public void setPersistedProp(String persistedColumn) {
        this.persistedProp = persistedColumn;
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    public XMLSchemaCollectionSqlServerv2k5 getXmlSchemaCollection() {
        return this.xmlSchemaCollection;
    }

    public void setXmlSchemaCollection(XMLSchemaCollectionSqlServerv2k5 xmlSchemaCollection) {
        this.xmlSchemaCollection = xmlSchemaCollection;
    }

    public static String[] getCollectionTypeChoices() {
        return collectionTypeChoices;
    }

    @Override
    public AbstractStorageObjectSqlServer getUserDefinedType() {
        block5: {
            short columnUse;
            block4: {
                DataBaseSqlServer database;
                columnUse = this.getColumn().getUse();
                if (columnUse != 0) break block4;
                Domain domain = this.getColumn().getDomain();
                TableProxySqlServerv2k5 tableProxy = (TableProxySqlServerv2k5)this.getTableProxyR();
                if (domain == null || tableProxy == null || (database = tableProxy.getDatabase()) == null) break block5;
                for (UsedUserDefinedData usedType : ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet()) {
                    UserDefinedTypeSqlServer userDefinedType;
                    if (usedType.getDatabase() != database || (userDefinedType = usedType.getUserDefinedType()) == null || userDefinedType.getDomainObj() != domain) continue;
                    return usedType;
                }
                break block5;
            }
            if (columnUse == 2) {
                DataBaseSqlServer database;
                DistinctType distinctType = this.getColumn().getDistinctType();
                TableProxySqlServerv2k5 tableProxy = (TableProxySqlServerv2k5)this.getTableProxyR();
                if (distinctType != null && tableProxy != null && (database = tableProxy.getDatabase()) != null) {
                    for (UsedUserDefinedData usedType : ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet()) {
                        DistinctTypeProxySqlServer distinctTypeProxy;
                        if (usedType.getDatabase() != database || (distinctTypeProxy = usedType.getDistinctTypeProxy()) == null || distinctTypeProxy.getObjectID() != distinctType.getObjectID()) continue;
                        return usedType;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String getDatatypeString() {
        if (this.getXmlSchemaCollection() != null) {
            return super.getDatatypeString() + " " + this.getCollectionType() + " " + this.getXmlSchemaCollection().toString();
        }
        return super.getDatatypeString();
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Column column = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxySqlServerv2k5 columnProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k5)targetDesign).getColumnProxySet().getProxy(column.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            columnProxy = (ColumnProxySqlServerv2k5)storageObject;
        }
        if (columnProxy != null) {
            columnProxy.setName(this.getName());
            columnProxy.setDefineDefault(this.getDefineDefault());
            columnProxy.setDefaultValue(this.getDefaultValue());
            if (this.getDefaultObject() != null) {
                DefaultSqlServerv2k5 defaultObj = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDefaultSet().getByName(this.getDefaultObject().getName());
                if (defaultObj == null) {
                    DefaultSqlServerv2k5 newDefaultObj = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDefaultSet().createDefault();
                    newDefaultObj.setName(this.getDefaultObject().getName());
                    newDefaultObj.setRawObject(true);
                    columnProxy.setDefaultObject(newDefaultObj);
                } else {
                    columnProxy.setDefaultObject(defaultObj);
                }
            }
            columnProxy.setAsIdentity(this.getAsIdentity());
            columnProxy.setIdentitySeed(this.getIdentitySeed());
            columnProxy.setIdentityIncrement(this.getIdentityIncrement());
            columnProxy.setIdentityForReplication(this.getIdentityForReplication());
            columnProxy.setComputed(this.getComputed());
            columnProxy.setComputedChanged(this.isComputedChanged());
            columnProxy.setFormula(this.getFormula());
            columnProxy.setFormulaChanged(this.isFormulaChanged());
            columnProxy.setCollation(this.getCollation());
            columnProxy.setPersisted(this.getPersisted());
            columnProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            columnProxy.setComment(this.getComment());
            columnProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            columnProxy.setRawObject(false);
        }
    }
}

