/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UniquePropertyDialogSqlServer;

public class UniqueProxySqlServer
extends IndexProxy {
    private FileGroupSqlServer filegroup;
    private int fillFactor = 0;
    public static final String TYPE_NAME = "Unique";

    public UniqueProxySqlServer(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public UniqueProxySqlServer(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UniquePropertyDialogSqlServer dialog = new UniquePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxySqlServer)this.getTableProxy()).getUser() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer filegroup) {
        this.filegroup = filegroup;
        this.fireDataFieldChange();
    }

    public int getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(int fillFactor) {
        if (fillFactor >= 0 && fillFactor <= 100) {
            this.fillFactor = fillFactor;
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getPKProxySet().add(object);
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE)) {
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().remove(this);
            if (!this.getStorageDesign().getIndexProxySet().containsId(object.getObjectID())) {
                this.getStorageDesign().getIndexProxySet().add(object);
            }
            this.fireChangeNoDirty(event);
        }
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public String getStorageName() {
        return "";
    }
}

