/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.RolePropertyDialogSqlServer;
import oracle.dbtools.crest.util.compare.StringComparator;
import oracle.dbtools.crest.util.string.Crypt;

public class RoleSqlServer
extends AbstractStorageObjectSqlServer {
    private DataBaseSqlServer database;
    private boolean isApplicationRole = false;
    private String password;
    private String users = "";
    private UserSet userSet = null;
    private UserSqlServer owner;
    private static final String[] PRIVILEGES = new String[]{"ALL", "CREATE DEFAULT", "CREATE FUNCTION", "CREATE PROCEDURE", "CREATE RULE", "CREATE TABLE", "CREATE VIEW", "BACKUP DATABASE", "BACKUP LOG"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String systemPrivileges = "";
    private InlineList systemPrivilegesSet = null;
    private static Crypt crypt = new Crypt();
    public static final String TYPE_NAME = "Role";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RolePropertyDialogSqlServer dialog = new RolePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public boolean getIsApplicationRole() {
        return this.isApplicationRole;
    }

    public void setIsApplicationRole(boolean isApplicationRole) {
        this.isApplicationRole = isApplicationRole;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer database) {
        this.database = database;
        this.fireDataFieldChange();
    }

    public String getPassword() {
        return this.password;
    }

    public String decodePassword() {
        String result = this.getDesign().getLoadedVersion() < 3.3f ? this.password : crypt.decrypt(this.password);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setPassword(String password) {
        this.password = password;
        this.fireDataFieldChange();
    }

    public void encodePassword(String password) {
        this.password = crypt.encrypt(password);
    }

    public UserSqlServer getOwner() {
        return this.owner;
    }

    public void setOwner(UserSqlServer owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    private void addUser(String user) {
        String userName = user.substring(user.lastIndexOf(46) + 1, user.length());
        if (!this.getUserSet().contains(userName)) {
            this.getUserSet().add(userName);
        }
    }

    public void recreateUserSet(String users) {
        this.getUserSet().clear();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            this.getUserSet().add(st.nextToken().trim());
        }
    }

    public void setUsers(String users) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(users);
        } else {
            this.addUser(users);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
        this.getPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    private void addPrivilege(String systemPrivilege) {
        if (!this.getPrivilegesSet().contains(systemPrivilege)) {
            this.getPrivilegesSet().add(systemPrivilege);
        }
    }

    public InlineList getPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new InlineList();
        }
        return this.systemPrivilegesSet;
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public void recreateSystemPrivilegesSet(String privileges) {
        this.getPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.systemPrivilegesSet = new InlineList();
        while (st.hasMoreTokens()) {
            String privilege = st.nextToken().trim();
            if (!this.checkPrivileges(privilege)) continue;
            this.getPrivilegesSet().add(privilege);
        }
    }

    protected boolean checkPrivileges(String value) {
        return PRIVILEGESLIST.contains(value);
    }

    public void setSystemPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(privilege);
        } else if (this.checkPrivileges(privilege)) {
            this.addPrivilege(privilege);
        }
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public List getPermissions() {
        ArrayList<PermissionsSqlServer> perms = new ArrayList<PermissionsSqlServer>();
        for (PermissionsSqlServer permission : ((StorageDesignSqlServer)this.getStorageDesign()).getPermissionsSet()) {
            if (permission.getRole() != this || permission.getTable() == null && permission.getView() == null) continue;
            perms.add(permission);
        }
        return perms;
    }

    public PermissionsSqlServer createPermission() {
        PermissionsSqlServer permission = ((StorageDesignSqlServer)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permission.setRole(this);
        return permission;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("ROLE_ICON", 16);
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

