/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.fcp.plSqlSourceEditors.PlSqlSourceURLStreamHandlerFactory;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.swingui.editor.storage.oracle.DefaultPropertyDialogOracle;

public class PackageOracle
extends PlSqlSourceStorageObjectOracle {
    public static final String TYPE_NAME = "Package";
    protected PackageBodyOracle body;
    protected StorageObjectCollection synonyms;
    PackageOracle thisPackageOracle = this;

    public PackageOracle(StorageDesign storageDesign, String id, String name) {
        super(storageDesign, id, name);
        this.initStorageObjects((StorageDesignOracle)storageDesign);
    }

    private void initStorageObjects(StorageDesignOracle storageDesign) {
        this.synonyms = new StorageObjectCollection();
        this.synonyms.setStorageObjectSet(storageDesign.getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(PackageOracle.class);
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        this.addSynonymsFromDesign(storageDesign.getSynonymSet());
    }

    @Override
    public List<JMenuItem> getAdditionalActions() {
        List<JMenuItem> additionalMenuItems = super.getAdditionalActions();
        final PackageOracle packageOracle = this;
        JMenuItem menuItemCreateBody = new JMenuItem(Messages.getString("PackageOracle.CreateBody"));
        menuItemCreateBody.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageOracle.this.body = new PackageBodyOracle(packageOracle);
                PackageOracle.this.body.initSource();
                PackageOracle.this.body.openEditor();
                PackageOracle.this.updateBrowserTree();
            }
        });
        menuItemCreateBody.setEnabled(this.body == null);
        additionalMenuItems.add(menuItemCreateBody);
        return additionalMenuItems;
    }

    private void updateBrowserTree() {
        try {
            BrowserPanel browserPanel = this.getAppView().getBrowserPanel();
            if (browserPanel != null) {
                browserPanel.getNavigationTreeDesign().updateSubtree(this.thisPackageOracle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected DefaultPropertyDialogOracle createPropertyDialog() {
        return new DefaultPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
    }

    @Override
    protected URL getUrl() {
        return PlSqlSourceURLStreamHandlerFactory.generateUrl("file", this);
    }

    @Override
    public boolean setName(String name) {
        boolean result = super.setName(name);
        if (result && this.body != null) {
            this.body.setName(name);
        }
        return result;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public void setBody(PackageBodyOracle packageBody) {
        this.body = packageBody;
        this.getStorageDesign().setDirty(true);
    }

    public PackageBodyOracle getBody() {
        return this.body;
    }

    public PackageBodyOracle createBody() {
        this.body = new PackageBodyOracle(this);
        this.setBody(this.body);
        return this.body;
    }

    public void clearBody() {
        if (this.body != null) {
            this.body.remove();
        }
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == 0) {
            return this.body == null ? this.synonyms : this.body;
        }
        if (index == 1) {
            return this.synonyms;
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.body) {
            return 0;
        }
        if (child == this.synonyms) {
            return this.body == null ? 0 : 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.body) {
            return 0;
        }
        if (child == this.synonyms) {
            return this.body == null ? 0 : 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return this.body == null ? 1 : 2;
    }

    @Override
    public void remove() {
        if (this.body != null) {
            this.body.remove();
        }
        super.remove();
    }

    @Override
    public void remove(boolean force) {
        if (this.body != null) {
            this.body.remove(force);
        }
        super.remove(force);
    }

    public void setBodySource(String source) {
        if (source != null && source.length() > 0) {
            if (this.body == null) {
                this.body = this.createBody();
                this.updateBrowserTree();
            }
            this.body.setSource(source);
        } else if (this.body != null) {
            this.clearBody();
            this.updateBrowserTree();
        }
    }

    public String getBodySource() {
        return this.body != null ? this.body.getSource() : null;
    }

    @Override
    public void setOwner(UserOracle owner) {
        super.setOwner(owner);
        if (this.body != null) {
            this.body.setOwner(owner);
        }
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDataObject() {
        return false;
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymOracle createSynonym() {
        SynonymOracle syn = (SynonymOracle)this.synonyms.createElement(null);
        syn.setReferredObjectID(this.getObjectID());
        syn.setPAC_Element(this);
        return syn;
    }

    public void removeSynonym(SynonymOracle syn) {
        this.synonyms.justRemove(syn);
        this.setDirty(true);
    }

    public void addSynonym(SynonymOracle syn) {
        if (!this.synonyms.contains(syn) && !this.synonyms.containsPlaceHolderFor(syn)) {
            int size = this.synonyms.size();
            this.synonyms.add(syn);
            if (this.synonyms.size() > size) {
                this.setDirty(true);
            }
        }
    }

    public void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymOracle syn : set) {
            if (!syn.getReferredObjectID().equalsIgnoreCase(this.getObjectID())) continue;
            StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(syn);
            this.synonyms.add(ph);
            ph.setParent(this.synonyms);
        }
    }
}

