/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.LobStoragePropertyDialogOracle;

public abstract class LobStorageOracle
extends AbstractStorageObjectOracle {
    private static final String[] SC_BUFFER_POOL = new String[]{"DEFAULT", "RECYCLE", "KEEP"};
    private static final String[] STORAGE_IN_ROW = new String[]{"ENABLE", "DISABLE"};
    private static final String[] CACHE = new String[]{"CACHE", "NOCACHE", "CACHE READS"};
    public static final String[] OLD_VERSIONS = new String[]{"RETENTION", "PCT_VERSION"};
    public static final String UNLIMITED = "UNLIMITED";
    private TableProxyOracle table;
    private SnapshotOracle snapshot;
    private PartitionOracle partition;
    private ListPartitionOracle listPartition;
    private String column = "";
    private String lobSegmentName = "";
    private TableSpaceOracle tableSpace = null;
    private static Set storageInRowSet = null;
    private String storageInRow = STORAGE_IN_ROW[0];
    protected String logging = "";
    private static Set cacheSet = null;
    private String cache = CACHE[1];
    private int chunk = 0;
    private int pctVersion = 0;
    private long scInitialExtent = 0L;
    private long scNextExtent = 0L;
    private int scMinExtents = 1;
    private String scMaxExtents = "UNLIMITED";
    private int scPctIncrease = 0;
    private static Set scBufferPoolSet = null;
    private String scBufferPool = SC_BUFFER_POOL[0];
    private int scFreeLists = 1;
    private int scFreelistGroups = 1;
    private String oldVersions = OLD_VERSIONS[0];
    private static Set oldVersionSet = null;
    private int freepools;
    public static final String TYPE_NAME = "LobStorage";

    @Override
    public String getIDPrefix() {
        return "LS";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        if (column != null && column.equals(this.column)) {
            return;
        }
        this.column = column;
        this.fireDataFieldChange();
    }

    public PartitionOracle getPartition() {
        return this.partition;
    }

    public void setPartition(PartitionOracle partition) {
        if (partition != this.partition) {
            this.partition = partition;
            if (partition != null) {
                partition.addLobStorageOracle(this);
            }
            this.table = null;
            this.snapshot = null;
            this.listPartition = null;
            if (partition != null) {
                this.setPAC_Element(partition.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    public ListPartitionOracle getListPartition() {
        return this.listPartition;
    }

    public void setListPartition(ListPartitionOracle listPartition) {
        if (this.listPartition != listPartition) {
            this.listPartition = listPartition;
            if (listPartition != null) {
                listPartition.addLobStorageOracle(this);
            }
            this.table = null;
            this.snapshot = null;
            this.partition = null;
            if (listPartition != null) {
                this.setPAC_Element(listPartition.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SnapshotOracle snapshot) {
        if (this.snapshot != snapshot) {
            this.snapshot = snapshot;
            this.table = null;
            this.partition = null;
            this.listPartition = null;
            if (snapshot != null) {
                this.setPAC_Element(snapshot);
            }
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle table) {
        if (this.table != table) {
            this.table = table;
            this.snapshot = null;
            this.partition = null;
            this.listPartition = null;
            if (table != null) {
                this.setPAC_Element(table);
                table.addObject(this);
            }
            this.fireDataFieldChange();
        }
    }

    public String getLobSegmentName() {
        return this.lobSegmentName;
    }

    public void setLobSegmentName(String lobSegmentName) {
        if (lobSegmentName != null && lobSegmentName.equals(this.lobSegmentName)) {
            return;
        }
        this.lobSegmentName = lobSegmentName;
        this.fireDataFieldChange();
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        if (this.tableSpace != tableSpace) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public static String[] getStorageInRowChoices() {
        return STORAGE_IN_ROW;
    }

    protected boolean checkStorageInRow(String value) {
        if (storageInRowSet == null) {
            storageInRowSet = new HashSet();
            storageInRowSet.addAll(Arrays.asList(LobStorageOracle.getStorageInRowChoices()));
        }
        return storageInRowSet.contains(value);
    }

    public void setStorageInRow(String value) {
        if (this.checkStorageInRow(value)) {
            this.storageInRow = value;
            this.fireDataFieldChange();
        }
    }

    public String getStorageInRow() {
        return this.storageInRow;
    }

    public void setLogging(String value) {
        if (!this.logging.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.logging = value;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public static String[] getCacheChoices() {
        return CACHE;
    }

    protected boolean checkCache(String value) {
        if (cacheSet == null) {
            cacheSet = new HashSet();
            cacheSet.addAll(Arrays.asList(LobStorageOracle.getCacheChoices()));
        }
        return cacheSet.contains(value);
    }

    public void setCache(String value) {
        if (this.checkCache(value)) {
            this.cache = value;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public int getChunk() {
        return this.chunk;
    }

    public void setChunk(int chunk) {
        if (this.chunk != chunk) {
            this.chunk = chunk;
            this.fireDataFieldChange();
        }
    }

    public int getPCTVersion() {
        return this.pctVersion;
    }

    public void setPCTVersion(int pctVersion) {
        if (this.pctVersion != pctVersion) {
            this.pctVersion = pctVersion;
            this.fireDataFieldChange();
        }
    }

    public long getSCInitialExtent() {
        return this.scInitialExtent;
    }

    public void setSCInitialExtent(long scInitialExtent) {
        if (this.scInitialExtent != scInitialExtent) {
            this.scInitialExtent = scInitialExtent;
            this.fireDataFieldChange();
        }
    }

    public long getSCNextExtent() {
        return this.scNextExtent;
    }

    public void setSCNextExtent(long scNextExtent) {
        if (this.scNextExtent != scNextExtent) {
            this.scNextExtent = scNextExtent;
            this.fireDataFieldChange();
        }
    }

    public int getSCMinExtents() {
        return this.scMinExtents;
    }

    public void setSCMinExtents(int scMinExtents) {
        if (scMinExtents >= 1) {
            this.scMinExtents = scMinExtents;
            this.fireDataFieldChange();
        }
    }

    public String getSCMaxExtents() {
        return this.scMaxExtents;
    }

    public void setSCMaxExtents(String scMaxExtents) {
        try {
            this.scMaxExtents = Integer.parseInt(scMaxExtents) > 0 ? scMaxExtents : UNLIMITED;
        }
        catch (NumberFormatException E) {
            this.scMaxExtents = UNLIMITED;
        }
        this.fireDataFieldChange();
    }

    public int getSCPctIncrease() {
        return this.scPctIncrease;
    }

    public void setSCPctIncrease(int scPctIncrease) {
        if (this.scPctIncrease != scPctIncrease) {
            this.scPctIncrease = scPctIncrease;
            this.fireDataFieldChange();
        }
    }

    public static String[] getSCBufferPoolValues() {
        return SC_BUFFER_POOL;
    }

    protected boolean checkSCBufferPoolValue(String value) {
        if (scBufferPoolSet == null) {
            scBufferPoolSet = new HashSet();
            scBufferPoolSet.addAll(Arrays.asList(LobStorageOracle.getSCBufferPoolValues()));
        }
        return scBufferPoolSet.contains(value);
    }

    public void setSCBufferPool(String value) {
        if (this.checkSCBufferPoolValue(value)) {
            this.scBufferPool = value;
            this.fireDataFieldChange();
        }
    }

    public String getSCBufferPool() {
        return this.scBufferPool;
    }

    public int getSCFreeLists() {
        return this.scFreeLists;
    }

    public void setSCFreeLists(int scFreeLists) {
        if (scFreeLists >= 1) {
            this.scFreeLists = scFreeLists;
            this.fireDataFieldChange();
        }
    }

    public int getSCFreelistGroups() {
        return this.scFreelistGroups;
    }

    public void setSCFreelistGroups(int scFreelistGroups) {
        if (scFreelistGroups >= 1) {
            this.scFreelistGroups = scFreelistGroups;
            this.fireDataFieldChange();
        }
    }

    public static String[] getOldVersionChoices() {
        return OLD_VERSIONS;
    }

    protected boolean checkOldVersion(String value) {
        if (oldVersionSet == null) {
            oldVersionSet = new HashSet();
            oldVersionSet.addAll(Arrays.asList(LobStorageOracle.getOldVersionChoices()));
        }
        return oldVersionSet.contains(value);
    }

    public String getOldVersions() {
        return this.oldVersions;
    }

    public void setOldVersions(String oldVersions) {
        if (this.checkOldVersion(oldVersions)) {
            this.oldVersions = oldVersions;
            this.fireDataFieldChange();
        }
    }

    public int getFreepools() {
        return this.freepools;
    }

    public void setFreepools(int freepools) {
        this.freepools = freepools;
    }

    public String getLobStorageType() {
        return "";
    }

    public void setLobStorageType(String lobStorageType) {
    }

    public String getCompression() {
        return "";
    }

    public void setCompression(String compression) {
    }

    public String getCompressionType() {
        return "";
    }

    public void setCompressionType(String compressionType) {
    }

    public String getDuplication() {
        return "";
    }

    public void setDuplication(String duplication) {
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LobStoragePropertyDialogOracle dialog = new LobStoragePropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        LobStorageOracle lobs = null;
        StorageObject stObject = (StorageObject)((StorageDesignOracle)targetDesign).getLobStorageSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                lobs = (LobStorageOracle)stObject;
            }
        } else {
            lobs = ((StorageDesignOracle)targetDesign).getLobStorageSet().createLobStorage();
        }
        if (lobs != null) {
            lobs.setName(this.getName());
            lobs.setColumn(this.getColumn());
            lobs.setLobSegmentName(this.getLobSegmentName());
            if (this.getTableSpace() != null) {
                TableSpaceOracle targetTableSpace = (TableSpaceOracle)((StorageDesignOracle)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (targetTableSpace == null) {
                    TableSpaceOracle newTableSpace = ((StorageDesignOracle)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    lobs.setTableSpace(newTableSpace);
                } else {
                    lobs.setTableSpace(targetTableSpace);
                }
            }
            lobs.setStorageInRow(this.getStorageInRow());
            lobs.setLogging(this.getLogging());
            lobs.setCache(this.getCache());
            lobs.setChunk(this.getChunk());
            lobs.setOldVersions(this.getOldVersions());
            lobs.setFreepools(this.getFreepools());
            lobs.setPCTVersion(this.getPCTVersion());
            lobs.setSCInitialExtent(this.getSCInitialExtent());
            lobs.setSCNextExtent(this.getSCNextExtent());
            lobs.setSCMinExtents(this.getSCMinExtents());
            lobs.setSCMaxExtents(this.getSCMaxExtents());
            lobs.setSCPctIncrease(this.getSCPctIncrease());
            lobs.setSCBufferPool(this.getSCBufferPool());
            lobs.setSCFreeLists(this.getSCFreeLists());
            lobs.setSCFreelistGroups(this.getSCFreelistGroups());
            lobs.setComment(this.getComment());
            lobs.setLobStorageType(this.getLobStorageType());
            lobs.setCompression(this.getCompression());
            lobs.setCompressionType(this.getCompressionType());
            lobs.setDuplication(this.getDuplication());
            lobs.setRawObject(false);
        }
    }

    @Override
    public void remove() {
        if (this.listPartition != null) {
            this.listPartition.removeObject(this);
        } else if (this.partition != null) {
            this.partition.removeObject(this);
        } else if (this.table != null) {
            this.table.removeObject(this);
        }
        super.remove();
    }
}

