/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.DimensionOraclev9iPropertyDialog;

public class DimensionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener,
OwnedObjectOracle {
    private UserOracle user;
    private StorageObjectCollection levels;
    private StorageObjectCollection hierarchies;
    public static final String TYPE_NAME = "Dimension";

    public DimensionOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        StorageDesignOracle design = (StorageDesignOracle)storageDesign;
        this.levels = new StorageObjectCollection(design.getLevelSet());
        this.levels.setParent(this);
        this.levels.setName(Messages.getString("DimensionOracle.Levels"));
        this.levels.setSetMethod("setDimension");
        this.levels.setClassForParent(DimensionOracle.class);
        this.levels.setIcon(GUIConfiguration.getInstance().getIcon("LEVEL_ICON", 16));
        ((StorageDesignOracle)storageDesign).getLevelSet().addSetListener(this);
        this.addLevelsFromDesign(((StorageDesignOracle)storageDesign).getLevelSet());
        this.hierarchies = new StorageObjectCollection(design.getHierarchySet());
        this.hierarchies.setParent(this);
        this.hierarchies.setName(Messages.getString("DimensionOracle.Hierarchies"));
        this.hierarchies.setSetMethod("setDimension");
        this.hierarchies.setClassForParent(DimensionOracle.class);
        this.hierarchies.setIcon(GUIConfiguration.getInstance().getIcon("HIERARCHY_ICON", 16));
        ((StorageDesignOracle)storageDesign).getHierarchySet().addSetListener(this);
        this.addHierarchiesFromDesign(((StorageDesignOracle)storageDesign).getHierarchySet());
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.levels;
            }
            case 1: {
                return this.hierarchies;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.levels) {
            return 0;
        }
        if (child == this.hierarchies) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.levels) {
            return 0;
        }
        if (child == this.hierarchies) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.levels.removeAll();
        this.hierarchies.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof LevelOracle) {
                LevelOracle level = (LevelOracle)event.getAffected();
                level.addObjectListener(this);
                if (level.getDimension() == this) {
                    level.setParent(this.levels);
                    this.levels.add(level);
                } else {
                    this.levels.remove(level);
                }
            } else if (event.getAffected() instanceof HierarchyOracle) {
                HierarchyOracle hier = (HierarchyOracle)event.getAffected();
                hier.addObjectListener(this);
                if (hier.getDimension() == this) {
                    hier.setParent(this.hierarchies);
                    this.hierarchies.add(hier);
                } else {
                    this.hierarchies.remove(hier);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof LevelOracle) {
                LevelOracle level = (LevelOracle)event.getAffected();
                this.levels.remove(level);
                level.removeObjectListener(this);
            } else if (event.getAffected() instanceof HierarchyOracle) {
                HierarchyOracle hier = (HierarchyOracle)event.getAffected();
                this.hierarchies.remove(hier);
                hier.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof LevelOracle) {
            LevelOracle level = (LevelOracle)event.getAffected();
            if (level.getDimension() == this) {
                level.setParent(this.levels);
                this.levels.add(level);
            } else {
                this.levels.remove(level);
            }
        } else if (event.getAffected() instanceof HierarchyOracle) {
            HierarchyOracle hier = (HierarchyOracle)event.getAffected();
            if (hier.getDimension() == this) {
                hier.setParent(this.hierarchies);
                this.hierarchies.add(hier);
            } else {
                this.hierarchies.remove(hier);
            }
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DimensionOraclev9iPropertyDialog dialog = new DimensionOraclev9iPropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Dim";
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        if (this.user != user) {
            this.user = user;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public Object[] getLevelSet() {
        ArrayList<LevelOracle> levels = new ArrayList<LevelOracle>();
        Iterator it = ((StorageDesignOracle)this.getStorageDesign()).getLevelSet().iterator();
        LevelOracle level = null;
        while (it.hasNext()) {
            level = (LevelOracle)it.next();
            if (level.getDimension() != this) continue;
            levels.add(level);
        }
        return levels.toArray();
    }

    public StorageObjectCollection getLevelCollection() {
        return this.levels;
    }

    public LevelOracle createLevel() {
        if (this.levels.getStorageObjectSet() != null) {
            return (LevelOracle)this.levels.createElement(null);
        }
        return null;
    }

    public Object[] getHierarchySet() {
        ArrayList<HierarchyOracle> hierarchies = new ArrayList<HierarchyOracle>();
        Iterator it = ((StorageDesignOracle)this.getStorageDesign()).getHierarchySet().iterator();
        HierarchyOracle hier = null;
        while (it.hasNext()) {
            hier = (HierarchyOracle)it.next();
            if (hier.getDimension() != this) continue;
            hierarchies.add(hier);
        }
        return hierarchies.toArray();
    }

    public StorageObjectCollection getHierarchyCollection() {
        return this.hierarchies;
    }

    public HierarchyOracle createHierarchy() {
        if (this.hierarchies.getStorageObjectSet() != null) {
            return (HierarchyOracle)this.hierarchies.createElement(null);
        }
        return null;
    }

    public Object[] getAttributeSet() {
        return this.getAttributeList().toArray();
    }

    public List getAttributeList() {
        ArrayList<DimensionAttributeOracle> attributes = new ArrayList<DimensionAttributeOracle>();
        Iterator it = ((StorageDesignOracle)this.getStorageDesign()).getDimensionAttributeSet().iterator();
        DimensionAttributeOracle att = null;
        while (it.hasNext()) {
            att = (DimensionAttributeOracle)it.next();
            if (att.getDimension() != this) continue;
            attributes.add(att);
        }
        return attributes;
    }

    public DimensionAttributeOracle createAttribute() {
        DimensionAttributeOracle att = ((StorageDesignOracle)this.getStorageDesign()).getDimensionAttributeSet().createDimensionAttribute();
        att.setDimension(this);
        return att;
    }

    public void addLevelsFromDesign(StorageObjectSet set) {
        for (LevelOracle level : set) {
            level.addObjectListener(this);
            if (level.getDimension() == this) {
                level.setParent(this.levels);
                this.levels.add(level);
                continue;
            }
            this.levels.remove(level);
        }
    }

    public void addHierarchiesFromDesign(StorageObjectSet set) {
        for (HierarchyOracle h : set) {
            h.addObjectListener(this);
            if (h.getDimension() == this) {
                h.setParent(this.hierarchies);
                this.hierarchies.add(h);
                continue;
            }
            this.hierarchies.remove(h);
        }
    }

    public LevelOracle getLevelByName(String name) {
        Iterator it = ((StorageDesignOracle)this.getStorageDesign()).getLevelSet().iterator();
        LevelOracle level = null;
        while (it.hasNext()) {
            level = (LevelOracle)it.next();
            if (level.getDimension() != this || !level.getName().equalsIgnoreCase(name)) continue;
            return level;
        }
        return null;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null) {
            name = this.getUser().getLongName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DIMENSION_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        Object[] attribs = this.getAttributeSet();
        for (int i = 0; i < attribs.length; ++i) {
            ((StorageObject)attribs[i]).remove();
        }
        this.levels.removeAll();
        this.hierarchies.removeAll();
    }
}

