/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;

public class ColumnIdentityDB2
extends AbstractStorageObjectDB2 {
    protected static final String[] GENERATE = new String[]{"ALWAYS", "BY DEFAULT"};
    protected ColumnProxyDB2 column = null;
    protected String generate = GENERATE[0];
    protected String startWith = "1";
    protected int incrementBy = 1;
    protected String maxValue = "";
    protected String minValue = "";
    protected boolean cycle = false;
    protected int cache = 20;
    public static final String TYPE_NAME = "ColumnIdentity";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "CI";
    }

    public ColumnProxyDB2 getColumn() {
        return this.column;
    }

    public void setColumn(ColumnProxyDB2 column) {
        this.column = column;
        this.fireDataFieldChange();
    }

    public String getGenerate() {
        if (this.column != null && !this.column.isGenerateAlwaysChanged()) {
            boolean generateAlways = this.column.getColumn().isAutoIncrementGenerateAlways();
            return generateAlways ? GENERATE[0] : GENERATE[1];
        }
        return this.generate;
    }

    public void setGenerate(String generate) {
        this.generate = generate;
        this.fireDataFieldChange();
    }

    public String getStartWith() {
        if (this.column != null && !this.column.isStartWithChanged()) {
            return this.column.getColumn().getAutoIncrementStartWith();
        }
        return this.startWith;
    }

    public void setStartWith(String startWith) {
        this.startWith = startWith;
        this.fireDataFieldChange();
    }

    public int getIncrementBy() {
        if (this.column != null && !this.column.isIncrementByChanged()) {
            return this.column.getColumn().getAutoIncrementIncrementBy();
        }
        return this.incrementBy;
    }

    public void setIncrementBy(int incrementBy) {
        this.incrementBy = incrementBy;
        this.fireDataFieldChange();
    }

    public String getMaxValue() {
        if (this.column != null && !this.column.isMaxValueChanged()) {
            String colMaxValue = this.column.getColumn().getAutoIncrementMaxValue();
            return colMaxValue == null ? "" : colMaxValue;
        }
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
        this.fireDataFieldChange();
    }

    public String getMinValue() {
        if (this.column != null && !this.column.isMinValueChanged()) {
            String colMinValue = this.column.getColumn().getAutoIncrementMinValue();
            return colMinValue == null ? "" : colMinValue;
        }
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
        this.fireDataFieldChange();
    }

    public boolean isCycle() {
        if (this.column != null && !this.column.isCycleChanged()) {
            return this.column.getColumn().isAutoIncrementCycle();
        }
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
        this.fireDataFieldChange();
    }

    public int getCache() {
        if (this.column != null && !this.column.isCacheChanged()) {
            Column relColumn = this.column.getColumn();
            if (relColumn.isAutoIncrementDisableCache()) {
                return 0;
            }
            Integer columnInteger = relColumn.getAutoIncrementCache();
            return columnInteger == null ? 0 : columnInteger;
        }
        return this.cache;
    }

    public void setCache(int cache) {
        this.cache = cache;
        this.fireDataFieldChange();
    }

    public static String[] getGenerateValues() {
        return GENERATE;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        ColumnIdentityDB2 identity = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getColumnIdentitySet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                identity = (ColumnIdentityDB2)storageObject;
            }
        } else {
            identity = ((AbstractStorageDesignDB2)targetDesign).getColumnIdentitySet().createColumnIdentity();
        }
        if (identity != null) {
            identity.setName(this.getName());
            identity.setGenerate(this.getGenerate());
            identity.setStartWith(this.getStartWith());
            identity.setIncrementBy(this.getIncrementBy());
            identity.setCache(this.getCache());
            identity.setCycle(this.isCycle());
            identity.setMinValue(this.getMinValue());
            identity.setMaxValue(this.getMaxValue());
            identity.setRawObject(false);
        }
    }
}

