/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.BufferPool16K;
import oracle.dbtools.crest.model.design.storage.db2.BufferPool32K;
import oracle.dbtools.crest.model.design.storage.db2.BufferPool4K;
import oracle.dbtools.crest.model.design.storage.db2.BufferPool8K;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class BufferPoolSetDB2
extends StorageObjectSet {
    private static final BufferPoolDB2[] PROTO_ARRAY = new BufferPoolDB2[0];

    public void initializeElements() {
        if (this.size() == 0) {
            this.initialize();
        }
    }

    @Override
    public boolean canCreateElement() {
        return false;
    }

    protected void initialize() {
        int i;
        for (i = 0; i < 50; ++i) {
            this.add(new BufferPool4K(i));
        }
        for (i = 0; i < 10; ++i) {
            this.add(new BufferPool8K(i));
        }
        for (i = 0; i < 10; ++i) {
            this.add(new BufferPool16K(i));
        }
        this.add(new BufferPool32K());
        for (i = 1; i < 10; ++i) {
            this.add(new BufferPool32K(i));
        }
    }

    @Override
    public void add(ModelObject object) {
        BufferPoolDB2 bufferPool = (BufferPoolDB2)object;
        bufferPool.setDesign(this.getDesign());
        bufferPool.setStorageDesign(this.getStorageDesign());
        bufferPool.setParent(this);
        super.add(object);
    }

    public List getBufferPoolList() {
        return this.getElementsList();
    }

    @Override
    public ModelIDObject createElement(String id) {
        throw new IllegalArgumentException(Messages.getString("BufferPoolSetDB2.BufferPoolsCanNotBeCcreated"));
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "BPNOTUSED";
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("STORAGE_OBJECT_ICON", 16);
    }
}

