/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.text.MessageFormat;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.AUXTableIndexPropertyDialogDB2;

public class AUXTableIndexDB2
extends AbstractStorageObjectDB2 {
    protected static final String[] PIECE_SIZES = new String[]{"254 K", "512 K", "1024 K", "2048 K", "4096 K", "8192 K", "16384 K", "32768 K", "65536 K", "131072 K", "262144 K", "524288 K", "1048576 K", "2097152 K", "4194304 K", "8388608 K", "16777216 K", "33554432 K", "67108864 K"};
    private AUXTableDB2 auxTable = null;
    private boolean unique = true;
    private Owner owner = null;
    private StorageTemplateDB2 storageTemplate = null;
    private String pieceSize = PIECE_SIZES[13];
    private BufferPoolDB2 bufferPool = null;
    private boolean close = true;
    private boolean copy = false;
    private final State UNIQUE = new Unique();
    private final State NONUNIQUE = new NonUnique();
    private State state = this.UNIQUE;
    private static final int PRIQTY = 1;
    private static final int SECQTY = 2;
    private static final int INITIALROWS = 1;
    private static final int MAXROWS = 2;
    private int rowsForCalculation = 1;
    private StringBuffer proposedQTYRemarks = new StringBuffer();
    public static final String TYPE_NAME = "AXTIdx";
    public static final String OLD_TYPE_NAME = "AUXTableIndex";
    private static int maxQTY = 0x400000;

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ATI";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AUXTableIndexPropertyDialogDB2 dialog = new AUXTableIndexPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public AUXTableDB2 getAuxTable() {
        return this.auxTable;
    }

    public void setAuxTable(AUXTableDB2 auxTable) {
        this.auxTable = auxTable;
        this.fireDataFieldChange();
    }

    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    public void setBufferPool(BufferPoolDB2 bufferPool) {
        this.bufferPool = bufferPool;
        this.fireDataFieldChange();
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
        this.fireDataFieldChange();
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
        this.fireDataFieldChange();
    }

    public String getPieceSize() {
        return this.pieceSize;
    }

    public void setPieceSize(String pieceSize) {
        this.pieceSize = pieceSize;
        this.fireDataFieldChange();
    }

    public StorageTemplateDB2 getStorageTemplate() {
        return this.storageTemplate;
    }

    public void setStorageTemplate(StorageTemplateDB2 storageTemplate) {
        this.storageTemplate = storageTemplate;
        this.fireDataFieldChange();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public static String[] getPieceSizes() {
        return PIECE_SIZES;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null) {
            return new StringBuffer(this.getOwner().getName()).append('.').append(this.getName()).toString();
        }
        return super.getName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getOwner() != null && !this.getOwner().isNullInstance()) {
            name = this.getOwner().getName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    public TableProxyDB2 getTableProxy() {
        return this.getAuxTable().getTable();
    }

    protected void checkState() {
        this.state = this.isUnique() ? this.UNIQUE : this.NONUNIQUE;
    }

    private int getSpacePerKeyL() {
        this.checkState();
        return this.state.getSpacePerKeyL();
    }

    private int getSpacePerKeyNL() {
        this.checkState();
        return this.state.getSpacePerKeyNL();
    }

    private int getIndexByteSize() {
        return 19;
    }

    private int getRIDSize() {
        return 5;
    }

    private int getMaxUsableSpacePerPageL() {
        return (int)Math.floor((float)((100 - this.getPercentageFree()) * 4038) / 100.0f);
    }

    private int getMaxUsableSpacePerPageNL() {
        float max = Math.max(90, 100 - this.getPercentageFree());
        return (int)Math.floor(max * 4046.0f / 100.0f);
    }

    private int getEntriesPerPageL() {
        this.checkState();
        return this.state.getEntriesPerPageL();
    }

    private int getEntriesPerPageNL() {
        return (int)Math.floor(this.getMaxUsableSpacePerPageNL() / this.getSpacePerKeyNL());
    }

    private int getPercentageFree() {
        if (this.getTableProxy() != null) {
            if (this.getStorageTemplate() != null && this.getTableProxy().getInsertMethod().equalsIgnoreCase("Load/Reorg")) {
                return this.getStorageTemplate().getPctFree();
            }
            return 0;
        }
        return 0;
    }

    private int getFreePage() {
        if (this.getTableProxy() != null) {
            if (this.getStorageTemplate() != null && this.getTableProxy().getInsertMethod().equalsIgnoreCase("Load/Reorg")) {
                return this.getStorageTemplate().getFreePage();
            }
            return 0;
        }
        return 0;
    }

    private int getAverageNumberDuplicatesPerKey() {
        return this.getNumberOfDuplicates();
    }

    private int getKeyEntriesPerPageL() {
        return (int)Math.floor((float)(this.getAverageNumberDuplicatesPerKey() * this.getMaxUsableSpacePerPageL()) / (float)this.getSpacePerKeyL());
    }

    private int getRemainingSpacePerPageL() {
        return (int)Math.floor((float)this.getMaxUsableSpacePerPageL() - (float)(this.getKeyEntriesPerPageL() * this.getSpacePerKeyL()) / (float)this.getAverageNumberDuplicatesPerKey());
    }

    private int getDataRecordsPerPartialEntryL() {
        return (int)Math.floor((float)(this.getRemainingSpacePerPageL() - (this.getIndexByteSize() + 4)) / 5.0f);
    }

    private int getPartialEntriesPerPageL() {
        if (this.getDataRecordsPerPartialEntryL() < 1) {
            return 0;
        }
        float a = (float)this.getAverageNumberDuplicatesPerKey() / (float)this.getDataRecordsPerPartialEntryL();
        return this.getAverageNumberDuplicatesPerKey() / (int)Math.ceil(a);
    }

    private long getRowNumberOfTableProxy() {
        TableProxyDB2 tableProxy = this.getTableProxy();
        if (tableProxy != null) {
            return this.rowsForCalculation == 1 ? tableProxy.getInitialRowNumber() : tableProxy.getMaxRowNumber();
        }
        return 0L;
    }

    private long getNumberLeafPages() {
        return (long)Math.ceil((float)this.getRowNumberOfTableProxy() / (float)this.getEntriesPerPageL());
    }

    private int getMinNumberChildPages() {
        return Math.max(2, this.getEntriesPerPageNL() + 1);
    }

    private long getLevel2Pages() {
        return (long)Math.ceil((float)this.getNumberLeafPages() / (float)this.getMinNumberChildPages());
    }

    private long getLevelXPages(float previousLevelPages) {
        return (long)Math.ceil(previousLevelPages / (float)this.getMinNumberChildPages());
    }

    private long getNumberNonleafPages() {
        long result = this.getLevel2Pages();
        long previousLevelPages = this.getLevel2Pages();
        while (previousLevelPages > 1L) {
            previousLevelPages = this.getLevelXPages(previousLevelPages);
            result += previousLevelPages;
        }
        return result;
    }

    private long getFreePages() {
        if (this.getFreePage() != 0) {
            return (long)Math.floor((float)this.getNumberLeafPages() / (float)this.getFreePage());
        }
        return 0L;
    }

    private long getTreePages() {
        return Math.max(2L, this.getNumberLeafPages() + this.getNumberNonleafPages());
    }

    private long getSpaceMapPages() {
        return (long)Math.ceil((float)(this.getFreePages() + this.getTreePages()) / 8131.0f);
    }

    private int getNumberIndexPages() {
        return (int)Math.max(4L, 1L + this.getSpaceMapPages() + this.getTreePages() + this.getFreePages());
    }

    private int getRequiredSpacePages() {
        return this.getNumberIndexPages() + 2;
    }

    public int getInitialNumberUsedPages() {
        this.rowsForCalculation = 1;
        return this.getRequiredSpacePages();
    }

    public int getMaxNumberUsedPages() {
        this.rowsForCalculation = 2;
        return this.getRequiredSpacePages();
    }

    public long getInitialNumberUsedKB() {
        return 4 * this.getInitialNumberUsedPages();
    }

    public long getMaxNumberUsedKB() {
        return 4 * this.getMaxNumberUsedPages();
    }

    private int getNumberOfPieces() {
        return 254;
    }

    public int transformPSizeToLong(String ps) {
        String psc = ps.substring(0, ps.length() - 2);
        return Integer.parseInt(psc);
    }

    public int getPieceSizeKB() {
        String ps = this.getPieceSize();
        String psc = ps.substring(0, ps.length() - 2);
        return Integer.parseInt(psc);
    }

    public int getNumberOfDuplicates() {
        return 1;
    }

    public int getNumParts() {
        if (this.getTableProxy() != null && this.getTableProxy().getTableSpace() != null) {
            return this.getTableProxy().getTableSpace().getNumParts();
        }
        return 0;
    }

    int chooseProperPieceSize(int ps) {
        for (int i = 0; i < PIECE_SIZES.length; ++i) {
            int psInt = this.transformPSizeToLong(PIECE_SIZES[i]);
            if (ps >= psInt) continue;
            return this.transformPSizeToLong(PIECE_SIZES[i]);
        }
        return this.transformPSizeToLong(PIECE_SIZES[PIECE_SIZES.length]);
    }

    public int getProposedPRIQTY() {
        return this.getProposedQTY(1);
    }

    public int getProposedQTY(int qtyType) {
        this.proposedQTYRemarks.setLength(0);
        int psizeInK = 4;
        int pieceSizePages = (int)Math.ceil((float)this.getPieceSizeKB() / 4.0f);
        int minPages = 0;
        int maxPages = 0;
        int priQTY = 0;
        int secQTY = 0;
        maxPages = this.getMaxNumberUsedPages();
        minPages = this.getInitialNumberUsedPages();
        minPages = Math.max(3, minPages);
        maxPages = Math.max(3, maxPages);
        priQTY *= psizeInK;
        secQTY *= psizeInK;
        if (this.getNumParts() == 0) {
            int numPieces = this.getNumberOfPieces();
            int maxSize = numPieces * pieceSizePages;
            if (maxSize < maxPages) {
                this.proposedQTYRemarks.append(Messages.getString("AUXTableIndexDB2.CurrentPIECESIZENotSufficient"));
                int ps = maxPages / numPieces;
                ps = this.chooseProperPieceSize(ps * 4);
                this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("AUXTableIndexDB2.PIECESIZEProposed"), Integer.toString(ps)));
                pieceSizePages = ps / 4;
            }
            if ((priQTY = minPages) >= pieceSizePages) {
                priQTY = pieceSizePages;
                secQTY = priQTY / 10;
            } else {
                long pages;
                secQTY = Math.max(3, priQTY / 10);
                if ((long)(priQTY + 118 * secQTY) < (pages = (long)Math.min(pieceSizePages, maxPages))) {
                    secQTY = priQTY = (int)Math.ceil((float)pages / 119.0f);
                    this.proposedQTYRemarks.append(Messages.getString("AUXTableIndexDB2.SizeAdjusted"));
                }
            }
        } else {
            priQTY = minPages;
            secQTY = Math.max(3, priQTY / 10);
            if (priQTY + 118 * secQTY < maxPages) {
                secQTY = priQTY = (int)Math.ceil((float)maxPages / 119.0f);
                this.proposedQTYRemarks.append(Messages.getString("AUXTableIndexDB2.SizeAdjusted"));
            }
        }
        priQTY *= psizeInK;
        secQTY *= psizeInK;
        if (minPages == maxPages) {
            secQTY = 0;
        }
        priQTY = Math.min(priQTY, maxQTY);
        secQTY = Math.min(secQTY, maxQTY);
        return qtyType == 1 ? priQTY : secQTY;
    }

    public int getProposedSECQTY() {
        return this.getProposedQTY(2);
    }

    public String getProposedQTYRemarks() {
        return this.proposedQTYRemarks.toString();
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        AUXTableIndexDB2 index = null;
        StorageObject stObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getAUXTableIndexSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                index = (AUXTableIndexDB2)stObject;
            }
        } else {
            index = ((AbstractStorageDesignDB2)targetDesign).getAUXTableIndexSet().createAUXTableIndex();
        }
        if (index != null) {
            index.setName(this.getName());
            if (this.getOwner() != null) {
                Owner targetOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (targetOwner == null) {
                    Owner newOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    index.setOwner(newOwner);
                } else {
                    index.setOwner(targetOwner);
                }
            }
            if (this.getStorageTemplate() != null) {
                StorageTemplateDB2 targetTemplate = (StorageTemplateDB2)((AbstractStorageDesignDB2)targetDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (targetTemplate == null) {
                    StorageTemplateDB2 newTemplate = ((AbstractStorageDesignDB2)targetDesign).getStorageTemplateSet().createStorageTemplate();
                    newTemplate.setName(this.getStorageTemplate().getName());
                    newTemplate.setRawObject(true);
                    index.setStorageTemplate(newTemplate);
                } else {
                    index.setStorageTemplate(targetTemplate);
                }
            }
            index.setPieceSize(this.getPieceSize());
            if (this.getBufferPool() != null) {
                BufferPoolDB2 targetBufferPool = (BufferPoolDB2)((AbstractStorageDesignDB2)targetDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (targetBufferPool == null) {
                    BufferPoolDB2 newBufferPool = (BufferPoolDB2)((AbstractStorageDesignDB2)targetDesign).getBufferPoolSet().createElement(null);
                    newBufferPool.setName(this.getBufferPool().getName());
                    newBufferPool.setRawObject(true);
                    index.setBufferPool(newBufferPool);
                } else {
                    index.setBufferPool(targetBufferPool);
                }
            }
            index.setClose(this.isClose());
            index.setCopy(this.isCopy());
            index.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("INDEX_ICON", 16);
    }

    class Unique
    extends State {
        Unique() {
        }

        @Override
        public int getSpacePerKeyL() {
            return AUXTableIndexDB2.this.getIndexByteSize() + AUXTableIndexDB2.this.getRIDSize() + 3;
        }

        @Override
        public int getSpacePerKeyNL() {
            return AUXTableIndexDB2.this.getIndexByteSize() + 7;
        }

        @Override
        public int getEntriesPerPageL() {
            return (int)Math.floor(AUXTableIndexDB2.this.getMaxUsableSpacePerPageL() / this.getSpacePerKeyL());
        }
    }

    abstract class State {
        State() {
        }

        public abstract int getSpacePerKeyL();

        public abstract int getSpacePerKeyNL();

        public abstract int getEntriesPerPageL();
    }

    class NonUnique
    extends State {
        NonUnique() {
        }

        @Override
        public int getSpacePerKeyL() {
            return AUXTableIndexDB2.this.getIndexByteSize() + 4 + AUXTableIndexDB2.this.getAverageNumberDuplicatesPerKey() * (AUXTableIndexDB2.this.getRIDSize() + 1);
        }

        @Override
        public int getSpacePerKeyNL() {
            return AUXTableIndexDB2.this.getIndexByteSize() + AUXTableIndexDB2.this.getRIDSize() + 7;
        }

        @Override
        public int getEntriesPerPageL() {
            return Math.max(1, AUXTableIndexDB2.this.getKeyEntriesPerPageL() + AUXTableIndexDB2.this.getPartialEntriesPerPageL());
        }
    }
}

