/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Dimension;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.logical.RelationPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.GUID;

public class Relation
extends DesignObject
implements ConnectionInterface {
    public static final int SOURCE = 0;
    public static final int TARGET = 1;
    public static final int MANY = 0;
    private final Entity[] ENTITIES = new Entity[2];
    private static final Cardinality MANY_CARD = new Cardinality(0, "*");
    private static Cardinality ONE_CARD = new Cardinality(1);
    public static final Cardinality[] CARDINALITY_CHOICES = new Cardinality[]{MANY_CARD, ONE_CARD};
    private final Cardinality[] CARDINALITIES = new Cardinality[]{MANY_CARD, MANY_CARD};
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new TargetConnection()};
    private FKAttributeManager fkAttributeManager = null;
    Collection dpvCol = new ArrayList();
    private boolean belongsToTargetPK = false;
    private boolean belongsToSourcePK = false;
    private boolean fireCardinalityChange = true;
    private Entity DOMINANT_ROLE;
    private Entity NONE = new Entity(this.getDesignPart());
    private boolean identifying = false;
    private Arc arc = null;
    private boolean transferable = true;
    private String deleteRule = "RESTRICT";
    private boolean useSurrogateKey = false;
    private boolean sourceTransferable = true;
    private boolean targetTransferable = true;
    private Entity ownedEntity;
    private String ownedEntityID;
    public static final String TYPE_NAME = "Relation";
    TVEntity sourceTVT = null;
    TVEntity targetTVT = null;
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];

    public Relation(DesignPart designPart) {
        super(designPart);
        String delr;
        this.setUseSurrogateKey(designPart.getAppView().getSettings().isDefaultUseSurrogateKey());
        this.getFKAttributeManager();
        this.deleteRule = delr = designPart.getAppView().getSettings().getDefaultFKDeleteRule();
    }

    @Override
    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public ModelObject getChild(int index) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Object getParent() {
        return ((LogicalDesign)this.getDesignPart()).getRelationSet();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setEntity(int endPoint, Entity entity) {
        if (this.ENTITIES[endPoint] == entity) {
            return;
        }
        if (this.ENTITIES[endPoint] != null) {
            if (this.ENTITIES[0] != this.ENTITIES[1]) {
                this.ENTITIES[endPoint].removeRelationFromRelationCollections(this);
            }
            this.ENTITIES[endPoint].remove(this.CONNECTIONS[endPoint]);
        }
        if (entity != null) {
            entity.add(this.CONNECTIONS[endPoint]);
        }
        this.ENTITIES[endPoint] = entity;
        if (entity != null) {
            entity.addRelationToRelationCollections(this);
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public void setEntityInh(int endPoint, Entity entity) {
        Entity oldEntity = this.ENTITIES[endPoint];
        if (this.ENTITIES[endPoint] == entity) {
            return;
        }
        if (this.ENTITIES[endPoint] != null) {
            if (this.ENTITIES[0] != this.ENTITIES[1]) {
                this.ENTITIES[endPoint].removeRelationFromRelationCollections(this);
            }
            this.ENTITIES[endPoint].remove(this.CONNECTIONS[endPoint]);
        }
        if (entity != null) {
            entity.add(this.CONNECTIONS[endPoint]);
        }
        this.ENTITIES[endPoint] = entity;
        if (entity != null) {
            entity.addRelationToRelationCollections(this);
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
        if (0 == endPoint && this.ENTITIES[1] != null) {
            this.ENTITIES[1].setHierarchicalParent(entity);
        }
        if (1 == endPoint && oldEntity != null) {
            oldEntity.setHierarchicalParentToNull();
            if (entity != null) {
                entity.joinInheritanceRelation(this, this.ENTITIES[0]);
            }
        }
    }

    public Entity getEntity(int endPoint) {
        return this.ENTITIES[endPoint];
    }

    public void setCardinality(int endPoint, Cardinality value) {
        this.CARDINALITIES[endPoint] = value;
        if (this.fireCardinalityChange) {
            this.fireChange(ObjectChangeEvent.RELATION_CARDINALITY_CHANGED);
        }
    }

    public void setCardinality(int endPoint, int code) {
        if (code < 0 || code >= CARDINALITY_CHOICES.length) {
            throw new IllegalArgumentException(Messages.getString("Relation.CodeMustPointCardinality"));
        }
        this.setCardinality(endPoint, CARDINALITY_CHOICES[code]);
    }

    public Cardinality getCardinality(int endPoint) {
        return this.CARDINALITIES[endPoint];
    }

    public Entity getTargetEntity() {
        return this.getEntity(1);
    }

    public void setTargetEntity(Entity entity) {
        if (this.getTargetEntity() != entity) {
            Entity old = this.getTargetEntity();
            this.setEntity(1, entity);
            if (old != null && old != entity) {
                this.clearTargetTV();
            }
            this.addToAllDPVs();
        }
    }

    public Entity getSourceEntity() {
        return this.getEntity(0);
    }

    public void setSourceEntity(Entity entity) {
        if (this.getSourceEntity() != entity) {
            Entity old = this.getSourceEntity();
            this.setEntity(0, entity);
            if (old != null && old != entity) {
                this.clearSourceTV();
            }
            this.addToAllDPVs();
        }
    }

    public void setTargetCardinality(Object cardinality) {
        if (cardinality instanceof Cardinality) {
            this.setCardinality(1, (Cardinality)cardinality);
        } else if (cardinality instanceof String) {
            this.setCardinality(1, (String)cardinality);
        }
    }

    public Object getTargetCardinality() {
        return this.getCardinality(1);
    }

    public void setSourceCardinality(Object cardinality) {
        if (cardinality instanceof Cardinality) {
            this.setCardinality(0, (Cardinality)cardinality);
        } else if (cardinality instanceof String) {
            this.setCardinality(0, (String)cardinality);
        }
    }

    public Object getSourceCardinality() {
        return this.getCardinality(0);
    }

    public boolean isValid() {
        return this.getEntity(0) != null && this.getEntity(1) != null;
    }

    public static Cardinality[] getCardinalityChoices() {
        return CARDINALITY_CHOICES;
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    public int getOtherEndPoint(int endPoint) {
        if (endPoint == 0) {
            return 1;
        }
        if (endPoint == 1) {
            return 0;
        }
        throw new IllegalArgumentException(Messages.getString("Relation.EndPointMmustBeRelation.SOURCE"));
    }

    public Connection getConnection(int endPoint) {
        return this.CONNECTIONS[endPoint];
    }

    public boolean isOptional(int endPoint) {
        return this.getConnection(endPoint).isOptional();
    }

    public Boolean getOptional(int endPoint) {
        return this.getConnection(endPoint).getOptionality();
    }

    public void setOptional(int endPoint, Boolean value) {
        Connection con = this.getConnection(endPoint);
        if (con != null && con.isOptional() != value.booleanValue()) {
            con.setOptionality(value);
            this.fireChange(ObjectChangeEvent.RELATION_OPTIONALITY_CHANGED);
        }
    }

    public void setOptionalTarget(boolean value) {
        this.setOptional(1, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setOptionalSource(boolean value) {
        this.setOptional(0, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isOptionalTarget() {
        return this.getOptional(1);
    }

    public boolean isOptionalSource() {
        return this.getOptional(0);
    }

    public void setNameOnTarget(String name) {
        this.getConnection(1).setNameOn(name);
    }

    public String getNameOnTarget() {
        return this.getConnection(1).getNameOn();
    }

    public void setNameOnSource(String name) {
        this.getConnection(0).setNameOn(name);
    }

    public String getNameOnSource() {
        return this.getConnection(0).getNameOn();
    }

    public String getLabelText(int endPoint) {
        StringBuffer buffer = new StringBuffer();
        if (this.isOptional(endPoint) && this.getCardinality(endPoint) != MANY_CARD) {
            buffer.append("0 .. ");
        } else if (!this.isOptional(endPoint) && this.getCardinality(endPoint) == MANY_CARD) {
            buffer.append("1 .. ");
        }
        buffer.append(this.getCardinality(endPoint));
        String nameOnEndpoint = this.getNameOn(endPoint);
        if (nameOnEndpoint != null) {
            buffer.append(' ').append(nameOnEndpoint);
        }
        return buffer.toString();
    }

    public String getNameOn(int endPoint) {
        return this.getConnection(endPoint).getNameOn();
    }

    public void setNameOn(int endPoint, String nameOnEndpoint) {
        this.getConnection(endPoint).setNameOn(nameOnEndpoint);
    }

    public void invertSense() {
        Cardinality tempc = this.CARDINALITIES[0];
        this.CARDINALITIES[0] = this.CARDINALITIES[1];
        this.CARDINALITIES[1] = tempc;
        Entity tempe = this.getEntity(0);
        this.setEntity(0, this.getEntity(1));
        this.setEntity(1, tempe);
    }

    public void setCardinality(int endPoint, String representation) {
        for (int i = 0; i < CARDINALITY_CHOICES.length; ++i) {
            if (!representation.equals(CARDINALITY_CHOICES[i].toString())) continue;
            this.setCardinality(endPoint, CARDINALITY_CHOICES[i]);
        }
    }

    public boolean isManyToMany() {
        return !this.getConnection(0).isOneCardinality() && !this.getConnection(1).isOneCardinality();
    }

    public boolean isOneToOne() {
        return this.getConnection(0).isOneCardinality() && this.getConnection(1).isOneCardinality();
    }

    public boolean isInheritanceRelation() {
        return false;
    }

    public FKAttributeManager getFKAttributeManager() {
        if (this.fkAttributeManager == null) {
            this.fkAttributeManager = new FKAttributeManager(this);
        }
        return this.fkAttributeManager;
    }

    public Attribute[] getFKAttributes(int endPoint) {
        return this.getFKAttributeManager().getFKAttributes(endPoint);
    }

    public Attribute[] getFKAttributes(Entity sourceOrTarget) {
        if (sourceOrTarget != null) {
            return this.getFKAttributes(this.getEndPointFor(sourceOrTarget));
        }
        return (Attribute[])DesignObject.PROTOTYPE;
    }

    public int getEndPointFor(Entity sourceOrTarget) {
        if (sourceOrTarget != null) {
            if (sourceOrTarget.equals(this.getSourceEntity())) {
                return 0;
            }
            if (sourceOrTarget.equals(this.getTargetEntity())) {
                return 1;
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("Relation.EntityNotSourceOrTarget"), sourceOrTarget));
        }
        throw new IllegalArgumentException(Messages.getString("Relation.EndpointForNullCanNotBeDetermined"));
    }

    public boolean isPrimaryForeignKey(int endPoint) {
        return this.getFKAttributeManager().isPrimaryForeignKey(endPoint);
    }

    public int[] getPKProviderEndPoint() {
        if (this.isManyToMany()) {
            return new int[]{0, 1};
        }
        if (this.getSourceConnection().isOneCardinality() && this.getTargetConnection().isOneCardinality()) {
            if (this.getEntity(0) == this.getEntity(1)) {
                return new int[]{0};
            }
            if (this.getDominantRole() != this.NONE) {
                if (this.getDominantRole() == this.getSourceEntity()) {
                    return new int[]{0};
                }
                return new int[]{1};
            }
            if (this.getSourceConnection().isOptional() && !this.getTargetConnection().isOptional()) {
                return new int[]{0};
            }
            if (!this.getSourceConnection().isOptional() && this.getTargetConnection().isOptional()) {
                return new int[]{1};
            }
            return new int[]{0, 1};
        }
        if (this.getSourceConnection().isOneCardinality()) {
            return new int[]{0};
        }
        if (this.getTargetConnection().isOneCardinality()) {
            return new int[]{1};
        }
        return new int[0];
    }

    public CandidateKey getPKProviderKeyForChild(Entity childEntity) {
        if (this.fkAttributeManager != null) {
            if (this.getSourceEntity() == childEntity) {
                return this.fkAttributeManager.getTargetPk();
            }
            if (this.getTargetEntity() == childEntity) {
                return this.fkAttributeManager.getSourcePk();
            }
        }
        return null;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("relation id prefix");
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public void remove() {
        if (this.getTargetEntity() != null) {
            this.getTargetEntity().removeRelationFromRelationCollections(this);
        }
        if (this.getSourceEntity() != null) {
            this.getSourceEntity().removeRelationFromRelationCollections(this);
        }
        if (this.fkAttributeManager != null) {
            this.fkAttributeManager.removeFromListeners();
        }
        if (this.ownedEntity != null) {
            this.ownedEntity.removeAll();
        }
        super.remove();
        this.setEntity(1, null);
        this.setEntity(0, null);
        this.delete();
    }

    public void delete() {
    }

    @Override
    public void changed(TopView tv, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView dpv = tv.getDesignPartView();
            dpv.removeViewFor(this);
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            dpi.tv = null;
            if (dpi.sourceTV == tv) {
                dpi.sourceTV = null;
            }
            if (dpi.targetTV == tv) {
                dpi.targetTV = null;
            }
        }
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null && inf.tv != view) {
            throw new RuntimeException(Messages.getString("Relation.AssociationAlreadyexists"));
        }
        inf.tv = view;
    }

    @Override
    public void removeTopView(TopView view) {
        if (view != null) {
            DesignPartView dpv = view.getDesignPartView();
            dpvInfo inf = this.getDPVInfoFor(dpv);
            ((TVRelation)view).removeConnection();
            if (inf.dpv != null) {
                inf.dpv.unregisterFromTreemodel(view);
            }
            if (inf.tv == null) {
                return;
            }
            this.dpvCol.remove(inf);
            this.removeObjectListener(view);
        }
    }

    public void removeViewFor(DesignPartView dpv) {
        if (dpv != null) {
            dpvInfo inf = this.getDPVInfoFor(dpv);
            if (inf.tv != null) {
                ((TVRelation)inf.tv).removeConnection();
                ((TVRelation)inf.tv).removeLabel(0);
                ((TVRelation)inf.tv).removeLabel(2);
                ((TVRelation)inf.tv).removeLabel(1);
                if (inf.dpv != null) {
                    inf.dpv.unregisterFromTreemodel(inf.tv);
                }
                this.dpvCol.remove(inf);
            }
        }
    }

    public dpvInfo getDPVInfoFor(DesignPartView dpv) {
        dpvInfo dpi2;
        for (dpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new dpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    public List getAllTVRelations() {
        ArrayList<TopView> list = new ArrayList<TopView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            list.add(dpi.tv);
        }
        return list;
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    public void updateConnections() {
        TVRelation tv = (TVRelation)this.getTopView();
        tv.removeConnection();
        tv.addConnection();
    }

    public void setSourceTV(TVEntity source) {
        if (source == null) {
            return;
        }
        DesignPartView dpv = source.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV != source) {
            if (dpi.sourceTV != null) {
                if (dpi.tv != null) {
                    ((TVRelation)dpi.tv).removeConnection();
                    if (dpi.dpv != null) {
                        dpi.dpv.unregisterFromTreemodel(dpi.tv);
                    }
                }
                dpi.sourceTV.removeTopViewListener(this);
            }
            dpi.sourceTV = source;
            dpi.sourceTV.addTopViewListener(this);
            this.addTVRelation(dpi);
        }
    }

    public void setTargetTV(TVEntity target) {
        if (target == null) {
            return;
        }
        DesignPartView dpv = target.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV != target) {
            if (dpi.targetTV != null) {
                if (dpi.tv != null) {
                    ((TVRelation)dpi.tv).removeConnection();
                    if (dpi.dpv != null) {
                        dpi.dpv.unregisterFromTreemodel(dpi.tv);
                    }
                }
                dpi.targetTV.removeTopViewListener(this);
            }
            dpi.targetTV = target;
            dpi.targetTV.addTopViewListener(this);
            this.addTVRelation(dpi);
        }
    }

    public void addTVRelation(dpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVRelation tvr = new TVRelation(this.getDesign().getAppView(), dpi.dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpi.dpv.registerForTreemodel(tvr);
            if (dpi.dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
            }
        } else if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null && ((TVRelation)dpi.tv).getEdge() == null && !ApplicationView.loading) {
            ((TVRelation)dpi.tv).addConnection();
        }
        if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            dpi.dpv.registerTopView(dpi.tv);
        }
    }

    public void addTVRelation(TopView tv, TVEntity sourceTV, TVEntity targetTV, DesignPartView dpv) {
        if (tv == null && sourceTV != null && targetTV != null && dpv != null) {
            TVRelation tvr = new TVRelation(this.getDesign().getAppView(), dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpv.registerForTreemodel(tvr);
            if (dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
            }
        }
    }

    public void addToAllDPVs() {
        DesignPartView dpv;
        if (this.getTargetEntity() == null || this.getSourceEntity() == null) {
            return;
        }
        Collection targetDPVs = this.getTargetEntity().getAffectedDPVs();
        Collection sourceDPVs = this.getSourceEntity().getAffectedDPVs();
        Iterator tit = targetDPVs.iterator();
        Iterator sit = sourceDPVs.iterator();
        while (tit.hasNext()) {
            dpv = (DesignPartView)tit.next();
            this.getTargetTV(dpv);
        }
        while (sit.hasNext()) {
            dpv = (DesignPartView)sit.next();
            this.getSourceTV(dpv);
        }
    }

    public void removeFromAllAllDPVs() {
        if (this.getTargetEntity() == null || this.getSourceEntity() == null) {
            return;
        }
        HashMap<DesignPartView, DesignPartView> map = new HashMap<DesignPartView, DesignPartView>();
        Collection targetDPVs = this.getTargetEntity().getAffectedDPVs();
        for (DesignPartView dpv : targetDPVs) {
            map.put(dpv, dpv);
            this.removeViewFor(dpv);
        }
        Collection sourceDPVs = this.getSourceEntity().getAffectedDPVs();
        for (DesignPartView dpv : sourceDPVs) {
            if (map.get(dpv) != null) continue;
            this.removeViewFor(dpv);
        }
    }

    public void clearSourceTV() {
        for (dpvInfo dpi : this.dpvCol) {
            dpi.sourceTV = null;
            if (dpi.tv == null) continue;
            ((TVRelation)dpi.tv).removeConnection();
            if (dpi.dpv != null) {
                dpi.dpv.unregisterFromTreemodel(dpi.tv);
            }
            dpi.tv = null;
        }
    }

    public void clearTargetTV() {
        for (dpvInfo dpi : this.dpvCol) {
            dpi.targetTV = null;
            if (dpi.tv == null) continue;
            ((TVRelation)dpi.tv).removeConnection();
            if (dpi.dpv != null) {
                dpi.dpv.unregisterFromTreemodel(dpi.tv);
            }
            dpi.tv = null;
        }
    }

    public TVEntity getSourceTVEntity() {
        DesignPartView dpv = ApplicationView.loading ? this.getDesign().getLogicalDesign().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        return this.getSourceTV(dpv);
    }

    public TVEntity getTargetTVEntity() {
        DesignPartView dpv = ApplicationView.loading ? this.getDesign().getLogicalDesign().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        return this.getTargetTV(dpv);
    }

    public boolean matchSourceTV(DesignPartView dpv, ContainerView cv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.sourceTV == cv;
    }

    public TVEntity getSourceTV(DesignPartView dpv) {
        Collection c;
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV == null && this.getSourceEntity() != null && !(c = this.getSourceEntity().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.sourceTV = (TVEntity)it.next();
            dpi.sourceTV.addTopViewListener(this);
            this.addTVRelation(dpi);
        }
        return dpi.sourceTV;
    }

    public boolean matchTargetTV(DesignPartView dpv, ContainerView cv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.targetTV == cv;
    }

    public TVEntity getTargetTV(DesignPartView dpv) {
        Collection c;
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV == null && this.getTargetEntity() != null && !(c = this.getTargetEntity().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.targetTV = (TVEntity)it.next();
            dpi.targetTV.addTopViewListener(this);
            this.addTVRelation(dpi);
        }
        return dpi.targetTV;
    }

    public void callRemoveListeners() {
        ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
        event.setAffected(this);
        this.fireChange(event);
        event.setAffected(null);
    }

    public void repairSelfReference() {
    }

    public void createDefaultSelfReferencePoints() {
        for (TVRelation tv : this.getAllTVRelations()) {
            tv.createDefaultSelfReferencePoints();
        }
    }

    public boolean belongsToTargetPK() {
        return this.belongsToTargetPK;
    }

    public void setBelongsToTargetPK(boolean belongsToPK) {
        this.belongsToTargetPK = belongsToPK;
    }

    public boolean belongsToSourcePK() {
        return this.belongsToSourcePK;
    }

    public void setBelongsToSourcePK(boolean belongsToPK) {
        this.belongsToSourcePK = belongsToPK;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getTargetEntity() != null && this.getTargetEntity().isReadOnly() || this.getSourceEntity() != null && this.getSourceEntity().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    @Override
    public boolean hasAliveGenerator() {
        TableSet tset;
        DesignObject obj;
        FKIndexAssociationSet set = this.getDesign().getRelationalDesign().getFKIndexAssociationSet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null || (tset = this.getDesign().getRelationalDesign().getTableSet()).getObjectByID(this.getGeneratorID()) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RelationPropertiesDialogEx dialog = new RelationPropertiesDialogEx(this.getDesign().getAppView(), this);
            this.setShowForFirstTime(false);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        return this.getViewFor(dpv) != null;
    }

    @Override
    public boolean getShouldEngineer() {
        boolean eng = super.getShouldEngineer();
        return eng;
    }

    public void setFireCardinalityChange(boolean fireCardinalityChange) {
        this.fireCardinalityChange = fireCardinalityChange;
    }

    public Entity getDominantRole() {
        if (this.DOMINANT_ROLE == null) {
            return this.getNONEEntity();
        }
        return this.DOMINANT_ROLE;
    }

    public void setDominantRole(Entity dominant_role) {
        if (dominant_role == null) {
            this.DOMINANT_ROLE = this.getNONEEntity();
        }
        this.DOMINANT_ROLE = dominant_role;
    }

    public Entity getNONEEntity() {
        this.NONE.setName(AbstractEditorConstants.NONE);
        return this.NONE;
    }

    public void setNONEEntity(Entity none) {
        this.NONE = none;
    }

    public Entity[] initDominatRole() {
        return new Entity[]{this.getNONEEntity(), this.getEntity(0), this.getEntity(1)};
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public void setIdentifying(boolean identifying) {
        if (this.identifying != identifying) {
            this.identifying = identifying;
            this.fireFK_AttributesChanged();
        }
    }

    @Override
    public String toString() {
        String name = this.getName() + " (";
        Object scard = this.isOptionalSource() ? "0" : "1";
        String repr = this.getTargetCardinality().toString();
        scard = (String)scard + ".." + repr;
        Object tcard = this.isOptionalTarget() ? "0" : "1";
        repr = this.getSourceCardinality().toString();
        tcard = (String)tcard + ".." + repr;
        if (this.getSourceEntity() != null) {
            name = name + this.getSourceEntity().getName() + " - " + (String)scard + ":";
        }
        if (this.getTargetEntity() != null) {
            name = name + (String)tcard + " - " + this.getTargetEntity().getName();
        }
        return name + ")";
    }

    public XtdMapping getDeletedMapping(String designPartID) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, designPartID);
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    public XtdMapping getDeletedMapping(String designPartID, String deletedID) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, designPartID);
        for (XtdMapping mapping : list) {
            if (!deletedID.equals(mapping.getDeletedID())) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setSourceTV((TVEntity)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setTargetTV((TVEntity)target);
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getSourceTV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getTargetTV(dpv);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.getViewFor(dpv);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getSourceEntity();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getTargetEntity();
    }

    public Entity getOtherEntity(Entity entity) {
        if (entity == this.getSourceEntity()) {
            return this.getTargetEntity();
        }
        return this.getSourceEntity();
    }

    public FKIndexAssociation getEngFK(RelationalDesign pdes, Table table) {
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                FKIndexAssociation fk;
                XtdMapping mapping = (XtdMapping)list.get(i);
                DesignObject obj = mapping.getObjectMappedTo(this);
                if (obj == null || !(obj instanceof FKIndexAssociation) || (fk = (FKIndexAssociation)obj).getContainerWithKeyObject() != table) continue;
                return fk;
            }
        }
        return null;
    }

    public List getEngForeignKeys(RelationalDesign pdes) {
        ArrayList<DesignObject> fkeys = new ArrayList<DesignObject>();
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        for (XtdMapping mapping : list) {
            DesignObject obj = mapping.getObjectMappedTo(this);
            if (obj == null || !(obj instanceof FKIndexAssociation)) continue;
            fkeys.add(obj);
        }
        return fkeys;
    }

    public List getEngObjects(RelationalDesign pdes) {
        ArrayList<DesignObject> fkeys = new ArrayList<DesignObject>();
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        for (XtdMapping mapping : list) {
            DesignObject obj = mapping.getObjectMappedTo(this);
            if (obj == null || obj.isRemoved()) continue;
            fkeys.add(obj);
        }
        return fkeys;
    }

    public boolean isPKConsumer(Entity entity) {
        if (entity == this.getSourceEntity() || entity == this.getTargetEntity()) {
            int[] ends = this.getPKProviderEndPoint();
            for (int i = 0; i < ends.length; ++i) {
                if (this.getEntity(ends[i]) == entity && this.getSourceEntity() != this.getTargetEntity()) continue;
                return true;
            }
        }
        return false;
    }

    void fireFK_AttributesChanged() {
        this.fireChange(ObjectChangeEvent.FK_ATTRIBUTES_CHANGED);
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            col.add(dpi.tv);
        }
        return col;
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
        tv.getDesignPartView().restoreTopview(tv, this);
        dpvInfo dpi = this.getDPVInfoFor(tv.getDesignPartView());
        if (dpi.tv == tv) {
            this.addObjectListener(tv);
            dpi.targetTV = (TVEntity)targetTV;
            dpi.targetTV.addTopViewListener(this);
            dpi.sourceTV = (TVEntity)sourceTV;
            dpi.sourceTV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public Arc getArc() {
        return this.arc;
    }

    public void setArc(Arc arc) {
        this.arc = arc;
    }

    public boolean inArc() {
        return this.arc != null;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public void setTransferable(boolean transferable) {
        this.transferable = transferable;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "relation" + File.separatorChar + this.getObjectID() + ".xml").getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSourceCardinalityString() {
        return this.getSourceCardinality().toString();
    }

    public void setSourceCardinalityString(String card) {
        if ("*".equals(card)) {
            this.setSourceCardinality(MANY_CARD);
        } else {
            this.setSourceCardinality(ONE_CARD);
        }
    }

    public String getTargetCardinalityString() {
        return this.getTargetCardinality().toString();
    }

    public void setTargetCardinalityString(String card) {
        if ("*".equals(card)) {
            this.setTargetCardinality(MANY_CARD);
        } else {
            this.setTargetCardinality(ONE_CARD);
        }
    }

    public boolean isSelfRefrence() {
        return this.getSourceEntity() == this.getTargetEntity();
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(String deleteRule) {
        this.deleteRule = deleteRule;
    }

    public CandidateKey getSourcePk() {
        return this.fkAttributeManager.getSourcePk();
    }

    public CandidateKey getTargetPk() {
        return this.fkAttributeManager.getTargetPk();
    }

    public void setSourcePk(CandidateKey sourcePk) {
        this.fkAttributeManager.setSourcePk(sourcePk);
    }

    public void setTargetPk(CandidateKey targetPk) {
        this.fkAttributeManager.setTargetPk(targetPk);
    }

    public boolean isUseSurrogateKey() {
        return this.useSurrogateKey;
    }

    public void setUseSurrogateKey(boolean useSurrogateKey) {
        this.useSurrogateKey = useSurrogateKey;
    }

    public boolean isSourceTransferable() {
        return this.sourceTransferable;
    }

    public void setSourceTransferable(boolean sourceTransferable) {
        this.sourceTransferable = sourceTransferable;
    }

    public boolean isTargetTransferable() {
        return this.targetTransferable;
    }

    public void setTargetTransferable(boolean targetTransferable) {
        this.targetTransferable = targetTransferable;
    }

    public Entity getOwnedEntity() {
        if (this.ownedEntity == null) {
            this.ownedEntity = new Entity(this.getDesignPart());
            if (this.ownedEntityID == null) {
                this.ownedEntityID = new GUID().toString();
            }
            this.ownedEntity.setObjectID(this.ownedEntityID);
            this.ownedEntity.setContainerRelation(this);
        }
        return this.ownedEntity;
    }

    public String getOwnedEntityID() {
        return this.ownedEntityID;
    }

    public void setOwnedEntityID(String ownedEntityID) {
        this.ownedEntityID = ownedEntityID;
    }

    public boolean hasAttributes() {
        return this.ownedEntity != null && this.ownedEntity.getElementsCollection().size() > 0;
    }

    public Attribute createAttribute() {
        return this.getOwnedEntity().createAttribute();
    }

    public Attribute createAttribute(String name) {
        return this.getOwnedEntity().createAttribute(name);
    }

    public Collection getAttributesCollection() {
        return this.getOwnedEntity().getElementsCollection();
    }

    public Attribute getAttributeByID(String id) {
        return (Attribute)this.getOwnedEntity().getElementByID(id);
    }

    public void moveAttributeToIndex(Attribute attr, int index) {
        this.getOwnedEntity().moveToIndex(attr, index);
    }

    public TopView getViewForEntity(Entity ent, DesignPartView dpv) {
        if (ent == this.getTargetEntity()) {
            return this.getTargetTV(dpv);
        }
        return this.getSourceTV(dpv);
    }

    public void resetEdgeParams() {
        for (TVRelation tv : this.getAllTVRelations()) {
            tv.resetEdgeParams();
        }
    }

    public RelationEndsDescription getRelationEndsDescription(int notation) {
        RelationEndsDescription rd = new RelationEndsDescription();
        Relation rel = this;
        if (rel.getClass() == Relation.class) {
            Cardinality scar = (Cardinality)rel.getSourceCardinality();
            Cardinality tcar = (Cardinality)rel.getTargetCardinality();
            if (notation == 0) {
                rd.beginOptional = false;
                rd.endOptional = false;
                if (rel.isIdentifying()) {
                    if (scar.getValue() == 1 && tcar.getValue() == 1) {
                        Entity dominantEntity = rel.getDominantRole();
                        if (rel.getSourceEntity() == dominantEntity) {
                            rd.beginType = 5;
                            rd.endType = 5;
                            rd.endType = 15;
                        } else {
                            rd.beginType = 15;
                            rd.endType = 5;
                        }
                    } else if (tcar.getValue() == 0) {
                        rd.beginType = 5;
                        rd.endType = 14;
                    } else {
                        rd.beginType = 14;
                        rd.endType = 5;
                    }
                } else {
                    rd.endType = tcar.getValue() == 0 ? 2 : 5;
                    rd.beginType = scar.getValue() == 0 ? 2 : 5;
                }
                rd.beginOptional = rel.getOptional(0) != false;
                rd.endOptional = rel.getOptional(1).booleanValue();
            } else if (notation == 1) {
                rd.beginOptional = false;
                rd.endOptional = false;
                if (rel.isIdentifying()) {
                    if (scar.getValue() == 1 && tcar.getValue() == 1) {
                        Entity dominantEntity = rel.getDominantRole();
                        if (rel.getSourceEntity() == dominantEntity) {
                            rd.beginType = 0;
                            rd.endType = 7;
                        } else if (rel.getTargetEntity() == dominantEntity) {
                            rd.beginType = 7;
                            rd.endType = 0;
                        } else if (rel.isOptionalSource() && !rel.isOptionalTarget()) {
                            rd.beginType = 0;
                            rd.endType = 7;
                        } else if (!rel.isOptionalSource() && rel.isOptionalTarget()) {
                            rd.beginType = 7;
                            rd.endType = 0;
                        }
                    } else if (tcar.getValue() == 0) {
                        rd.beginType = 0;
                        rd.endType = 17;
                    } else {
                        rd.beginType = 17;
                        rd.endType = 0;
                    }
                } else {
                    rd.endType = tcar.getValue() == 0 ? 16 : 0;
                    rd.beginType = scar.getValue() == 0 ? 16 : 0;
                }
                rd.beginOptional = rel.getOptional(0) != false;
                rd.endOptional = rel.getOptional(1).booleanValue();
            } else if (notation == 2) {
                rd.beginOptional = false;
                rd.endOptional = false;
                rd.endType = tcar.getValue() == 0 ? (rel.getOptional(0).booleanValue() ? 19 : 17) : (rel.getOptional(0) != false ? 18 : 8);
                rd.beginType = scar.getValue() == 0 ? (rel.getOptional(1).booleanValue() ? 19 : 17) : (rel.getOptional(1) != false ? 18 : 8);
            }
            if (notation == 1) {
                rd.beginTransferable = rel.isSourceTransferable();
                rd.endTransferable = rel.isTargetTransferable();
            } else {
                rd.beginTransferable = true;
                rd.endTransferable = true;
            }
        }
        return rd;
    }

    public static class Cardinality {
        private int cardinality;
        private String representation;

        private Cardinality(int value) {
            this.cardinality = value;
            this.representation = String.valueOf(value);
        }

        private Cardinality(int value, String string) {
            this.cardinality = value;
            this.representation = string;
        }

        public String toString() {
            return this.representation;
        }

        public int getValue() {
            return this.cardinality;
        }
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = "";

        public Relation getRelation() {
            return Relation.this;
        }

        public abstract Entity getEntity();

        public abstract Entity getOtherEntity();

        public abstract Cardinality getCardinality();

        public abstract String getDescriptor();

        public abstract Connection getOtherConnection();

        public abstract boolean isSource();

        public String toString() {
            return Relation.this.getName() + this.getDescriptor();
        }

        public boolean isOneCardinality() {
            return this.getCardinality().getValue() == 1;
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean value) {
            this.optionality = value ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean value) {
            this.optionality = value == null ? Boolean.FALSE : value;
        }

        public boolean isSingleEntityRelation() {
            return this.getEntity() == this.getOtherEntity();
        }

        public void setNameOn(String name) {
            this.nameOn = name;
        }

        public TopView getTopView() {
            return Relation.this.getTopView();
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public Entity getEntity() {
            return Relation.this.getEntity(0);
        }

        @Override
        public Entity getOtherEntity() {
            return Relation.this.getEntity(1);
        }

        @Override
        public Cardinality getCardinality() {
            return Relation.this.getCardinality(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public Connection getOtherConnection() {
            return Relation.this.getTargetConnection();
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public class TargetConnection
    extends Connection {
        @Override
        public Entity getEntity() {
            return Relation.this.getEntity(1);
        }

        @Override
        public Entity getOtherEntity() {
            return Relation.this.getEntity(0);
        }

        @Override
        public Cardinality getCardinality() {
            return Relation.this.getCardinality(1);
        }

        @Override
        public String getDescriptor() {
            return "Target";
        }

        @Override
        public Connection getOtherConnection() {
            return Relation.this.getSourceConnection();
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class dpvInfo {
        public TVEntity sourceTV;
        public TVEntity targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }

    public class RelationEndsDescription {
        public int beginType = 0;
        public int endType = 0;
        public boolean beginOptional;
        public boolean endOptional;
        public boolean beginTransferable = true;
        public boolean endTransferable = true;
    }
}

