/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.Iterator;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.impact.ImpA_FKAssociation;
import oracle.dbtools.crest.model.design.impact.ImpA_KeyObject;
import oracle.dbtools.crest.model.design.impact.ImpA_Table;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_PK_UK
extends LongNameObjectSelection {
    private Index index;

    public ImpA_PK_UK(Index index, ModelIdObjectSelection parent, boolean load) {
        super(index);
        this.index = index;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addChildTables();
        this.addMappings(this);
        this.loaded = true;
    }

    private void addMappings(ImpA_PK_UK parent) {
        if (this.index.getObjectID() != null && this.index.getEngCandidateKey() != null) {
            ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_PK_UK.Mappings"));
            selection.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
            parent.addChild(selection);
            CandidateKey key = this.index.getEngCandidateKey();
            if (!selection.hasAsParent(key)) {
                selection.addChild(new ImpA_KeyObject(key, selection, false));
            } else {
                selection.addChild(new LongNameObjectSelection(key));
            }
        }
    }

    @Override
    public String toString() {
        if (this.index.isPK()) {
            return "(PK) " + this.index.getLongName();
        }
        return this.index.getLongName();
    }

    private void addChildTables() {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_PK_UK.FKsAndChildTables"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        this.addChild(selection);
        Iterator it = ((RelationalDesign)this.index.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            Table table;
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (fk.getRemoteIndex() != this.index) continue;
            if (!selection.hasAsParent(fk)) {
                ImpA_FKAssociation imp_fk = new ImpA_FKAssociation(fk, selection, false);
                selection.addChild(imp_fk);
                table = (Table)fk.getContainerWithKeyObject();
                if (!imp_fk.hasAsParent(table)) {
                    imp_fk.addChild(new ImpA_Table(table, imp_fk, false));
                    continue;
                }
                imp_fk.addChild(new ModelIdObjectSelection(table));
                continue;
            }
            LongNameObjectSelection fknode = new LongNameObjectSelection(fk);
            selection.addChild(fknode);
            table = (Table)fk.getContainerWithKeyObject();
            if (!fknode.hasAsParent(table)) {
                fknode.addChild(new ImpA_Table(table, fknode, false));
                continue;
            }
            fknode.addChild(new ModelIdObjectSelection(table));
        }
    }
}

