/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Table;

public class RelationTableComparator
extends EngPropertiesComparator {
    private Relation rel;
    private Table table;

    public RelationTableComparator(Relation rel, Table table) {
        super(rel, table);
        this.rel = rel;
        this.table = table;
        this.initPropertiesList();
    }

    public RelationTableComparator(Relation rel, Table table, List filters) {
        this(rel, table);
        this.applyCompareFilter(filters, rel.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization()) {
            this.initNameTranslationProperty();
        }
        this.initCommentsAndNotes();
    }

    @Override
    protected void initNameProperty() {
        EngPropertyHolder ph = new EngPropertyHolder(NAME);
        ph.setLeftValue(this.rel != null ? this.rel.getName() : "");
        ph.setRightValue(this.table != null ? this.table.getName() : "");
        if (this.rel != null && this.table != null && !this.rel.getName().equals(this.table.getName())) {
            if (this.getDesign().isApplyNameStandardization()) {
                String tr_name = "";
                tr_name = this.rel.getDesignPart() instanceof LogicalDesign ? this.getDesign().transformNameFromLogicalToRelational(this.rel, this.table, null) : this.getDesign().transformNameFromRelationalToLogical(this.rel);
                if (!tr_name.equals(this.table.getName())) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
    }
}

