/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.SSBErrorHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterColumn;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterMViewLog;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBArcConstraintOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCollectionType;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBContextOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCreateTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDimensionOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDirectoryOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropArcConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropColumn;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropContextOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropDimensionOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropDirectoryOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropMViewLog;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropPlSqlObjectOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSequence;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSnapshot;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSynonymOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTableView;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTriggerOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropType;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropValidTime;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBFKIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBMaterializedViewLogOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBPlSqlObjectOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBRenameTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBSequence;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBSnapshot;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBStructuredType;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBSynonymOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBTableView;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBTriggerOracle;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;

public class CompareObjectSelection
extends ModelIdObjectSelection {
    private PropertiesComparator propertiesComparator;
    private CompareObjectSelection correspondentNode;
    private JComponent dependentComponent;
    private String rname;
    private DDLGenerator dropGenerator;
    protected Map fkMap = new TreeMap();
    private DDLGenerator generator;
    public static final int TABLE_INDEX = 1;
    public static final int VIEW_INDEX = 2;
    public static final int SNAPSHOT_INDEX = 3;
    public static final int SEQUENCE_INDEX = 4;
    public static final int TABLE_COLUMN = 0;
    public static final int TABLE_INDEX_KEY = 1;
    public static final int TABLE_PK_UK = 2;
    public static final int TABLE_FK = 3;
    public static final int TABLE_CONSTRAINT = 4;
    private RelationalObjectProxy proxy;
    private String dataTypeConversion = "";
    private boolean updateDependent = true;

    public CompareObjectSelection(ModelIDObject object) {
        super(object);
    }

    public CompareObjectSelection(ModelIDObject object, boolean applySelectionImmediate) {
        super(object, applySelectionImmediate);
    }

    public CompareObjectSelection(String name) {
        super(name);
    }

    public PropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(PropertiesComparator propertiesComparator) {
        this.propertiesComparator = propertiesComparator;
    }

    public CompareObjectSelection getCorrespondentNode() {
        return this.correspondentNode;
    }

    public void setCorrespondentNode(CompareObjectSelection correspondentNode) {
        this.correspondentNode = correspondentNode;
    }

    @Override
    public ModelIdObjectSelection getCorrespondentObjectSelection() {
        return this.getCorrespondentNode();
    }

    public void applySelectionToEngineering() {
        this.applySelectionToEngineering(false);
    }

    public void applySelectionToEngineering(boolean processDeleted) {
        CompareObjectSelection co;
        if (this.getObject() != null) {
            this.getObject().setShouldMerge(this.isSelected());
        }
        int count = this.getNumberOfChildren();
        for (int i = 0; i < count; ++i) {
            CompareObjectSelection child = (CompareObjectSelection)this.getChild(i);
            child.applySelectionToEngineering(processDeleted);
        }
        if (processDeleted && 3 == this.getStatus() && (co = this.getCorrespondentNode()) != null && co.getObject() != null) {
            co.getObject().setShouldMerge(this.isSelected());
        }
    }

    public void setStatus(int status) {
        if (status == 1) {
            if (this.status != 2 && this.status != 3) {
                this.status = status;
            }
        } else {
            this.status = status;
        }
    }

    public void presetStatus(int status) {
        this.status = status;
    }

    @Override
    public boolean isModified() {
        if (this.propertiesComparator != null) {
            return this.propertiesComparator.isModified();
        }
        return false;
    }

    public boolean hasChildsWithChangeStatus() {
        for (CompareObjectSelection selob : this.childs) {
            if (!selob.isModified() && selob.getStatus() == 0) continue;
            return true;
        }
        for (CompareObjectSelection selob : this.childs) {
            if (!selob.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        for (CompareObjectSelection selob : this.childs) {
            selob.resetModifiedStatus();
            if (selob.getStatus() == 0) continue;
            this.setStatus(1);
        }
        if (this.isModified() || this.hasChildsWithChangeStatus()) {
            this.setStatus(1);
        }
    }

    @Override
    public String getName() {
        ModelIDObject object = this.getObject();
        RelationalObjectProxy pr = this.getProxy();
        if (pr != null) {
            return pr.getName();
        }
        if (object != null) {
            if (this.rname != null) {
                return this.rname;
            }
            if (object instanceof KeyObject && ((KeyObject)object).isPK()) {
                return "(PK) " + object.getName();
            }
            if (object instanceof Column) {
                return "(" + ((Column)object).getIndex() + ")" + object.getName();
            }
            return object.getName();
        }
        String nn = "";
        nn = this.rname != null ? this.rname : super.getName();
        if (this.isInSyncOperation()) {
            return nn;
        }
        return nn + " (Not synchronized)";
    }

    @Override
    public boolean setName(String name) {
        this.rname = name;
        super.setName(name);
        return true;
    }

    public JComponent getDependentComponent() {
        return this.dependentComponent;
    }

    public void setDependentComponent(JComponent dependentComponent) {
        this.dependentComponent = dependentComponent;
    }

    @Override
    public void setSelected(boolean selected) {
        boolean old = this.selected;
        super.setSelected(selected);
        if (old != selected && this.updateDependent && this.dependentComponent != null) {
            this.dependentComponent.updateUI();
        }
    }

    public void setSelected(boolean selected, boolean updateDependent) {
        boolean old = this.updateDependent;
        this.updateDependent = updateDependent;
        this.setSelected(selected);
        this.updateDependent = old;
    }

    public boolean canBeRename() {
        if (this.getPropertiesComparator() instanceof TableComparator) {
            Table targetTable = ((TableComparator)this.getPropertiesComparator()).getTargetTable();
            if (targetTable != null && targetTable.isMaterializedQueryTable()) {
                return false;
            }
            if (!this.getPropertiesComparator().hasToBeRename() && !this.isLeaf()) {
                if (this.childs.size() > 0) {
                    return this.isChangeColumnsType((CompareObjectSelection)this.childs.get(0));
                }
                return false;
            }
            return true;
        }
        if (this.getPropertiesComparator() instanceof TableViewComparator) {
            return this.getPropertiesComparator().hasToBeRename();
        }
        return this.getPropertiesComparator().hasToBeRename();
    }

    public boolean canBeRenameOnly() {
        if (this.getPropertiesComparator() instanceof TableComparator && !this.canBeRename()) {
            return this.getPropertiesComparator().hasToBeRenameOnly();
        }
        return false;
    }

    private boolean isChangeColumnsType(CompareObjectSelection parent) {
        for (CompareObjectSelection obj : parent.childs) {
            if (!(obj.getPropertiesComparator() instanceof ColumnComparator) || !((ColumnComparator)obj.getPropertiesComparator()).isRecreateTable()) continue;
            return true;
        }
        return false;
    }

    public Iterator ddlDropObjects() {
        ArrayList list = new ArrayList();
        list.addAll(this.getDropViewComparator((CompareObjectSelection)this.getChild(2)));
        if (ModelChooserDialog.isSelectedDatabase) {
            int childIndex = this.getChildIndex(ModelIdObjectSelection.DIMENSIONS);
            if (childIndex > -1) {
                list.addAll(this.getDroppedChildNodes((CompareObjectSelection)this.childs.get(childIndex)));
                list.addAll(this.getDDLModifiedChildNodes((CompareObjectSelection)this.childs.get(childIndex)));
            }
            list.addAll(this.getDroppedChildNodes((CompareObjectSelection)this.getChild(3)));
        }
        this.addDroppedChildNodes(list, ModelIdObjectSelection.MVIEW_LOGS);
        list.addAll(this.getDropTableComparator((CompareObjectSelection)this.getChild(1)));
        if (ModelChooserDialog.isSelectedDatabase) {
            this.addDroppedChildNodes(list, ModelIdObjectSelection.STORED_PROCEDURES);
            this.addDroppedChildNodes(list, ModelIdObjectSelection.FUNCTIONS);
            this.addDroppedChildNodes(list, ModelIdObjectSelection.PACKAGES);
            list.addAll(this.getDroppedChildNodes((CompareObjectSelection)this.getChild(4)));
            this.addDroppedChildNodes(list, ModelIdObjectSelection.DIRECTORIES);
            this.addDroppedChildNodes(list, ModelIdObjectSelection.CONTEXTS);
        }
        ModelObject dataTypesModelNode = this.getChild(0);
        list.addAll(this.getDroppedChildNodes((CompareObjectSelection)dataTypesModelNode.getChild(2)));
        list.addAll(this.getDroppedChildNodes((CompareObjectSelection)dataTypesModelNode.getChild(1)));
        if (ModelChooserDialog.isSelectedDatabase) {
            this.addDroppedChildNodes(list, ModelIdObjectSelection.SYNONYMS);
        }
        return list.iterator();
    }

    private void addDroppedChildNodes(List list, String nodeText) {
        int childIndex = this.getChildIndex(nodeText);
        if (childIndex > -1) {
            list.addAll(this.getDroppedChildNodes((CompareObjectSelection)this.childs.get(childIndex)));
        }
    }

    private List getDroppedChildNodes(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = null;
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!obj.isSelected() || !obj.canBeDrop()) continue;
                if (list == null) {
                    list = new ArrayList<CompareObjectSelection>();
                }
                list.add(obj);
            }
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    private List getDDLModifiedChildNodes(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = null;
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!obj.isSelected() || obj.canBeDrop() || obj.canBeCreate() || !obj.isDDLModified() && !obj.hasDDLModifiedChildren()) continue;
                if (list == null) {
                    list = new ArrayList<CompareObjectSelection>();
                }
                list.add(obj);
            }
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    private List getDropViewComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        for (CompareObjectSelection obj : parent.childs) {
            if (!obj.isSelected()) continue;
            if (obj.canBeDrop() || obj.canBeRename()) {
                TableView tv;
                boolean add = true;
                CompareObjectSelection tsel = obj.getCorrespondentNode();
                if (tsel != null && (tv = (TableView)tsel.getObject()) != null && tv.getAllInds_PK_UK_NoFKeys().size() == 0) {
                    add = false;
                }
                if (!add) continue;
                list.add(obj);
                continue;
            }
            this.getChildsToBeDrop(list, obj);
        }
        return list;
    }

    private List getDropTableComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!(obj.getPropertiesComparator() instanceof TableComparator) || !obj.isSelected()) continue;
                if (obj.canBeDrop()) {
                    list.add(obj);
                    continue;
                }
                if (obj.canBeRename()) continue;
                this.getChildsToBeDrop(list, obj);
            }
        }
        return list;
    }

    private void getChildsToBeDrop(List list, CompareObjectSelection obj) {
        for (CompareObjectSelection object : obj.childs) {
            if (!object.isSelected()) continue;
            if (object.canBeDrop()) {
                list.add(object);
                continue;
            }
            this.getChildsToBeDrop(list, object);
        }
    }

    public List getListOfDDLObjects() {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (ModelChooserDialog.isSelectedDatabase) {
            this.addSelectedChildNodes(list, ModelIdObjectSelection.SYNONYMS);
        }
        ModelObject dataTypesModelNode = this.getChild(0);
        list.addAll(this.getSelectedChildNodes((CompareObjectSelection)dataTypesModelNode.getChild(1)));
        list.addAll(this.getSelectedChildNodes((CompareObjectSelection)dataTypesModelNode.getChild(2)));
        if (ModelChooserDialog.isSelectedDatabase) {
            this.addSelectedChildNodes(list, ModelIdObjectSelection.CONTEXTS);
            this.addSelectedChildNodes(list, ModelIdObjectSelection.DIRECTORIES);
            list.addAll(this.getSelectedChildNodes((CompareObjectSelection)this.getChild(4)));
            this.addSelectedChildNodes(list, ModelIdObjectSelection.MVIEW_LOGS);
            this.addSelectedChildNodes(list, ModelIdObjectSelection.PACKAGES);
            this.addSelectedChildNodes(list, ModelIdObjectSelection.FUNCTIONS);
            this.addSelectedChildNodes(list, ModelIdObjectSelection.STORED_PROCEDURES);
        }
        list.addAll(this.getTableComparator((CompareObjectSelection)this.getChild(1)));
        list.addAll(this.getSelectedObjectsForTables((CompareObjectSelection)this.getChild(1)));
        if (ModelChooserDialog.isSelectedDatabase) {
            list.addAll(((CompareObjectSelection)this.getChild(3)).getChilds());
        }
        list.addAll(this.getTableViewComparator((CompareObjectSelection)this.getChild(2)));
        list.addAll(this.getFKComparator((CompareObjectSelection)this.getChild(1)));
        if (ModelChooserDialog.isSelectedDatabase) {
            this.addSelectedChildNodes(list, ModelIdObjectSelection.DIMENSIONS);
        }
        return list;
    }

    private void addSelectedChildNodes(List list, String nodeText) {
        int childIndex = this.getChildIndex(nodeText);
        if (childIndex > -1) {
            list.addAll(this.getSelectedChildNodes((CompareObjectSelection)this.childs.get(childIndex)));
        }
    }

    private List getSelectedChildNodes(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = null;
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!obj.isSelected() || obj.canBeDrop()) continue;
                if (list == null) {
                    list = new ArrayList<CompareObjectSelection>();
                }
                list.add(obj);
            }
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    private List<CompareObjectSelection> getTableViewComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            ArrayList<CompareObjectSelection> fkList = null;
            for (CompareObjectSelection view : parent.childs) {
                boolean viewAdded = false;
                boolean canBeRename = view.canBeRename();
                if (!view.isSelected() || view.canBeDrop()) continue;
                if (view.isDDLModified()) {
                    list.add(view);
                    viewAdded = true;
                }
                int numberOfChildren = view.getNumberOfChildren();
                block1: for (int index = 0; index < numberOfChildren; ++index) {
                    CompareObjectSelection viewChild = (CompareObjectSelection)view.getChild(index);
                    for (CompareObjectSelection chObj : viewChild.childs) {
                        if (canBeRename) {
                            if (!viewChild.getName().equals(CompareModelToModel.FOREIGN_KEYS) || 3 == chObj.getStatus()) continue;
                            if (fkList == null) {
                                fkList = new ArrayList<CompareObjectSelection>();
                            }
                            fkList.add(chObj);
                            continue;
                        }
                        if (!chObj.isSelected() || chObj.canBeDrop()) continue;
                        if (viewChild.getName().equals(CompareModelToModel.FOREIGN_KEYS)) {
                            if (fkList == null) {
                                fkList = new ArrayList();
                            }
                            fkList.add(chObj);
                            continue;
                        }
                        if ("Columns".equalsIgnoreCase(viewChild.getType()) && chObj.isDDLModified()) {
                            if (viewAdded) continue block1;
                            list.add(view);
                            continue block1;
                        }
                        list.add(chObj);
                    }
                }
            }
            if (fkList != null) {
                list.addAll(fkList);
            }
        }
        return list;
    }

    private List getFKComparator(CompareObjectSelection parent) {
        ArrayList list = new ArrayList();
        if (parent != null) {
            for (CompareObjectSelection table : parent.childs) {
                if (table.getNumberOfChildren() <= 3) continue;
                CompareObjectSelection fkchild = (CompareObjectSelection)table.getChild(3);
                Iterator fkIt = fkchild.childs.iterator();
                while (fkIt.hasNext()) {
                    list.add(fkIt.next());
                }
            }
        }
        return list;
    }

    private List getTableComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                ModelIDObject sourceTable;
                PropertiesComparator propsComp = obj.getPropertiesComparator();
                if (!(propsComp instanceof TableComparator)) continue;
                ((TableComparator)propsComp).setSnapshotDropped(false);
                if (!obj.isSelected() || obj.canBeDrop() || !((sourceTable = obj.getObject()) instanceof Table) || ((Table)sourceTable).isMaterializedQueryTable() && !((Table)sourceTable).isOnPrebuiltTable()) continue;
                list.add(obj);
            }
        }
        return list;
    }

    private List getSelectedObjectsForTables(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection table : parent.childs) {
                ModelIDObject sourceTable;
                if (!table.isSelected() || !((sourceTable = table.getObject()) instanceof Table) || ((Table)sourceTable).isMaterializedQueryTable() && !((Table)sourceTable).isOnPrebuiltTable()) continue;
                if (table.canBeCreate()) {
                    int triggersIndex = table.getChildIndex(ModelIdObjectSelection.TRIGGERS);
                    if (triggersIndex <= -1) continue;
                    list.addAll(this.getSelectedChildNodes((CompareObjectSelection)table.childs.get(triggersIndex)));
                    continue;
                }
                if (table.canBeRename()) continue;
                int numberOfChildren = table.getNumberOfChildren();
                for (int index = 0; index < numberOfChildren; ++index) {
                    if (index == 3) continue;
                    CompareObjectSelection colchild = (CompareObjectSelection)table.getChild(index);
                    for (CompareObjectSelection chobj : colchild.childs) {
                        if (!chobj.isSelected() || chobj.canBeDrop() || !chobj.canBeCreate() && !chobj.isDDLModified()) continue;
                        list.add(chobj);
                    }
                }
            }
        }
        return list;
    }

    public boolean canBeDrop() {
        return this.getPropertiesComparator().hasToBeDrop();
    }

    public boolean canBeCreate() {
        return this.getStatus() == 2;
    }

    public void removeDDLObjects() {
        this.fkMap.clear();
    }

    public DDLGenerator getDDLDropGenerator(StorageDesign storageDesign) {
        if (this.dropGenerator == null) {
            this.dropGenerator = this.createDDLDropGenerator(storageDesign);
            this.dropGenerator.setLabel("DropGen");
            this.dropGenerator.append(SSBErrorHandler.getInstance());
        }
        return this.dropGenerator;
    }

    protected DDLGenerator createDDLDropGenerator(StorageDesign storageDesign) {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific(storageDesign);
        ddlGenerator.append(new CSSBDropTable());
        ddlGenerator.append(new CSSBDropTableView());
        ddlGenerator.append(new CSSBDropTableConstraint());
        ddlGenerator.append(new CSSBDropIndex(this.fkMap));
        ddlGenerator.append(new CSSBDropColumn());
        ddlGenerator.append(new CSSBDropValidTime());
        ddlGenerator.append(new CSSBDropSnapshot());
        ddlGenerator.append(new CSSBDropMViewLog());
        ddlGenerator.append(new CSSBDropSequence());
        ddlGenerator.append(new CSSBDropTriggerOracle());
        ddlGenerator.append(new CSSBDropPlSqlObjectOracle());
        ddlGenerator.append(new CSSBDropType());
        ddlGenerator.append(new CSSBDropSynonymOracle());
        ddlGenerator.append(new CSSBDropDimensionOracle());
        ddlGenerator.append(new CSSBDropDirectoryOracle());
        ddlGenerator.append(new CSSBDropContextOracle());
        ddlGenerator.append(new CSSBDropArcConstraint());
        return ddlGenerator;
    }

    public DDLGenerator getDDLGenerator(StorageDesign storageDesign) {
        if (this.generator == null) {
            this.generator = this.createDDLGenerator(storageDesign);
            this.generator.append(SSBErrorHandler.getInstance());
        }
        return this.generator;
    }

    protected DDLGenerator createDDLGenerator(StorageDesign storageDesign) {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific(storageDesign);
        CSSBCreateTable cssbCreateTable = new CSSBCreateTable();
        ddlGenerator.append(cssbCreateTable);
        ddlGenerator.append(new CSSBRenameTable(this.fkMap));
        ddlGenerator.append(new CSSBAlterTable());
        ddlGenerator.append(new CSSBAlterIndex(this.fkMap));
        ddlGenerator.append(new CSSBAlterColumn());
        ddlGenerator.append(new CSSBAlterTableConstraint());
        ddlGenerator.append(new CSSBFKIndex(this.fkMap));
        ddlGenerator.append(new CSSBSnapshot(cssbCreateTable));
        ddlGenerator.append(new CSSBMaterializedViewLogOracle());
        ddlGenerator.append(new CSSBAlterMViewLog());
        ddlGenerator.append(new CSSBSequence());
        ddlGenerator.append(new CSSBTableView());
        ddlGenerator.append(new CSSBTriggerOracle());
        ddlGenerator.append(new CSSBPlSqlObjectOracle());
        ddlGenerator.append(new CSSBStructuredType());
        ddlGenerator.append(new CSSBCollectionType());
        ddlGenerator.append(new CSSBSynonymOracle());
        ddlGenerator.append(new CSSBDimensionOracle());
        ddlGenerator.append(new CSSBDirectoryOracle());
        ddlGenerator.append(new CSSBContextOracle());
        ddlGenerator.append(new CSSBArcConstraintOracle());
        return ddlGenerator;
    }

    public List getObjectsForRestore(int index) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (this.getNumberOfChildren() > index) {
            CompareObjectSelection object = (CompareObjectSelection)this.childs.get(index);
            for (CompareObjectSelection childObj : object.childs) {
                if (!childObj.canBeDrop() || childObj.isSelected()) continue;
                list.add(childObj.getCorrespondentNode());
            }
        }
        return list;
    }

    public List getChildObjects(int index) {
        ArrayList list = new ArrayList();
        if (this.getNumberOfChildren() > index) {
            CompareObjectSelection object = (CompareObjectSelection)this.childs.get(index);
            list.addAll(object.childs);
        }
        return list;
    }

    public void setObject(ModelIDObject object) {
        this.object = object;
        this.elDescriptor = object.getClass();
    }

    public CompareObjectSelection getChild(Object object) {
        for (CompareObjectSelection obj : this.childs) {
            if (obj.getObject() != object) continue;
            return obj;
        }
        return null;
    }

    public CompareObjectSelection getChildNested(Object object, int level) {
        int nlevel = level - 1;
        if (nlevel >= 0) {
            if (this.getObject() == object) {
                return this;
            }
            for (CompareObjectSelection obj : this.childs) {
                CompareObjectSelection nobj;
                if (obj.getObject() == object) {
                    return obj;
                }
                if (nlevel <= 0 || (nobj = obj.getChildNested(object, nlevel)) == null || nobj.getObject() != object) continue;
                return nobj;
            }
        }
        return null;
    }

    public int getChildIndex(String text) {
        int numberOfChildren = this.childs.size();
        for (int i = 0; i < numberOfChildren; ++i) {
            CompareObjectSelection child = (CompareObjectSelection)this.childs.get(i);
            if (!child.getName().equals(text)) continue;
            return i;
        }
        return -1;
    }

    public String getChoosedPropertyValue(String propertyName) {
        return this.getPropertiesComparator().getChoosedPropertyValue(propertyName);
    }

    public boolean isTargetSelected(String propertyName) {
        return this.getPropertiesComparator().isTargetSelected(propertyName);
    }

    public String getChoosedPropertyValue(String propertyName, boolean selected) {
        return this.getPropertiesComparator().getChoosedPropertyValue(propertyName, selected);
    }

    public String getMergedProperty(String propName) {
        EngPropertyHolder ph = this.getPropertiesComparator().getPropertyHolderByName(propName);
        String prop = ph.isSelected() ? ph.getLeftValue() : ph.getRightValue();
        return prop;
    }

    public CompareObjectSelection getTableNode() {
        if (this.getParent() != null) {
            return (CompareObjectSelection)((ModelObject)this.getParent()).getParent();
        }
        return null;
    }

    public boolean isDDLModified() {
        return this.getPropertiesComparator().isDDLModified();
    }

    public boolean hasDDLModifiedChildren() {
        for (CompareObjectSelection selob : this.childs) {
            if (!selob.isSelected()) continue;
            if (selob.canBeCreate() || selob.canBeDrop()) {
                return true;
            }
            PropertiesComparator propsComparator = selob.getPropertiesComparator();
            if ((propsComparator == null || !propsComparator.isDDLModified()) && !selob.hasDDLModifiedChildren()) continue;
            return true;
        }
        return false;
    }

    public String getDataTypeConversion() {
        return this.dataTypeConversion;
    }

    public void setDataTypeConversion(String dataTypeConversion) {
        this.dataTypeConversion = dataTypeConversion;
    }

    @Override
    public String getLongName() {
        if (this.getObject() != null) {
            return this.getObject().getLongName();
        }
        return this.getName();
    }

    @Override
    public boolean isFiltered(List filters) {
        for (Integer filter : filters) {
            if (filter.intValue() != this.getStatus() || this.getObject() == null && EngFilter.STATE_MODIFIED_FILTER.intValue() == filter.intValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFilteredChilds(List filters) {
        for (CompareObjectSelection object : this.getChilds()) {
            if (!object.isFiltered(filters) && !object.hasFilteredChilds(filters)) continue;
            return true;
        }
        return false;
    }

    public RelationalObjectProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(RelationalObjectProxy proxy) {
        this.proxy = proxy;
    }
}

