/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.GlobalSearchDockable;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.GeneralStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.git.DMGITNavigatorContextMenu;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ChangeRequestSet;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.TSDPPolicy;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DLDomains;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.RLDomains;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.constraint.ConstraintSet;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.engineering.AttributeColumnComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EntViewTableViewComparator;
import oracle.dbtools.crest.model.design.engineering.EntityTableComparator;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.engineering.KeyIndexComparator;
import oracle.dbtools.crest.model.design.engineering.RelationFKComparator;
import oracle.dbtools.crest.model.design.engineering.RelationTableComparator;
import oracle.dbtools.crest.model.design.engineering.ReverseEngineering;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesignSet;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesignFactory;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.model.design.undo.DP_UndoManager;
import oracle.dbtools.crest.model.metadata.NewObjectIDPropertiesPair;
import oracle.dbtools.crest.model.metadata.SVNDMPropertiesManager;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.xml.RXMLDefaultRDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.xml.WXMLRelationalDesign;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DMDOpenObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.OpenDesignDialog;
import oracle.dbtools.crest.swingui.OpenDesignDialogPersistence;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.swingui.editor.DesignPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.UDPLibrariesPersistence;
import oracle.dbtools.crest.swingui.editor.UDPLibrary;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.engineeringcompare.EngineeringCompareDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.search.GlobalSearchPanel;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSEvent;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.util.browser.DefaultBrowsable;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.RevisionInfoListener;
import org.netbeans.libs.git.progress.StatusListener;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Design
extends ModelIDObject
implements ModelObjectSetListener,
NamingConstants {
    public static final String TYPE_NAME = "Design";
    public static final int CURRENT_OPERATION_NONE = -1;
    public static final int CURRENT_OPERATION_OPEN = 1;
    public static final int CURRENT_OPERATION_CLOSE = 2;
    public static final int CURRENT_OPERATION_SAVE = 3;
    public static final int CURRENT_OPERATION_SAVE_AS = 4;
    public static final int CURRENT_OPERATION_EXPORT_TO = 5;
    private static final String SYSTEM_DESIGN = "System";
    public static final String ENTITY_TABLE = Messages.getString("Design.EntityTable");
    public static final String ATTRIBUTE_COLUMN = Messages.getString("Design.AttributeColumn");
    public static final String KEY_INDEX = Messages.getString("Design.KeyIndex");
    public static final String RELATION_FK = Messages.getString("Design.RelationForeignkey");
    public static final String RELATION_TABLE = Messages.getString("Design.RelationTable");
    public static final String ENTVIEW_TBLVIEW = Messages.getString("Design.EntityViewView");
    public static final String DOMAINS = Messages.getString("Design.Domains");
    public static boolean USE_DROP_DEPENDENCY = true;
    public static boolean DROP_GENERATED_OBJECTS_ONLY = true;
    private LogicalDesign logicalDesign;
    private BusinessInfoDesign businessInfoDesign;
    private RelationalDesign relationalDesign;
    private ProcessModel processModel;
    private DataTypesDesign dataTypesDesign;
    private MultidimensionalDesign multidimensionalDesign;
    private LogicalDatatypeSet logicalDatatypeSet;
    private String fileName;
    private String exportFileName = "";
    private final Set listeners = new HashSet();
    private boolean readOnly = false;
    private DomainSet domainSet;
    private ConstraintSet constraintSet;
    private FWDEngineering fwdEngineering;
    private ReverseEngineering revEngineering;
    private Set importedDesigns = null;
    private final Map idMap = new TreeMap();
    private final Map fkMap = new TreeMap();
    private ChangeRequestSet changeRequestSet;
    private RelationalDesignSet pdesignSet;
    private MultidimensionalDesignSet mddSet;
    private boolean engineerCoordinates = true;
    private boolean engineerAsSubView = false;
    private String defDateFormat = "YYYY/MM/DD HH24:MI:SS";
    private String defTimestampFormat = "YYYY/MM/DD HH24:MI:SS.FF";
    private String defTimestampWTZFormat = "YYYY/MM/DD HH24:MI:SS.FFTZH:TZM";
    private String engDateFormat = "YYYY/MM/DD HH24:MI:SS";
    private String engTimestampFormat = "YYYY/MM/DD HH24:MI:SS.FF";
    private String engTimestampWTZFormat = "YYYY/MM/DD HH24:MI:SS.FFTZH:TZM";
    private boolean propagatePKChahges = true;
    private boolean showEngineeringInTree = false;
    private boolean showMappingsInEngineeringDialog = true;
    private boolean engineerGenerated = false;
    private boolean replaceSpaces = false;
    private boolean capitalNames = false;
    private boolean deleteWithoutOrigin = false;
    private boolean cleaning = false;
    private final Collection loadedRelDesIDs = new ArrayList();
    private Collection domainFileNames;
    private boolean disableTreeUpdate = false;
    private float loadedVersion = 3.5f;
    private boolean importToCurrent = false;
    private ExtendedMap extendedMap;
    private boolean applyNameSubstitution = false;
    private String unloadDirectory = "";
    private final Map dpvs = new TreeMap();
    private List diagramViews = new ArrayList();
    private int currentOperation = -1;
    private List entTablePropertyList;
    private List attrColPropertyList;
    private List keyIdxPropertyList;
    private List relFKPropertyList;
    private List relTablePropertyList;
    private List viewPropertyList;
    private boolean applyNameStandardization = true;
    private boolean usePreferredAbbreviation = true;
    private boolean saveDefaultDomains = false;
    private final List exportedDesignParts = new ArrayList();
    private final Map expDesPartsMap = new TreeMap();
    private final Map expPartialDesPartsMap = new TreeMap();
    private final Map expDesObjectsMap = new TreeMap();
    private final Map expDPVMap = new TreeMap();
    public static boolean OPEN_FAILED = false;
    private boolean showSelPropsOnly = true;
    private boolean notForNewObjects = true;
    private boolean excludeFromTree = false;
    private DP_UndoManager undoManager = new DP_UndoManager();
    private RLDomains rlDomains;
    private DLDomains dlDomains;
    private TreeMap repositoryMap = new TreeMap();
    private TreeMap localDPMap = new TreeMap();
    private boolean loadFromDB = false;
    private boolean merging = false;
    private ApplicationView appView;
    private RDBMSSiteSet rdbmsSiteSet = null;
    private static RDBMSTypeSet defauttRdbmsTypeSet;
    private boolean newDesign;
    private Design oldDesign = null;
    private String oldDesignPath = null;
    private boolean modelListChanged = false;
    private boolean oldRepositoryType = false;
    private boolean changeRequestListChanged = false;
    private boolean sensitiveTypeChanged = false;
    private boolean compressedDesign = false;
    private boolean svnVersioned;
    private Map f2tMap = null;
    private String designPath = "";
    private String exportDesignPath = "";
    private Map correspondenceMap;
    private boolean designLevelSettingsChanged = false;
    private NamingStandardRule namingRule;
    private List tempProxiesToDelete = new ArrayList();
    private List proxiesToDelete = new ArrayList();
    private TreeMap<String, String> changeRequestsMap = new TreeMap();
    private DesignPartView selectedSubView = null;
    private DockStation dockStation = null;
    private List designStorageDescriptors = new ArrayList();
    private DesignObjectCollection stSet;
    private DesignObjectCollection tsdpPolicySet;
    private DesignLevelSettings designLevelSettings;
    private File additionalFilesDirectory;
    UDPLibrariesPersistence udpLibrariesPersistence;
    private List<UDPLibrary> userDefinedLibraries = new ArrayList<UDPLibrary>();
    public static int PERS_MODEL_IN_ONE_FILE;
    public static int PERS_MODEL_IN_MANY_FILES;
    public static int PERS_MODEL_MIXED_MODE;
    private int modelPersistence = PERS_MODEL_IN_MANY_FILES;
    private int loadedModelPersistence = PERS_MODEL_IN_MANY_FILES;
    public static String PCHOICE_MODEL_IN_MANY_FILES;
    public static String PCHOICE_MODEL_IN_ONE_FILE;
    public static String PCHOICE_MODEL_MIXED_MODE;
    public static String[] PESITENCE_CHOICES;
    public static String[] PESITENCE_CHOICES_VERSIONED;
    private List oldNotesDPVs = new ArrayList();
    private boolean hidden = false;
    private boolean singleObjectRefresh = true;
    public final Map<String, SVNObjectHelper> svnOHMap = new HashMap<String, SVNObjectHelper>();
    private final TreeMap<String, List> comparatorFilterListMap = new TreeMap();
    private final TreeMap<String, List> dynamicPropsFilterListMap = new TreeMap();
    protected Map<SVNUrl, SVNStatusAndPropertiesPair> svnPropertiesCache;
    protected Map<SVNUrl, SVNStatusAndPropertiesPair> svnRemotePropertiesCache;
    protected Map<String, String> svnDMPropertiesCache;
    protected List<StorableObjectStatus> statuses = null;
    private Map<String, Map> localObjectFilesMap;
    protected List<NewObjectIDPropertiesPair> newObjectsList = new ArrayList<NewObjectIDPropertiesPair>();
    public Document lastAddedObjectsFileHEADRevDoc = null;
    private boolean allAddedObjectsFileDocChanged = false;
    private boolean gitVersioned = false;
    private String gitRepositoryPath = "";
    private static final Logger LOGGER;
    boolean closing = false;
    private Workspace workspace;
    Map<String, Icon> icons = new HashMap<String, Icon>();
    Map<String, String> modelINamdMap = null;
    DelegateListener delegateListener = null;

    public Design(ApplicationView appView) {
        this(appView, null, false);
    }

    public Design(ApplicationView appView, Design oldDesign) {
        this(appView, null, false);
    }

    public Design(ApplicationView appView, Design oldDesign, boolean hidden) {
        this.appView = appView;
        this.oldDesign = oldDesign;
        this.hidden = hidden;
        this.newDesign = true;
        this.svnPropertiesCache = new HashMap<SVNUrl, SVNStatusAndPropertiesPair>();
        this.svnDMPropertiesCache = new HashMap<String, String>();
        this.createRelationalDesignSet();
        this.createMDDSet();
        this.rlDomains = new RLDomains(this);
        this.dlDomains = new DLDomains(this);
        this.setDesignID(new GUID().toString());
        this.setDesign(this);
        this.createSensitiveTypeSet();
        this.createTSDPPolicySet();
    }

    private void createSensitiveTypeSet() {
        this.stSet = new DesignObjectCollection();
        this.stSet.setDesign(this.getDesign());
        this.stSet.setName(Messages.getString("Design.SensitiveTypes"));
        this.stSet.setParent(this);
        this.stSet.setElementDescriptor(SensitiveType.class);
        Iterator it = this.getAppView().getSensitiveTypeSet().iterator();
        while (it.hasNext()) {
            this.stSet.add((ModelIDObject)it.next());
        }
        this.getAppView().getSensitiveTypeSet().addSetListener(this);
    }

    private void createTSDPPolicySet() {
        this.tsdpPolicySet = new DesignObjectCollection();
        this.tsdpPolicySet.setDesign(this.getDesign());
        this.tsdpPolicySet.setName(Messages.getString("Design.TSDPPolicies"));
        this.tsdpPolicySet.setParent(this);
        this.tsdpPolicySet.setElementDescriptor(TSDPPolicy.class);
        Iterator it = this.getAppView().getTSDPPolicySet().iterator();
        while (it.hasNext()) {
            this.tsdpPolicySet.add((ModelIDObject)it.next());
        }
        this.getAppView().getTSDPPolicySet().addSetListener(this);
    }

    public static final String getRelationalModelsSetName() {
        return Messages.getString("Design.RelationalModels");
    }

    public static final String getMultidimensionalDesignSetName() {
        return Messages.getString("Design.MultidimensionalModels");
    }

    private void createRelationalDesignSet() {
        this.pdesignSet = new RelationalDesignSet(this);
        this.pdesignSet.setName(Design.getRelationalModelsSetName());
        this.pdesignSet.setElementDescriptor(RelationalDesign.class);
        this.pdesignSet.setDesign(this);
        this.pdesignSet.setParent(this);
    }

    private void createMDDSet() {
        this.mddSet = new MultidimensionalDesignSet(this);
        this.mddSet.setName(Design.getMultidimensionalDesignSetName());
        this.mddSet.setElementDescriptor(MultidimensionalDesign.class);
        this.pdesignSet.setDesign(this);
        this.mddSet.setParent(this);
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
    }

    public void addDiagramView(DiagramView dv) {
        if (!this.diagramViews.contains(dv)) {
            this.diagramViews.add(dv);
        }
    }

    public void clearAll(boolean showDiagrams) {
        this.removeDeletedProxies();
        AbstractRepositoryManager rman = this.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        if (rman.isConnected()) {
            try {
                rman.getConnection().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLoadFromDB(false);
        ApplicationView.IS_VIEWER = ApplicationView.BACK_UP_IS_VIEWER;
        ApplicationView.LOGICAL_MODEL_ONLY = ApplicationView.BACK_UP_LOGICAL_MODEL_ONLY;
        this.getAppView().getController().updateMenus();
        this.getAppView().getController().updateToolbar();
        this.getAppView().updateActions();
        this.clearDesign(showDiagrams);
        this.tempProxiesToDelete.clear();
        if (this.relationalDesign != null) {
            this.relationalDesign.closeStorageDesigns();
        }
        this.diagramViews.clear();
    }

    public void removeDeletedProxies() {
        try {
            if (!this.proxiesToDelete.isEmpty()) {
                ArrayList files = new ArrayList();
                for (RelationalDesign relDesign : this.getRelationalDesigns()) {
                    files.addAll(this.findFiles(new File(relDesign.getStoragePath(), "phys")));
                }
                if (Extension.isUsingVersioningFunctionality() && files.size() > 0) {
                    if (this.isSVNVersioned()) {
                        SVNClientHelper.getInstance().doRemove(files.toArray(new File[0]));
                    } else if (this.isGitVersioned()) {
                        GitClientHelper.doRemove(files.toArray(new File[0]));
                    } else {
                        for (File file : files) {
                            try {
                                file.delete();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to delete file: " + file.getAbsolutePath(), e);
                            }
                        }
                    }
                } else {
                    for (File file : files) {
                        try {
                            file.delete();
                        }
                        catch (Exception e) {
                            LOGGER.error("Unable to delete file: " + file.getAbsolutePath(), e);
                        }
                    }
                }
                this.proxiesToDelete.clear();
            }
            this.tempProxiesToDelete.clear();
        }
        catch (Exception e) {
            LOGGER.error("Unable to remove deleted proxies", e);
        }
    }

    private List findFiles(File root) {
        File[] files;
        ArrayList<File> result = new ArrayList<File>();
        if (root != null && root.exists() && (files = root.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isFile()) {
                    String fileName = FileUtils.removeExt(file.getName());
                    if (!this.proxiesToDelete.contains(fileName)) continue;
                    result.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                result.addAll(this.findFiles(file));
            }
        }
        return result;
    }

    public void clearDesign(boolean showDiagrams) {
        int i;
        this.closing = true;
        this.getExportedDesignParts().clear();
        this.getExtendedMap().clearMappings();
        this.getChangeRequestSet().removeAll();
        for (i = this.pdesignSet.size() - 1; i >= 0; --i) {
            RelationalDesign pd = (RelationalDesign)this.pdesignSet.getElement(i);
            pd.clearDesignPart();
            this.pdesignSet.remove(pd);
            this.removeDesignPartView(pd.getMainView());
            pd.removeDesignPartListener(this.getExtendedMap());
        }
        this.pdesignSet.resetCounter();
        this.setRelationalDesign(null);
        for (i = this.mddSet.size() - 1; i >= 0; --i) {
            MultidimensionalDesign mdd = (MultidimensionalDesign)this.mddSet.getElement(i);
            mdd.clearDesignPart();
            this.mddSet.remove(mdd);
            this.removeDesignPartView(mdd.getMainView());
            mdd.removeDesignPartListener(this.getExtendedMap());
        }
        this.mddSet.resetCounter();
        this.setMultidimensionalDesign(null);
        this.getProcessModel().clearDesignPart();
        this.getLogicalDesign().clearDesignPart();
        this.getBusinessInfoDesign().clearAll();
        Design.clearMap(this.idMap);
        Design.clearMap(this.fkMap);
        this.setName("");
        this.setFileName(this.getAppView().getDesigns().createName(false));
        this.getDomainSet().removeAll();
        this.getLogicalDatatypeSet().removeAll();
        this.getDataTypesDesign().clearDesignPart();
        this.getRDBMSSiteSet().setLoadFromRepository(false);
        this.getSVNObjectHelperMap().clear();
        this.getSVNPropertiesCache().clear();
        this.getSVNPropertiesCache(true).clear();
        this.getSVNDMPropertiesCache().clear();
        this.getLocalObjectFilesMap().clear();
        this.resetRDBMSSites();
        this.closing = false;
        this.getAppView().clearTree();
        this.loadedRelDesIDs.clear();
        this.getAppView().getIDGenerator().setCounter(0L);
        this.icons.clear();
        if (this.modelINamdMap != null) {
            this.modelINamdMap.clear();
        }
        this.modelINamdMap = null;
        if (this.delegateListener != null) {
            this.delegateListener.setDesign(null);
            this.delegateListener = null;
        }
        System.gc();
        if (showDiagrams) {
            this.getAppView().getPersistenceManager().readSystemInit(this);
            this.getLogicalDesign().setMainViewVisible(true);
            this.getRelationalDesign().setMainViewVisible(true);
        }
        this.setSaveDefaultDomains(false);
        this.getLogicalDesign().setDirty(false);
        this.getRelationalDesign().setDirty(false);
        this.getDataTypesDesign().setDirty(false);
        this.clearCompareLists();
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
        this.setCheckedOut(false);
        this.setCheckedOutByMe(false);
        this.setCheckedOutBy("");
        this.undoManager.discardAllEdits();
        this.setObjectID(new GUID().toString());
    }

    public String getRDBMS() {
        return this.getRelationalDesign().getRDBMS();
    }

    @Override
    public String getName() {
        if (this.currentOperation == 5) {
            return this.exportFileName;
        }
        return super.getName();
    }

    public String getFileName() {
        if (this.currentOperation == 5) {
            return this.exportFileName;
        }
        if (this.fileName == null) {
            this.fileName = this.getName();
        }
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (SYSTEM_DESIGN.equalsIgnoreCase(fileName)) {
            this.fileName = SYSTEM_DESIGN;
        } else {
            if (this.isNewDesign()) {
                this.setDirty(true);
            }
            this.fileName = fileName;
        }
        this.setName(fileName);
        if (ApplicationView.GUIMode) {
            this.fireNameChange();
        }
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String fileName) {
        this.exportFileName = fileName;
    }

    public boolean isSystem() {
        return SYSTEM_DESIGN.equalsIgnoreCase(this.getFileName());
    }

    public ConstraintSet getConstraintSet() {
        if (this.constraintSet == null) {
            this.constraintSet = new ConstraintSet();
            this.constraintSet.setDesign(this);
            this.constraintSet.setParent(this);
        }
        return this.constraintSet;
    }

    public DomainSet getDomainSet() {
        if (this.domainSet == null) {
            this.domainSet = new DomainSet(this.getLogicalDesign());
            this.domainSet.setDesign(this);
            this.domainSet.setName(DOMAINS);
            this.domainSet.createUnknownDomain();
            this.domainSet.setParent(this);
        }
        return this.domainSet;
    }

    public Domain getLoadDomain(String id, String fName) {
        Domain domain = (Domain)this.getDomainSet().getObjectByID(id);
        if (null == domain) {
            this.getDomainSet().loadDomainFile(fName);
            domain = (Domain)this.getDomainSet().getObjectByID(id);
        }
        return domain;
    }

    public LogicalDatatypeSet getLogicalDatatypeSet() {
        if (this.logicalDatatypeSet == null) {
            this.logicalDatatypeSet = new LogicalDatatypeSet(this.getLogicalDesign());
            this.logicalDatatypeSet.setDesign(this);
            this.logicalDatatypeSet.createUnknownType();
            this.logicalDatatypeSet.setParent(this);
        }
        return this.logicalDatatypeSet;
    }

    public LogicalDesign getLogicalDesign() {
        if (this.logicalDesign == null) {
            this.logicalDesign = new LogicalDesign();
            this.logicalDesign.setObjectID(new GUID().toString());
            this.logicalDesign.setDesign(this);
            this.logicalDesign.setParent(this);
            this.logicalDesign.setName(Messages.getString("Design.LogicalModel"));
            this.logicalDesign.addDesignPartListener(this.getExtendedMap());
        }
        return this.logicalDesign;
    }

    public BusinessInfoDesign getBusinessInfoDesign() {
        if (this.businessInfoDesign == null) {
            this.businessInfoDesign = new BusinessInfoDesign(this);
            this.businessInfoDesign.setObjectID(new GUID().toString());
            this.businessInfoDesign.setDesign(this);
            this.businessInfoDesign.setName(Messages.getString("Design.BusinessInformation"));
            this.businessInfoDesign.setParent(this);
        }
        return this.businessInfoDesign;
    }

    public DataTypesDesign getDataTypesDesign() {
        if (this.dataTypesDesign == null) {
            this.dataTypesDesign = new DataTypesDesign();
            this.dataTypesDesign.setObjectID(new GUID().toString());
            this.dataTypesDesign.setDesign(this);
            this.dataTypesDesign.setName(Messages.getString("Design.DataTypes"));
            this.dataTypesDesign.setParent(this);
        }
        return this.dataTypesDesign;
    }

    public ProcessModel getProcessModel() {
        if (this.processModel == null) {
            this.processModel = new ProcessModel(this);
            this.processModel.setObjectID(new GUID().toString());
            this.processModel.setDesign(this);
            this.processModel.setParent(this);
        }
        return this.processModel;
    }

    public Map getFKMap() {
        return this.fkMap;
    }

    public RelationalDesign getRelationalDesign() {
        if (this.relationalDesign == null) {
            this.relationalDesign = this.addRelationalDesign(null);
        }
        return this.relationalDesign;
    }

    public void setRelationalDesign(RelationalDesign design) {
        this.relationalDesign = design;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        if (this.multidimensionalDesign == null) {
            this.multidimensionalDesign = this.addMultidimensionalDesign(null);
        }
        return this.multidimensionalDesign;
    }

    public MultidimensionalDesign addMultidimensionalDesign() {
        MultidimensionalDesign mdes;
        this.multidimensionalDesign = mdes = this.addMultidimensionalDesign(null);
        return mdes;
    }

    public MultidimensionalDesign addMultidimensionalDesign(String name) {
        MultidimensionalDesign design = (MultidimensionalDesign)this.mddSet.createElement(null);
        design.setDesign(this);
        if (name != null) {
            design.setName(name);
        }
        if (this.multidimensionalDesign == null) {
            this.multidimensionalDesign = design;
        }
        design.getMainView().setName(design.getName());
        design.createCompactDiagram();
        this.setDirty(true);
        this.setModelListChanged(true);
        return design;
    }

    public void setMultidimensionalDesign(MultidimensionalDesign design) {
        this.multidimensionalDesign = design;
    }

    public void addDesignObject(DesignObject object) {
        if (object.isDesignLevelAccessibleObject()) {
            this.registerAndAssignIDIfNull(object);
            this.idMap.put(object.getObjectID(), object);
            if (object.hasProxyToDelete() && this.tempProxiesToDelete.contains(object.getObjectID())) {
                this.tempProxiesToDelete.remove(object.getObjectID());
            }
        } else {
            throw new RuntimeException("trying to add object that is not design level accessible.");
        }
    }

    public void removeDesignObject(DesignObject object) {
        if (object != null && object.getObjectID() != null) {
            if (object.hasProxyToDelete() && !this.tempProxiesToDelete.contains(object.getObjectID())) {
                this.tempProxiesToDelete.add(object.getObjectID());
            }
            this.idMap.remove(object.getObjectID());
        }
    }

    private void registerAndAssignIDIfNull(DesignObject object) {
        String id = object.getObjectID();
        if (id == null) {
            object.createGlobalID();
        }
    }

    public DesignObject getDesignObject(String id) {
        if (id == null) {
            return null;
        }
        if (id.indexOf(35) > -1) {
            DesignObject top = this.getTopDesignObject(id);
            if (top != null) {
                return top;
            }
            top = this.getTopDesignObject(this.getTopDesignObjectId(id));
            if (top != null) {
                if (top instanceof ContainerObject) {
                    return (DesignObject)((ContainerObject)top).getLocalObject(id);
                }
                if (top instanceof StructuredType) {
                    DesignObject elm = ((StructuredType)top).getElementByID(id);
                    if (elm == null) {
                        elm = ((StructuredType)top).getMethodByID(id);
                    }
                    return elm;
                }
                return null;
            }
            return null;
        }
        return this.getTopDesignObject(id);
    }

    public void updateDesignObjectId(String oldId, String newId) {
        ContainerObject top;
        if (oldId == null || "".equalsIgnoreCase(oldId)) {
            return;
        }
        Object object = this.idMap.get(oldId);
        if (object != null) {
            this.idMap.remove(oldId);
            if (newId != null && !"".equalsIgnoreCase(newId)) {
                this.idMap.put(newId, object);
            }
        } else if (oldId.indexOf(35) > -1 && (top = (ContainerObject)this.getTopDesignObject(this.getTopDesignObjectId(oldId))) != null) {
            top.updateLocalObjectId(oldId, newId);
        }
    }

    public String getTopDesignObjectId(String localId) {
        int index = -1;
        index = localId.indexOf(35);
        if (index > -1) {
            return localId.substring(0, index);
        }
        return localId;
    }

    public DesignObject getTopDesignObject(String id) {
        return (DesignObject)this.idMap.get(id);
    }

    public FWDEngineering getFWDEngineering() {
        if (this.fwdEngineering == null) {
            this.fwdEngineering = new FWDEngineering(this);
        }
        return this.fwdEngineering;
    }

    public ReverseEngineering getReverseEngineering() {
        if (this.revEngineering == null) {
            this.revEngineering = new ReverseEngineering(this);
        }
        return this.revEngineering;
    }

    public void forwardEngineer(DesignPartView dpv, Map comparatorsMap) {
        this.getFWDEngineering().execute(dpv, comparatorsMap);
    }

    public void executeMerging(DesignPart dpv, Map comparatorsMap, Map physComparatorsMap, Map objectsMap) {
        this.getMergingModels().execute(dpv, comparatorsMap, physComparatorsMap, objectsMap);
    }

    private MergingModels getMergingModels() {
        return new MergingModels(this);
    }

    public void reverseEngineer(Map comparatorsMap, DesignPartView dpv) {
        this.getReverseEngineering().execute(comparatorsMap, dpv);
    }

    public Collection getStorableDesignObjects() {
        ArrayList collection = new ArrayList();
        this.getDomainSet().addAllElementsTo(collection);
        return collection;
    }

    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getLogicalDesign().getEntitySet().addAllElementsTo(collection);
        this.getLogicalDesign().getEntityViewSet().addAllElementsTo(collection);
        this.getLogicalDesign().getAttributeSet().addAllElementsTo(collection);
        this.getLogicalDesign().getGlobalCandidateKeySet().addAllElementsTo(collection);
        this.getLogicalDesign().getRelationSet().addAllElementsTo(collection);
        this.getLogicalDesign().getNoteSet().addAllElementsTo(collection);
        this.getDataTypesDesign().getDistinctTypeSet().addAllElementsTo(collection);
        this.getDataTypesDesign().getStructuredTypeSet().addAllElementsTo(collection);
        this.getDataTypesDesign().getCollectionTypeSet().addAllElementsTo(collection);
        this.getDataTypesDesign().getNoteSet().addAllElementsTo(collection);
        for (RelationalDesign phDesign : this.getRelationalDesigns()) {
            phDesign.getTableSet().addAllElementsTo(collection);
            phDesign.getColumnSet().addAllElementsTo(collection);
            phDesign.getTableSet().getGlobalIndexSet().addAllElementsTo(collection);
            phDesign.getFKIndexAssociationSet().addAllElementsTo(collection);
            phDesign.getColumnViewSet().addAllElementsTo(collection);
            phDesign.getTableViewSet().addAllElementsTo(collection);
            phDesign.getNoteSet().addAllElementsTo(collection);
        }
        for (MultidimensionalDesign mdDesign : this.getMultidimensionalDesigns()) {
            mdDesign.getCubeSet().addAllElementsTo(collection);
            mdDesign.getDimensionSet().addAllElementsTo(collection);
            mdDesign.getHierarchySet().addAllElementsTo(collection);
            mdDesign.getLevelSet().addAllElementsTo(collection);
            mdDesign.getMeasureSet().addAllElementsTo(collection);
            mdDesign.getRollupLinkSet().addAllElementsTo(collection);
            mdDesign.getSliceSet().addAllElementsTo(collection);
            mdDesign.getNoteSet().addAllElementsTo(collection);
            mdDesign.getMeasureFolderSet().addAllElementsTo(collection);
        }
        this.getProcessModel().getRecordStructureSet().addAllElementsTo(collection);
        this.getProcessModel().getExternalDataSet().addAllElementsTo(collection);
        this.getProcessModel().getEventSet().addAllElementsTo(collection);
        this.getProcessModel().getInfoStructureSet().addAllElementsTo(collection);
        this.getProcessModel().getInfoStoreSet().addAllElementsTo(collection);
        this.getProcessModel().getRoleSet().addAllElementsTo(collection);
        for (DataFlowDesign dfDesign : this.getProcessModel().getDataFlowDesigns()) {
            dfDesign.getProcessSet().addAllElementsTo(collection);
            dfDesign.getExternalAgentSet().addAllElementsTo(collection);
            dfDesign.getFlowSet().addAllElementsTo(collection);
            dfDesign.getNoteSet().addAllElementsTo(collection);
        }
        Iterator it = this.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage tp = (TransformationPackage)it.next();
            for (TransformationTask tt : tp.getTransformationTaskSet()) {
                tt.getFlowSet().addAllElementsTo(collection);
                tt.getNoteSet().addAllElementsTo(collection);
                tt.getTransformationSet().addAllElementsTo(collection);
            }
        }
        return collection;
    }

    public List getAllStorableObjects() {
        ArrayList<ModelIDObject> collection = new ArrayList<ModelIDObject>();
        this.getChangeRequestSet().addAllElementsTo(collection);
        this.getBusinessInfoDesign().getEmailSet().addAllElementsTo(collection);
        this.getBusinessInfoDesign().getLocationSet().addAllElementsTo(collection);
        this.getBusinessInfoDesign().getPhoneSet().addAllElementsTo(collection);
        this.getBusinessInfoDesign().getUrlSet().addAllElementsTo(collection);
        this.getBusinessInfoDesign().getContactSet().addAllElementsTo(collection);
        this.getBusinessInfoDesign().getResPartySet().addAllElementsTo(collection);
        this.getBusinessInfoDesign().getDocumentSet().addAllElementsTo(collection);
        this.getDataTypesDesign().getDistinctTypeSet().addAllElementsTo(collection);
        this.getDataTypesDesign().getStructuredTypeSet().addAllElementsTo(collection);
        this.getDataTypesDesign().getCollectionTypeSet().addAllElementsTo(collection);
        this.getDataTypesDesign().getNoteSet().addAllElementsTo(collection);
        this.getLogicalDesign().getEntitySet().addAllElementsTo(collection);
        this.getLogicalDesign().getEntityViewSet().addAllElementsTo(collection);
        this.getLogicalDesign().getRelationSet().addAllElementsTo(collection);
        this.getLogicalDesign().getInheritanceRelationSet().addAllElementsTo(collection);
        this.getLogicalDesign().getArcSet().addAllElementsTo(collection);
        this.getLogicalDesign().getNoteSet().addAllElementsTo(collection);
        for (RelationalDesign phDesign : this.getRelationalDesigns()) {
            phDesign.getSchemaObjectSet().addAllElementsTo(collection);
            phDesign.getTableSet().addAllElementsTo(collection);
            phDesign.getTableViewSet().addAllElementsTo(collection);
            phDesign.getArcSet().addAllElementsTo(collection);
            phDesign.getFKIndexAssociationSet().addAllElementsTo(collection);
            phDesign.getNoteSet().addAllElementsTo(collection);
        }
        for (MultidimensionalDesign mdDesign : this.getMultidimensionalDesigns()) {
            mdDesign.getLevelSet().addAllElementsTo(collection);
            mdDesign.getRaggedHLinkSet().addAllElementsTo(collection);
            mdDesign.getDimensionSet().addAllElementsTo(collection);
            mdDesign.getSliceSet().addAllElementsTo(collection);
            mdDesign.getCubeSet().addAllElementsTo(collection);
            mdDesign.getRollupLinkSet().addAllElementsTo(collection);
            mdDesign.getHierarchySet().addAllElementsTo(collection);
            mdDesign.getMeasureFolderSet().addAllElementsTo(collection);
            mdDesign.getSQLAccessToAWSet().addAllElementsTo(collection);
            mdDesign.getNoteSet().addAllElementsTo(collection);
        }
        this.getProcessModel().getRecordStructureSet().addAllElementsTo(collection);
        this.getProcessModel().getEventSet().addAllElementsTo(collection);
        this.getProcessModel().getInfoStructureSet().addAllElementsTo(collection);
        this.getProcessModel().getInfoStoreSet().addAllElementsTo(collection);
        this.getProcessModel().getRoleSet().addAllElementsTo(collection);
        for (DataFlowDesign dfDesign : this.getProcessModel().getDataFlowDesigns()) {
            dfDesign.getExternalAgentSet().addAllElementsTo(collection);
            dfDesign.getProcessSet().addAllElementsTo(collection);
            dfDesign.getFlowSet().addAllElementsTo(collection);
            dfDesign.getNoteSet().addAllElementsTo(collection);
        }
        Iterator it = this.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage tp = (TransformationPackage)it.next();
            collection.add(tp);
            for (TransformationTask tt : tp.getTransformationTaskSet()) {
                collection.add(tt);
                tt.getTransformationSet().addAllElementsTo(collection);
                tt.getFlowSet().addAllElementsTo(collection);
                tt.getNoteSet().addAllElementsTo(collection);
            }
        }
        return collection;
    }

    @Override
    public ApplicationView getAppView() {
        return this.appView;
    }

    @Override
    public int getNumberOfChildren() {
        return 10;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.getLogicalDesign();
            }
            case 1: {
                return this.mddSet;
            }
            case 2: {
                return this.pdesignSet;
            }
            case 3: {
                return this.getDomainSet();
            }
            case 4: {
                return this.getDataTypesDesign();
            }
            case 5: {
                return this.getProcessModel();
            }
            case 6: {
                return this.getBusinessInfoDesign();
            }
            case 7: {
                return this.getChangeRequestSet();
            }
            case 8: {
                return this.stSet;
            }
            case 9: {
                return this.tsdpPolicySet;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.getLogicalDesign()) {
            return 0;
        }
        if (child == this.mddSet) {
            return 1;
        }
        if (child == this.pdesignSet) {
            return 2;
        }
        if (child == this.getDomainSet()) {
            return 3;
        }
        if (child == this.getDataTypesDesign()) {
            return 4;
        }
        if (child == this.getProcessModel()) {
            return 5;
        }
        if (child == this.getBusinessInfoDesign()) {
            return 6;
        }
        if (child == this.getChangeRequestSet()) {
            return 7;
        }
        if (child == this.stSet) {
            return 8;
        }
        if (child == this.tsdpPolicySet) {
            return 9;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public static String getSystemDesignName() {
        return SYSTEM_DESIGN;
    }

    public void addDesignListener(DesignListener listener) {
        this.listeners.add(listener);
    }

    public void removeDesignListener(DesignListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireNameChange() {
        DesignEvent event = new DesignEvent(DesignEvent.NAME_CHANGED);
        this.fireDesignChange(event);
        this.resetOwner();
        if (ApplicationView.GUIMode) {
            this.getAppView().getBrowserPanel().updateDesignName();
        }
    }

    protected void fireDesignChange(DesignEvent event) {
        event.setDesign(this);
        DesignListener[] array = this.listeners.toArray(DesignListener.ARRAY_PROTOTYPE);
        for (int i = 0; i < array.length; ++i) {
            array[i].designChanged(event);
        }
    }

    private void resetOwner() {
        for (Object object : this.getAllTopLevelObjects()) {
            if (!(object instanceof ModelIDObject)) continue;
            ((ModelIDObject)object).setOwnerDesign(this);
        }
        for (RelationalDesign pd : this.getRelationalDesigns()) {
            StorageDesign[] sds = pd.getStorageDesignFactory().getOpenStorageDesigns();
            for (int i = 0; i < sds.length; ++i) {
                StorageDesign sd = sds[i];
                for (Object obj : sd.getAllTopLevelObjects()) {
                    if (!(obj instanceof ModelIDObject)) continue;
                    ((ModelIDObject)obj).setOwnerDesign(this);
                }
            }
        }
    }

    public void resetDomains() {
        for (Object object : this.getStorableDesignObjects()) {
            if (!(object instanceof ModelIDObject)) continue;
            ((ModelIDObject)object).setOwnerDesign(this);
        }
    }

    public void resetDesignForDomains() {
        Iterator it = this.getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            domain.setDesign(this);
        }
    }

    public static void fixDataTypeSize(DesignObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            try {
                ContainedObjectWithDomain co = (ContainedObjectWithDomain)it.next();
                String size = co.getDataTypeSize();
                String precision = co.getDataTypePrecision();
                if (size == null || "".equals(size) || precision == null || "".equals(precision)) continue;
                co.setDataTypeSize(null);
            }
            catch (Exception exception) {}
        }
    }

    public List getOldNotesDPVs() {
        return this.oldNotesDPVs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openDesign(String designName, String ext) {
        TimeLog.log();
        this.oldNotesDPVs.clear();
        this.diagramViews.clear();
        OPEN_FAILED = false;
        boolean result = false;
        int maxNameLength = 18;
        LogReport logPanel = null;
        ProgressDialog monitor = null;
        try {
            Dockable dockable;
            Flow flow;
            Iterator flit;
            this.getUndoManager().setLocked(true);
            RelationalDesign oldDesign = this.getRelationalDesign();
            oldDesign.setMainViewVisible(false);
            this.getLogicalDesign().setLoaded(false);
            this.getLogicalDesign().setMainViewVisible(false);
            this.getBusinessInfoDesign().setLoaded(false);
            this.getDataTypesDesign().setLoaded(false);
            this.getDataTypesDesign().getMainView();
            oldDesign.setLoaded(false);
            this.setFileName(designName);
            if (Extension.isUsingVersioningFunctionality() && !this.design.isOldRepositoryType()) {
                if (GitClientHelper.isGitVersioned(this.design)) {
                    List<GitStatus> list = GitClientHelper.getConflictsForDesign(this.design);
                    GitClientHelper.fixBrokenFiles(list);
                } else {
                    SVNClientHelper.getInstance().checkAndSetVersionedDesignOnly(this.design);
                }
            }
            ApplicationView.loading = true;
            result = this.isOldRepositoryType() ? null != this.getAppView().getPersistenceManager().read((Object)designName, this, monitor) : this.getAppView().getXMLTransformationManager().openDesign(this, new File(this.getDesignPath(), designName + ext));
            this.fireDesignChange(new DesignEvent(DesignEvent.DESIGN_OPENED));
            this.loadDesignLevelSettings(false);
            this.getAppView().getUDPLibrariesPersistence().load(this, this.getAppView(), true);
            if (this.getLoadedVersion() > this.getVersion()) {
                String title = this.getAppView().getMDConfiguration().get("appName");
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Design.DesignFormatIsNewerThanFormat"), title), Messages.getString("Design.Warning"), 0, 1, null, new String[]{Messages.getString("Design.OK")}, Messages.getString("Design.OK"));
            }
            if (this.getLoadedVersion() < this.getVersion() && this.isEditable()) {
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), Messages.getString("Design.ThisDesignIsInOldFormat"), Messages.getString("Design.Warning"), 0, 1, null, new String[]{Messages.getString("Design.OK")}, Messages.getString("Design.OK"));
            }
            OpenDesignDialogPersistence persistence = new OpenDesignDialogPersistence(this.appView, this);
            persistence.load();
            if (persistence.getLoadedRModelsList().size() > 0) {
                RelationalDesign[] rds = (RelationalDesign[])this.getRelationalDesigns().toArray();
                block10: for (int i = 0; i < rds.length; ++i) {
                    RelationalDesign rd = rds[i];
                    for (DMDOpenObject mo : persistence.getLoadedRModelsList()) {
                        if (!rd.getObjectID().equals(mo.getModelObjId())) continue;
                        if (mo.isOpen()) {
                            rd.setShouldBeOpen(true);
                            continue block10;
                        }
                        rd.setShouldBeOpen(false);
                        continue block10;
                    }
                }
            }
            if (ApplicationView.GUIMode) {
                if (this.getAppView().getSettings().showSelectRelModelDialog() && this.getRelationalDesigns().size() > 0) {
                    OpenDesignDialog od = new OpenDesignDialog(this.getAppView(), this, persistence);
                    od.setVisible(true);
                }
                monitor = new ProgressDialog(this.getAppView(), "", 0, 100);
                monitor.setNote(MessageFormat.format(Messages.getString("Design.OpenDesign"), designName));
                try {
                    monitor.setNote(Messages.getString("Design.ReadRDBMSSites"));
                    monitor.setProgress(20);
                    if (this.isOldRepositoryType()) {
                        this.loadRDBMSSites();
                    }
                    monitor.setProgress(30);
                }
                catch (NullPointerException od) {
                    // empty catch block
                }
                monitor.setNote(Messages.getString("Design.ReadDomains"));
                monitor.setProgress(20);
            }
            if (this.isOldRepositoryType()) {
                this.loadDomainFiles();
            } else {
                this.getAppView().getXMLTransformationManager().loadDomains(this);
            }
            this.getDomainSet().sort();
            if (ApplicationView.GUIMode) {
                monitor.setProgress(30);
                monitor.setNote(Messages.getString("Design.OpenBusinessInformation"));
            }
            if (this.isOldRepositoryType()) {
                this.getBusinessInfoDesign().load();
            } else {
                this.getAppView().getXMLTransformationManager().openDesignPart(this.getBusinessInfoDesign());
            }
            this.getBusinessInfoDesign().sortCollections();
            if (ApplicationView.GUIMode) {
                monitor.setProgress(35);
                monitor.setNote(Messages.getString("Design.OpenDataTypes"));
            }
            if (this.isOldRepositoryType()) {
                this.getDataTypesDesign().load();
            } else {
                this.getAppView().getXMLTransformationManager().openDesignPart(this.getDataTypesDesign());
            }
            this.getDataTypesDesign().sortCollections();
            if (ApplicationView.GUIMode) {
                monitor.setNote(Messages.getString("Design.OpenLogicalModel"));
            }
            if (this.isOldRepositoryType()) {
                this.getLogicalDesign().load();
            } else {
                this.getAppView().getXMLTransformationManager().openDesignPart(this.getLogicalDesign());
            }
            this.getLogicalDesign().sortCollections();
            if (this.getLoadedVersion() < 3.41f) {
                Design.fixDataTypeSize(this.getLogicalDesign().getAttributeSet());
            }
            Iterator it = this.getRelationalDesigns().iterator();
            int cc = 40;
            int step = 30;
            if (this.getRelationalDesigns().size() > 0) {
                step = 30 / this.getRelationalDesigns().size();
            }
            persistence.load();
            while (it.hasNext()) {
                RelationalDesign relModel = (RelationalDesign)it.next();
                if (relModel.isShouldBeOpen() || this.getLoadedVersion() < 3.5f) {
                    RDBMSSite defaultSite;
                    StorageDesign storageDesign;
                    File file;
                    Object pdName = relModel.getName();
                    if (((String)pdName).length() > maxNameLength) {
                        pdName = ((String)pdName).substring(0, maxNameLength) + "...";
                    }
                    if (ApplicationView.GUIMode) {
                        monitor.setNote(MessageFormat.format(Messages.getString("Design.OpenRelationalModel"), pdName));
                        monitor.setProgress(cc);
                    }
                    if (this.isOldRepositoryType()) {
                        relModel.load();
                    } else {
                        this.getAppView().getXMLTransformationManager().openDesignPart(relModel);
                    }
                    relModel.sortCollections();
                    if (this.getLoadedVersion() < 3.41f) {
                        Design.fixDataTypeSize(relModel.getColumnSet());
                    }
                    logPanel = BrowserPanel.showErrosInDesignPart(relModel, logPanel);
                    if (persistence.getLoadedRModelsList().size() > 0 && (file = new File((storageDesign = relModel.getStorageDesign(defaultSite = relModel.getSelectedRDBMSSite())).getStorageName())).exists()) {
                        for (DMDOpenObject mo : persistence.getLoadedRModelsList()) {
                            if (!relModel.getObjectID().equals(mo.getModelObjId())) continue;
                            if (!mo.isOpenDefaultPhysicalModel()) break;
                            try {
                                if (ApplicationView.GUIMode) {
                                    ApplicationView.log(MessageFormat.format(Messages.getString("Design.OpenPhysicalDesign"), storageDesign.getName()));
                                    monitor.setNote(MessageFormat.format(Messages.getString("Design.OpenPhysicalDesign"), storageDesign.getName()));
                                }
                                if (this.isLoadFromDB()) {
                                    AbstractRepositoryManager rman = this.getAppView().getDBPersistenceManager().getDBRepositoryManager();
                                    rman.readPhysicalModel(storageDesign);
                                } else if (storageDesign.getDesign().isOldRepositoryType()) {
                                    storageDesign.load();
                                } else {
                                    this.getAppView().getXMLTransformationManager().openPhysicalModel(storageDesign);
                                }
                                storageDesign.setOpen(true);
                            }
                            catch (Exception e) {
                                LOGGER.error("Error Opening Storage Design!", e);
                            }
                            break;
                        }
                    }
                    persistence.clearDesignInstance();
                }
                cc += step;
            }
            if (ApplicationView.GUIMode) {
                monitor.setNote(Messages.getString("Design.ReadMappings"));
            }
            if (this.isOldRepositoryType()) {
                this.getExtendedMap().load();
            } else {
                this.getAppView().getXMLTransformationManager().transformFromXMLToObject(this.getExtendedMap(), new File(this.getExtendedMap().getStorageName()), this.getDesign().isCompressedDesign());
            }
            this.getExtendedMap().setDirty(false);
            if (this.getLoadedVersion() > 3.49999f) {
                for (RelationalDesign relModel : this.getRelationalDesigns()) {
                    RMExtendedMap rxmap = relModel.getRMExtendedMap();
                    this.getAppView().getXMLTransformationManager().transformFromXMLToObject(rxmap, new File(rxmap.getStorageName()), this.getDesign().isCompressedDesign());
                    rxmap.setDirty(false);
                    RMDeletedMap dxmap = relModel.getRMDeletedMap();
                    relModel.getAppView().getXMLTransformationManager().transformFromXMLToObject(dxmap, new File(dxmap.getStorageName()), relModel.getDesign().isCompressedDesign());
                }
            }
            for (MultidimensionalDesign mdd : this.getMultidimensionalDesigns()) {
                if (!mdd.isShouldBeOpen() || mdd.getBoundModel() == null || !mdd.getBoundModel().isLoaded()) continue;
                Object mddName = mdd.getName();
                if (((String)mddName).length() > maxNameLength) {
                    mddName = ((String)mddName).substring(0, maxNameLength) + "...";
                }
                if (ApplicationView.GUIMode) {
                    monitor.setNote(MessageFormat.format(Messages.getString("Design.OpenMultidimensionalDiagram"), mddName));
                }
                if (this.isOldRepositoryType()) {
                    mdd.load();
                } else {
                    this.getAppView().getXMLTransformationManager().openDesignPart(mdd);
                }
                mdd.clearUnusedObjects();
                mdd.sortCollections();
            }
            ProcessModel processModel = this.getProcessModel();
            if (this.isOldRepositoryType()) {
                processModel.load();
            } else {
                this.getAppView().getXMLTransformationManager().openDesignPart(processModel);
            }
            processModel.sortCollections();
            for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
                if (!dfd.isShouldBeOpen()) continue;
                Object dfdName = dfd.getName();
                if (((String)dfdName).length() > maxNameLength) {
                    dfdName = ((String)dfdName).substring(0, maxNameLength) + "...";
                }
                if (ApplicationView.GUIMode) {
                    monitor.setNote(MessageFormat.format(Messages.getString("Design.OpenDataFlowDiagram"), dfdName));
                }
                if (this.isOldRepositoryType()) {
                    dfd.load();
                } else {
                    this.getAppView().getXMLTransformationManager().openDesignPart(dfd);
                }
                dfd.sortCollections();
            }
            for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
                flit = dfd.getFlowSet().iterator();
                while (flit.hasNext()) {
                    flow = (Flow)flit.next();
                    if (!this.isOldRepositoryType()) continue;
                    flow.addSynonymToCompositeProcDiagram();
                    flow.createOrSetParentFlow();
                }
            }
            processModel.updateObjects();
            for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
                dfd.setDirty(false);
            }
            if (this.getLoadedVersion() < this.getVersion()) {
                this.resetToDirtyStorableObjects();
            }
            ApplicationView.loading = false;
            this.getExtendedMap().checkAndCleanMappings();
            this.getExtendedMap().distributenMappings();
            if (ApplicationView.GUIMode) {
                monitor.setNote(Messages.getString("Design.CreateGraphicalObjects"));
                monitor.setProgress(80);
            }
            if (this.isOldRepositoryType()) {
                for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
                    flit = dfd.getFlowSet().iterator();
                    while (flit.hasNext()) {
                        flow = (Flow)flit.next();
                        flow.addToAllDPVs(null);
                    }
                }
            }
            if (this.getAppView().getSettings().isSyncRemoteObjectsOnLoad()) {
                this.synchronizeRemoteObjects();
            }
            if (ApplicationView.GUIMode) {
                monitor.setNote(Messages.getString("Design.CenterDesign"));
                monitor.setProgress(90);
                this.getAppView().centerDesign();
                EntitySet entitySet = this.getLogicalDesign().getEntitySet();
                if (entitySet.size() > 0) {
                    TopView tv = ((DesignObject)entitySet.getElement(0)).getTopView();
                    this.getAppView().getDPVLogical().setCurrentSelection(tv.getSelectableObject(), tv);
                }
                this.deleteNotUsedDiagramViews();
                monitor.setNote(Messages.getString("Design.ShowModels"));
                monitor.setProgress(98);
                if (this.getLogicalDesign().isVisible()) {
                    this.getLogicalDesign().setMainViewVisible(true, true);
                    if (this.getLogicalDesign().getMainView().showLabels()) {
                        ((DPVLogical)this.getLogicalDesign().getMainView()).refreshLabels();
                    }
                    this.getLogicalDesign().getMainView().getTabbedPane().setSelectedIndex(this.getLogicalDesign().getMainView().getTabbedPane().getTabCount() > 0 ? 0 : -1);
                } else {
                    this.getLogicalDesign().setMainViewVisible(false);
                }
                this.showLogicalSubViews();
                this.showAllRelationalDesigns();
                this.showDataTypesDesign();
                this.showAllMultidimensionalDesigns();
                this.showAllDataFlowDesigns();
                this.showAllTransformationTask();
            }
            this.createLocalDP_Map();
            this.createChangeRequestsMap();
            if (ApplicationView.GUIMode) {
                if (this.getRelationalDesign().getTableSet().size() > 0 && this.getRelationalDesign().getMainView().isVisible()) {
                    this.getAppView().setCurrentDPV(this.getRelationalDesign().getMainView());
                } else if (this.getLogicalDesign().getEntitySet().size() > 0 && this.getLogicalDesign().getMainView().isVisible()) {
                    this.getAppView().setCurrentDPV(this.getLogicalDesign().getMainView());
                }
            }
            this.getRelationalDesigns().sortByName();
            this.getRelationalDesign().setDirty(false);
            this.getLogicalDesign().setDirty(false);
            if (ApplicationView.GUIMode) {
                this.getAppView().addRecent(this.getFileName(), this.getDesignPath());
            }
            this.setDirty(false);
            this.setModelListChanged(false);
            this.setChangeRequestListChanged(false);
            this.setSensitiveTypeListChanged(false);
            this.setLoadFromDB(false);
            this.setNewDesign(false);
            this.checkDataFlowDesigns();
            this.setOldNotesDPVsDirty();
            if (ApplicationView.GUIMode && (dockable = this.getDockStation().getDockable(GlobalSearchDockable.VIEW_ID)) != null) {
                GlobalSearchDockable globalSearchDockable = (GlobalSearchDockable)dockable;
                ((GlobalSearchPanel)globalSearchDockable.getGUI()).reloadOpenModels();
            }
            for (DesignRuleSet drs : this.appView.getSettings().getDesignRuleSets()) {
                drs.initDesignRules(this.appView);
            }
            this.checkForGitDesign();
            if (this.isGitVersioned()) {
                if (ApplicationView.GUIMode) {
                    VCSManager.getVCSManager().addVCSListener((VCSListener)new L(), (URLFilter)new Filter());
                    File f = new File(new File(this.getDesign().getDesignPath()), this.getDesign().getName());
                    GitClient cl = null;
                    try {
                        cl = GITClientAdaptor.getClient((URL)f.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (GitException e) {
                        e.printStackTrace();
                    }
                    if (cl != null) {
                        cl.addNotificationListener((NotificationListener)new DelegateListener(this));
                    }
                    GitClientHelper.ensureGlobalIgnoreList(this.getDesignPath());
                    this.addToWorkspaces();
                }
                this.gitRepositoryPath = this.getGitRepositoryRoot();
            }
            this.updateModelIdNameMap();
        }
        finally {
            ApplicationView.loading = false;
            this.getAppView().clearTree();
            if (monitor != null) {
                monitor.close();
            }
            this.getUndoManager().setLocked(false);
        }
        TimeLog.log();
        if (OPEN_FAILED && ApplicationView.GUIMode) {
            if (this.isSVNVersioned()) {
                MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), Messages.getString("Design.SomeObjectsNotLoadedCorrectlyVersioned"), true);
            } else {
                MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), Messages.getString("Design.SomeObjectsNotLoadedCorrectly"), true);
            }
        }
        if (ApplicationView.debugMode) {
            // empty if block
        }
        if (ApplicationView.GUIMode && logPanel != null) {
            logPanel.showModalDialog(new Dimension(750, 550));
        }
        if (ApplicationView.GUIMode) {
            RelationalDesign rd;
            if (this.dockStation.getDockable(SVNChangeListWindow.VIEW_ID) != null) {
                DataModelerChangeList changeList;
                SVNChangeListWindow changeListWindow = (SVNChangeListWindow)this.dockStation.getDockable(SVNChangeListWindow.VIEW_ID);
                changeListWindow.setOpenedOnStart(true);
                if (SVNChangeListWindow.getSVNIncomingChangesChangeList().isShowing()) {
                    SVNChangeListWindow.getSVNIncomingChangesChangeList().setDataModelerChangesTimerTaskUpdatable(false);
                }
                if (this.isSVNVersioned()) {
                    changeListWindow.postInitialization();
                }
                if (changeListWindow != null && (changeList = (DataModelerChangeList)changeListWindow.getContextChangeList()) != null) {
                    changeList.getScopeComboBox().updateUI();
                }
                if (!changeListWindow.isVisible()) {
                    changeListWindow.refresh();
                }
            }
            if ((rd = this.design.getRelationalDesign()).isLoaded()) {
                ModelIDObject obj = rd;
                StorageDesign sd = rd.getStorageDesign();
                if (sd.isOpen()) {
                    obj = sd;
                }
                Object[] arr = obj.getPath();
                TreePath path = new TreePath(arr);
                this.getAppView().getBrowserPanel().getJTree().scrollPathToVisible(path);
                this.getAppView().getBrowserPanel().getJTree().expandPath(path);
            }
        }
        this.design.fireNameChange();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cliOpenRelationalModel(String designName, String ext, String rmName) {
        this.oldNotesDPVs.clear();
        this.diagramViews.clear();
        OPEN_FAILED = false;
        boolean result = false;
        try {
            this.getUndoManager().setLocked(true);
            RelationalDesign oldDesign = this.getRelationalDesign();
            this.getLogicalDesign().setLoaded(false);
            this.getBusinessInfoDesign().setLoaded(false);
            this.getDataTypesDesign().setLoaded(false);
            oldDesign.setLoaded(false);
            this.setFileName(designName);
            ApplicationView.loading = true;
            result = this.getAppView().getXMLTransformationManager().openDesign(this, new File(this.getDesignPath(), designName + ext), true, rmName);
            if (result) {
                this.loadDesignLevelSettings(false);
                this.getAppView().getUDPLibrariesPersistence().load(this, this.getAppView(), true);
                if (this.getLoadedVersion() > this.getVersion()) {
                    System.out.println(Messages.getString("Design.DesignFormatIsNewerThanFormat"));
                }
                if (this.getLoadedVersion() < this.getVersion() && this.isEditable()) {
                    System.out.println(Messages.getString("Design.ThisDesignIsInOldFormat"));
                }
                if (this.isOldRepositoryType()) {
                    this.loadDomainFiles();
                } else {
                    this.getAppView().getXMLTransformationManager().loadDomains(this);
                }
                this.getDomainSet().sort();
                if (this.isOldRepositoryType()) {
                    this.getDataTypesDesign().load();
                } else {
                    this.getAppView().getXMLTransformationManager().openDesignPart(this.getDataTypesDesign());
                }
                this.getDataTypesDesign().sortCollections();
                boolean bl = result = this.getRelationalDesigns().size() > 0;
                if (result) {
                    for (RelationalDesign relModel : this.getRelationalDesigns()) {
                        RDBMSSite defaultSite;
                        StorageDesign storageDesign;
                        File file;
                        String relDesName = relModel.getName();
                        if (!relDesName.equalsIgnoreCase(rmName)) continue;
                        if (this.isOldRepositoryType()) {
                            relModel.load();
                        } else {
                            this.getAppView().getXMLTransformationManager().openDesignPart(relModel);
                        }
                        relModel.sortCollections();
                        if (this.getLoadedVersion() < 3.41f) {
                            Design.fixDataTypeSize(relModel.getColumnSet());
                        }
                        if (!(file = new File((storageDesign = relModel.getStorageDesign(defaultSite = relModel.getSelectedRDBMSSite())).getStorageName())).exists()) continue;
                        try {
                            if (this.isLoadFromDB()) {
                                AbstractRepositoryManager rman = this.getAppView().getDBPersistenceManager().getDBRepositoryManager();
                                rman.readPhysicalModel(storageDesign);
                            } else if (storageDesign.getDesign().isOldRepositoryType()) {
                                storageDesign.load();
                            } else {
                                this.getAppView().getXMLTransformationManager().openPhysicalModel(storageDesign);
                            }
                            storageDesign.setOpen(true);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error Opening Storage Design!", e);
                        }
                    }
                    ApplicationView.loading = false;
                    this.updateModelIdNameMap();
                }
            }
        }
        finally {
            ApplicationView.loading = false;
            this.getUndoManager().setLocked(false);
        }
        if (OPEN_FAILED) {
            System.out.println(Messages.getString("Design.SomeObjectsNotLoadedCorrectly"));
        }
        return result;
    }

    private void setOldNotesDPVsDirty() {
        for (DesignPartView dpv : this.oldNotesDPVs) {
            dpv.setDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDataFlowDesigns() {
        boolean hasbad = false;
        for (DataFlowDesign dfd : this.getProcessModel().getDataFlowDesigns()) {
            if (dfd.getTopLevelDataFlowDesign() != null) continue;
            hasbad = true;
            LOGGER.error("Design.checkDataFlowDesigns(): DataFlow Diagram (" + dfd.getName() + ") has no parent object and must be deleted from the file system.\n Delete the file and related directory - " + dfd.getSegmentedStorageName());
        }
        if (hasbad) {
            boolean canlogging = ApplicationView.canLogging;
            ApplicationView.canLogging = true;
            try {
                ApplicationView.log("There are bad Data Flow Diagrams - please check the log file for details");
            }
            finally {
                ApplicationView.canLogging = canlogging;
            }
        }
    }

    private void deleteNotUsedDiagramViews() {
        Object[] dvs = this.diagramViews.toArray();
        for (int i = dvs.length - 1; i >= 0; --i) {
            DiagramView dv = (DiagramView)dvs[i];
            dv.removeIfNotModelExists();
        }
    }

    public void loadDomainFiles() {
        for (String fname : this.getDomainFileNames()) {
            if ("defaultdomains".equalsIgnoreCase(fname)) continue;
            this.getAppView().getPersistenceManager().readDomainFile(fname, this, false);
        }
    }

    public void loadRDBMSSites() {
        String designName = this.getName();
        StringBuffer buffer = new StringBuffer();
        buffer.append(designName).append("_RDBMSSites");
        String fileName = buffer.toString();
        RDBMSSiteSet rdbmsSiteSet = (RDBMSSiteSet)this.getAppView().getPersistenceManager().read((Object)fileName, this, false);
        RDBMSSiteSet defRdbmsSiteSet = this.getRDBMSSiteSet();
        Iterator it = rdbmsSiteSet.iterator();
        while (it.hasNext()) {
            defRdbmsSiteSet.add((RDBMSSite)it.next());
        }
        this.setRDBMSSiteSet(defRdbmsSiteSet);
    }

    public void showLogicalSubViews() {
        Iterator itsv = this.getLogicalDesign().getLogicalDesignSubviews().iterator();
        while (itsv.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)itsv.next();
            if (!ph.getDesignPartView().mustBeVisible()) continue;
            ph.setVisibleNoLater(true, true);
            DesignPartView dpv = ph.getDesignPartView();
            if (dpv.isBoxInBox()) {
                dpv.fixBoxInBox();
            }
            if (dpv.showLabels()) {
                ((DPVLogical)dpv).refreshLabels();
            }
            dpv.setDirty(false);
        }
    }

    public void showDataTypesDesign() {
        DataTypesDesign dtd = this.getDataTypesDesign();
        if (dtd.isLoaded()) {
            if (dtd.isVisible()) {
                dtd.setMainViewVisible(true, true);
                dtd.getMainView().getTabbedPane().setSelectedIndex(dtd.getMainView().getTabbedPane().getTabCount() > 0 ? 0 : -1);
            }
            Iterator itsv = dtd.getDesignSubviews().iterator();
            while (itsv.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)itsv.next();
                if (!ph.getDesignPartView().mustBeVisible()) continue;
                ph.setVisible(true, true);
                ph.setDirty(false);
            }
            dtd.setDirty(false);
        }
    }

    public void showAllRelationalDesigns() {
        for (RelationalDesign pDesign : this.pdesignSet) {
            if (pDesign.isLoaded()) {
                if (pDesign.isVisible() && !pDesign.isMainViewVisible()) {
                    pDesign.setMainViewVisible(true, true);
                    pDesign.getMainView().getTabbedPane().setSelectedIndex(pDesign.getMainView().getTabbedPane().getTabCount() > 0 ? 0 : -1);
                }
                Iterator itsv = pDesign.getDesignSubviews().iterator();
                while (itsv.hasNext()) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)itsv.next();
                    if (!ph.getDesignPartView().mustBeVisible()) continue;
                    ph.setVisibleNoLater(true, true);
                    ph.setDirty(false);
                }
            }
            pDesign.setDirty(false);
            try {
                this.getDesignLevelSettings().initPhysicalModelsEstimates(pDesign);
            }
            catch (Exception exception) {}
        }
    }

    public void showAllMultidimensionalDesigns() {
        for (MultidimensionalDesign mdDesign : this.getMultidimensionalDesigns()) {
            if (mdDesign.isLoaded() && !mdDesign.isEmpty()) {
                if (mdDesign.isVisible()) {
                    mdDesign.setMainViewVisible(true, true);
                }
                if (mdDesign.getCompactDiagram().mustBeVisible()) {
                    mdDesign.getCompactDiagramPlaceHolder().setVisible(true, true);
                    mdDesign.getCompactDiagramPlaceHolder().setDirty(false);
                }
            }
            mdDesign.setDirty(false);
        }
    }

    public void showAllDataFlowDesigns() {
        if (!this.processModel.hasOpenedDFDesigns()) {
            this.processModel.clearDesign();
        } else {
            for (DataFlowDesign dfDesign : this.processModel.getDataFlowDesigns()) {
                if (dfDesign.isLoaded() && dfDesign.isVisible()) {
                    dfDesign.setMainViewVisible(true, true);
                }
                dfDesign.setDirty(false);
            }
        }
    }

    public void showAllTransformationTask() {
        Iterator it = this.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            for (TransformationTask task : pack.getTransformationTaskSet()) {
                if (task.isLoaded() && task.isVisible()) {
                    task.setMainViewVisible(true, true);
                }
                task.setDirty(false);
            }
            pack.setDirty(false);
        }
    }

    public void resetToDirtyStorableObjects() {
        ArrayList allObjects = new ArrayList();
        allObjects.addAll(this.getLogicalDesign().getStorableDesignObjects());
        allObjects.addAll(this.getDataTypesDesign().getStorableDesignObjects());
        for (RelationalDesign pd : this.getRelationalDesigns()) {
            allObjects.addAll(pd.getStorableDesignObjects());
        }
        for (DataFlowDesign dfd : this.getProcessModel().getDataFlowDesigns()) {
            allObjects.addAll(dfd.getStorableDesignObjects());
        }
        for (MultidimensionalDesign mdd : this.getMultidimensionalDesigns()) {
            allObjects.addAll(mdd.getStorableDesignObjects());
        }
        Iterator it = this.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            for (TransformationTask task : pack.getTransformationTaskSet()) {
                allObjects.addAll(task.getStorableDesignObjects());
            }
        }
        for (DesignObject object : allObjects) {
            object.setDirty(true);
        }
    }

    public boolean saveDesignFile() {
        return this.getAppView().getXMLTransformationManager().saveDesignFile(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAll() {
        boolean result = false;
        try (ProgressDialog monitor = new ProgressDialog(this.getAppView(), "", 0, 100);){
            monitor.setNote(MessageFormat.format(Messages.getString("Design.SaveDesign"), this.getFileName()));
            monitor.setProgress(50);
            this.proxiesToDelete.clear();
            this.proxiesToDelete.addAll(this.tempProxiesToDelete);
            result = this.getAppView().getXMLTransformationManager().saveDesign(this);
            this.saveDesignLevelSettings();
            File[] files = new File(XMLTransformationManager.getDefaultSystemTypesPath()).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".udposdm");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                Path to = Paths.get(this.design.getAdditionalFilesDirectory().getAbsolutePath(), "/", file.getName());
                Files.copy(file.toPath(), to, StandardCopyOption.REPLACE_EXISTING);
            }
            this.setLoadedVersion(this.getVersion());
            if (this.getCurrentOperation() != 5) {
                this.removeDeletedDesignParts();
            }
            monitor.setProgress(100);
            this.fireDesignChange(new DesignEvent(DesignEvent.DESIGN_SAVED));
            this.setDirty(false);
            this.designLevelSettingsChanged = false;
            if (this.getCurrentOperation() != 5) {
                this.createLocalDP_Map();
                this.createChangeRequestsMap();
                if (GITUtil.insideWorkingCopy((URL)new File(this.getDesignPath()).toURI().toURL()) && !this.hasWorkspaceSet()) {
                    this.addToWorkspaces();
                }
                this.updateModelIdNameMap();
            }
            this.setOldRepositoryType(false);
        }
        catch (Exception e) {
            LOGGER.error(e);
            MessageDialogs.showErrorMessage(Messages.getString("Design.UnableToSaveTheDesign"), true);
        }
        return result;
    }

    public boolean canUpgradeInPlace() {
        return this.getLoadedVersion() >= 3.4f && (this.isSVNVersioned() || this.isGitVersioned());
    }

    public void fixGeneratorIds(Design tempDesign) {
        FKIndexAssociation fk;
        FKIndexAssociation tempFk;
        Relation tempRel;
        KeyObject index;
        KeyObject tempIndex;
        KeyObject tempCandKey;
        KeyObject candKey;
        Column col;
        Column tempCol;
        Attribute tempAttr;
        Attribute attr;
        Table table;
        Table tempTable;
        Entity tempEntity;
        Entity entity;
        Iterator it = this.getLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            int i;
            entity = (Entity)it.next();
            if (entity.getImportedId() == null || "User generated".equals((tempEntity = (Entity)tempDesign.getDesignObject(entity.getImportedId())).getGeneratorID()) || (tempTable = (Table)tempDesign.getDesignObject(tempEntity.getGeneratorID())) == null) continue;
            table = (Table)this.getCorrObject(tempTable.getObjectID());
            entity.setGeneratorID(table.getObjectID());
            for (i = 0; i < entity.getAttributes().size(); ++i) {
                attr = (Attribute)entity.getAttributes().get(i);
                if (attr.getImportedId() == null || "User generated".equals((tempAttr = (Attribute)tempEntity.getElementByID(attr.getImportedId())).getGeneratorID())) continue;
                if (tempDesign.getDesignObject(tempAttr.getGeneratorID()) instanceof Column) {
                    tempCol = (Column)tempDesign.getDesignObject(tempAttr.getGeneratorID());
                    col = (Column)this.getCorrObject(tempCol.getObjectID());
                    attr.setGeneratorID(col.getObjectID());
                    continue;
                }
                if (!(tempDesign.getDesignObject(tempAttr.getGeneratorID()) instanceof Relation)) continue;
                Relation tempRelation = (Relation)tempDesign.getDesignObject(tempAttr.getGeneratorID());
                Relation rel = (Relation)this.getCorrObject(tempRelation.getObjectID());
                attr.setGeneratorID(rel.getObjectID());
            }
            for (i = 0; i < entity.getKeys().length; ++i) {
                candKey = entity.getKeys()[i];
                if (candKey.getImportedId() == null || "User generated".equals((tempCandKey = tempEntity.getKeyObject(candKey.getImportedId())).getGeneratorID())) continue;
                tempIndex = (KeyObject)tempDesign.getDesignObject(tempCandKey.getGeneratorID());
                index = (KeyObject)this.getCorrObject(tempIndex.getObjectID());
                candKey.setGeneratorID(index.getObjectID());
            }
        }
        it = this.getLogicalDesign().getRelationSet().iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            if (rel.getImportedId() == null || "User generated".equals((tempRel = (Relation)tempDesign.getDesignObject(rel.getImportedId())).getGeneratorID()) || (tempFk = (FKIndexAssociation)tempDesign.getDesignObject(tempRel.getGeneratorID())) == null) continue;
            fk = (FKIndexAssociation)this.getCorrObject(tempFk.getObjectID());
            rel.setGeneratorID(fk.getObjectID());
        }
        it = this.getRelationalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            int i;
            table = (Table)it.next();
            if (table.getImportedId() == null || (tempTable = (Table)tempDesign.getDesignObject(table.getImportedId())) == null || "User generated".equals(tempTable.getGeneratorID()) || (tempEntity = (Entity)tempDesign.getDesignObject(tempTable.getGeneratorID())) == null) continue;
            entity = (Entity)this.getCorrObject(tempEntity.getObjectID());
            table.setGeneratorID(entity.getObjectID());
            for (i = 0; i < table.getElements().length; ++i) {
                col = (Column)table.getElements()[i];
                if (col.getImportedId() == null || "User generated".equals((tempCol = (Column)tempTable.getElementByID(col.getImportedId())).getGeneratorID())) continue;
                if (tempDesign.getDesignObject(tempCol.getGeneratorID()) instanceof Attribute) {
                    tempAttr = (Attribute)tempDesign.getDesignObject(tempCol.getGeneratorID());
                    attr = (Attribute)this.getCorrObject(tempAttr.getObjectID());
                    col.setGeneratorID(attr.getObjectID());
                    continue;
                }
                if (!(tempDesign.getDesignObject(tempCol.getGeneratorID()) instanceof FKIndexAssociation)) continue;
                tempFk = (FKIndexAssociation)tempDesign.getDesignObject(tempCol.getGeneratorID());
                fk = (FKIndexAssociation)this.getCorrObject(tempFk.getObjectID());
                col.setGeneratorID(fk.getObjectID());
            }
            for (i = 0; i < table.getKeys().length; ++i) {
                index = table.getKeys()[i];
                if (index.getImportedId() == null || "User generated".equals((tempIndex = tempTable.getKeyObject(index.getImportedId())).getGeneratorID())) continue;
                tempCandKey = (KeyObject)tempDesign.getDesignObject(tempIndex.getGeneratorID());
                candKey = (KeyObject)this.getCorrObject(tempCandKey.getObjectID());
                index.setGeneratorID(candKey.getObjectID());
            }
        }
        it = this.getRelationalDesign().getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            fk = (FKIndexAssociation)it.next();
            if (fk.getImportedId() == null || "User generated".equals((tempFk = (FKIndexAssociation)tempDesign.getDesignObject(fk.getImportedId())).getGeneratorID())) continue;
            tempRel = (Relation)tempDesign.getDesignObject(tempFk.getGeneratorID());
            Relation rel = (Relation)this.getCorrObject(tempRel.getObjectID());
            fk.setGeneratorID(rel.getObjectID());
        }
    }

    public DesignObject getCorrObject(String id) {
        for (DesignObject obj : this.getAllTopLevelObjects()) {
            if (obj.getImportedId() == null || !obj.getImportedId().equalsIgnoreCase(id)) continue;
            return obj;
        }
        return null;
    }

    public void addImportedDesignName(String name) {
        this.getImportedDesignsSet().add(name);
    }

    private Set getImportedDesignsSet() {
        if (this.importedDesigns == null) {
            this.importedDesigns = new TreeSet();
        }
        return this.importedDesigns;
    }

    public String[] getImportedDesignNames() {
        int size = this.getImportedDesignsSet().size();
        return this.getImportedDesignsSet().toArray(new String[size]);
    }

    public boolean isDesign() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getRepositoryOID() != null && this.isLoadFromDB() && !this.isLoading()) {
            return !this.isCheckedOutByMe();
        }
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public RelationalDesign addRelationalDesign() {
        RelationalDesign rdes;
        this.relationalDesign = rdes = this.addRelationalDesign(null);
        return rdes;
    }

    public RelationalDesign addRelationalDesign(String name) {
        RelationalDesign design = (RelationalDesign)this.pdesignSet.createElement(null);
        design.setDesign(this);
        if (this.relationalDesign == null) {
            this.relationalDesign = design;
        }
        if (name != null) {
            RelationalDesign oldDes = (RelationalDesign)this.getRelationalDesigns().getByName(name);
            if (oldDes != null && oldDes != design) {
                Object tempName = name;
                int p = 1;
                while (oldDes != null && oldDes != design) {
                    tempName = name + "(" + ++p + ")";
                    oldDes = (RelationalDesign)this.getRelationalDesigns().getByName((String)tempName);
                }
                name = tempName;
            }
            design.setName(name);
        }
        if (ApplicationView.isGUIMode()) {
            design.getMainView().setName(design.getName());
        }
        this.setModelListChanged(true);
        return design;
    }

    public void addToListOfLoaded(RelationalDesign pdes) {
        Iterator it = this.loadedRelDesIDs.iterator();
        String desId = pdes.getObjectID();
        while (it.hasNext()) {
            String id = (String)it.next();
            if (!id.equalsIgnoreCase(desId)) continue;
            return;
        }
        this.loadedRelDesIDs.add(desId);
    }

    public void removeDeletedRelationalDesigns() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String oldID : this.loadedRelDesIDs) {
            if (oldID == null) continue;
            Iterator rdit = this.pdesignSet.iterator();
            boolean found = false;
            while (rdit.hasNext()) {
                RelationalDesign pd = (RelationalDesign)rdit.next();
                if (pd == null || !oldID.equalsIgnoreCase(pd.getObjectID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            String rdesPath = this.makeRelDesignPath(oldID);
            String rdesFileName = rdesPath + ".xml" + (this.compressedDesign ? "z" : "");
            list.add(rdesPath);
            list.add(rdesFileName);
        }
        if (list.size() > 0) {
            XMLPersistenceManager pm = this.getAppView().getPersistenceManager();
            ((PersistenceManager)pm).deleteFiles(list);
        }
    }

    private String makeRelDesignPath(String desID) {
        StringBuffer sb = new StringBuffer(this.getDesignPath());
        sb.append("/").append(this.getFileName());
        sb.append("/").append("rel");
        sb.append("/").append(desID);
        return sb.toString();
    }

    public void removeRelationalDesign(RelationalDesign design) {
        if (design != null) {
            this.pdesignSet.remove(design);
            design.clearDesignPart();
            design.fireDeleted();
            design.removeDesignPartListener(this.getExtendedMap());
            if (this.getRelationalDesign() == design) {
                if (this.pdesignSet.size() > 0) {
                    this.setRelationalDesign((RelationalDesign)this.pdesignSet.getElement(0));
                } else {
                    this.setRelationalDesign(null);
                }
            }
            this.getExtendedMap().removeAllMappingsForDesignPart(design.getObjectID());
            this.setDirty(true);
            this.setModelListChanged(true);
        }
    }

    public void removeMultidimensionalDesign(MultidimensionalDesign design) {
        if (design != null) {
            this.mddSet.remove(design);
            design.clearDesignPart();
            design.fireDeleted();
            this.setDirty(true);
            this.setModelListChanged(true);
        }
    }

    public ChangeRequestSet getChangeRequestSet() {
        if (this.changeRequestSet == null) {
            this.changeRequestSet = new ChangeRequestSet(this.getLogicalDesign());
            this.changeRequestSet.setDesign(this);
            this.changeRequestSet.setName(Messages.getString("Design.ChangeRequests"));
            this.changeRequestSet.setParent(this);
        }
        return this.changeRequestSet;
    }

    public RelationalDesignSet getRelationalDesigns() {
        return this.pdesignSet;
    }

    public List<RelationalDesign> getLoadedRelationalDesigns() {
        ArrayList<RelationalDesign> list = new ArrayList<RelationalDesign>();
        for (RelationalDesign rd : this.pdesignSet) {
            if (!rd.isLoaded()) continue;
            list.add(rd);
        }
        return list;
    }

    public RelationalDesign getFirstOpenRelationalDesign() {
        if (this.pdesignSet.size() > 0) {
            if (this.getRelationalDesign().isLoaded()) {
                return this.getRelationalDesign();
            }
            for (RelationalDesign next : this.pdesignSet) {
                if (!next.isLoaded()) continue;
                this.setRelationalDesign(next);
                return next;
            }
        }
        return null;
    }

    public MultidimensionalDesignSet getMultidimensionalDesigns() {
        return this.mddSet;
    }

    public boolean isEngineerCoordinates() {
        return this.engineerCoordinates;
    }

    public void setEngineerCoordinates(boolean engineerCoordinates) {
        this.engineerCoordinates = engineerCoordinates;
    }

    public boolean isPropagatePKChahges() {
        return this.propagatePKChahges;
    }

    public void setPropagatePKChahges(boolean propagatePKChahges) {
        this.propagatePKChahges = propagatePKChahges;
    }

    public boolean isShowEngineeringInTree() {
        return this.showEngineeringInTree;
    }

    public void setShowEngineeringInTree(boolean showEngineerinInTree) {
        this.showEngineeringInTree = showEngineerinInTree;
    }

    public boolean isEngineerGenerated() {
        return this.engineerGenerated;
    }

    public void setEngineerGenerated(boolean engineerGenerated) {
        this.engineerGenerated = engineerGenerated;
    }

    public boolean isCapitalNames() {
        return this.capitalNames;
    }

    public void setCapitalNames(boolean capitalNames) {
        this.capitalNames = capitalNames;
    }

    public boolean isReplaceSpaces() {
        return this.replaceSpaces;
    }

    public void setReplaceSpaces(boolean replaceSpaces) {
        this.replaceSpaces = replaceSpaces;
    }

    public boolean isDeleteWithoutOrigin() {
        return this.deleteWithoutOrigin;
    }

    public void setDeleteWithoutOrigin(boolean deleteWithoutOrigin) {
        this.deleteWithoutOrigin = deleteWithoutOrigin;
    }

    public boolean isShowMappingsInEngineeringDialog() {
        return this.showMappingsInEngineeringDialog;
    }

    public void setShowMappingsInEngineeringDialog(boolean showMappingsInEngineeringDialog) {
        this.showMappingsInEngineeringDialog = showMappingsInEngineeringDialog;
    }

    public Collection getDomainFileNames() {
        if (this.domainFileNames == null) {
            this.domainFileNames = new ArrayList();
        }
        return this.domainFileNames;
    }

    public boolean isCleaning() {
        return this.cleaning;
    }

    public void setCleaning(boolean cleaning) {
        this.cleaning = cleaning;
    }

    public boolean isLoading() {
        if (this.getAppView() != null) {
            return ApplicationView.loading;
        }
        return false;
    }

    public boolean isDisableTreeUpdate() {
        return this.disableTreeUpdate;
    }

    public void setDisableTreeUpdate(boolean disableTreeUpdate) {
        this.disableTreeUpdate = disableTreeUpdate;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof SensitiveType) {
                this.stSet.add(event.getAffected());
            } else if (event.getAffected() instanceof TSDPPolicy) {
                this.tsdpPolicySet.add(event.getAffected());
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof SensitiveType) {
                this.stSet.remove(event.getAffected());
            } else if (event.getAffected() instanceof TSDPPolicy) {
                this.tsdpPolicySet.remove(event.getAffected());
            }
        }
    }

    public boolean isEngineerAsSubView() {
        return this.engineerAsSubView;
    }

    public void setEngineerAsSubView(boolean engineerAsSubView) {
        this.engineerAsSubView = engineerAsSubView;
    }

    public float getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setLoadedVersion(float loadedVersion) {
        this.loadedVersion = loadedVersion;
    }

    public float getVersion() {
        return 3.5f;
    }

    public boolean isImportToCurrent() {
        return this.importToCurrent;
    }

    public void setImportToCurrent(boolean importToCurrent) {
        this.importToCurrent = importToCurrent;
    }

    public ExtendedMap getExtendedMap() {
        if (this.extendedMap == null) {
            this.extendedMap = new ExtendedMap(this);
            this.getLogicalDesign().addDesignPartListener(this.extendedMap);
            for (RelationalDesign pd : this.getRelationalDesigns()) {
                pd.addDesignPartListener(this.extendedMap);
            }
        }
        return this.extendedMap;
    }

    public String getDesignID() {
        return this.getObjectID();
    }

    public void setDesignID(String designID) {
        this.setObjectID(designID);
    }

    public void closeAllDiagrams() {
        DesignPartViewPlaceHolder dpvph;
        Iterator itsv;
        this.getLogicalDesign().setMainViewVisible(false);
        Iterator it = this.getLogicalDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            if (!ph.getDesignPartView().mustBeVisible()) continue;
            ph.setVisible(false);
        }
        for (int i = 0; i < this.getRelationalDesigns().size(); ++i) {
            RelationalDesign ph = (RelationalDesign)this.getRelationalDesigns().getElement(i);
            ph.setMainViewVisible(false);
            itsv = ph.getDesignSubviews().iterator();
            while (itsv.hasNext()) {
                dpvph = (DesignPartViewPlaceHolder)itsv.next();
                dpvph.setVisible(false);
            }
        }
        this.getDataTypesDesign().setMainViewVisible(false);
        it = this.getDataTypesDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            ph.setVisible(false);
        }
        for (int i = 0; i < this.getMultidimensionalDesigns().size(); ++i) {
            MultidimensionalDesign mdm = (MultidimensionalDesign)this.getMultidimensionalDesigns().getElement(i);
            mdm.setMainViewVisible(false);
            itsv = mdm.getDesignSubviews().iterator();
            while (itsv.hasNext()) {
                dpvph = (DesignPartViewPlaceHolder)itsv.next();
                dpvph.setVisible(false);
            }
        }
        for (DataFlowDesign dfDesign : this.getProcessModel().getDataFlowDesigns()) {
            if (!dfDesign.isLoaded() || !dfDesign.isVisible()) continue;
            dfDesign.setMainViewVisible(false);
        }
        it = this.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            for (TransformationTask task : pack.getTransformationTaskSet()) {
                if (!task.isVisible()) continue;
                task.setMainViewVisible(false);
            }
        }
    }

    public void selectLastOpenDPV() {
        DesignPartView dpv = this.findDPV(this.getAppView().getSettings().getLastOpenDPV());
        if (dpv != null) {
            this.getAppView().setCurrentDPV(dpv);
        }
    }

    public DesignPartView findDPV(String dpvID) {
        try {
            if (dpvID != null && dpvID.length() > 0) {
                DesignPartViewPlaceHolder dpvph;
                Iterator itsv;
                if (dpvID.equalsIgnoreCase(this.getLogicalDesign().getMainViewID())) {
                    return this.getLogicalDesign().getMainView();
                }
                Iterator it = this.getLogicalDesign().getDesignSubviews().iterator();
                while (it.hasNext()) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
                    if (!dpvID.equalsIgnoreCase(ph.getDesignPartView().getDPVId())) continue;
                    return ph.getDesignPartView();
                }
                for (int i = 0; i < this.getRelationalDesigns().size(); ++i) {
                    RelationalDesign ph = (RelationalDesign)this.getRelationalDesigns().getElement(i);
                    if (dpvID.equalsIgnoreCase(ph.getMainViewID())) {
                        return ph.getMainView();
                    }
                    itsv = ph.getDesignSubviews().iterator();
                    while (itsv.hasNext()) {
                        dpvph = (DesignPartViewPlaceHolder)itsv.next();
                        if (!dpvID.equalsIgnoreCase(dpvph.getDesignPartView().getDPVId())) continue;
                        return dpvph.getDesignPartView();
                    }
                }
                if (dpvID.equalsIgnoreCase(this.getDataTypesDesign().getMainViewID())) {
                    return this.getDataTypesDesign().getMainView();
                }
                it = this.getDataTypesDesign().getDesignSubviews().iterator();
                while (it.hasNext()) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
                    if (!dpvID.equalsIgnoreCase(ph.getDesignPartView().getDPVId())) continue;
                    return ph.getDesignPartView();
                }
                for (int i = 0; i < this.getMultidimensionalDesigns().size(); ++i) {
                    MultidimensionalDesign mdm = (MultidimensionalDesign)this.getMultidimensionalDesigns().getElement(i);
                    if (dpvID.equalsIgnoreCase(mdm.getMainViewID())) {
                        return mdm.getMainView();
                    }
                    itsv = mdm.getDesignSubviews().iterator();
                    while (itsv.hasNext()) {
                        dpvph = (DesignPartViewPlaceHolder)itsv.next();
                        if (!dpvID.equalsIgnoreCase(dpvph.getDesignPartView().getDPVId())) continue;
                        return dpvph.getDesignPartView();
                    }
                }
                for (DataFlowDesign dfDesign : this.getProcessModel().getDataFlowDesigns()) {
                    if (!dfDesign.isLoaded() || !dfDesign.isVisible() || !dpvID.equalsIgnoreCase(dfDesign.getMainViewID())) continue;
                    return dfDesign.getMainView();
                }
                it = this.getProcessModel().getTransformationPackageSet().iterator();
                while (it.hasNext()) {
                    TransformationPackage pack = (TransformationPackage)it.next();
                    for (TransformationTask task : pack.getTransformationTaskSet()) {
                        if (!task.isVisible() || !dpvID.equalsIgnoreCase(task.getMainViewID())) continue;
                        return task.getMainView();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Design.findDPV", e);
        }
        return null;
    }

    public void closeAllDiagramsAndClearRefs() {
        DesignPartViewPlaceHolder dpvph;
        Iterator itsv;
        this.getLogicalDesign().setMainViewVisible(false);
        this.getLogicalDesign().getMainView().clearCellRefsToObjects();
        this.getLogicalDesign().getMainView().getController().setDesignPartView(null);
        Iterator it = this.getLogicalDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            ph.setVisible(false);
            ph.getDesignPartView().clearCellRefsToObjects();
            ph.getDesignPartView().getController().setDesignPartView(null);
        }
        for (int i = 0; i < this.getRelationalDesigns().size(); ++i) {
            RelationalDesign ph = (RelationalDesign)this.getRelationalDesigns().getElement(i);
            ph.setMainViewVisible(false);
            ph.getMainView().clearCellRefsToObjects();
            ph.getMainView().getController().setDesignPartView(null);
            itsv = ph.getDesignSubviews().iterator();
            while (itsv.hasNext()) {
                dpvph = (DesignPartViewPlaceHolder)itsv.next();
                dpvph.setVisible(false);
                dpvph.getDesignPartView().clearCellRefsToObjects();
                dpvph.getDesignPartView().getController().setDesignPartView(null);
            }
        }
        this.getDataTypesDesign().setMainViewVisible(false);
        this.getDataTypesDesign().getMainView().clearCellRefsToObjects();
        it = this.getDataTypesDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            ph.setVisible(false);
            ph.getDesignPartView().clearCellRefsToObjects();
        }
        for (int i = 0; i < this.getMultidimensionalDesigns().size(); ++i) {
            MultidimensionalDesign mdm = (MultidimensionalDesign)this.getMultidimensionalDesigns().getElement(i);
            mdm.setMainViewVisible(false);
            mdm.getMainView().clearCellRefsToObjects();
            itsv = mdm.getDesignSubviews().iterator();
            while (itsv.hasNext()) {
                dpvph = (DesignPartViewPlaceHolder)itsv.next();
                dpvph.setVisible(false);
                dpvph.getDesignPartView().clearCellRefsToObjects();
            }
        }
        for (DataFlowDesign dfDesign : this.getProcessModel().getDataFlowDesigns()) {
            if (!dfDesign.isLoaded() || !dfDesign.isVisible()) continue;
            dfDesign.setMainViewVisible(false);
            dfDesign.getMainView().clearCellRefsToObjects();
        }
        it = this.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            for (TransformationTask task : pack.getTransformationTaskSet()) {
                if (!task.isVisible()) continue;
                task.setMainViewVisible(false);
                task.getMainView().clearCellRefsToObjects();
            }
        }
    }

    public boolean isApplyNameSubstitution() {
        return this.applyNameSubstitution;
    }

    public void setApplyNameSubstitution(boolean applyNameSubstitution) {
        this.applyNameSubstitution = applyNameSubstitution;
    }

    public String getUnloadDirectory() {
        return this.unloadDirectory;
    }

    public void setUnloadDirectory(String unloadDirectory) {
        this.unloadDirectory = unloadDirectory;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = currentOperation;
    }

    public void addDesignPartView(DesignPartView dpv) {
        String dpvID = dpv.getDPVId();
        if (dpvID != null && !"".equalsIgnoreCase(dpvID)) {
            this.dpvs.remove(dpvID);
            this.dpvs.put(dpvID, dpv);
        }
    }

    public void removeDesignPartView(DesignPartView dpv) {
        String dpvID = dpv.getDPVId();
        if (dpvID != null && !"".equalsIgnoreCase(dpvID)) {
            Object[] keys = this.dpvs.keySet().toArray();
            for (int i = keys.length - 1; i >= 0; --i) {
                Object value = this.dpvs.get(keys[i]);
                if (!value.equals(dpv)) continue;
                this.dpvs.remove(keys[i]);
                this.removeDesignListener(dpv);
            }
            this.dpvs.remove(dpvID);
        } else {
            Object[] values = this.dpvs.values().toArray();
            for (int i = values.length - 1; i >= 0; --i) {
                Object value = values[i];
                if (value != dpv) continue;
                this.dpvs.remove(dpv);
                this.removeDesignListener(dpv);
            }
        }
    }

    public DesignPartView getDesignPartView(String dpvID) {
        return (DesignPartView)this.dpvs.get(dpvID);
    }

    public boolean hasUsageOfStructuredType(StructuredType st) {
        for (RelationalDesign phd : this.getRelationalDesigns()) {
            if (!phd.hasUsageOfStructuredType(st)) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlossaries() {
        return this.getNamingStandardRule().getGlossariesList().size() > 0;
    }

    public void clearGlossaries() {
        this.getNamingStandardRule().clearGlossaries();
    }

    private Glossary getValidRelationalNameGlossary(DesignObject dobj) {
        int ctype;
        String name = dobj.getName().trim();
        NamingStandardRule namingRule = this.getNamingStandardRule();
        List rules = dobj instanceof Table || dobj instanceof TableView ? namingRule.getTablesList() : (dobj instanceof Column ? namingRule.getColumnsList() : new ArrayList());
        List list = namingRule.getGlossaries();
        if (list.size() == 0) {
            list.add(Glossary.getEmptyGlossary());
        }
        Iterator it = list.iterator();
        NamingOptionsHolder oph = dobj.getDesignPart().getNamingOptionsHolderFor(dobj.getClass());
        if (oph == null) {
            oph = dobj.getDesignPart().getNamingOptionsHolderFor(Table.class);
        }
        boolean upperCaseOnly = false;
        if (oph != null && (ctype = oph.getCaseType()) == 0) {
            upperCaseOnly = true;
        }
        char relSep = namingRule.getRelationalSeparatorChar();
        boolean abbreviatedOnly = namingRule.isAbbreviatedOnly();
        while (it.hasNext()) {
            Glossary glossary = (Glossary)it.next();
            String error = glossary.checkValidName(name, rules, relSep, false, upperCaseOnly, true, abbreviatedOnly);
            if (error != null) continue;
            return glossary;
        }
        return null;
    }

    private Glossary getValidLogicalNameGlossary(DesignObject dobj) {
        String name = dobj.getName().trim();
        NamingStandardRule namingRule = this.getNamingStandardRule();
        List rules = dobj instanceof Entity || dobj instanceof EntityView ? namingRule.getEntitiesList() : (dobj instanceof Attribute ? namingRule.getAttributesList() : new ArrayList());
        List list = namingRule.getGlossaries();
        if (list.size() == 0) {
            list.add(Glossary.getEmptyGlossary());
        }
        Iterator it = list.iterator();
        char logSep = namingRule.getLogicalSeparatorChar();
        boolean titleCaseSep = "Title Case".equalsIgnoreCase(namingRule.getLogicalSep());
        while (it.hasNext()) {
            Glossary glossary = (Glossary)it.next();
            String error = glossary.checkValidName(name, rules, logSep, titleCaseSep, false, false, false);
            if (error != null) continue;
            return glossary;
        }
        return null;
    }

    private Class getCorrespondentClass(DesignObject dobj) {
        if (dobj instanceof Table) {
            return Entity.class;
        }
        if (dobj instanceof Column) {
            return Attribute.class;
        }
        if (dobj instanceof TableView) {
            return EntityView.class;
        }
        if (dobj instanceof Entity) {
            return Table.class;
        }
        if (dobj instanceof EntityView) {
            return TableView.class;
        }
        if (dobj instanceof Attribute) {
            return Column.class;
        }
        return DesignObject.class;
    }

    public String transformNameFromLogicalToRelational(DesignObject dobj) {
        return this.transformNameFromLogicalToRelational(dobj, null, null);
    }

    public String transformNameFromLogicalToRelational(DesignObject dobj, DesignObject relObject, FKContainer table) {
        Relation rel;
        NamingStandardRule namingRule = this.getNamingStandardRule();
        RelationalDesign phdes = dobj.getDesign().getRelationalDesign();
        NamingOptionsHolder oph = phdes.getNamingOptionsHolderFor(this.getCorrespondentClass(dobj));
        if (oph == null) {
            oph = phdes.getNamingOptionsHolderFor(Table.class);
        }
        boolean upperCaseOnly = false;
        int ctype = -1;
        if (oph != null && (ctype = oph.getCaseType()) == 0) {
            upperCaseOnly = true;
        }
        Object name = dobj.getName().trim();
        char logSep = namingRule.getLogicalSeparatorChar();
        char relSep = namingRule.getRelationalSeparatorChar();
        Glossary glossary = null;
        String preferredAbbreviation = "";
        Relation relM_N = null;
        boolean glossaryRelated = false;
        if (dobj instanceof Entity) {
            preferredAbbreviation = ((Entity)dobj).getPreferredAbbreviation();
            glossaryRelated = true;
        } else if (dobj instanceof Attribute) {
            preferredAbbreviation = ((Attribute)dobj).getPreferredAbbreviation();
            glossaryRelated = ApplyNamingStandards.applyToFKColumn ? !((Attribute)dobj).isFKAttribute() : true;
        } else if (dobj instanceof Relation && (rel = (Relation)dobj).isManyToMany() && !(rel instanceof InheritanceRelation)) {
            relM_N = rel;
            glossaryRelated = true;
        }
        if (this.isApplyNameStandardization() && this.isUsePreferredAbbreviation() && !"".equals(preferredAbbreviation)) {
            if (upperCaseOnly) {
                return preferredAbbreviation.toUpperCase();
            }
            return preferredAbbreviation;
        }
        if (this.isApplyNameStandardization() && glossaryRelated) {
            glossary = this.getValidLogicalNameGlossary(dobj);
            boolean titleCaseSep = "Title Case".equalsIgnoreCase(namingRule.getLogicalSep());
            if (glossary != null || titleCaseSep) {
                int nameSize = this.getRelationalNamesize(dobj, phdes);
                if (glossary == null) {
                    glossary = new Glossary(null);
                    glossary.setIncompleteModifiers(true);
                }
                List nameTerms = glossary.getTerms((String)name, logSep, titleCaseSep);
                Object newName = "";
                if (nameTerms.size() == 1 && (dobj instanceof Entity || relM_N != null)) {
                    Glossary.NamePart part = (Glossary.NamePart)nameTerms.get(0);
                    if (part.word != null && !"".equals(part.word.getPlural().trim())) {
                        newName = part.word.getPlural().trim();
                    }
                }
                boolean entity = false;
                if (dobj instanceof Entity || relM_N != null) {
                    entity = true;
                }
                if ("".equals(newName)) {
                    newName = this.transform(nameTerms, nameSize, 0, relSep, false, entity);
                }
                if (dobj instanceof Attribute) {
                    String shname;
                    Entity ent = ((Attribute)dobj).getEntity();
                    if (EngineeringCompareDialog.PREFIX_ENT_HIER_COLS && ent.isHierarchicalEntityType() && !"".equals(shname = ent.getShortName())) {
                        newName = shname + relSep + (String)newName;
                    }
                }
                if (upperCaseOnly) {
                    return ((String)newName).toUpperCase();
                }
                if (ctype == 1) {
                    return ((String)newName).toLowerCase();
                }
                return newName;
            }
        }
        if (this.isApplyNameStandardization()) {
            if (!glossaryRelated) {
                name = this.getNamingTemplateName(dobj, relObject, table);
                if (dobj instanceof Attribute && ((Attribute)dobj).isFKAttribute()) {
                    name = this.getNamingTemplateName(dobj, relObject, table);
                }
            } else if (dobj instanceof Attribute && ((Attribute)dobj).isFKAttribute() && ApplyNamingStandards.applyToFKColumn) {
                name = this.getNamingTemplateName(dobj, relObject, table);
            } else if (dobj instanceof Attribute) {
                String shname;
                Entity ent = ((Attribute)dobj).getEntity();
                if (EngineeringCompareDialog.PREFIX_ENT_HIER_COLS && ent.isHierarchicalEntityType() && !"".equals(shname = ent.getShortName())) {
                    name = shname + relSep + (String)name;
                }
            }
        }
        name = AbstractEngineering.transformSeparatorFromLogical((String)name, logSep, relSep);
        if (ctype == 0) {
            return ((String)name).toUpperCase();
        }
        if (ctype == 1) {
            return ((String)name).toLowerCase();
        }
        return name;
    }

    private String getNamingTemplateName(DesignObject dobj, DesignObject relObject, FKContainer table) {
        FKElement refcol;
        FKIndexAssociation fk;
        Column col;
        String name = dobj.getName();
        String tableName = "";
        String tableAbbr = "";
        String modelName = "";
        boolean hasSK = false;
        if (table != null) {
            tableName = table.getName();
            tableAbbr = table.getAbbreviation();
            modelName = table.getRelationalModel().getName();
            Index ind = (Index)table.getPK();
            if (ind != null && ind.isSurrogateKey()) {
                hasSK = true;
            }
        }
        if (dobj instanceof CandidateKey) {
            CandidateKey key = (CandidateKey)dobj;
            if (table == null) {
                tableName = this.transformNameFromLogicalToRelational(key.getEntity());
                tableAbbr = key.getEntity().getShortName();
            }
            if (key.isPK()) {
                if (key.getEntity().isCreateSurrogateKey() || hasSK) {
                    int ind = -1;
                    if (relObject != null && relObject instanceof Index) {
                        Index index = (Index)relObject;
                        ind = index.getTable().getUniqueKeysList().indexOf(index);
                    }
                    name = relObject instanceof KeyObject ? ApplyNamingStandards.createUK_Name((KeyObject)relObject, ind, this.namingRule, modelName, tableName, tableAbbr) : ApplyNamingStandards.createUK_Name(tableName, ind, this.getDesignLevelSettings().getNamingStandardRule(), modelName, tableAbbr);
                } else {
                    name = ApplyNamingStandards.createPK_Name(tableName, this.getDesignLevelSettings().getNamingStandardRule(), modelName, tableAbbr);
                }
            } else {
                int ind = key.getEntity().getUniqueKeysList().indexOf(key);
                if (relObject != null && relObject instanceof Index) {
                    Index index = (Index)relObject;
                    ind = index.getTable().getUniqueKeysList().indexOf(index);
                }
                name = relObject instanceof KeyObject ? ApplyNamingStandards.createUK_Name((KeyObject)relObject, ind, this.namingRule, modelName, tableName, tableAbbr) : ApplyNamingStandards.createUK_Name(tableName, ind, this.getDesignLevelSettings().getNamingStandardRule(), modelName, tableAbbr);
            }
        } else if (dobj instanceof Relation) {
            if (relObject != null && relObject instanceof FKIndexAssociation) {
                name = ApplyNamingStandards.createFK_Name((Relation)dobj, (FKIndexAssociation)relObject, this.getDesignLevelSettings().getNamingStandardRule());
            }
        } else if (dobj instanceof Attribute && ((Attribute)dobj).isFKAttribute() && relObject instanceof Column && (col = (Column)relObject).isFKColumn() && col.getAllFKs().size() == 1 && (fk = col.getFKIndexAssociation()) != null && (refcol = col.getReferencedColumn(fk)) != null) {
            name = ApplyNamingStandards.createFKColumnName(refcol, fk, this.getDesignLevelSettings().getNamingStandardRule(), fk.getTable());
        }
        return name;
    }

    private String transform(List nameTerms, int nameSize, int position, char relSep, boolean altAbbr, boolean entity) {
        String newName = "";
        int usage = 0;
        if (position < nameTerms.size()) {
            String term = "";
            Glossary.NamePart part = (Glossary.NamePart)nameTerms.get(position);
            if (part.word != null) {
                GlossaryWord word = part.word;
                if (entity && position == nameTerms.size() - 1 && !"".equalsIgnoreCase(word.getPlural())) {
                    term = word.getPlural();
                    usage = 5;
                } else if (!"".equalsIgnoreCase(word.getAbbreviation()) && !altAbbr) {
                    term = word.getAbbreviation();
                    usage = 1;
                } else if (!"".equalsIgnoreCase(word.getAltAbbrevation())) {
                    term = word.getAltAbbrevation();
                    usage = 2;
                } else if (altAbbr && "".equalsIgnoreCase(word.getAltAbbrevation()) && !"".equalsIgnoreCase(word.getAbbreviation())) {
                    term = word.getAbbreviation();
                    usage = 2;
                } else {
                    term = word.getName();
                    usage = 3;
                }
            } else {
                term = part.namePart;
                usage = 4;
            }
            newName = term;
            int newpos = position + 1;
            if (newpos < nameTerms.size()) {
                int newsize = nameSize - newName.length();
                String nextPart = this.transform(nameTerms, newsize, newpos, relSep, altAbbr, entity);
                Object temp = "";
                temp = relSep != '\u0000' && !"".equals(nextPart) ? newName + relSep + nextPart : newName + nextPart;
                if (((String)temp).length() > nameSize) {
                    if (!altAbbr) {
                        nextPart = this.transform(nameTerms, newsize, newpos, relSep, true, entity);
                        temp = relSep != '\u0000' && !"".equals(nextPart) ? newName + relSep + nextPart : newName + nextPart;
                        if (((String)temp).length() <= nameSize) {
                            return temp;
                        }
                    }
                    if (usage == 1 && part.word != null && !"".equalsIgnoreCase(part.word.getAltAbbrevation())) {
                        newName = part.word.getAltAbbrevation();
                        temp = relSep != '\u0000' && !"".equals(nextPart) ? newName + relSep + nextPart : newName + nextPart;
                        return temp;
                    }
                    return temp;
                }
                return temp;
            }
            if (newName.length() > nameSize && usage == 1 && part.word != null && !"".equalsIgnoreCase(part.word.getAltAbbrevation())) {
                return part.word.getAltAbbrevation();
            }
            return newName;
        }
        return newName;
    }

    private int getRelationalNamesize(DesignObject object, RelationalDesign reld) {
        NamingOptionsHolder nh = null;
        nh = object instanceof CandidateKey || object instanceof Entity ? reld.getNamingOptionsHolderFor(Table.class) : (object instanceof Attribute ? reld.getNamingOptionsHolderFor(Column.class) : (object instanceof EntityView ? reld.getNamingOptionsHolderFor(TableView.class) : reld.getNamingOptionsHolderFor(object.getClass())));
        if (nh != null) {
            int size = nh.getMaxNameLength();
            return size;
        }
        return 18;
    }

    public String transformNameFromRelationalToLogical(DesignObject dobj) {
        return this.transformNameFromRelationalToLogical(dobj, null);
    }

    public String transformNameFromRelationalToLogical(DesignObject dobj, DesignObject logObj) {
        String abbr;
        NamingStandardRule namingRule = this.getNamingStandardRule();
        LogicalDesign ldes = dobj.getDesign().getLogicalDesign();
        NamingOptionsHolder oph = ldes.getNamingOptionsHolderFor(this.getCorrespondentClass(dobj));
        if (oph == null) {
            oph = ldes.getNamingOptionsHolderFor(Entity.class);
        }
        boolean upperCaseOnly = false;
        int ctype = -1;
        if (oph != null && (ctype = oph.getCaseType()) == 0) {
            upperCaseOnly = true;
        }
        String name = dobj.getName().trim();
        if (dobj instanceof Column && !"".equals(abbr = ((Column)dobj).getTable().getAbbreviation()) && name.toUpperCase().startsWith(abbr.toUpperCase() + "_")) {
            name = name.substring(abbr.length() + 1);
        }
        Glossary glossary = null;
        char logSep = namingRule.getLogicalSeparatorChar();
        char relSep = namingRule.getRelationalSeparatorChar();
        if (this.isApplyNameStandardization() && (glossary = this.getValidRelationalNameGlossary(dobj)) != null) {
            boolean titleCaseSep = "Title Case".equalsIgnoreCase(namingRule.getLogicalSep());
            boolean abbreviatedOnly = namingRule.isAbbreviatedOnly();
            List nameTerms = glossary.getTerms(name, relSep, false, true, upperCaseOnly, abbreviatedOnly);
            Object newName = "";
            boolean first = true;
            Iterator it = nameTerms.iterator();
            while (it.hasNext()) {
                Object term = "";
                Glossary.NamePart part = (Glossary.NamePart)it.next();
                term = part.word != null ? part.word.getName() : part.namePart;
                if (titleCaseSep && !"".equalsIgnoreCase((String)term)) {
                    term = ((String)term).length() > 1 ? Character.toUpperCase(((String)term).charAt(0)) + ((String)term).substring(1, ((String)term).length()) : "" + Character.toUpperCase(((String)term).charAt(0));
                }
                if (first) {
                    newName = term;
                    first = false;
                    continue;
                }
                if (logSep != '\u0000' && !titleCaseSep) {
                    newName = (String)newName + logSep + (String)term;
                    continue;
                }
                newName = (String)newName + (String)term;
            }
            if (ctype == 0) {
                return ((String)newName).toUpperCase();
            }
            if (ctype == 1) {
                return ((String)newName).toLowerCase();
            }
            return newName;
        }
        if (this.isApplyNameStandardization()) {
            name = AbstractEngineering.transformSeparatorFromRelational(name, relSep, logSep);
        }
        if (ctype == 0) {
            return name.toUpperCase();
        }
        if (ctype == 1) {
            return name.toLowerCase();
        }
        return name;
    }

    public boolean isApplyNameStandardization() {
        return this.applyNameStandardization;
    }

    public void setApplyNameStandardization(boolean applyNameStandardization) {
        this.applyNameStandardization = applyNameStandardization;
    }

    public boolean isUsePreferredAbbreviation() {
        return this.usePreferredAbbreviation;
    }

    public void setUsePreferredAbbreviation(boolean usePreferredAbbreviation) {
        this.usePreferredAbbreviation = usePreferredAbbreviation;
    }

    public boolean isEditable() {
        return !ApplicationView.IS_VIEWER;
    }

    public boolean isSaveDefaultDomains() {
        return this.saveDefaultDomains;
    }

    public void setSaveDefaultDomains(boolean saveDefaultDomains) {
        this.saveDefaultDomains = saveDefaultDomains;
    }

    public void buildNativeToLogicalMappings() {
        RDBMSType[] rdbms = Design.getDefaultRDBMSTypeSet().toTypeArray();
        LogicalDatatype unknown = (LogicalDatatype)this.getLogicalDatatypeSet().getByName("UNKNOWN");
        for (int i = 0; i < rdbms.length; ++i) {
            RDBMSType dbtype = rdbms[i];
            String[] types = StandardDatatypeNames.getAllPossibleDatatypes(dbtype);
            for (int j = 0; j < types.length; ++j) {
                String type = types[j];
                String usedtype = StandardDatatypeNames.getUsedDatatypeName(type);
                LogicalDatatype ltype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, usedtype);
                if (ltype == null) {
                    ltype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, type);
                }
                if (ltype != null) continue;
                String ltypeName = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(usedtype);
                ltype = (LogicalDatatype)this.getLogicalDatatypeSet().getByName(ltypeName);
                if (ltype == null) {
                    ltype = unknown;
                }
                if (ltype == null) continue;
                MappingDatatypeNameLogicalDataType.addNativeToLogicalMapping(dbtype, type, ltype);
            }
        }
    }

    public List getExportedDesignParts() {
        return this.exportedDesignParts;
    }

    public void buildExporMaps(List list) {
        this.clearExportMaps();
        for (Object obj : list) {
            if (!(obj instanceof DesignPart)) continue;
            DesignPart dp = (DesignPart)obj;
            this.expDesPartsMap.put(dp.getObjectID(), dp);
        }
        for (Object obj : list) {
            DesignPartViewPlaceHolder ph;
            DesignPartView dpv;
            DesignPart dp;
            if (!(obj instanceof DesignPartViewPlaceHolder) || this.expDesPartsMap.get((dp = (dpv = (ph = (DesignPartViewPlaceHolder)obj).getDesignPartView()).getDesignPart()).getObjectID()) != null) continue;
            this.addSubviewObjectsToObjectsExpMap(dpv);
            this.expPartialDesPartsMap.put(dp.getObjectID(), dp);
        }
    }

    private void addSubviewObjectsToObjectsExpMap(DesignPartView dpv) {
        this.expDPVMap.put(dpv.getDPVId(), dpv);
        Collection list = dpv.getDesignPart().getStorableDesignObjects();
        for (DesignObject dobj : list) {
            TopView tv = dobj.getFirstViewForDPV(dpv);
            if (tv == null) continue;
            this.expDesObjectsMap.put(dobj.getObjectID(), dobj);
            if (!(dobj instanceof Entity) || !((Entity)dobj).isHierarchicalEntityType()) continue;
            this.addEntitySuperTypes((Entity)dobj);
        }
    }

    private void addEntitySuperTypes(Entity ent) {
        if (ent.isHierarchicalEntityType()) {
            for (Entity supert = ent.getHierarchicalParent(); supert != null; supert = supert.getHierarchicalParent()) {
                this.expDesObjectsMap.put(supert.getObjectID(), supert);
            }
        }
    }

    public boolean shouldExportFull(DesignPart designPart) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        return this.expDesPartsMap.get(designPart.getObjectID()) != null;
    }

    public boolean shouldExportPartial(DesignPart designPart) {
        return this.expPartialDesPartsMap.get(designPart.getObjectID()) != null;
    }

    public boolean shouldExport(DesignObject designObject) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        if (this.shouldExportFull(designObject.getDesignPart())) {
            return true;
        }
        return this.expDesObjectsMap.get(designObject.getObjectID()) != null;
    }

    public boolean shouldExportDPV(DesignPartView dpv) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        if (this.shouldExportFull(dpv.getDesignPart())) {
            return true;
        }
        return this.expDPVMap.get(dpv.getDPVId()) != null;
    }

    public boolean shouldExport(RelationalObjectProxy proxy) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        DesignObject dobj = proxy.getObject();
        if (dobj != null) {
            if (this.shouldExportFull(dobj.getDesignPart())) {
                return true;
            }
            if (dobj instanceof Column) {
                ContainerWithKeyObject container = ((Column)dobj).getContainerWithKeyObject();
                return this.shouldExport(container);
            }
            if (dobj instanceof Index) {
                ContainerWithKeyObject container = ((Index)dobj).getContainerWithKeyObject();
                return this.shouldExport(container);
            }
            if (dobj instanceof FKIndexAssociation) {
                ContainerWithKeyObject container = ((FKIndexAssociation)dobj).getContainerWithKeyObject();
                return this.shouldExport(container) && this.shouldExport(((FKIndexAssociation)dobj).getRemoteTable());
            }
            return this.shouldExport(dobj);
        }
        return false;
    }

    public boolean shouldExportMappedObject(DesignObject dobj) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        if (dobj != null) {
            if (this.shouldExportFull(dobj.getDesignPart())) {
                return true;
            }
            if (dobj instanceof ContainedObject) {
                ContainerObject container = ((ContainedObject)dobj).getContainer();
                return this.shouldExport(container);
            }
            if (dobj instanceof KeyObject) {
                ContainerWithKeyObject container = ((KeyObject)dobj).getContainerWithKeyObject();
                return this.shouldExport(container);
            }
            if (dobj instanceof FKIndexAssociation) {
                ContainerWithKeyObject container = ((FKIndexAssociation)dobj).getContainerWithKeyObject();
                return this.shouldExport(container);
            }
            return this.shouldExport(dobj);
        }
        return false;
    }

    public void clearExportMaps() {
        this.expDesObjectsMap.clear();
        this.expDesPartsMap.clear();
        this.expPartialDesPartsMap.clear();
        this.expDPVMap.clear();
    }

    public static void clearMap(Map map) {
        if (map != null) {
            map.clear();
        }
    }

    public static void openFailed() {
        OPEN_FAILED = true;
    }

    public List getAttrColPropertyList() {
        if (this.attrColPropertyList == null) {
            this.attrColPropertyList = new ArrayList();
            Attribute attr = new Attribute(this.getLogicalDesign());
            attr.setUseDomainConstraints(false);
            AttributeColumnComparator comp = new AttributeColumnComparator(attr, null);
            for (EngPropertyHolder holder : comp.getPropertiesList()) {
                holder.setSelected(true);
                this.attrColPropertyList.add(holder);
            }
        }
        return this.attrColPropertyList;
    }

    public void setAttrColPropertyList(List attrColPropertyList) {
        this.attrColPropertyList = attrColPropertyList;
    }

    public List getEntTablePropertyList() {
        if (this.entTablePropertyList == null) {
            this.entTablePropertyList = new ArrayList();
            Entity entity = new Entity(this.getLogicalDesign());
            EntityTableComparator comp = new EntityTableComparator(entity, null);
            for (EngPropertyHolder holder : comp.getPropertiesList()) {
                holder.setSelected(true);
                this.entTablePropertyList.add(holder);
            }
        }
        return this.entTablePropertyList;
    }

    public void setEntTablePropertyList(List entTablePropertyList) {
        this.entTablePropertyList = entTablePropertyList;
    }

    public List getKeyIdxPropertyList() {
        if (this.keyIdxPropertyList == null) {
            this.keyIdxPropertyList = new ArrayList();
            CandidateKey key = new CandidateKey(this.getLogicalDesign());
            KeyIndexComparator comp = new KeyIndexComparator(key, null);
            for (EngPropertyHolder holder : comp.getPropertiesList()) {
                holder.setSelected(true);
                this.keyIdxPropertyList.add(holder);
            }
        }
        return this.keyIdxPropertyList;
    }

    public void setKeyIdxPropertyList(List keyIdxPropertyList) {
        this.keyIdxPropertyList = keyIdxPropertyList;
    }

    public static EngPropertyHolder getEngPropertyHolder(List list, String name) {
        for (Object obj : list) {
            EngPropertyHolder holder;
            if (!(obj instanceof EngPropertyHolder) || !name.equalsIgnoreCase((holder = (EngPropertyHolder)obj).getName())) continue;
            return holder;
        }
        return null;
    }

    public List getRelFKPropertyList() {
        if (this.relFKPropertyList == null) {
            this.relFKPropertyList = new ArrayList();
            Relation rel = new Relation(this.getLogicalDesign());
            RelationFKComparator comp = new RelationFKComparator(rel, null);
            for (EngPropertyHolder holder : comp.getPropertiesList()) {
                holder.setSelected(true);
                this.relFKPropertyList.add(holder);
            }
        }
        return this.relFKPropertyList;
    }

    public void setRelFKPropertyList(List relFKPropertyList) {
        this.relFKPropertyList = relFKPropertyList;
    }

    public List getRelTablePropertyList() {
        if (this.relTablePropertyList == null) {
            this.relTablePropertyList = new ArrayList();
            Relation rel = new Relation(this.getLogicalDesign());
            RelationTableComparator comp = new RelationTableComparator(rel, null);
            for (EngPropertyHolder holder : comp.getPropertiesList()) {
                holder.setSelected(true);
                this.relTablePropertyList.add(holder);
            }
        }
        return this.relTablePropertyList;
    }

    public void setRelTablePropertyList(List relTablePropertyList) {
        this.relTablePropertyList = relTablePropertyList;
    }

    public List getViewPropertyList() {
        if (this.viewPropertyList == null) {
            this.viewPropertyList = new ArrayList();
            EntityView view = new EntityView(this.getLogicalDesign());
            EntViewTableViewComparator comp = new EntViewTableViewComparator(view, null);
            for (EngPropertyHolder holder : comp.getPropertiesList()) {
                holder.setSelected(true);
                this.viewPropertyList.add(holder);
            }
        }
        return this.viewPropertyList;
    }

    public void setViewPropertyList(List viewPropertyList) {
        this.viewPropertyList = viewPropertyList;
    }

    public boolean getShowSelPropsOnly() {
        return this.showSelPropsOnly;
    }

    public void setShowSelPropsOnly(boolean showSelPropsOnly) {
        this.showSelPropsOnly = showSelPropsOnly;
    }

    public boolean getNotForNewObjects() {
        return this.notForNewObjects;
    }

    public void setNotForNewObjects(boolean notForNewObjects) {
        this.notForNewObjects = notForNewObjects;
    }

    public boolean getExcludeFromTree() {
        return this.excludeFromTree;
    }

    public void setExcludeFromTree(boolean excludeFromTree) {
        this.excludeFromTree = excludeFromTree;
    }

    private void clearCompareLists() {
        if (this.entTablePropertyList != null) {
            this.entTablePropertyList.clear();
            this.entTablePropertyList = null;
        }
        if (this.attrColPropertyList != null) {
            this.attrColPropertyList.clear();
            this.attrColPropertyList = null;
        }
        if (this.keyIdxPropertyList != null) {
            this.keyIdxPropertyList.clear();
            this.keyIdxPropertyList = null;
        }
        if (this.relFKPropertyList != null) {
            this.relFKPropertyList.clear();
            this.relFKPropertyList = null;
        }
        if (this.relTablePropertyList != null) {
            this.relTablePropertyList.clear();
            this.relTablePropertyList = null;
        }
        if (this.viewPropertyList != null) {
            this.viewPropertyList.clear();
            this.viewPropertyList = null;
        }
    }

    public DP_UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DesignPropertiesDialog dialog = new DesignPropertiesDialog(this.getAppView(), this);
            dialog.initProperties(false);
            dialog.showDialog();
        }
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public List getStorableDesignParts() {
        ArrayList<DesignPart> list = new ArrayList<DesignPart>();
        list.add(this.getBusinessInfoDesign());
        list.add(this.getDataTypesDesign());
        list.add(this.getLogicalDesign());
        Iterator it = this.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            list.add((DesignPart)it.next());
        }
        it = this.getMultidimensionalDesigns().iterator();
        while (it.hasNext()) {
            list.add((DesignPart)it.next());
        }
        list.add(this.getProcessModel());
        it = this.getProcessModel().getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            list.add((DesignPart)it.next());
        }
        return list;
    }

    public boolean isLoadFromDB() {
        return this.loadFromDB;
    }

    public void setLoadFromDB(boolean loadFromDB) {
        this.loadFromDB = loadFromDB;
    }

    public boolean isRepositoryRelated() {
        return this.getRepositoryOID() != null;
    }

    public RLDomains getRLDomains() {
        return this.rlDomains;
    }

    public DLDomains getDLDomains() {
        return this.dlDomains;
    }

    public void saveDesignLevelSettings() {
        Object designPath = "";
        boolean global = false;
        if (this.getDesignPath().equals("")) {
            this.getDesignLevelSettings();
            designPath = XMLTransformationManager.getDefaultSystemTypesPath() + File.separatorChar + "dl_settings.xml";
            global = true;
        } else {
            this.getDesignLevelSettings();
            designPath = this.getDesignPath() + File.separatorChar + this.getFileName() + File.separatorChar + "dl_settings.xml";
        }
        this.getDesignLevelSettings().saveDesignLevelLSettingsFile((String)designPath, GitClientHelper.isGitVersioned((String)designPath));
        if (!global && this.getDesignLevelSettings().isUseGlobalDesignLevelSettings()) {
            this.getDesignLevelSettings().saveDesignLevelLSettingsFile(XMLTransformationManager.getDefaultSystemTypesPath() + File.separatorChar + "dl_settings.xml", this.isGitVersioned());
        }
    }

    public void loadDesignLevelSettings(boolean useGlobalDesignLevelSettings) {
        Object path = "";
        path = useGlobalDesignLevelSettings ? XMLTransformationManager.getDefaultSystemTypesPath(this.getAppView().getSettings()) : this.getDesignPath() + File.separatorChar + this.getFileName();
        this.getDesignLevelSettings().loadDesignLevelSettingsFile((String)path);
    }

    private List getRemovableDesignParts() {
        ArrayList list = new ArrayList();
        Iterator it = this.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it = this.getMultidimensionalDesigns().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it = this.getProcessModel().getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it = this.getProcessModel().getAllTransformationTasks().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    private void createRemovableDPMap(Map map) {
        map.clear();
        List col = this.getRemovableDesignParts();
        for (ModelIDObject dobj : col) {
            if (dobj.getRepositoryOID() == null) continue;
            RepDeleteDescr descr = new RepDeleteDescr();
            descr.objectType = dobj.getObjectTypeName();
            descr.repOID = dobj.getRepositoryOID();
            descr.repOVID = dobj.getRepositoryOVID();
            descr.objectID = dobj.getObjectID();
            descr.pathID = dobj.getPathID();
            map.put(dobj.getRepositoryOID(), descr);
        }
    }

    public void createDP_RepositoryMap() {
        this.createRemovableDPMap(this.repositoryMap);
    }

    public void createLocalDP_Map() {
        this.localDPMap.clear();
        List col = this.getRemovableDesignParts();
        for (ModelIDObject dobj : col) {
            RepDeleteDescr descr = new RepDeleteDescr();
            descr.objectType = dobj.getObjectTypeName();
            descr.repOID = dobj.getRepositoryOID();
            descr.repOVID = dobj.getRepositoryOVID();
            descr.objectID = dobj.getObjectID();
            if (this.getLoadedVersion() >= 3.4f) {
                descr.shortObjectID = dobj.getShortObjectID();
            }
            descr.pathID = dobj.getPathID();
            descr.parent = dobj.getParent();
            this.localDPMap.put(dobj.getObjectID(), descr);
        }
    }

    private List getLocalDesignPartsToDelete(Map dpMap) {
        List col = this.getRemovableDesignParts();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ModelIDObject dobj : col) {
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList deleted = new ArrayList();
        for (Map.Entry entry : dpMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            deleted.add(entry.getValue());
        }
        return deleted;
    }

    private List getRepositoryDesignPartsToDelete(Map dpMap) {
        List col = this.getRemovableDesignParts();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ModelIDObject dobj : col) {
            if (dobj.getRepositoryOID() == null) continue;
            map.put(dobj.getRepositoryOID(), dobj.getRepositoryOID());
        }
        ArrayList deleted = new ArrayList();
        for (Map.Entry entry : dpMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            deleted.add(entry.getValue());
        }
        return deleted;
    }

    public List getDesignPartsToDeleteFromRepository() {
        return this.getRepositoryDesignPartsToDelete(this.repositoryMap);
    }

    public List getDesignPartsToDeleteFromLocalFS() {
        return this.getLocalDesignPartsToDelete(this.localDPMap);
    }

    public void addToRepositoryLoadedRemovableDesignParts(DesignPart dp) {
        this.addToLoadedRemovableDesignParts(dp, this.repositoryMap);
    }

    public void addToLocalLoadedRemovableDesignParts(DesignPart dp) {
        this.addToLoadedRemovableDesignParts(dp, this.localDPMap);
    }

    private void addToLoadedRemovableDesignParts(DesignPart dp, Map map) {
        String id = dp.getObjectID();
        Object obj = map.get(id);
        if (obj == null) {
            RepDeleteDescr descr = new RepDeleteDescr();
            descr.objectType = dp.getObjectTypeName();
            descr.repOID = dp.getRepositoryOID();
            descr.repOVID = dp.getRepositoryOVID();
            descr.objectID = id;
            descr.pathID = dp.getPathID();
            map.put(id, descr);
        }
    }

    public void removeDeletedDesignParts() {
        this.removeDeletedDesignParts(true);
    }

    public void removeDeletedDesignParts(boolean removeFromVCS) {
        ArrayList<String> list = new ArrayList<String>();
        for (RepDeleteDescr descr : this.getDesignPartsToDeleteFromLocalFS()) {
            String rdesPath = this.makeDesignPartPath(descr);
            if ("".equals(rdesPath)) continue;
            String rdesFileName = rdesPath + ".xml" + (this.compressedDesign ? "z" : "");
            list.add(rdesPath);
            list.add(rdesFileName);
        }
        if (list.size() > 0) {
            XMLPersistenceManager pm;
            this.getAppView().setCurrentDesign(this.getDesign());
            if (removeFromVCS && this.getDesign().isGitVersioned()) {
                try {
                    GitClientHelper.doRemove(list);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("Design - error in removing Git files when save the design", e);
                }
            } else if (Extension.isUsingVersioningFunctionality() && removeFromVCS) {
                if (this.isSVNVersioned()) {
                    SVNClientHelper.getInstance().doRemove(list);
                } else if (this.isGitVersioned()) {
                    GitClientHelper.doRemove(list);
                } else {
                    pm = this.getAppView().getPersistenceManager();
                    ((PersistenceManager)pm).deleteFiles(list);
                }
            } else {
                pm = this.getAppView().getPersistenceManager();
                ((PersistenceManager)pm).deleteFiles(list);
            }
        }
    }

    private String makeDesignPartPath(RepDeleteDescr descr) {
        String res = "";
        if ("RelationalModel".equalsIgnoreCase(descr.objectType)) {
            res = descr.shortObjectID != null ? this.makeRelDesignPath(String.valueOf(descr.shortObjectID)) : this.makeRelDesignPath(String.valueOf(descr.pathID));
        } else if ("Dimensional Model".equalsIgnoreCase(descr.objectType)) {
            res = this.makeDimensionalDesignPath(descr.objectID);
        } else if ("Data Flow Diagram".equalsIgnoreCase(descr.objectType)) {
            res = this.makeDataFlowDesignPath(descr.objectID);
        } else if ("TransformationTask".equalsIgnoreCase(descr.objectType)) {
            res = this.makeTransformationTaskDesignPath(descr.objectID, ((TransformationPackage)descr.parent).getObjectID());
        }
        return res;
    }

    private String makeDimensionalDesignPath(String desID) {
        StringBuffer sb = new StringBuffer(this.getDesignPath());
        sb.append("/").append(this.getFileName());
        sb.append("/").append("multidimensional");
        sb.append("/").append(desID);
        return sb.toString();
    }

    private String makeDataFlowDesignPath(String desID) {
        StringBuffer sb = new StringBuffer(this.getDesignPath());
        sb.append("/").append(this.getFileName());
        sb.append("/").append(XMLConstants.DATAFLOW_PATH);
        sb.append("/").append(desID);
        return sb.toString();
    }

    private String makeTransformationTaskDesignPath(String desID, String parentID) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDesignPath());
        sb.append("/").append(this.getFileName());
        sb.append("/").append(XMLConstants.TRPACKAGE_PATH);
        sb.append("/").append(parentID);
        sb.append("/").append("tt");
        sb.append("/").append(desID);
        return sb.toString();
    }

    public boolean isMerging() {
        return this.merging;
    }

    public void setMerging(boolean merging) {
        this.merging = merging;
    }

    public String getEngDateFormat() {
        if ("".equals(this.engDateFormat)) {
            return this.defDateFormat;
        }
        return this.engDateFormat;
    }

    public void setEngDateFormat(String engDateFormat) {
        this.engDateFormat = engDateFormat;
    }

    public String getEngTimestampFormat() {
        if ("".equals(this.engTimestampFormat)) {
            return this.defTimestampFormat;
        }
        return this.engTimestampFormat;
    }

    public void setEngTimestampFormat(String engTimestampFormat) {
        this.engTimestampFormat = engTimestampFormat;
    }

    public String getEngTimestampWTZFormat() {
        if ("".equals(this.engTimestampWTZFormat)) {
            return this.defTimestampWTZFormat;
        }
        return this.engTimestampWTZFormat;
    }

    public void setEngTimestampWTZFormat(String engTimestampWTZFormat) {
        this.engTimestampWTZFormat = engTimestampWTZFormat;
    }

    public void resetRDBMSSites() {
        if (this.rdbmsSiteSet != null) {
            this.rdbmsSiteSet.removeAll();
        }
    }

    @Override
    public Design getDesign() {
        return this;
    }

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        if (this.getRelationalDesign() != null && this.getRelationalDesign().getSelectedRDBMSSite() != null) {
            return this.getRelationalDesign().getSelectedRDBMSSite();
        }
        return this.getRDBMSSiteSet().getDefaultRDBMSSite(this.getAppView().getSettings());
    }

    public void setSelectedRDBMSSite(RDBMSSite site) {
        if (this.getRelationalDesign() != null) {
            this.getRelationalDesign().setSelectedRDBMSSite(site);
        }
    }

    public StorageDesignFactory getStorageDesignFactory() {
        if (this.getRelationalDesign() != null) {
            return this.getRelationalDesign().getStorageDesignFactory();
        }
        return null;
    }

    public static RDBMSTypeSet getDefaultRDBMSTypeSet() {
        if (defauttRdbmsTypeSet == null) {
            defauttRdbmsTypeSet = new RDBMSTypeSet();
            defauttRdbmsTypeSet.add(StorageDesignOraclev20c.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev12cR2.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev12c.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev11g.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev10g.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev9i.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignSqlServerv2k12.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignSqlServerv2k8.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignSqlServerv2k5.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignSqlServerv2k.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignDB2v80.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignDB2v70.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignUDBv9.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignUDBv81.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignUDBv71.RDBMS_TYPE);
        }
        return defauttRdbmsTypeSet;
    }

    public void setRDBMSSiteSet(RDBMSSiteSet rdbmsSiteSet) {
        this.rdbmsSiteSet = rdbmsSiteSet;
    }

    public RDBMSSiteSet getRDBMSSiteSet() {
        boolean empty;
        boolean bl = empty = this.rdbmsSiteSet != null && this.rdbmsSiteSet.size() == 0;
        if (this.rdbmsSiteSet != null && this.rdbmsSiteSet.isLoadFromRepository()) {
            empty = false;
        }
        if (this.rdbmsSiteSet == null || empty) {
            this.rdbmsSiteSet = new RDBMSSiteSet();
            this.rdbmsSiteSet.add(StorageDesignOraclev20c.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev12cR2.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev12c.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev11g.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev10g.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev9i.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignSqlServerv2k12.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignSqlServerv2k8.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignSqlServerv2k5.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignSqlServerv2k.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignDB2v80.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignDB2v70.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignUDBv9.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignUDBv81.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignUDBv71.RDBMS_SITE);
            RXMLDefaultRDBMSSiteSet reader = new RXMLDefaultRDBMSSiteSet();
            Object sysTypesPath = this.getAppView().getSettings().getDefaultSystemTypesPath();
            File file = new File((String)sysTypesPath);
            if (((String)sysTypesPath).length() == 0 || !file.exists()) {
                sysTypesPath = this.getAppView().getMDConfiguration().get("defaultFilePath") + File.separatorChar + this.getAppView().getMDConfiguration().get("typesPath");
            }
            reader.readDefaultRDBMSSites((String)sysTypesPath + File.separatorChar + "defaultRDBMSSites.xml", this, this.rdbmsSiteSet);
            this.rdbmsSiteSet.updateMaxIndex(this.rdbmsSiteSet.size());
        }
        return this.rdbmsSiteSet;
    }

    public RDBMSSite getFirstOfType(RDBMSType type) {
        Iterator it = this.getRDBMSSiteSet().iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            if (site.getType() != type) continue;
            return site;
        }
        return null;
    }

    public StorageDesign getStorageDesign(RDBMSSite site) {
        if (this.getRelationalDesign() != null) {
            return this.getRelationalDesign().getStorageDesign(site);
        }
        return null;
    }

    public StorageDesign getStorageDesign(RDBMSSite site, FKContainer table) {
        if ((RelationalDesign)table.getDesignPart() != null) {
            return ((RelationalDesign)table.getDesignPart()).getStorageDesign(site);
        }
        return null;
    }

    public void destroyAll(boolean showDiagrams) {
        this.clearAll(showDiagrams);
        this.setReadOnly(false);
    }

    public boolean isNewDesign() {
        return this.newDesign;
    }

    public void setNewDesign(boolean newDesign) {
        this.newDesign = newDesign;
    }

    @Override
    public String getStoragePath() {
        try {
            String desName = this.getFileName();
            if (desName != null) {
                return new File(this.getDesignPath(), desName).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getDesignStoragePath(String designID) {
        if (designID != null) {
            if (designID.equals(this.getObjectID())) {
                try {
                    String desName = this.getFileName();
                    if (desName != null) {
                        return new File(this.getDesignPath(), desName).getCanonicalPath();
                    }
                }
                catch (IOException desName) {}
            } else {
                DesignStorageDesc desc = this.getDesignStorageDesc(designID);
                if (desc != null) {
                    try {
                        return new File(desc.getDesignStoragePath()).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            String desName = this.getFileName();
            if (desName != null) {
                return new File(this.getDesignPath(), desName + ".dmd").getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void setModelListChanged(boolean modelListChanged) {
        this.modelListChanged = modelListChanged;
    }

    public boolean isModelListChanged() {
        return this.modelListChanged;
    }

    public void setOldRepositoryType(boolean oldRepositoryType) {
        this.oldRepositoryType = oldRepositoryType;
    }

    public boolean isOldRepositoryType() {
        return this.oldRepositoryType;
    }

    public void setChangeRequestListChanged(boolean changeRequestListChanged) {
        this.changeRequestListChanged = changeRequestListChanged;
    }

    public boolean isChangeRequestListChanged() {
        return this.changeRequestListChanged;
    }

    public void setSensitiveTypeListChanged(boolean sensitiveTypeChanged) {
        this.sensitiveTypeChanged = sensitiveTypeChanged;
    }

    public boolean isSensitiveTypeListChanged() {
        return this.sensitiveTypeChanged;
    }

    public void setCompressedDesign(boolean compressedDesign) {
        this.compressedDesign = compressedDesign;
    }

    public boolean isCompressedDesign() {
        return this.compressedDesign;
    }

    public boolean isSVNVersioned() {
        return this.svnVersioned;
    }

    public void setSVNVersioned(boolean versioned) {
        this.svnVersioned = versioned;
    }

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("changerequest", "ChangeRequest");
        }
        return this.f2tMap;
    }

    public String getDesignPath() {
        if (this.currentOperation == 5) {
            return this.exportDesignPath;
        }
        return this.designPath;
    }

    public void setDesignPath(String designPath) {
        this.designPath = designPath;
    }

    public String getExportDesignPath() {
        return this.exportDesignPath;
    }

    public void setExportDesignPath(String exportDesignPath) {
        this.exportDesignPath = exportDesignPath;
    }

    public StorableObjectStatusHelper getDesignPart(String pathName, String dpID) {
        if ("businessinfo".equalsIgnoreCase(pathName)) {
            StorableObjectStatusHelper sosHelper = new StorableObjectStatusHelper();
            sosHelper.designPart = this.getBusinessInfoDesign();
            sosHelper.designPartClass = BusinessInfoDesign.class;
            return sosHelper;
        }
        if ("datatypes".equalsIgnoreCase(pathName)) {
            StorableObjectStatusHelper sosHelper = new StorableObjectStatusHelper();
            sosHelper.designPart = this.getDataTypesDesign();
            sosHelper.designPartClass = DataTypesDesign.class;
            return sosHelper;
        }
        if ("logical".equalsIgnoreCase(pathName)) {
            StorableObjectStatusHelper sosHelper = new StorableObjectStatusHelper();
            sosHelper.designPart = this.getLogicalDesign();
            sosHelper.designPartClass = LogicalDesign.class;
            return sosHelper;
        }
        if ("rel".equalsIgnoreCase(pathName)) {
            StorableObjectStatusHelper sosHelper = new StorableObjectStatusHelper();
            sosHelper.designPartClass = RelationalDesign.class;
            for (RelationalDesign model : this.getRelationalDesigns()) {
                if (!dpID.equalsIgnoreCase(model.getShortObjectID())) continue;
                sosHelper.designPart = model;
                sosHelper.shortObjectID = model.getShortObjectID();
                break;
            }
            return sosHelper;
        }
        if ("multidimensional".equalsIgnoreCase(pathName)) {
            StorableObjectStatusHelper sosHelper = new StorableObjectStatusHelper();
            sosHelper.designPartClass = MultidimensionalDesign.class;
            for (MultidimensionalDesign model : this.getMultidimensionalDesigns()) {
                if (!dpID.equalsIgnoreCase(model.getObjectID())) continue;
                sosHelper.designPart = model;
                return sosHelper;
            }
            return sosHelper;
        }
        if ("pm".equalsIgnoreCase(pathName)) {
            StorableObjectStatusHelper sosHelper = new StorableObjectStatusHelper();
            sosHelper.designPart = this.getProcessModel();
            sosHelper.designPartClass = ProcessModel.class;
            return sosHelper;
        }
        return null;
    }

    public Map getDesignObjectsMap() {
        return this.idMap;
    }

    public Map getCorrespondenceMap() {
        return this.correspondenceMap;
    }

    public void setCorrespondenceMap(Map correspondenceMap) {
        this.correspondenceMap = correspondenceMap;
    }

    @Override
    public void setDirty(boolean dirty) {
        if (dirty && this.isNewDesign()) {
            return;
        }
        super.setDirty(dirty);
    }

    public boolean areDesignLevelSettingsChanged() {
        return this.designLevelSettingsChanged;
    }

    public void setDesignLevelSettingsChanged(boolean changed) {
        this.designLevelSettingsChanged = changed;
    }

    public DefaultLineWidthAndColor getDefaultLWCObject(String className) {
        for (DefaultLineWidthAndColor dlwc : this.getDesignLevelSettings().defaultLWCObjects) {
            if (!dlwc.getClassName().equalsIgnoreCase(className)) continue;
            return dlwc;
        }
        return null;
    }

    public org.w3c.dom.Element getFirstElementByTagName(String tag, org.w3c.dom.Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            org.w3c.dom.Element elem = (org.w3c.dom.Element)nodes.item(0);
            return elem;
        }
        return null;
    }

    public DefaultFontAndColor getDefaultFCObject(String className) {
        for (DefaultFontAndColor dfc : this.getDesignLevelSettings().defaultFCObjects) {
            if (!dfc.getClassName().equalsIgnoreCase(className)) continue;
            return dfc;
        }
        return null;
    }

    public void getListElements(List list, StringBuffer buffer) {
        for (WordRule wr : list) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append("<").append("value").append(' ');
            buffer.append("type=\"").append(wr.getWordType()).append("\"").append(' ');
            buffer.append("mandatory=\"").append(wr.isMandatory()).append("\"");
            buffer.append("/>");
        }
    }

    public NamingStandardRule getNamingStandardRule() {
        this.namingRule = this.getDesignLevelSettings().getNamingStandardRule();
        return this.namingRule;
    }

    public List getProxiesToDeleteList() {
        return this.proxiesToDelete;
    }

    public void createChangeRequestsMap() {
        this.changeRequestsMap.clear();
        Iterator iterator = this.getChangeRequestSet().iterator();
        while (iterator.hasNext()) {
            ChangeRequest changeRequest = (ChangeRequest)iterator.next();
            this.changeRequestsMap.put(changeRequest.getObjectID(), changeRequest.getSegmentedStorageName());
        }
    }

    public void synchronizeChangeRequestsMap() {
        this.removeDeletedChangeRequests();
        this.createChangeRequestsMap();
    }

    public void removeDeletedChangeRequests() {
        ArrayList<String> deleted = new ArrayList<String>();
        for (String changeRequestID : this.changeRequestsMap.keySet()) {
            if (this.getChangeRequestSet().containsId(changeRequestID)) continue;
            deleted.add(this.changeRequestsMap.get(changeRequestID));
        }
        if (deleted.size() > 0) {
            if (Extension.isUsingVersioningFunctionality()) {
                ArrayList<File> files;
                if (this.isSVNVersioned()) {
                    files = new ArrayList<File>();
                    for (String fname : deleted) {
                        File file = null;
                        try {
                            file = new File(fname);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (file == null) continue;
                        files.add(file);
                    }
                    if (files.size() > 0) {
                        SVNClientHelper.getInstance().doRemove(files.toArray(new File[0]));
                    }
                } else if (this.isGitVersioned()) {
                    files = new ArrayList();
                    for (String fname : deleted) {
                        File file = null;
                        try {
                            file = new File(fname);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (file == null) continue;
                        files.add(file);
                    }
                    GitClientHelper.doRemove(files.toArray(new File[0]));
                } else {
                    this.getAppView().getXMLTransformationManager().deleteFiles(deleted);
                }
            } else {
                this.getAppView().getXMLTransformationManager().deleteFiles(deleted);
            }
        }
    }

    public ChangeRequest createChangeRequest() {
        return this.getChangeRequestSet().createChangeRequest(null);
    }

    public void doAfterExternalLoad() {
        this.sortDomains();
        this.createLocalDP_Map();
        this.createChangeRequestsMap();
        this.setDirty(false);
        this.setModelListChanged(false);
        this.setChangeRequestListChanged(false);
        this.setSensitiveTypeListChanged(false);
        this.setLoadFromDB(false);
        this.setNewDesign(false);
    }

    public List getDefaultDomainsList() {
        ArrayList<Domain> list = new ArrayList<Domain>();
        Iterator it = this.getDomainSet().iterator();
        while (it.hasNext()) {
            Domain dom = (Domain)it.next();
            if (!"defaultdomains".equalsIgnoreCase(dom.getFileName())) continue;
            list.add(dom);
        }
        return list;
    }

    public List getDL_DomainsList() {
        ArrayList<Domain> list = new ArrayList<Domain>();
        Iterator it = this.getDomainSet().iterator();
        while (it.hasNext()) {
            Domain dom = (Domain)it.next();
            if ("defaultdomains".equalsIgnoreCase(dom.getFileName())) continue;
            list.add(dom);
        }
        return list;
    }

    public Domain createDomain() {
        return this.getDomainSet().createDomain();
    }

    public Domain getDomainByID(String id) {
        return (Domain)this.getDesignObject(id);
    }

    public void sortDomains() {
        this.getDomainSet().sort();
    }

    public RDBMSSite createRDBMSSite() {
        return this.getRDBMSSiteSet().createSite("");
    }

    public RDBMSSite getRDBMSSiteByID(String id) {
        return this.getRDBMSSiteSet().getByObjectID(id);
    }

    public RDBMSSite getRDBMSSiteByShortID(String id) {
        return this.getRDBMSSiteSet().getByShortObjectIDString(id);
    }

    public List getDefaultRDBMSSites() {
        ArrayList<RDBMSSite> list = new ArrayList<RDBMSSite>();
        Iterator it = this.getRDBMSSiteSet().iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            if (!site.isDefault()) continue;
            list.add(site);
        }
        return list;
    }

    public List getDL_RDBMSSites() {
        ArrayList<RDBMSSite> list = new ArrayList<RDBMSSite>();
        Iterator it = this.getRDBMSSiteSet().iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            if (!site.isDesignLevel()) continue;
            list.add(site);
        }
        return list;
    }

    public void clearMappings() {
        this.getExtendedMap().clearMappings();
    }

    public void setSelectedSubView(DesignPartView selectedSubView) {
        this.selectedSubView = selectedSubView;
    }

    public DesignPartView getSelectedSubView() {
        return this.selectedSubView;
    }

    public List getAllDPVs() {
        DesignPartViewPlaceHolder dpvph;
        ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
        ArrayList<DesignPartView> result = new ArrayList<DesignPartView>();
        list.add(this.getDataTypesDesign().getMainView());
        Iterator it = this.getDataTypesDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            dpvph = (DesignPartViewPlaceHolder)it.next();
            list.add(dpvph.getDesignPartView());
        }
        list.add(this.getLogicalDesign().getMainView());
        it = this.getLogicalDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            dpvph = (DesignPartViewPlaceHolder)it.next();
            list.add(dpvph.getDesignPartView());
        }
        for (RelationalDesign pd : this.getRelationalDesigns()) {
            list.add(pd.getMainView());
            Iterator it2 = pd.getDesignSubviews().iterator();
            while (it2.hasNext()) {
                DesignPartViewPlaceHolder dpvph2 = (DesignPartViewPlaceHolder)it2.next();
                list.add(dpvph2.getDesignPartView());
            }
        }
        for (DataFlowDesign dfd : this.getProcessModel().getDataFlowDesigns()) {
            list.add(dfd.getMainView());
        }
        it = this.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage tp = (TransformationPackage)it.next();
            for (TransformationTask tt : tp.getTransformationTaskSet()) {
                list.add(tt.getMainView());
            }
        }
        for (MultidimensionalDesign mdd : this.getMultidimensionalDesigns()) {
            list.add(mdd.getMainView());
        }
        result.addAll(list);
        for (DesignPartView dpv : list) {
            if (!dpv.isMasterDPV()) continue;
            for (DesignPartView dpvd : dpv.getSubordinateViews()) {
                result.add(dpvd);
            }
        }
        return result;
    }

    public void synchronizeRemoteObjects() {
        this.synchronizeRemoteDomains();
        this.getLogicalDesign().synchronizeRemoteObjects();
        for (RelationalDesign relModel : this.getRelationalDesigns()) {
            relModel.synchronizeRemoteObjects();
        }
    }

    public void synchronizeRemoteDomains() {
        ArrayList list = new ArrayList();
        this.getDesign().getDomainSet().addAllElementsTo(list);
        Iterator doIt = list.iterator();
        while (doIt.hasNext()) {
            try {
                DesignObject desObj = (DesignObject)doIt.next();
                desObj.updateFromRemoteObject(true);
                if (!desObj.isDirty()) continue;
                this.getDesign().getDomainSet().setDirty(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List getDesignStorageDescriptors() {
        if (this.designStorageDescriptors == null) {
            this.designStorageDescriptors = new ArrayList();
        }
        return this.designStorageDescriptors;
    }

    public DesignStorageDesc createDesignStorageDesc() {
        return new DesignStorageDesc();
    }

    public DesignStorageDesc getDesignStorageDesc(String designID) {
        if (designID != null && !"".equals(designID)) {
            for (DesignStorageDesc desc : this.designStorageDescriptors) {
                if (!designID.equals(desc.getDesignID())) continue;
                return desc;
            }
        }
        return null;
    }

    public void addDesignStorageDesc(DesignStorageDesc desc) {
        DesignStorageDesc d = this.getDesignStorageDesc(desc.getDesignID());
        if (d == null) {
            this.designStorageDescriptors.add(desc);
            this.setDirty(true);
        } else {
            d.setDesignStoragePath(desc.getDesignStoragePath());
        }
    }

    public void addDesignStorageDesc(Design design) {
        DesignStorageDesc d = this.getDesignStorageDesc(design.getObjectID());
        if (d == null) {
            DesignStorageDesc desc = new DesignStorageDesc();
            desc.setDesignID(design.getObjectID());
            desc.setDesignStoragePath(design.getStoragePath());
            this.designStorageDescriptors.add(desc);
            this.setDirty(true);
        }
    }

    public void copyDesignStorageDescriptors(Design target) {
        for (DesignStorageDesc desc : this.getDesignStorageDescriptors()) {
            DesignStorageDesc dd = target.getDesignStorageDesc(desc.getDesignID());
            if (dd != null) continue;
            dd = new DesignStorageDesc();
            dd.setDesignID(desc.getDesignID());
            dd.setDesignStoragePath(desc.getDesignStoragePath());
            target.addDesignStorageDesc(dd);
            target.setDirty(true);
        }
    }

    public void removeDesignStorageDesc(DesignStorageDesc desc) {
        DesignStorageDesc d = this.getDesignStorageDesc(desc.getDesignID());
        if (d == null) {
            this.designStorageDescriptors.remove(d);
            this.setDirty(true);
        }
    }

    public Design getDesignByID(String designID) {
        if (designID != null) {
            if (designID.equals(this.getObjectID())) {
                return this;
            }
            return (Design)this.getAppView().getDesigns().getObjectByID(designID);
        }
        return null;
    }

    public void clearDomainsDatatypes(LogicalDatatype lt) {
        if (lt != null) {
            Iterator it = this.getDomainSet().iterator();
            while (it.hasNext()) {
                Domain dom = (Domain)it.next();
                if (lt != dom.getLogicalDatatype()) continue;
                dom.clearDataTypesMap();
            }
        }
    }

    public DesignLevelSettings getDesignLevelSettings() {
        return this.getDesignLevelSettings(false);
    }

    public DesignLevelSettings getDesignLevelSettings(boolean defaultsOnly) {
        if (this.designLevelSettings == null) {
            this.designLevelSettings = new DesignLevelSettings(this, defaultsOnly);
        }
        return this.designLevelSettings;
    }

    public File getAdditionalFilesDirectory() {
        return this.getAdditionalFilesDirectory(false);
    }

    public File getAdditionalFilesDirectory(boolean resetFile) {
        if (this.additionalFilesDirectory == null || resetFile) {
            this.additionalFilesDirectory = new File(this.designPath + File.separator + this.design.getFileName() + File.separator + "files");
            if (!this.additionalFilesDirectory.exists()) {
                this.additionalFilesDirectory.mkdir();
                if (this.design.isSVNVersioned()) {
                    SVNClientHelper.getInstance().doAdd(this.additionalFilesDirectory);
                    File[] directoryToCommit = new File[]{this.additionalFilesDirectory};
                    SVNClientHelper.getInstance().doCommit(directoryToCommit, "Automatically added", false, false);
                }
            } else if (this.design.isSVNVersioned() && !SVNClientHelper.getInstance().isVersioned(this.additionalFilesDirectory)) {
                SVNClientHelper.getInstance().doAdd(this.additionalFilesDirectory);
                File[] directoryToCommit = new File[]{this.additionalFilesDirectory};
                SVNClientHelper.getInstance().doCommit(directoryToCommit, "Automatically added", false, false);
            } else if (this.design.isGitVersioned()) {
                // empty if block
            }
        }
        return this.additionalFilesDirectory;
    }

    public List<UDPLibrary> getUserDefinedLibraries() {
        return this.userDefinedLibraries;
    }

    public List<UserDefinedProperty> getUserDefinedProperties() {
        ArrayList<UserDefinedProperty> list = new ArrayList<UserDefinedProperty>();
        for (UDPLibrary lib : this.getUserDefinedLibraries()) {
            Iterator<UserDefinedProperty> pIt = lib.getPropertiesList().iterator();
            while (pIt.hasNext()) {
                list.add(pIt.next());
            }
        }
        return list;
    }

    public UserDefinedProperty getUserDefinedPropertyByName(String name) {
        for (UserDefinedProperty udp : this.getUserDefinedProperties()) {
            if (!udp.getName().equals(name)) continue;
            return udp;
        }
        return null;
    }

    public int getModelPersistence() {
        return this.modelPersistence;
    }

    public void setModelPersistence(int modelPersistence) {
        this.modelPersistence = modelPersistence;
    }

    public String getModelPersistenceChoice() {
        if (this.modelPersistence == PERS_MODEL_IN_MANY_FILES) {
            return PCHOICE_MODEL_IN_MANY_FILES;
        }
        if (this.modelPersistence == PERS_MODEL_IN_ONE_FILE) {
            return PCHOICE_MODEL_IN_ONE_FILE;
        }
        if (this.modelPersistence == PERS_MODEL_MIXED_MODE) {
            return PCHOICE_MODEL_MIXED_MODE;
        }
        return PCHOICE_MODEL_IN_MANY_FILES;
    }

    public void setModelPersistenceChoice(String choice) {
        if (PCHOICE_MODEL_IN_MANY_FILES.equals(choice)) {
            this.modelPersistence = PERS_MODEL_IN_MANY_FILES;
        } else if (PCHOICE_MODEL_IN_ONE_FILE.equals(choice)) {
            this.modelPersistence = PERS_MODEL_IN_ONE_FILE;
        } else if (PCHOICE_MODEL_MIXED_MODE.equals(choice)) {
            this.modelPersistence = PERS_MODEL_MIXED_MODE;
        }
    }

    public void loadAllModels() {
        this.loadAllModels(null);
    }

    public int getLoadedModelPersistence() {
        return this.loadedModelPersistence;
    }

    public void setLoadedModelPersistence(int loadedModelPersistence) {
        this.loadedModelPersistence = loadedModelPersistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllModels(ProgressDialog monitor) {
        boolean tloading = ApplicationView.loading;
        try {
            ApplicationView.loading = true;
            int size = this.getRelationalDesigns().size();
            if (size == 0) {
                size = 2;
            }
            int step = 70 / size;
            if (monitor != null) {
                monitor.setNote(oracle.dbtools.crest.swingui.Messages.getString("ControllerApplication.OpenRelationalAndPhysicalModels"));
                monitor.setProgress(0);
                monitor.setNote(oracle.dbtools.crest.swingui.Messages.getString("ControllerApplication.OpenRelationalAndPhysicalModels"));
                monitor.setProgress(1);
            }
            boolean export = this.getCurrentOperation() == 5;
            for (DesignPart pd : this.getRelationalDesigns()) {
                if (!pd.isLoaded() && (!export || export && (this.shouldExportFull(pd) || this.shouldExportPartial(pd)))) {
                    if (monitor != null) {
                        monitor.setNote(oracle.dbtools.crest.swingui.Messages.getString("ControllerApplication.Open") + ((RelationalDesign)pd).getName());
                    }
                    if (pd.getDesign().isOldRepositoryType()) {
                        ((RelationalDesign)pd).load();
                    } else {
                        pd.getAppView().getXMLTransformationManager().openDesignPart(pd);
                        RMExtendedMap rxmap = ((RelationalDesign)pd).getRMExtendedMap();
                        pd.getAppView().getXMLTransformationManager().transformFromXMLToObject(rxmap, new File(rxmap.getStorageName()), pd.getDesign().isCompressedDesign());
                        RMDeletedMap dxmap = ((RelationalDesign)pd).getRMDeletedMap();
                        pd.getAppView().getXMLTransformationManager().transformFromXMLToObject(dxmap, new File(dxmap.getStorageName()), pd.getDesign().isCompressedDesign());
                    }
                    pd.getDesign().getExtendedMap().distributenMappings((RelationalDesign)pd);
                    this.getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(pd);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.getAppView().getCurrentDesign().getDesignPath());
                if (this.getLoadedVersion() < 3.2f) {
                    buffer.append(WXMLRelationalDesign.getRelativePath((RelationalDesign)pd)).append('/').append(pd.getObjectID()).append("/storage");
                } else if (this.getLoadedVersion() < 3.4f) {
                    buffer.append(WXMLRelationalDesign.getRelativePath((RelationalDesign)pd)).append('/').append(pd.getPathIDString()).append("/phys");
                } else {
                    buffer.append(WXMLRelationalDesign.getRelativePath((RelationalDesign)pd)).append('/').append(pd.getShortObjectID()).append("/phys");
                }
                String path = buffer.toString();
                File file = new File(path);
                File[] files = file.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        StorageDesign sd;
                        SVNClientHelper svnClientHelper;
                        if (!files[i].isDirectory() || Extension.isUsingVersioningFunctionality() && (svnClientHelper = SVNClientHelper.getInstance()).isDeleted(files[i])) continue;
                        String dirName = files[i].getName();
                        RDBMSSite site = null;
                        site = this.getLoadedVersion() < 3.2f ? ((RelationalDesign)pd).getStorageDesignFactory().getRDBMSSiteSet().getByObjectID(dirName) : ((RelationalDesign)pd).getStorageDesignFactory().getRDBMSSiteSet().getByShortObjectIDString(dirName);
                        if (site == null || (sd = ((RelationalDesign)pd).getStorageDesignFactory().getStorageDesign(site)) == null || sd.isOpen()) continue;
                        if (monitor != null) {
                            monitor.setNote(oracle.dbtools.crest.swingui.Messages.getString("ControllerApplication.Open") + sd.getName());
                        }
                        if (sd.getDesign().isOldRepositoryType()) {
                            sd.load();
                        } else {
                            this.getAppView().getXMLTransformationManager().openPhysicalModel(sd);
                        }
                        sd.setOpen(true);
                    }
                }
                if (monitor == null) continue;
                monitor.increaseProgress(step);
            }
            for (DesignPart pd : this.getMultidimensionalDesigns()) {
                if (pd.isLoaded() || export && (!export || !this.shouldExportFull(pd) && !this.shouldExportPartial(pd))) continue;
                if (monitor != null) {
                    monitor.setNote(oracle.dbtools.crest.swingui.Messages.getString("ControllerApplication.Open") + pd.getName());
                }
                if (pd.getDesign().isOldRepositoryType()) {
                    ((MultidimensionalDesign)pd).load();
                } else {
                    pd.getAppView().getXMLTransformationManager().openDesignPart(pd);
                }
                this.getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(pd);
            }
        }
        finally {
            ApplicationView.loading = tloading;
        }
    }

    public Design getOldDesign() {
        return this.oldDesign;
    }

    public String getOldDesignPath() {
        return this.oldDesignPath;
    }

    public void setOldDesignPath(String oldDesignPath) {
        this.oldDesignPath = oldDesignPath;
    }

    public boolean isAllAddedObjectsFileDocChanged() {
        return this.allAddedObjectsFileDocChanged;
    }

    public void setAllAddedObjectsFileDocChanged(boolean changed) {
        this.allAddedObjectsFileDocChanged = changed;
    }

    public List getPropertiesFilterList(Class comparatorClass, boolean updatable) {
        String comparatorName = comparatorClass.getName();
        return this.getFilterList(comparatorName, updatable, false);
    }

    public List getPropertiesFilterList(String comparatorName, boolean updatable) {
        return this.getFilterList(comparatorName, updatable, false);
    }

    public List getStoragePropertiesFilterList(Class comparatorClass, boolean updatable) {
        String comparatorName = comparatorClass.getName();
        return this.getFilterList(comparatorName, updatable, true);
    }

    private List getFilterList(String comparatorName, boolean updatable, boolean storageTemplate) {
        ArrayList propsFilterList;
        if (storageTemplate) {
            comparatorName = (String)comparatorName + "Storage";
        }
        if ((propsFilterList = this.comparatorFilterListMap.get(comparatorName)) == null) {
            if (updatable) {
                propsFilterList = new ArrayList();
                this.comparatorFilterListMap.put((String)comparatorName, propsFilterList);
            } else {
                propsFilterList = Collections.EMPTY_LIST;
            }
        }
        return propsFilterList;
    }

    public List getDynamicPropertiesFilterList(String comparatorClassName, boolean updatable) {
        ArrayList propsFilterList = this.dynamicPropsFilterListMap.get(comparatorClassName);
        if (propsFilterList == null) {
            if (updatable) {
                propsFilterList = new ArrayList();
                this.dynamicPropsFilterListMap.put(comparatorClassName, propsFilterList);
            } else {
                propsFilterList = Collections.EMPTY_LIST;
            }
        }
        return propsFilterList;
    }

    public void clearPropertiesAndStoragePropsFilters() {
        this.comparatorFilterListMap.clear();
    }

    public void clearDynamicPropertiesFilters() {
        this.dynamicPropsFilterListMap.clear();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Map<SVNUrl, SVNStatusAndPropertiesPair> getSVNPropertiesCache() {
        return this.getSVNPropertiesCache(false);
    }

    public Map<SVNUrl, SVNStatusAndPropertiesPair> getSVNPropertiesCache(boolean remote) {
        if (remote) {
            if (this.svnRemotePropertiesCache == null) {
                this.svnRemotePropertiesCache = new HashMap<SVNUrl, SVNStatusAndPropertiesPair>();
            }
            return this.svnRemotePropertiesCache;
        }
        if (this.svnPropertiesCache == null) {
            this.svnPropertiesCache = new HashMap<SVNUrl, SVNStatusAndPropertiesPair>();
        }
        return this.svnPropertiesCache;
    }

    public Map<String, String> getSVNDMPropertiesCache() {
        if (this.svnDMPropertiesCache == null) {
            this.svnDMPropertiesCache = new HashMap<String, String>();
        }
        return this.svnDMPropertiesCache;
    }

    public DockStation getDockStation() {
        if (this.dockStation == null) {
            this.dockStation = DockStation.getDockStation();
        }
        return this.dockStation;
    }

    public boolean isSingleObjectRefresh() {
        return this.singleObjectRefresh;
    }

    public void setSingleObjectRefresh(boolean singleObjectRefresh) {
        this.singleObjectRefresh = singleObjectRefresh;
    }

    public Map<String, SVNObjectHelper> getSVNObjectHelperMap() {
        return this.svnOHMap;
    }

    public List<StorableObjectStatus> getStorableObjectStatuses() {
        return this.statuses;
    }

    public void setStorableObjectStatuses(List<StorableObjectStatus> statuses) {
        this.statuses = statuses;
    }

    public List<NewObjectIDPropertiesPair> getNewSVNObjectsList() {
        return this.newObjectsList;
    }

    public void addNewObjectToSVNPropertiesList(String id, String properties) {
        NewObjectIDPropertiesPair e = new NewObjectIDPropertiesPair(id, properties);
        this.newObjectsList.add(e);
    }

    public void clearNewObjectsList() {
        this.newObjectsList.clear();
    }

    public Map<String, Map> getLocalObjectFilesMap() {
        if (this.localObjectFilesMap == null) {
            this.localObjectFilesMap = new HashMap<String, Map>();
        }
        return this.localObjectFilesMap;
    }

    public ModelIDObject getModelByIdName(String idname) {
        if ("businessinfo".equals(idname) || "Business Information".equalsIgnoreCase(idname)) {
            return this.getBusinessInfoDesign();
        }
        if ("logical".equals(idname)) {
            return this.getLogicalDesign();
        }
        if ("datatypes".equals(idname) || "DataTypes".equalsIgnoreCase(idname)) {
            return this.getDataTypesDesign();
        }
        if ("pm".equals(idname) || "Process Model".equalsIgnoreCase(idname)) {
            return this.getProcessModel();
        }
        ModelIDObject obj = this.getRelationalDesigns().getByShortId(idname);
        if (obj == null) {
            obj = this.getRelationalDesigns().getById(idname);
        }
        if (obj != null) {
            return obj;
        }
        obj = this.getMultidimensionalDesigns().getById(idname);
        if (obj != null) {
            return obj;
        }
        obj = this.getProcessModel().getDataFlowDesigns().getById(idname);
        if (obj != null) {
            return obj;
        }
        obj = this.getProcessModel().getDataFlowDesigns().getById(idname);
        if (obj != null) {
            return obj;
        }
        obj = this.getProcessModel().getTransformationPackageSet().getObjectByID(idname);
        if (obj != null) {
            return obj;
        }
        Iterator it = this.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage tp = (TransformationPackage)it.next();
            obj = tp.getTransformationTaskSet().getById(idname);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public void clearWorkspace() {
        this.workspace = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace getWorkspace() {
        if (this.workspace == null && !this.isNewDesign()) {
            this.workspace = new Workspace();
            this.workspace.setReadOnly(true);
            this.workspace.getAttributes().unset(ElementAttributes.BUILDABLE | ElementAttributes.DELETEABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.NAVIGABLE | ElementAttributes.CLOSEABLE);
            this.workspace.getAttributes().set(ElementAttributes.NON_EDITABLE);
            GitClientHelper.setWorkspaceAsOpen(this.workspace);
            File file = new File(this.getDesignPath());
            File pfile = new File(file, this.getFileName());
            try {
                try {
                    this.workspace.open();
                    this.workspace.setURL(pfile.toURI().toURL());
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.workspace.setURL(pfile.toURI().toURL());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Field field = Node.class.getDeclaredField("_shortLabel");
                field.setAccessible(true);
                field.set(this.workspace, this.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.workspace;
    }

    private void addToWorkspaces() {
        Workspace w = this.getWorkspace();
        System.setProperty("ide.vcs.noapplications", "false");
        if (w != null) {
            Ide.getWorkspaces().add((Element)w);
            File file = new File(this.getDesignPath());
            File pfile = new File(file, this.getFileName());
            try {
                if (GITUtil.insideWorkingCopy((URL)file.toURI().toURL())) {
                    GitClientHelper.modifyGitChangeList();
                    String desName = this.getFileName();
                    String art = new File(this.getDesignPath()).getName();
                    String artFolder = desName + "/";
                    String artDMD = desName + ".dmd";
                    w.setProperty(GitClientHelper.MODELER_PATHS, artFolder + ";" + artDMD);
                    UpdateMessage um = new UpdateMessage(UpdateMessage.CHILD_ADDED, (Object)w);
                    um.getModifyObjects().add(new Project());
                    um.getModifyObjects().add(w);
                    Ide.getSystem().notifyObservers((Object)Ide.getWorkspaces(), um);
                    um = new UpdateMessage(IdeConstants.ACTIVE_PROJECT_CHANGED, (Object)w);
                    um.getModifyObjects().add(new Project());
                    um.getModifyObjects().add(w);
                    Ide.setActiveWorkspace((Workspace)w);
                    Ide.getSystem().notifyObservers((Object)Ide.getWorkspaces(), um);
                    Dockable d = this.getDockStation().getDockable(new ViewId("VersioningNavigatorWindow.VersioningNavigator"));
                    if (d instanceof DefaultNavigatorWindow) {
                        DefaultNavigatorWindow nav = (DefaultNavigatorWindow)d;
                        nav.getContextMenu().addContextMenuListener((ContextMenuListener)new DMGITNavigatorContextMenu(), null);
                    }
                    GitClientHelper.updateComboBoxModel();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void updateWorkspace(String oldDesignPath) {
        this.removeFromWorkspaces(oldDesignPath, false);
        this.workspace = null;
        this.gitRepositoryPath = this.getGitRepositoryRoot();
        this.addToWorkspaces();
    }

    public void removeFromWorkspaces(String designPath) {
        this.removeFromWorkspaces(designPath, true);
    }

    public void removeFromWorkspaces(String designPath, boolean refreshChangeList) {
        Workspace w = this.getWorkspace();
        if (w != null) {
            w.markDirty(false);
            Ide.getWorkspaces().remove((Element)w);
            Workspace w2 = Ide.getWorkspaces().currentActiveWorkspace();
            if (w2 == w) {
                Ide.getWorkspaces().setActiveWorkspace(null);
            }
            if (refreshChangeList && !ApplicationView.closing) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GitClientHelper.refreshGitChangeList();
                    }
                });
            }
        }
    }

    public List<Design> getOtherDesignsWithSameDesignPath(String dpath) {
        ArrayList<Design> list = new ArrayList<Design>();
        for (Design des : this.getAppView().getDesigns()) {
            if (des == this || !dpath.equals(des.getDesignPath())) continue;
            list.add(des);
        }
        return list;
    }

    public void checkForGitDesign() {
        if (!this.getAppView().getSettings().isUseVersioningFunctionality()) {
            this.gitVersioned = false;
            return;
        }
        if (this.isNewDesign()) {
            this.gitVersioned = false;
            return;
        }
        File file = new File(this.getDesignPath());
        try {
            if (GITUtil.insideWorkingCopy((URL)file.toURI().toURL())) {
                this.gitVersioned = true;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.gitVersioned = false;
    }

    private String getGitRepositoryRoot() {
        if (this.isGitVersioned()) {
            String path = this.getDesignPath();
            try {
                File file;
                for (file = new File(path); file != null && !GITUtil.isReposRoot((URL)file.toURI().toURL()); file = file.getParentFile()) {
                }
                if (file != null) {
                    return file.getCanonicalPath();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public boolean isGitVersioned() {
        return this.gitVersioned;
    }

    public boolean isVersioned() {
        return Extension.isUsingVersioningFunctionality() && (this.isSVNVersioned() || this.isGitVersioned());
    }

    public boolean hasWorkspaceSet() {
        return this.workspace != null;
    }

    public boolean containsURL(URL url) {
        try {
            File f = new File(new File(this.getDesignPath()), this.getName() + ".dmd");
            URL dmd = f.toURI().toURL();
            if (URLFileSystem.equals((URL)dmd, (URL)url)) {
                return true;
            }
            dmd = (f = new File(f.getParentFile(), this.getName())).toURI().toURL();
            if (URLFileSystem.isBaseURLFor((URL)dmd, (URL)url)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean containsGitRelativePathL(String path) {
        try {
            File gfile = new File(new File(this.getGitRepositoryPath()), path);
            URL url = gfile.toURI().toURL();
            File f = new File(new File(this.getDesignPath()), this.getName() + ".dmd");
            URL dmd = f.toURI().toURL();
            if (URLFileSystem.equals((URL)dmd, (URL)url)) {
                return true;
            }
            dmd = (f = new File(f.getParentFile(), this.getName())).toURI().toURL();
            if (URLFileSystem.isBaseURLFor((URL)dmd, (URL)url)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public DesignObject getObject(URL url) {
        String fname;
        String id = fname = URLFileSystem.getFileName((URL)url);
        if (fname.indexOf(46) > 0) {
            id = fname.substring(0, fname.lastIndexOf(46));
            return this.getDesignObject(id);
        }
        return null;
    }

    public ObjectDescriptor getObjectDescriptor(String gitRelPath, String operation, String commitID) {
        try {
            File gfile = new File(new File(this.getGitRepositoryPath()), gitRelPath);
            URL url = gfile.toURI().toURL();
            File f = new File(new File(this.getDesignPath()), this.getName() + ".dmd");
            URL dmd = f.toURI().toURL();
            if (URLFileSystem.equals((URL)dmd, (URL)url)) {
                return this.getObjectDescriptor(dmd, null, operation, commitID);
            }
            dmd = (f = new File(f.getParentFile(), this.getName())).toURI().toURL();
            if (URLFileSystem.isBaseURLFor((URL)dmd, (URL)url)) {
                return this.getObjectDescriptor(url, null, operation, commitID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ObjectDescriptor getObjectDescriptor(URL url, Icon overLayIcon) {
        return this.getObjectDescriptor(url, overLayIcon, null, null);
    }

    public ObjectDescriptor getObjectDescriptor(URL url, Icon overLayIcon, String operation, String commitID) {
        String path = URLFileSystem.getPath((URL)url);
        File file = new File(path);
        try {
            path = file.getCanonicalPath();
            if (overLayIcon == null) {
                VCSStatus[] stat = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getStatus(new URL[]{url});
                overLayIcon = stat[0].getOverlay().getIcon();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String prop = this.getSVNDMPropertiesCache().get(path);
        String name = null;
        if (prop == null || prop.isEmpty()) {
            prop = SVNDMPropertiesManager.extractObjectPropertiesFromLocalFile(this, file);
        }
        if (prop == null) {
            prop = SVNClientHelper.getPropertiesOfDesignAndModelFile(this, file);
        }
        if (prop != null && !prop.isEmpty()) {
            ObjectDescriptor od = new ObjectDescriptor();
            name = VCSClientHelper.getProperty(prop, 5);
            if (name != null && !name.isEmpty()) {
                String className = VCSClientHelper.getProperty(prop, 1);
                od.name = name;
                od.className = className;
                Icon icon = this.getIcon(className);
                if (icon != null) {
                    if (overLayIcon != null) {
                        icon = GUIConfiguration.getStatusIcon(GUIConfiguration.getImage(icon), GUIConfiguration.getImage(overLayIcon));
                    }
                    od.icon = icon;
                } else {
                    od.icon = OracleIcons.getIcon((String)"file.png");
                }
                return od;
            }
        }
        if (prop == null || prop.isEmpty() || name == null || name.isEmpty()) {
            GeneralStorableObjectStatus st = new GeneralStorableObjectStatus(this, file, "D");
            name = null;
            StorableObject so = st.getStorableObject();
            name = so != null ? so.getName() : GitClientHelper.getObjectName(url, file, operation, commitID);
            if (name != null) {
                ObjectDescriptor od = new ObjectDescriptor();
                od.name = name;
                String className = null;
                String id = st.getStorableObjectID();
                if (st.getObjectClass() != null) {
                    className = od.className = st.getObjectClass().getName();
                }
                if (so != null && so instanceof ModelIDObject) {
                    prop = VCSClientHelper.getProperties((ModelIDObject)so);
                    this.getSVNDMPropertiesCache().put(path, prop);
                } else {
                    String[] str = new String[]{id, className, null, null, null, name};
                    this.getSVNDMPropertiesCache().put(path, VCSClientHelper.generateProperty(str));
                }
                return od;
            }
        }
        return null;
    }

    private String getNameFromXML(String xml) {
        String part;
        String p = " name=\"";
        int ind = xml.indexOf(p);
        if (ind > 0 && (ind = (part = xml.substring(ind + p.length())).indexOf(34)) > 0) {
            return part.substring(0, ind);
        }
        return null;
    }

    public String getPathWithNames(String filePath, boolean physAtTheend) {
        String res = filePath;
        String dpath = this.getDesignPath();
        try {
            dpath = new File(dpath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(filePath);
        try {
            String sp;
            String p = file.getCanonicalPath();
            res = sp = p.substring(dpath.length() + 1);
            Object r = "";
            String sep = "\\\\";
            int ind = sp.indexOf("\\");
            if (ind == -1) {
                sep = "/";
            }
            String[] parts = sp.split(sep);
            Map<String, String> map = this.getModelINamdMap();
            for (String part : parts) {
                if (part.startsWith("seg_")) continue;
                Object name = map.get(part);
                if (name == null) {
                    name = part;
                }
                if (physAtTheend && "phys".equalsIgnoreCase((String)name)) {
                    name = "z" + (String)name;
                }
                r = ((String)r).isEmpty() ? name : (String)r + "/" + (String)name;
            }
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public Map<String, String> getModelINamdMap() {
        if (this.modelINamdMap == null) {
            this.modelINamdMap = new TreeMap<String, String>();
            this.updateModelIdNameMap();
        }
        return this.modelINamdMap;
    }

    public Icon getIcon(String className) {
        try {
            Icon icon = this.icons.get(className);
            if (icon == null && className != null && !className.isEmpty()) {
                Class<?> cl = Class.forName(className);
                icon = NavigationTreeRenderer.getIcon(cl);
                for (cl = cl.getSuperclass(); icon == null && Object.class != cl; cl = cl.getSuperclass()) {
                    icon = NavigationTreeRenderer.getIcon(cl);
                }
                if (icon != null) {
                    this.icons.put(className, icon);
                }
                return icon;
            }
            return icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateModelIdNameMap() {
        LongNameObject mo2;
        if (this.modelINamdMap == null) {
            this.modelINamdMap = new TreeMap<String, String>();
        } else {
            this.modelINamdMap.clear();
        }
        for (LongNameObject mo2 : this.getRelationalDesigns()) {
            try {
                this.modelINamdMap.put(((ModelIDObject)mo2).getObjectID(), ((ModelObject)mo2).getName());
                this.modelINamdMap.put(((ModelIDObject)mo2).getShortObjectID(), ((ModelObject)mo2).getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (LongNameObject mo2 : this.getMultidimensionalDesigns()) {
            try {
                this.modelINamdMap.put(((ModelIDObject)mo2).getObjectID(), ((ModelObject)mo2).getName());
                this.modelINamdMap.put(((ModelIDObject)mo2).getShortObjectID(), ((ModelObject)mo2).getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator it = this.getProcessModel().getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            mo2 = (ModelIDObject)it.next();
            try {
                this.modelINamdMap.put(((ModelIDObject)mo2).getObjectID(), ((ModelObject)mo2).getName());
                this.modelINamdMap.put(((ModelIDObject)mo2).getShortObjectID(), ((ModelObject)mo2).getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (it.hasNext()) {
            TransformationPackage tp = (TransformationPackage)it.next();
            try {
                this.modelINamdMap.put(tp.getObjectID(), tp.getName());
                this.modelINamdMap.put(tp.getShortObjectID(), tp.getName());
                for (ModelIDObject mo3 : tp.getTransformationTaskSet()) {
                    try {
                        this.modelINamdMap.put(mo3.getObjectID(), mo3.getName());
                        this.modelINamdMap.put(mo3.getShortObjectID(), mo3.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        it = this.getRDBMSSiteSet().iterator();
        while (it.hasNext()) {
            mo2 = (RDBMSSite)it.next();
            try {
                this.modelINamdMap.put(((RDBMSSite)mo2).getObjectID(), ((RDBMSSite)mo2).getName());
                this.modelINamdMap.put(((RDBMSSite)mo2).getShortObjectID(), ((RDBMSSite)mo2).getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static DMDesignNode getDMDesignNode(URL url) {
        return new DMDesignNode(url);
    }

    public DelegateListener getDelegateListener() {
        if (this.delegateListener == null) {
            this.delegateListener = new DelegateListener(this);
        }
        return this.delegateListener;
    }

    public String getGitRepositoryPath() {
        return this.gitRepositoryPath;
    }

    public void setAllow_LB_DDL(boolean value) {
        DDLGenerationOptions.allow_LB_DDL = value;
    }

    static {
        PERS_MODEL_IN_ONE_FILE = 2;
        PERS_MODEL_IN_MANY_FILES = 1;
        PERS_MODEL_MIXED_MODE = 3;
        PCHOICE_MODEL_IN_MANY_FILES = "Model in many files";
        PCHOICE_MODEL_IN_ONE_FILE = "Model in one file";
        PCHOICE_MODEL_MIXED_MODE = "Model in mixed mode";
        PESITENCE_CHOICES = new String[]{PCHOICE_MODEL_IN_MANY_FILES, PCHOICE_MODEL_IN_ONE_FILE, PCHOICE_MODEL_MIXED_MODE};
        PESITENCE_CHOICES_VERSIONED = new String[]{PCHOICE_MODEL_IN_MANY_FILES};
        LOGGER = new Logger(Design.class);
    }

    private static class DelegateListener
    implements NotificationListener,
    StatusListener,
    FileListener,
    RevisionInfoListener,
    URLFileSystemListener {
        Design design;

        public DelegateListener(Design design) {
            this.design = design;
        }

        public void notifyStatus(GitStatus status) {
            if (status.isConflict()) {
                // empty if block
            }
        }

        public void notifyFile(File file, String relativePathToRoot) {
        }

        public void notifyRevisionInfo(GitRevisionInfo revisionInfo) {
        }

        public void notifyEvent(URLFileSystemEvent arg0) {
        }

        public void setDesign(Design design) {
            this.design = design;
        }
    }

    private class L
    implements VCSListener {
        private L() {
        }

        public void notifyEvent(VCSEvent event) {
            switch (event.getEventType()) {
                case 1: 
                case 2: 
                case 4: {
                    try {
                        VCSStatus[] stats = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getStatus(event.getURLs());
                        URL[] scb = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getStatusCacheBridge();
                        int k = 0;
                        ++k;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    TreeSet<URL> urls = new TreeSet<URL>(new Comparator<URL>(){

                        @Override
                        public int compare(URL o1, URL o2) {
                            URLFileSystemHelper fsh = URLFileSystem.findHelper((URL)o1);
                            assert (fsh == URLFileSystem.findHelper((URL)o2));
                            if (fsh.equals(o1, o2)) {
                                return 0;
                            }
                            if (fsh.isBaseURLFor(o1, o2)) {
                                return -1;
                            }
                            if (fsh.isBaseURLFor(o2, o1)) {
                                return 1;
                            }
                            return fsh.getPath(o1).compareTo(fsh.getPath(o2));
                        }
                    });
                    for (URL url : event.getURLs()) {
                        if (URLFileSystem.isDirectory((URL)url)) {
                            urls.add(url);
                            continue;
                        }
                        URL parent = URLFileSystem.getParent((URL)url);
                        if (parent == null) continue;
                        urls.add(parent);
                    }
                    break;
                }
                case 3: {
                    try {
                        VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getStatus(event.getURLs());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static final class Filter
    implements URLFilter {
        private Filter() {
        }

        public boolean accept(URL url) {
            if ("file".equals(url.getProtocol())) {
                return true;
            }
            return true;
        }
    }

    public static class DesignStorageDesc {
        String designID;
        String designStoragePath;

        public String getDesignID() {
            return this.designID;
        }

        public void setDesignID(String designID) {
            this.designID = designID;
        }

        public String getDesignStoragePath() {
            return this.designStoragePath;
        }

        public void setDesignStoragePath(String designStoragePath) {
            this.designStoragePath = designStoragePath;
        }
    }

    public class ObjectDescriptor {
        public ModelIDObject object;
        public String name;
        public String className;
        public String type;
        public Icon icon;
    }

    public static class DMDesignNode
    extends DefaultBrowsable {
        public DMDesignNode(URL url) {
            super(url);
        }

        public DMDesignNode() {
        }

        public Icon getIcon() {
            return GUIConfiguration.getInstance().getIcon("DIAGRAM_ICON", 16);
        }

        protected boolean isTrackedInNodeCache() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    public class SVNStatusAndPropertiesPair {
        public SVNStorableObjectStatus svnStatus;
        public String svnProperties;

        public SVNStatusAndPropertiesPair() {
            this.svnStatus = null;
            this.svnProperties = "";
        }

        public SVNStatusAndPropertiesPair(SVNStorableObjectStatus svnStatus, String svnProperties) {
            this.svnStatus = svnStatus;
            this.svnProperties = svnProperties;
        }

        public String toString() {
            return String.valueOf(this.svnProperties);
        }
    }
}

