/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;

public class ContainerObjectPlaceHolderRecursive
extends DesignObjectPlaceHolder {
    private DesignObjectCollection elements = new DesignObjectCollection();

    public ContainerObjectPlaceHolderRecursive(DesignPart designPart, DesignObject object) {
        super(designPart, object);
        this.loadElements(object);
    }

    public ContainerObjectPlaceHolderRecursive(DesignPart designPart, String name) {
        super(designPart, name);
    }

    public ContainerObjectPlaceHolderRecursive(DesignPart designPart, DesignObject object, boolean propagateSelection) {
        this(designPart, object);
        this.propagate = propagateSelection;
    }

    public void loadElements(DesignObject object) {
        int numchild = object.getNumberOfChildren();
        for (int i = 0; i < numchild; ++i) {
            ModelObject obj2 = object.getChild(i);
            if (obj2 instanceof DesignObjectCollection) {
                DesignObjectCollection col = (DesignObjectCollection)obj2;
                DesignObjectCollection newcol = new DesignObjectCollection();
                newcol.setName(col.getName());
                newcol.setParent(this);
                newcol.setElementDescriptor(col.getElementDescriptor());
                this.elements.add(newcol);
                for (ModelObject obj2 : col) {
                    if (!(obj2 instanceof DesignObject)) continue;
                    DesignObject dobj = obj2 instanceof DesignObjectPlaceHolder ? ((DesignObjectPlaceHolder)obj2).getDesignObject() : (DesignObject)obj2;
                    DesignObjectPlaceHolder dp = new DesignObjectPlaceHolder(dobj.getDesignPart(), dobj);
                    dp.setParent(newcol);
                    newcol.add(dp);
                }
                continue;
            }
            if (!(obj2 instanceof DesignObject)) continue;
            DesignObject dobj = (DesignObject)obj2;
            DesignObjectPlaceHolder dp = new DesignObjectPlaceHolder(dobj.getDesignPart(), dobj);
            dp.setParent(this);
            this.elements.add(dp);
            dp.setParent(this);
        }
    }

    @Override
    public void setShouldEngineer(boolean value, boolean setDirty) {
        if (this.getDesignObject() != null) {
            this.getDesignObject().setShouldEngineer(value, setDirty);
            if (this.propagate) {
                this.propagateShouldEngineer(value, setDirty);
            }
        }
    }

    @Override
    public void propagateShouldEngineer(boolean selected) {
        this.propagateShouldEngineer(selected, true);
    }

    @Override
    public void propagateShouldEngineer(boolean selected, boolean setDirty) {
        int k = this.getNumberOfChildren();
        for (int i = 0; i < k; ++i) {
            ModelObject object = this.getChild(i);
            if (object instanceof DesignObject) {
                DesignObject dp = (DesignObject)object;
                dp.setShouldEngineer(selected, setDirty);
                continue;
            }
            if (!(object instanceof DesignObjectCollection)) continue;
            DesignObjectCollection col = (DesignObjectCollection)object;
            for (Object obj : col) {
                if (!(obj instanceof DesignObject)) continue;
                DesignObject dp = (DesignObject)obj;
                dp.setShouldEngineer(selected, setDirty);
            }
        }
    }

    public int getIndexOf(ContainedObject object) {
        return ((ContainerObject)this.getDesignObject()).getIndexOf(object);
    }

    @Override
    public int getNumberOfChildren() {
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int index) {
        return (ModelObject)this.elements.getChildPlain(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.elements.getIndexForChild(child);
    }

    @Override
    public boolean isLeaf() {
        return this.getNumberOfChildren() < 1;
    }
}

