/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;

public class RHDiagram
extends RowHandler {
    public static final String OBJECT_TYPE = "DIAGRAM";
    public static final String DIAGRAM_DEFAULT_PHYSICAL = "default_physical";
    public static final String DIAGRAM_DEFAULT_LOGICAL = "default_logical";
    public static final String DIAGRAM_PHYSICAL_TERRAIN = "default_physical_terrain";
    private Fields constants;
    List lines = new ArrayList();
    private static final Integer DIAGRAM_TYPE_POSITION = new Integer(3);
    private static final Integer DIAGRAM_NAME_POSITION = new Integer(2);
    private static final String PHYSICAL_DIAGRAM_TYPE = "1";
    Map diagramMap = new TreeMap();

    public RHDiagram(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
        this.constants = constants;
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    private void collectLines(VarFileLine line) {
        String type = this.getField(line.getLine(), DIAGRAM_TYPE_POSITION);
        String name = this.getField(line.getLine(), DIAGRAM_NAME_POSITION);
        if (type.equalsIgnoreCase(PHYSICAL_DIAGRAM_TYPE) && !name.equalsIgnoreCase(DIAGRAM_PHYSICAL_TERRAIN) && !this.lines.contains(line)) {
            if (!this.lines.contains(line)) {
                DesignPartView dpv;
                this.lines.add(line);
                if (name.equalsIgnoreCase(DIAGRAM_DEFAULT_PHYSICAL)) {
                    this.setPhysicalDesignID(line);
                    dpv = this.getDesign().getRelationalDesign().getMainView();
                } else {
                    dpv = this.getDesign().getRelationalDesign().createDesignPartSubView();
                    dpv.setName(name);
                    ((DesignPartViewPlaceHolder)((DPVRelationalSubView)dpv).getPlaceHolder()).setVisible(false);
                }
                this.diagramMap.put(this.getField(line, "general_id"), dpv);
            }
            this.removeSelectedLine(line);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.collectLines(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void setPhysicalDesignID(VarFileLine line) {
        String id = this.getField(line, "general_id");
        this.constants.setPhysicalDesignID(id);
    }

    public Map getDiagramsMap() {
        return this.diagramMap;
    }
}

