/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableSQLServer
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "TABLE";
    protected static final String COL_OBJECT_TYPE = "COLUMN";
    protected static final String SIZE = "size";
    protected static final String PRECISION = "precision";
    protected static final String SCALE = "scale";
    private static final Logger LOGGER = new Logger(MOHTableSQLServer.class);

    public MOHTableSQLServer(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(MOHTableSQLServer.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private static List extractByUser(Connection sqlConnection, DBUserSqlServer dbUser) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String uid = dbUser.getUid();
        String db = dbUser.getDb();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append("TABLENAME").append(',').append(' ');
            buffer.append("ID").append(',').append(' ');
            buffer.append("UID").append(' ');
            buffer.append("USERID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysobjects").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append("U").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(uid).append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSQLServer.extractByUser():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tableName = rs.getString(1);
                DBObjectSqlServer dboTable = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), tableName, OBJECT_TYPE, "");
                dboTable.setDb(db);
                dboTable.setSchema(dbUser.getName());
                list.add(dboTable);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }

    protected ResultSet getTables(DatabaseMetaData dbmd, DBObject dbo, boolean all) throws Exception {
        DBObjectSqlServer dboSql = (DBObjectSqlServer)dbo;
        if (all) {
            return dbmd.getTables(dbo.getName(), null, "%", new String[]{OBJECT_TYPE});
        }
        return dbmd.getTables(dboSql.getDb(), null, dbo.getName(), new String[]{OBJECT_TYPE});
    }

    protected ResultSet getColumns(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        DBObjectSqlServer dboSql = (DBObjectSqlServer)dboTable;
        return dbmd.getColumns(dboSql.getDb(), null, dboTable.getName(), "%");
    }

    protected ResultSet getPrimaryKeys(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        DBObjectSqlServer dboSql = (DBObjectSqlServer)dboTable;
        return dbmd.getPrimaryKeys(dboSql.getDb(), null, dboTable.getName());
    }

    protected ResultSet getIndexInfo(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        DBObjectSqlServer dboSql = (DBObjectSqlServer)dboTable;
        return dbmd.getIndexInfo(dboSql.getDb(), null, dboTable.getName(), false, false);
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String tableName = dbo.getName();
            String db = dbo.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("o").append('.').append("NAME").append(' ');
                buffer.append("TABLENAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("u").append('.').append("NAME").append(' ');
                buffer.append("USERNAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("ID").append(' ');
                buffer.append("TABLEID").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("XTYPE").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append("U").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("UID").append(' ');
                buffer.append('=').append(' ');
                buffer.append("u").append('.').append("UID").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("NAME").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append(tableName).append('\'').append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableSqlServer.extract():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String username = rs.getString(2);
                    String tableId = rs.getString(3);
                    if (!name.equals(tableName)) continue;
                    Table table = this.getRelationalDesign().createTable();
                    table.setSchemaObject(this.getSchemaSqlServer(dbo.getSchema(), db));
                    table.setName(name);
                    this.stampModelObject(table, dbo);
                    this.initColumns(sqlConnection, table, tableId, db);
                    this.initIndexes(sqlConnection, table, tableId, db);
                    this.initConstraints(sqlConnection, table, tableId, db);
                    this.initUniqueKeys(sqlConnection, table, tableId, db);
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                        StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                        TableProxySqlServer tableProxy = (TableProxySqlServer)storage.getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxy != null) {
                            DataBaseSqlServer database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                            if (database == null) {
                                database = storage.getDataBaseSet().createDataBase();
                                database.setName(db);
                                this.stampModelObject((ModelObject)database, "", db);
                            }
                            tableProxy.setDatabase(database);
                            this.setUser(tableProxy, username, database);
                            this.setFilegroups(tableProxy, tableId, storage, database, sqlConnection);
                            this.initTriggers(sqlConnection, tableProxy, tableId, db);
                            continue;
                        }
                        LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        continue;
                    }
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setUser(TableProxySqlServer tableProxy, String username, DataBaseSqlServer database) {
        UserSqlServer user = (UserSqlServer)database.getUsers().getByName(username);
        if (user != null) {
            tableProxy.setUser(user);
        }
    }

    private void setFilegroups(TableProxySqlServer tableProxy, String tableId, StorageDesignSqlServer storage, DataBaseSqlServer database, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("s").append('.').append("GROUPNAME").append(' ');
            buffer.append("filegroup").append(' ');
            buffer.append(',').append(' ');
            buffer.append("i").append('.').append("indid").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(database.getName())).append('.').append("dbo.sysfilegroups s").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(database.getName())).append('.').append("dbo.sysindexes i").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("i").append('.').append("ID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("(i.indid =0 or i.indid = 255)").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("i").append('.').append("GROUPID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("s").append('.').append("GROUPID").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    FileGroupSqlServer group;
                    String groupName = rs.getString(1);
                    int indid = rs.getInt(2);
                    if (indid == 0) {
                        group = (FileGroupSqlServer)database.getFilegroups().getByName(groupName);
                        if (group == null) {
                            group = storage.getFileGroupSet().createFileGroup();
                            group.setName(groupName);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, tableProxy, groupName);
                        }
                        tableProxy.setFilegroup(group);
                        continue;
                    }
                    if (indid != 255) continue;
                    group = (FileGroupSqlServer)database.getFilegroups().getByName(groupName);
                    if (group == null) {
                        group = storage.getFileGroupSet().createFileGroup();
                        group.setName(groupName);
                        group.setDataBase(database);
                        this.stampModelObject((ModelObject)group, tableProxy, groupName);
                    }
                    tableProxy.setTextImageFG(group);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initFilegroups():", e);
        }
    }

    private void initColumns(Connection sqlConnection, Table table, String tableId, String db) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("c").append('.');
            buffer.append("NAME").append(' ');
            buffer.append("colname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("t").append('.');
            buffer.append("NAME").append(' ');
            buffer.append("typename").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("colid").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("length").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("prec").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append(SCALE).append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("isnullable").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("iscomputed").append(' ');
            buffer.append(',').append(' ');
            buffer.append("computed_expr = com.text").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("collation").append(' ');
            buffer.append(',').append(' ');
            buffer.append("identitycolumn = ");
            buffer.append("case c.colstat & 1 ");
            buffer.append("when 1 then 'YES' ");
            buffer.append("else 'NO' ");
            buffer.append("end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("ROWGUIDCOLL = ColumnProperty(c.id, c.name, 'IsRowGuidCol')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("default_value = def.text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.systypes t").append(',');
            buffer.append('(').append(' ').append(MOHTableSQLServer.getFormattedName(db)).append('.');
            buffer.append("dbo.syscolumns c ");
            buffer.append("Left Outer Join ");
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.');
            buffer.append("dbo.syscomments com ");
            buffer.append("On com.id = c.id and com.number = c.colid ");
            buffer.append("Left Outer Join ");
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.');
            buffer.append("dbo.syscomments def ");
            buffer.append("On def.id = c.cdefault and c.cdefault > 0");
            buffer.append(')').append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("c.id ").append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("c.xusertype ").append('=').append("t.xusertype").append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("c.colid");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                StorageDesign storageDesign;
                String colName = rs.getString(1);
                String colDatatype = rs.getString(2);
                int colSize = rs.getInt(4);
                int colPrecision = rs.getInt(5);
                int colScale = rs.getInt(6);
                int isNullable = rs.getInt(7);
                int isComputed = rs.getInt(8);
                String computedExpr = rs.getString(9);
                String collation = rs.getString(10);
                String identitycolumn = rs.getString(11);
                int rowgiudcoll = rs.getInt(12);
                String defaultValue = rs.getString(13);
                Column column = table.createColumn(colName);
                this.stampModelObject((ModelObject)column, table.getName(), colName);
                String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
                LogicalDatatype logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(usedDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
                if (logDatatype != null && !"UNKNOWN".equalsIgnoreCase(usedDatatype)) {
                    column.setUse((short)1);
                    column.setLogicalDatatype(logDatatype);
                    column.setDataTypeParameter(SIZE, String.valueOf(colSize));
                    column.setDataTypeParameter(PRECISION, String.valueOf(colPrecision));
                    column.setDataTypeParameter(SCALE, String.valueOf(colScale));
                } else {
                    DistinctType dt = (DistinctType)this.getDesign().getDataTypesDesign().getDistinctTypeSet().getByName(colDatatype);
                    if (dt != null) {
                        column.setUse((short)2);
                        column.setDistinctType(dt);
                    } else {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logDatatype);
                        column.setDataTypeParameter(SIZE, String.valueOf(colSize));
                        column.setDataTypeParameter(PRECISION, String.valueOf(colPrecision));
                        column.setDataTypeParameter(SCALE, String.valueOf(colScale));
                        System.out.println("Unable to find logical datatype for: " + colDatatype);
                    }
                }
                column.setNullsAllowed(isNullable == 1);
                if (isComputed != 0) {
                    column.setComputed(true);
                    column.setFormulaDesc(computedExpr);
                }
                if (defaultValue != null) {
                    while (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                    }
                    while (defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                    }
                    column.setDefaultValue(defaultValue);
                }
                if ((storageDesign = this.getStorageDesign()) != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                    ColumnProxySqlServer columnProxy = (ColumnProxySqlServer)storage.getColumnProxySet().getProxy(column.getObjectID());
                    if (columnProxy != null) {
                        if (rowgiudcoll == 0) {
                            columnProxy.setRowGuidCol("NO");
                        } else {
                            columnProxy.setRowGuidCol("YES");
                        }
                        columnProxy.setAsIdentity("YES".equalsIgnoreCase(identitycolumn));
                        columnProxy.setCollation(collation);
                        continue;
                    }
                    LOGGER.error("Unable to find ColumnProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initIndexes(Connection sqlConnection, Table table, String tableId, String db) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("i.name").append(' ');
            buffer.append(',').append(' ');
            buffer.append("clustered_ind = ");
            buffer.append("case when (i.status & 16)=16 ");
            buffer.append("then 'YES' ");
            buffer.append("else 'NO' ");
            buffer.append("end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("f.groupname filegroup").append(' ');
            buffer.append(',').append(' ');
            buffer.append("i.origfillfactor fill_factor").append(' ');
            buffer.append(',').append(' ');
            buffer.append("i.indid").append(' ');
            buffer.append(',').append(' ');
            buffer.append("unique_ind = case when (i.status & 2)<>0 then 'YES' else 'NO' end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("stats_no_recompute = case when (i.status & 16777216)<>0 then 'YES'  else 'NO' end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("ignore_dup_keys = case when (i.status & 1)<>0 then 'YES'  else 'NO' end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("is_pad_index = (select INDEXPROPERTY(i.id, i.name,'IsPadIndex'))").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysindexes i").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysfilegroups f").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("i.id ").append('=').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("f.groupid ").append('=').append("i.groupid").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("NOT").append(' ').append("EXISTS").append(' ');
            buffer.append('(').append(' ');
            buffer.append("select 1 from ");
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysobjects o ");
            buffer.append(" where ");
            buffer.append(" o.parent_obj = i.id and o.name = i.name and ");
            buffer.append(" o.xtype in ('PK','UQ')").append(' ');
            buffer.append(')').append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initIndexes():", e);
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String clustered = rs.getString(2);
                String filegroup = rs.getString(3);
                int fillFactor = rs.getInt(4);
                String indId = rs.getString(5);
                String unique = rs.getString(6);
                String statsNoRecompute = rs.getString(7);
                String ignoreDupKeys = rs.getString(8);
                String isPadIndex = rs.getString(9);
                if (name == null) continue;
                Properties props = new Properties();
                props.setProperty("name", name);
                props.setProperty("clustered", clustered);
                props.setProperty("filegroup", filegroup);
                props.setProperty("fillFactor", String.valueOf(fillFactor));
                props.setProperty("indId", indId);
                props.setProperty("unique", unique);
                props.setProperty("statsNoRecompute", statsNoRecompute);
                props.setProperty("ignoreDupKeys", ignoreDupKeys);
                props.setProperty("isPadIndex", isPadIndex != null ? isPadIndex : "0");
                list.add(props);
            }
        }
        if (statement != null) {
            statement.close();
        }
        for (Properties props : list) {
            String name = props.getProperty("name");
            String clustered = props.getProperty("clustered");
            String filegroup = props.getProperty("filegroup");
            int fillFactor = Integer.parseInt(props.getProperty("fillFactor"));
            String indId = props.getProperty("indId");
            String unique = props.getProperty("unique");
            String statsNoRecompute = props.getProperty("statsNoRecompute");
            String ignoreDupKeys = props.getProperty("ignoreDupKeys");
            String isPadIndex = props.getProperty("isPadIndex");
            Index index = table.createIndex();
            index.setName(name);
            this.stampModelObject((ModelObject)index, table.getSchema(), name);
            if ("YES".equalsIgnoreCase(unique)) {
                index.setIndexState("Unique Plain Index");
            }
            this.initKeyColumns(index, table, tableId, indId, db, sqlConnection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesign storage = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storage = (StorageDesignSqlServer)storageDesign;
            }
            if (storage != null) {
                IndexProxySqlServer proxy = (IndexProxySqlServer)storage.getIndexProxySet().getProxy(index.getObjectID());
                if (proxy != null) {
                    FileGroupSqlServer group;
                    if ("YES".equalsIgnoreCase(clustered)) {
                        proxy.setClustered(true);
                    } else {
                        proxy.setClustered(false);
                    }
                    proxy.setFillFactor(fillFactor);
                    if ("YES".equalsIgnoreCase(statsNoRecompute)) {
                        proxy.setRecomputeStatistics("NO");
                    } else {
                        proxy.setRecomputeStatistics("AUTO");
                    }
                    proxy.setIgnoreDupKey(ignoreDupKeys);
                    if ("1".equalsIgnoreCase(isPadIndex)) {
                        proxy.setPadIndex("YES");
                    } else {
                        proxy.setPadIndex("NO");
                    }
                    DataBaseSqlServer database = (DataBaseSqlServer)((StorageDesignSqlServer)storage).getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = ((StorageDesignSqlServer)storage).getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    if ((group = (FileGroupSqlServer)database.getFilegroups().getByName(filegroup)) == null) {
                        group = ((StorageDesignSqlServer)storage).getFileGroupSet().createFileGroup();
                        group.setName(filegroup);
                        group.setDataBase(database);
                        this.stampModelObject((ModelObject)group, proxy, filegroup);
                    }
                    proxy.setFilegroup(group);
                    continue;
                }
                LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                continue;
            }
            LOGGER.error("Unable to find Storage Design!");
        }
    }

    private void initConstraints(Connection sqlConnection, Table table, String tableId, String db) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("o").append('.');
            buffer.append("ID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.');
            buffer.append("XTYPE").append(' ');
            buffer.append(',').append(' ');
            buffer.append("table_constraint = ");
            buffer.append(" case ");
            buffer.append("  when o.info = 0 then 'YES' ");
            buffer.append(" else 'NO' ");
            buffer.append(" end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("column_name ").append('=').append(' ');
            buffer.append("col_name").append(' ');
            buffer.append('(').append(' ');
            buffer.append(tableId).append(' ');
            buffer.append(',').append(' ');
            buffer.append("o.info").append(' ');
            buffer.append(')').append(' ');
            buffer.append(',').append(' ');
            buffer.append("c.text constr_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.syscomments c").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("o.parent_obj").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o.xtype in ('C ','D')").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o.id = c.id").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                ModelObject constraint;
                String constrName = rs.getString(2);
                String constrXtype = rs.getString(3);
                String tableConstr = rs.getString(4);
                String columnName = rs.getString(5);
                String constrText = rs.getString(6);
                if ("NO".equalsIgnoreCase(tableConstr)) {
                    if ("C".equalsIgnoreCase(constrXtype.trim())) {
                        constraint = new CheckConstraint();
                        constraint.setName(constrName);
                        ((CheckConstraint)constraint).add(StorageDesignSqlServerv2k.RDBMS_TYPE, constrText);
                        Column col = (Column)table.getElementByName(columnName);
                        if (col == null) continue;
                        col.setUseDomainConstraints(false);
                        col.setCheck((CheckConstraint)constraint);
                        continue;
                    }
                    Column col = (Column)table.getElementByName(columnName);
                    if (col == null) continue;
                    col.setUsesDefaultValue(true);
                    col.setDefaultValue(constrText);
                    continue;
                }
                constraint = table.createCheckConstraint(constrName, constrText);
                table.addCheckConstraint((TableLevelConstraint)constraint);
                this.stampModelObject(constraint, table.getSchema(), constrName);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initUniqueKeys(Connection sqlConnection, Table table, String tableId, String db) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("o").append('.');
            buffer.append("ID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.');
            buffer.append("XTYPE").append(' ');
            buffer.append(',').append(' ');
            buffer.append("clustered_ind = ");
            buffer.append("case when (i.status & 16)=16 ");
            buffer.append("then 'YES' ");
            buffer.append("else 'NO' ");
            buffer.append("end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("f.groupname filegroup").append(' ');
            buffer.append(',').append(' ');
            buffer.append("i.origfillfactor fill_factor").append(' ');
            buffer.append(',').append(' ');
            buffer.append("i.indid").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysindexes i").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysfilegroups f").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("o.parent_obj").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o.xtype in ('PK','UQ')").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("i.id").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o.name").append(' ').append('=').append(' ').append("i.name").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("f.groupid").append(' ').append('=').append(' ').append("i.groupid").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initUniqueKeys():", e);
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(2);
                String xtype = rs.getString(3);
                String clustered = rs.getString(4);
                String filegroup = rs.getString(5);
                int fillFactor = rs.getInt(6);
                String indId = rs.getString(7);
                Properties props = new Properties();
                props.setProperty("name", name);
                props.setProperty("xtype", xtype);
                props.setProperty("clustered", clustered);
                props.setProperty("filegroup", filegroup);
                props.setProperty("fillFactor", String.valueOf(fillFactor));
                props.setProperty("indId", indId);
                list.add(props);
            }
        }
        if (statement != null) {
            statement.close();
        }
        for (Properties props : list) {
            FileGroupSqlServer group;
            DataBaseSqlServer database;
            IndexProxy proxy;
            String name = props.getProperty("name");
            String xtype = props.getProperty("xtype");
            String clustered = props.getProperty("clustered");
            String filegroup = props.getProperty("filegroup");
            int fillFactor = Integer.parseInt(props.getProperty("fillFactor"));
            String indId = props.getProperty("indId");
            Index key = table.createIndex();
            key.setName(name);
            this.stampModelObject((ModelObject)key, table.getSchema(), name);
            this.initKeyColumns(key, table, tableId, indId, db, sqlConnection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesignSqlServer storage = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storage = (StorageDesignSqlServer)storageDesign;
            }
            if ("PK".equalsIgnoreCase(xtype)) {
                key.setIndexState("Primary Constraint");
                if (storage != null) {
                    proxy = (PKProxySqlServer)storage.getPKProxySet().getProxy(key.getObjectID());
                    if (proxy != null) {
                        if ("YES".equalsIgnoreCase(clustered)) {
                            proxy.setClustered(true);
                        } else {
                            proxy.setClustered(false);
                        }
                        ((PKProxySqlServer)proxy).setFillFactor(fillFactor);
                        database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                        if (database == null) {
                            database = storage.getDataBaseSet().createDataBase();
                            database.setName(db);
                            this.stampModelObject((ModelObject)database, "", db);
                        }
                        if ((group = (FileGroupSqlServer)database.getFilegroups().getByName(filegroup)) == null) {
                            group = storage.getFileGroupSet().createFileGroup();
                            group.setName(filegroup);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, proxy, filegroup);
                        }
                        ((PKProxySqlServer)proxy).setFilegroup(group);
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
                continue;
            }
            key.setIndexState("Unique Constraint");
            if (storage != null) {
                proxy = (UniqueProxySqlServer)storage.getUniqueProxySet().getProxy(key.getObjectID());
                if (proxy != null) {
                    if ("YES".equalsIgnoreCase(clustered)) {
                        proxy.setClustered(true);
                    } else {
                        proxy.setClustered(false);
                    }
                    ((UniqueProxySqlServer)proxy).setFillFactor(fillFactor);
                    database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = storage.getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    if ((group = (FileGroupSqlServer)database.getFilegroups().getByName(filegroup)) == null) {
                        group = storage.getFileGroupSet().createFileGroup();
                        group.setName(filegroup);
                        group.setDataBase(database);
                        this.stampModelObject((ModelObject)group, proxy, filegroup);
                    }
                    ((UniqueProxySqlServer)proxy).setFilegroup(group);
                    continue;
                }
                LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                continue;
            }
            LOGGER.error("Unable to find Storage Design!");
        }
    }

    private void initKeyColumns(Index key, Table table, String tableId, String indId, String db, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("col_name(id,colid) columnname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("sort_desc = indexkey_property(id, indid, keyno, 'isdescending')").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysindexkeys").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("ID").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("indid").append(' ').append('=').append(' ').append(indId).append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("keyno").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initKeyColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                int sortOrder = rs.getInt(2);
                Column col = (Column)table.getElementByName(colName);
                if (col == null) continue;
                key.add(col);
                if (sortOrder == 0) {
                    key.setColumnSortOrder(col, "ASC");
                    continue;
                }
                key.setColumnSortOrder(col, "DESC");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTriggers(Connection sqlConnection, TableProxySqlServer table, String tableId, String db) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("trigger_name").append(' ');
            buffer.append('=').append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.');
            buffer.append("ID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("trigger_owner").append(' ');
            buffer.append('=').append(' ');
            buffer.append("user_name(uid)").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isupdate = ObjectProperty( o.id, 'ExecIsUpdateTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isdelete = ObjectProperty( o.id, 'ExecIsDeleteTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isinsert = ObjectProperty( o.id, 'ExecIsInsertTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isafter = ObjectProperty( o.id, 'ExecIsAfterTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isinsteadof = ObjectProperty( o.id, 'ExecIsInsteadOfTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isfirstupdate = ObjectProperty( o.id, 'ExecIsFirstUpdateTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isfirstdelete = ObjectProperty( o.id, 'ExecIsFirstDeleteTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isfirstinsert = ObjectProperty( o.id, 'ExecIsFirstInsertTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isLastupdate = ObjectProperty( o.id, 'ExecIsLastUpdateTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isLastdelete = ObjectProperty( o.id, 'ExecIsLastDeleteTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isLastinsert = ObjectProperty( o.id, 'ExecIsLastInsertTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("s.encrypted").append(' ');
            buffer.append(',').append(' ');
            buffer.append("s.text trigger_definition").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHTableSQLServer.getFormattedName(db)).append('.').append("dbo.syscomments s").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("parent_obj").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("type = 'TR'").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o.id = s.id").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initTriggers():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String ownerName = rs.getString(3);
                int isUpdate = rs.getInt(4);
                int isDelete = rs.getInt(5);
                int isInsert = rs.getInt(6);
                int isAfter = rs.getInt(7);
                int isInsteadOf = rs.getInt(8);
                int isFirstUpdate = rs.getInt(9);
                int isFirstDelete = rs.getInt(10);
                int isFirstInsert = rs.getInt(11);
                int isLastUpdate = rs.getInt(12);
                int isLastDelete = rs.getInt(13);
                int isLastInsert = rs.getInt(14);
                int encripted = rs.getInt(15);
                String body = rs.getString(16);
                StorageDesignSqlServer storage = (StorageDesignSqlServer)table.getStorageDesign();
                TriggerSqlServer trigger = storage.getTriggerSet().createTrigger();
                trigger.setName(name);
                trigger.setTable(table);
                this.stampModelObject((ModelObject)trigger, table.getSchema(), name);
                UserSqlServer user = (UserSqlServer)storage.getUserSet().getByName(ownerName);
                if (user != null) {
                    trigger.setOwner(user);
                }
                if (isUpdate == 1) {
                    trigger.setActions("UPDATE");
                }
                if (isDelete == 1) {
                    trigger.setActions("DELETE");
                }
                if (isInsert == 1) {
                    trigger.setActions("INSERT");
                }
                if (isAfter == 1) {
                    trigger.setTriggerTime("AFTER");
                } else if (isInsteadOf == 1) {
                    trigger.setTriggerTime("INSTEAD OF");
                }
                if (isFirstDelete == 1 || isFirstInsert == 1 || isFirstUpdate == 1) {
                    trigger.setExecutionOrder("FIRST");
                } else if (isLastDelete == 1 || isLastInsert == 1 || isLastUpdate == 1) {
                    trigger.setExecutionOrder("LAST");
                }
                if (encripted == 1) {
                    trigger.setEncription("YES");
                } else {
                    trigger.setEncription("NO");
                }
                trigger.setBody(body);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }
}

