/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class MOHForeignKey
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "FOREIGN KEY";

    public MOHForeignKey(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getImportedKeys(DatabaseMetaData dbmd, Table table) throws Exception {
        return dbmd.getImportedKeys(null, table.getSchema(), table.getName());
    }

    private FKHelper getFKHelperFor(Table pkTable, List<FKHelper> list, String fkName) {
        for (FKHelper next : list) {
            if (next.pkTable != pkTable) continue;
            if (fkName != null && !"".equals(fkName)) {
                if (!fkName.equalsIgnoreCase(next.fk_NAME)) continue;
                return next;
            }
            return next;
        }
        FKHelper fkHelper = new FKHelper();
        fkHelper.pkTable = pkTable;
        fkHelper.pkTableLongName = pkTable.getLongName();
        list.add(fkHelper);
        return fkHelper;
    }

    private FKHelper getFKHelperByName(String pkTableLongName, List<FKHelper> list, String fkName) {
        for (FKHelper next : list) {
            if (next.pkTableLongName == null || !next.pkTableLongName.equals(pkTableLongName)) continue;
            if (fkName != null && !"".equals(fkName)) {
                if (!fkName.equalsIgnoreCase(next.fk_NAME)) continue;
                return next;
            }
            return next;
        }
        FKHelper fkHelper = new FKHelper();
        fkHelper.pkTableLongName = pkTableLongName;
        list.add(fkHelper);
        return fkHelper;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        Object[] tables = this.getRelationalDesign().getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Table table = (Table)tables[i];
            String fschema = table.getSchema();
            ResultSet rs = this.getImportedKeys(dbmd, table);
            ArrayList<FKHelper> fkHelpers = new ArrayList<FKHelper>();
            if (rs == null) continue;
            while (rs.next()) {
                String schema = rs.getString(2);
                String pkTABLE_NAME = rs.getString(3);
                String pkCOLUMN_NAME = rs.getString(4);
                String tschema = rs.getString(6);
                if (tschema != null && !tschema.isEmpty() && fschema != null && !fschema.isEmpty() && !tschema.equals(fschema)) continue;
                String fkCOLUMN_NAME = rs.getString(8);
                int seq = rs.getInt(9);
                String fkDELETE_RULE = rs.getString(11);
                String fk_NAME = rs.getString(12);
                String pk_NAME = rs.getString(13);
                String pkTableName = pkTABLE_NAME;
                Table pkTable = schema != null && !schema.isEmpty() ? this.getDesign().getRelationalDesign().getTableSet().getBySchemaAndName(schema, pkTableName) : (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(pkTableName);
                FKHelper fkHelper = null;
                if (pkTable != null) {
                    fkHelper = this.getFKHelperFor(pkTable, fkHelpers, fk_NAME);
                } else {
                    String longName = schema + "." + pkTableName;
                    fkHelper = this.getFKHelperByName(longName, fkHelpers, fk_NAME);
                }
                fkHelper.fk_NAME = fk_NAME;
                fkHelper.pk_NAME = pk_NAME;
                fkHelper.fkDELETE_RULE = fkDELETE_RULE;
                if (fkCOLUMN_NAME != null) {
                    fkHelper.fkMap.put(seq, fkCOLUMN_NAME);
                    fkHelper.pkMap.put(seq, pkCOLUMN_NAME);
                    continue;
                }
                System.out.println("Unable to find FK column!");
            }
            rs.close();
            for (FKHelper next : fkHelpers) {
                int deleteRule;
                next.fkColNames.addAll(next.fkMap.values());
                next.pkColNames.addAll(next.pkMap.values());
                Table pkTable = next.pkTable;
                if (pkTable != null) {
                    int deleteRule2;
                    Index index = null;
                    index = next.pk_NAME == null ? SHAlterTableOraclev10g.getUniqueIndexForColumnNames(pkTable, next.pkColNames) : pkTable.getIndexByName(next.pk_NAME);
                    FKIndexAssociation fkass = null;
                    Column column = null;
                    if (index != null) {
                        for (int f = 0; f < next.fkColNames.size(); ++f) {
                            String fkName;
                            String fkColumnName;
                            Column fkColumn;
                            String pkColumnName = next.pkColNames.get(f);
                            if (pkColumnName != null && (column = (Column)pkTable.getElementByName(pkColumnName)) == null) {
                                column = pkTable.createColumn();
                                column.setName(pkColumnName);
                                this.stampModelObject((ModelObject)column, pkTable.getName(), pkColumnName);
                                index.add(column);
                            }
                            if ((fkColumn = (Column)table.getElementByName(fkColumnName = next.fkColNames.get(f))) == null) {
                                fkColumn = table.createColumn();
                                fkColumn.setName(fkColumnName);
                                this.stampModelObject((ModelObject)column, table.getName(), fkColumnName);
                            }
                            if ((fkName = next.fk_NAME) != null) {
                                FKIndexAssociation[] fkis = table.getFKAssociations();
                                for (int j = 0; j < fkis.length; ++j) {
                                    FKIndexAssociation fkia = fkis[j];
                                    if (!fkia.getName().equalsIgnoreCase(fkName)) continue;
                                    fkass = fkia;
                                    break;
                                }
                            }
                            if (fkass == null) {
                                fkass = table.addFK(index);
                                if (fkName != null) {
                                    fkass.setName(fkName);
                                    fkass.getLocalFKIndex().setName(fkName);
                                    this.stampModelObject((ModelObject)fkass, table.getSchema(), fkName);
                                }
                            }
                            if (fkass == null) continue;
                            fkColumn.addFKAssociation(column, fkass);
                            fkass.getLocalFKIndex().add(fkColumn);
                        }
                    }
                    if (fkass == null) continue;
                    try {
                        deleteRule2 = Integer.valueOf(next.fkDELETE_RULE);
                    }
                    catch (Exception e) {
                        deleteRule2 = 3;
                    }
                    switch (deleteRule2) {
                        case 3: {
                            fkass.setDeleteRule("NO ACTION");
                            break;
                        }
                        case 0: {
                            fkass.setDeleteRule("CASCADE");
                            break;
                        }
                        case 2: {
                            fkass.setDeleteRule("SET NULL");
                            break;
                        }
                        case 1: {
                            fkass.setDeleteRule("RESTRICT");
                        }
                    }
                    fkass.resetMandatoryUsingColumns();
                    fkass.resetEdgeParams();
                    continue;
                }
                if (next.pkTableLongName == null || next.pkTableLongName.isEmpty()) continue;
                FKIndexAssociation fk = this.getRelationalDesign().createForeignKey();
                fk.setContainerWithKeyObject(table);
                fk.setName(next.fk_NAME);
                table.setLoadedCompletely(true);
                fk.addToTable();
                this.stampModelObject((ModelObject)fk, table.getSchema(), next.fk_NAME);
                KeyObject localFKIndex = fk.getLocalFKIndex();
                localFKIndex.setName(next.fk_NAME);
                if (!next.fk_NAME.equals(next.fk_NAME.toUpperCase())) {
                    localFKIndex.setNameHasQuotes(true);
                }
                fk.setDeleteRule(next.fkDELETE_RULE);
                fk.setReferredTableLongName(next.pkTableLongName);
                fk.setReferredColumnNames(StringUtilities.getAsCommaDelimitedString(next.pkColNames));
                for (String cname : next.fkColNames) {
                    Column col = (Column)table.getElementByName(cname);
                    if (col == null) continue;
                    localFKIndex.add(col);
                }
                if (fk == null) continue;
                try {
                    deleteRule = Integer.valueOf(next.fkDELETE_RULE);
                }
                catch (Exception e) {
                    deleteRule = 3;
                }
                switch (deleteRule) {
                    case 3: {
                        fk.setDeleteRule("NO ACTION");
                        break;
                    }
                    case 0: {
                        fk.setDeleteRule("CASCADE");
                        break;
                    }
                    case 2: {
                        fk.setDeleteRule("SET NULL");
                        break;
                    }
                    case 1: {
                        fk.setDeleteRule("RESTRICT");
                    }
                }
            }
        }
    }

    private static class FKHelper {
        public List<String> pkColNames = new ArrayList<String>();
        public List<String> fkColNames = new ArrayList<String>();
        public Map pkMap = new TreeMap();
        public Map fkMap = new TreeMap();
        public String fkDELETE_RULE = "";
        public String fk_NAME = null;
        public String pk_NAME = null;
        public Table pkTable = null;
        public String pkTableLongName = null;

        private FKHelper() {
        }
    }
}

