/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateNodeGroupUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateNodeGroupUDB.class);

    public SHCreateNodeGroupUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateNodeGroupUDB.clearCR(line);
        if (Token.startsWithString(statement, "create nodegroup")) {
            try {
                this.parseNodeGroup(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateNodeGroupUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseNodeGroup(String statement) {
        this.statement = statement;
        String nodeGroupName = Token.getNameAfterToken(this.statement, "NODEGROUP", '\"', '\"').trim();
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        NodeGroupUDB nodeGroup = storageDesign.getNodeGroupSet().createNodeGroup();
        if (nodeGroup != null) {
            nodeGroup.setName(nodeGroupName);
            String onNodes = Token.getTokenAfter(this.statement, "ON").trim();
            if (onNodes.equalsIgnoreCase("NODES")) {
                nodeGroup.setScope("ON SOME NODES");
                if (Token.hasCloseAndOpenBrackets(this.statement)) {
                    String nodes = Token.getValBetweenBrackets(this.statement).trim();
                    nodeGroup.setNodeNumbers(nodes);
                }
            }
        }
    }
}

