/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.FileGroupSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexOnViewSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.PKProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.UniqueProxySqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexSqlServer
extends DDLStatementHandlerSqlServer
implements Constants {
    private Index index;
    private Table table;
    private TableViewProxySqlServer viewProxy;
    private String indexName = "";
    private StorageDesignSqlServerv2k stoDesign;
    private TableView view;
    private IndexOnViewSqlServer iov;
    private RDBMSSite site;
    private static final Logger LOGGER = new Logger(SHCreateIndexSqlServer.class);

    public SHCreateIndexSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateIndexSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "create index") || Token.startsWithString(statement, "create unique index") || Token.startsWithString(statement, "create unique clustered index") || Token.startsWithString(statement, "create unique nonclustered index") || Token.startsWithString(statement, "create clustered index") || Token.startsWithString(statement, "create nonclustered index")) {
            this.index = null;
            this.indexName = "";
            try {
                this.parseIndex(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateIndexSqlServer.FormatCR(line, "\n"));
            }
            this.index = null;
            this.table = null;
            this.viewProxy = null;
            this.indexName = "";
            this.stoDesign = null;
            this.view = null;
            this.iov = null;
        } else {
            this.nextHandler(line);
        }
    }

    private void parseIndex(String statement) {
        this.statement = statement;
        if (this.isPK()) {
            this.parsePK(statement);
        } else if (this.isUK()) {
            this.parseUK(statement);
        } else if (this.isIOV()) {
            this.parseIOV(statement);
        } else {
            this.parseInd();
        }
    }

    public void parseInd() {
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.index != null && this.index.getName().equals(this.indexName)) {
                IndexProxySqlServerv2k indexProxy;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (indexProxy = (IndexProxySqlServerv2k)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initClustered(indexProxy);
                    this.initPadIndex(indexProxy);
                    this.initFillFactor(indexProxy);
                    this.initIgnoreDupKey(indexProxy);
                    this.initStatisticNoRecompute(indexProxy);
                    this.initSortInTempDB(indexProxy);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    private void initClustered(IndexProxy indexProxy) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            indexProxy.setClustered(true);
        } else {
            indexProxy.setClustered(false);
        }
    }

    public void parseIOV(String statement) {
        this.statement = statement;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.view != null) {
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && this.iov != null) {
                    this.initPadIndex((IndexOnViewSqlServerv2k)this.iov);
                    this.initFillFactor((IndexOnViewSqlServerv2k)this.iov);
                    this.initIgnoreDupKey((IndexOnViewSqlServerv2k)this.iov);
                    this.initSortInTempDB((IndexOnViewSqlServerv2k)this.iov);
                    this.initStatisticNoRecompute((IndexOnViewSqlServerv2k)this.iov);
                    this.initFileGroup((IndexOnViewSqlServerv2k)this.iov);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    public void parsePK(String statement) {
        this.statement = statement;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.table != null) {
                PKProxySqlServerv2k pk;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (pk = new PKProxySqlServerv2k(this.index, (StorageDesign)this.stoDesign)) != null) {
                    this.initClustered(pk);
                    this.initFillFactorPK(pk);
                    this.initFileGroupPK(pk);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    private boolean isIOV() {
        String name = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(name);
        return this.table == null;
    }

    private boolean isPK() {
        return Token.hasToken(this.statement, "ADD") && Token.hasToken(this.statement, "PRIMARY");
    }

    private String getIndexOption(String optionName) {
        String afterOptionName = Token.getStringAfter(this.statement, optionName);
        if (afterOptionName.startsWith("=")) {
            String optionValue = Token.getFirstToken(afterOptionName.substring(1).trim());
            int commaInd = optionValue.indexOf(44);
            if (commaInd > -1) {
                optionValue = optionValue.substring(0, commaInd);
            }
            return optionValue;
        }
        return "";
    }

    private void initSortInTempDB(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (this.getIndexOption("SORT_IN_TEMPDB").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k.setSortInTempDB("YES");
        }
    }

    private void initStatisticNoRecompute(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (this.getIndexOption("STATISTICS_NORECOMPUTE").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k.setRecomputeStatistics("NO");
        }
    }

    private void initIgnoreDupKey(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (this.getIndexOption("IGNORE_DUP_KEY").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k.setIgnoreDupKey("YES");
        }
    }

    private void initFillFactor(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        String fillFactorValue = this.getIndexOption("FILLFACTOR");
        if (!fillFactorValue.equals("")) {
            try {
                indexOnViewSqlServerv2k.setFillFactor(Integer.parseInt(fillFactorValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Fill factor is unknown on index on view " + indexOnViewSqlServerv2k.getName());
            }
        }
    }

    private void initPadIndex(IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (this.getIndexOption("PAD_INDEX").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k.setPadIndex("YES");
        }
    }

    private void initSortInTempDB(IndexProxySqlServerv2k indexProxy) {
        if (this.getIndexOption("SORT_IN_TEMPDB").equalsIgnoreCase("ON")) {
            indexProxy.setSortInTempDB("YES");
        }
    }

    private void initStatisticNoRecompute(IndexProxySqlServerv2k indexProxy) {
        if (this.getIndexOption("STATISTICS_NORECOMPUTE").equalsIgnoreCase("ON")) {
            indexProxy.setRecomputeStatistics("NO");
        }
    }

    private void initIgnoreDupKey(IndexProxySqlServerv2k indexProxy) {
        if (this.getIndexOption("IGNORE_DUP_KEY").equalsIgnoreCase("ON")) {
            indexProxy.setIgnoreDupKey("YES");
        }
    }

    private void initFillFactor(IndexProxySqlServerv2k indexProxy) {
        String fillFactorValue = this.getIndexOption("FILLFACTOR");
        if (!fillFactorValue.equals("")) {
            try {
                indexProxy.setFillFactor(Integer.parseInt(fillFactorValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Fill factor is unknown on index " + indexProxy.getName());
            }
        }
    }

    private void initPadIndex(IndexProxySqlServerv2k indexProxy) {
        if (this.getIndexOption("PAD_INDEX").equalsIgnoreCase("ON")) {
            indexProxy.setPadIndex("YES");
        }
    }

    private void initFileGroup(IndexOnViewSqlServerv2k indexProxy) {
        while (Token.hasToken(this.statement, "ON")) {
            String fgName = Token.getStringAfter(this.statement, "ON");
            fgName = Token.getValBetweenQuotationMarks(fgName);
            FileGroupSqlServerv2k fileGroup = (FileGroupSqlServerv2k)this.stoDesign.getFileGroupSet().getByName(fgName);
            if (fileGroup != null) {
                indexProxy.setFilegroup(fileGroup);
            }
            this.statement = Token.getStringAfter(this.statement, "ON");
        }
    }

    private String initIndexName() {
        String temp = Token.getTokenAfter(this.statement, "INDEX").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "INDEX", '[', ']').trim() : Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            name = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "INDEX"), '.');
        }
        return name;
    }

    private void constructIndex() {
        String name = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(name);
        if (this.table == null) {
            this.view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(name);
            this.viewProxy = ((TableViewProxySetSqlServer)this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).getTableViewProxySet()).getByName(name);
        }
        if (this.table != null) {
            Index[] indexes = (Index[])this.table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                Index ind = indexes[i];
                if (!ind.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = ind;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else if (this.viewProxy != null) {
            this.iov = ((StorageDesignSqlServerv2k)this.design.getStorageDesign(this.design.getSelectedRDBMSSite())).getIndexOnViewSet().createIndexOnView();
            this.iov.setName(this.indexName);
            this.iov.setView(this.viewProxy);
            this.design.getRelationalDesign().stampModelObjectDDL(this.iov);
        }
    }

    private void initUnique() {
        boolean unique;
        if (!this.index.isPK() && (unique = Token.hasToken(this.statement, "UNIQUE"))) {
            this.index.setIndexState("Unique Constraint");
        }
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        block13: {
            Map columnCollection;
            block12: {
                columnCollection = null;
                if (this.table == null) break block12;
                columnCollection = this.getColumnsForTable();
                if (columnCollection.size() <= 0) break block13;
                String columnString = Token.getValBetweenBrackets(this.statement, 1);
                if ("".equalsIgnoreCase(columnString.trim())) {
                    return;
                }
                boolean functionString = Token.hasCloseAndOpenBrackets(columnString);
                if (functionString) {
                    this.index.setIndexExpression(columnString);
                    return;
                }
                StringTokenizer columnToken = new StringTokenizer(columnString, ",");
                while (columnToken.hasMoreTokens()) {
                    Column columnTable;
                    String columnName = columnToken.nextToken().trim();
                    columnName = Token.getValBetweenSquareBrackets(columnName);
                    columnName = Token.getNamesOnly(columnName);
                    String sortOrder = "ASC";
                    int posColumnSpace = columnName.indexOf(" ");
                    if (posColumnSpace > 0) {
                        try {
                            if (columnName.substring(posColumnSpace + 1).trim().equalsIgnoreCase("DESC")) {
                                sortOrder = "DESC";
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        columnName = columnName.substring(0, posColumnSpace);
                    }
                    if ((columnTable = (Column)columnCollection.get(columnName = Token.getValBetweenSquareBrackets(columnName))) != null) {
                        try {
                            this.index.add(columnTable);
                            this.index.setColumnSortOrder(columnTable, sortOrder);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception occured while adding column to index!" + this.statement);
                            this.importLog.addError("Error in adding column " + columnTable + " to index " + this.indexName);
                        }
                        continue;
                    }
                    throw new ObjectDoesNotExistException("Column");
                }
                break block13;
            }
            if (this.viewProxy != null && (columnCollection = this.getColumnsForView()).size() > 0) {
                String columnString = Token.getValBetweenBrackets(this.statement, 1);
                StringTokenizer columnToken = new StringTokenizer(columnString, ",");
                while (columnToken.hasMoreTokens()) {
                    String columnName = columnToken.nextToken().trim();
                    int posColumnSpace = columnName.indexOf(" ");
                    if (posColumnSpace <= 0) continue;
                    columnName = columnName.substring(0, posColumnSpace);
                }
            }
        }
    }

    private String getName() {
        String name = Token.getQuotedNameAfterToken(this.statement, "ON");
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            name = Token.getValAfterCharacter(name, '.');
        }
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40));
        }
        return Token.getValBetweenSquareBrackets(name);
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> collectionColumns = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columns = (Column[])this.table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                collectionColumns.put(columns[i].getName(), columns[i]);
            }
        }
        return collectionColumns;
    }

    private Map getColumnsForView() {
        HashMap<String, ColumnView> collectionColumns = new HashMap<String, ColumnView>();
        if (this.viewProxy != null) {
            ColumnView[] columns = (ColumnView[])this.view.getElements();
            for (int i = 0; i < columns.length; ++i) {
                collectionColumns.put(columns[i].getName(), columns[i]);
            }
        }
        return collectionColumns;
    }

    public void parseUK(String statement) {
        this.statement = statement;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.initUnique();
            this.setColumnForIndex();
            if (this.table != null) {
                UniqueProxySqlServerv2k uk;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (uk = new UniqueProxySqlServerv2k(this.index, (StorageDesign)this.stoDesign)) != null) {
                    this.initClustered(uk);
                    this.initFillFactorUK(uk);
                    this.initFileGroupUK(uk);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Error in creating unique key " + this.indexName);
        }
    }

    private void initFileGroupUK(UniqueProxySqlServerv2k uk) {
        if (Token.hasToken(this.statement, "ON")) {
            String fileGroupUK = Token.getTokenAfter(this.statement, "ON");
            fileGroupUK = Token.getValBetweenQuotationMarks(fileGroupUK);
            uk.setFilegroup((FileGroupSqlServer)this.stoDesign.getFileGroupSet().getByName(fileGroupUK));
        }
    }

    private void initFillFactorUK(UniqueProxySqlServerv2k uk) {
        String fillFactorValue = this.getIndexOption("FILLFACTOR");
        if (!fillFactorValue.equals("")) {
            try {
                uk.setFillFactor(Integer.parseInt(fillFactorValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Unknown fill factor of unique key " + uk.getName());
            }
        }
    }

    private boolean isUK() {
        return Token.hasToken(this.statement, "UNIQUE") && !this.isIOV();
    }

    private void initFileGroupPK(PKProxySqlServerv2k pk) {
        if (Token.hasToken(this.statement, "ON")) {
            String fileGroupUK = Token.getTokenAfter(this.statement, "ON");
            fileGroupUK = Token.getValBetweenQuotationMarks(fileGroupUK);
            pk.setFilegroup((FileGroupSqlServer)this.stoDesign.getFileGroupSet().getByName(fileGroupUK));
        }
    }

    private void initFillFactorPK(PKProxySqlServerv2k pk) {
        String fillFactorValue = this.getIndexOption("FILLFACTOR");
        if (!fillFactorValue.equals("")) {
            try {
                pk.setFillFactor(Integer.parseInt(fillFactorValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Unknown fill factor of primary key " + pk.getName());
            }
        }
    }
}

