/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.Locale;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceOraclev9i
extends DDLStatementHandler {
    private TableSpaceOraclev9i tableSpace;
    private RDBMSSite site;
    private StorageDesignOraclev9i stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceOraclev9i.class);

    public SHCreateTablespaceOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTablespaceOraclev9i.clearCR(line);
        if (Token.startsWithString(statement, "CREATE TABLESPACE") || Token.startsWithString(statement, "CREATE SMALLFILE TABLESPACE") || Token.startsWithString(statement, "CREATE BIGFILE TABLESPACE")) {
            try {
                this.parseTablespace(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateTablespaceOraclev9i.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseTablespace(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = (TableSpaceOraclev9i)this.stoDesign.getTableSpaceSet().createTableSpace();
            if (this.tableSpace != null) {
                this.initName();
                this.initDataFiles();
                this.initMinimumExtent();
                this.initBlockSize();
                this.initLogging();
                this.initForceLogging();
                this.initStatus();
                this.initContents();
                this.initDefaultStorage();
                this.initExtManagement();
                this.initSegmentManagement();
                this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
            }
        }
    }

    private void initBlockSize() {
        if (Token.hasToken(this.statement, "BLOCKSIZE")) {
            String blockSize = this.getNumberOnly(Token.getTokenAfter(this.statement, "BLOCKSIZE").trim());
            try {
                int size = Integer.parseInt(blockSize);
                this.tableSpace.setBlockSize(size);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong BLOCKSIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initBlockSize() : " + e.getMessage());
            }
        }
    }

    private void initName() {
        String name = Token.getNameAfterToken(this.statement, "TABLESPACE", '\"', '\"').trim();
        this.tableSpace.setName(name);
    }

    public TableSpaceOraclev9i getTablespace() {
        return this.tableSpace;
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE")) {
            String[] match = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String dataFiles = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), match);
            StringTokenizer tokenizer = new StringTokenizer(dataFiles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.initDataFile(token);
            }
        }
    }

    private void initDataFile(String dfInfo) {
        if (!"".equalsIgnoreCase(dfInfo)) {
            DataFileOraclev9i dataFile = (DataFileOraclev9i)this.stoDesign.getDataFileSet().createDataFile();
            dataFile.setTableSpace(this.tableSpace);
            String fileName = Token.getValBetweenQuotes(dfInfo);
            dataFile.setFileName(fileName);
            this.design.getRelationalDesign().stampModelObjectDDL(dataFile);
            if (Token.hasToken(dfInfo, "SIZE")) {
                String afterSize = Token.getStringAfter(dfInfo, "SIZE");
                String sizeStr = Token.getFirstToken(afterSize);
                try {
                    long size = Long.parseLong(this.removeMeasureUnit(sizeStr));
                    dataFile.setSize(size);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong SIZE format in SHCreateTablespaceOracle.initDataFile", e);
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                }
                String measureUnit = this.getMeasureUnit(sizeStr, afterSize);
                dataFile.setMeasureUnit(measureUnit);
            }
            if (Token.hasToken(dfInfo, "REUSE")) {
                dataFile.setReuse("YES");
            } else {
                dataFile.setReuse("NO");
            }
            if (Token.hasToken(dfInfo, "AUTOEXTEND")) {
                String autoextend = Token.getTokenAfter(dfInfo, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("ON");
                    if (Token.hasToken(dfInfo, "NEXT")) {
                        String afterNext = Token.getStringAfter(dfInfo, "NEXT");
                        String nextStr = Token.getFirstToken(afterNext);
                        try {
                            int size = Integer.parseInt(this.removeMeasureUnit(nextStr));
                            dataFile.setNextBlockSize(size);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong NEXT format in SHCreateTablespaceOracle.initDataFile", e);
                            this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                        }
                        String nextUnit = this.getMeasureUnit(nextStr, afterNext);
                        dataFile.setNextBlockSizeUnit(nextUnit);
                    }
                    if (Token.hasToken(dfInfo, "MAXSIZE")) {
                        String afterMaxsize = Token.getStringAfter(dfInfo, "MAXSIZE");
                        String maxsizeStr = Token.getFirstToken(afterMaxsize);
                        if (maxsizeStr.equalsIgnoreCase("UNLIMITED")) {
                            dataFile.setMaxSize("UNLIMITED");
                        } else {
                            try {
                                String noUnit = this.removeMeasureUnit(maxsizeStr);
                                Long.parseLong(noUnit);
                                dataFile.setMaxSize(noUnit);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("wrong MAXSIZE format in SHCreateTablespaceOracle.initDataFile", e);
                                this.importLog.addWarning("Wrong MAXSIZE format in statement " + this.statement);
                            }
                            String maxsizeUnit = this.getMeasureUnit(maxsizeStr, afterMaxsize);
                            dataFile.setMaxSizeUnit(maxsizeUnit);
                        }
                    }
                } else if ("OFF".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("OFF");
                }
            }
        }
    }

    private String getMeasureUnit(String value, String dfInfo) {
        String sizeStr = value.toUpperCase(Locale.ROOT);
        if (sizeStr.endsWith("K")) {
            return "K";
        }
        if (sizeStr.endsWith("M")) {
            return "M";
        }
        sizeStr = Token.getTokenAfter(dfInfo, value).toUpperCase(Locale.ROOT);
        if (sizeStr.equals("K") || sizeStr.equals("M")) {
            return sizeStr;
        }
        return "";
    }

    private String removeMeasureUnit(String value) {
        String sizeStr = value.toUpperCase(Locale.ROOT);
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private void initMinimumExtent() {
        String line;
        if (Token.hasToken(this.statement, "MINIMUM") && "EXTENT".equalsIgnoreCase(Token.getFirstToken(line = Token.getStringAfter(this.statement, "MINIMUM")).trim())) {
            String minExtLen = this.getNumberOnly(Token.getTokenAfter(line, "EXTENT").trim());
            try {
                int minExtent = Integer.parseInt(minExtLen);
                this.tableSpace.setMinExtLen(minExtent);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initMinimumExtent : " + e.getMessage());
                this.importLog.addWarning("Wrong MINIMUM format in statement " + this.statement);
            }
        }
    }

    private void initLogging() {
        if (Token.hasToken(this.statement, "NOLOGGING")) {
            this.tableSpace.setLogging("NOLOGGING");
        }
    }

    private void initForceLogging() {
        if (this.statement.toUpperCase(Locale.ROOT).indexOf("FORCE LOGGING") > -1) {
            this.tableSpace.setForceLogging("YES");
        }
    }

    private void initStatus() {
        if (Token.hasToken(this.statement, "OFFLINE")) {
            this.tableSpace.setStatus("OFFLINE");
        }
    }

    private void initContents() {
        if (Token.hasToken(this.statement, "TEMPORARY")) {
            this.tableSpace.setContents("TEMPORARY");
        }
    }

    private void initDefaultStorage() {
        String line;
        if (Token.hasToken(this.statement, "STORAGE") && Token.hasCloseAndOpenBrackets(line = Token.getStringAfter(this.statement, "STORAGE"))) {
            line = Token.getValBetweenBrackets(line, 1).trim();
            this.initInitialExtent(line);
            this.initMinExtents(line);
            this.initNextExtents(line);
            this.initMaxExtents(line);
            this.initPctIncrease(line);
        }
    }

    private void initInitialExtent(String line) {
        if (Token.hasToken(line, "INITIAL")) {
            String initExtentStr = this.getNumberOnly(Token.getTokenAfter(line, "INITIAL").trim());
            try {
                long initExtent = Long.parseLong(initExtentStr);
                this.tableSpace.setDSInitialExtent(initExtent);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initInitialExtent : " + e.getMessage());
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
            }
        }
    }

    private void initMinExtents(String line) {
        if (Token.hasToken(line, "MINEXTENTS")) {
            String initMinExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "MINEXTENTS").trim());
            try {
                int initMinExtents = Integer.parseInt(initMinExtentsStr);
                this.tableSpace.setDSMinExtents(initMinExtents);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initMinExtents : " + e.getMessage());
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
            }
        }
    }

    private void initNextExtents(String line) {
        if (Token.hasToken(line, "NEXT")) {
            String initNextExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "NEXT").trim());
            try {
                long initNextExtents = Long.parseLong(initNextExtentsStr);
                this.tableSpace.setDSNextExtent(initNextExtents);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initNextExtents : " + e.getMessage());
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
            }
        }
    }

    private void initMaxExtents(String line) {
        if (Token.hasToken(line, "MAXEXTENTS")) {
            String initMaxExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "MAXEXTENTS").trim());
            this.tableSpace.setDSMaxExtents(initMaxExtentsStr);
        }
    }

    private void initPctIncrease(String line) {
        if (Token.hasToken(line, "PCTINCREASE")) {
            String initPctIncStr = this.getNumberOnly(Token.getTokenAfter(line, "PCTINCREASE").trim());
            try {
                int initPctInc = Integer.parseInt(initPctIncStr);
                this.tableSpace.setDSPctIncrease(initPctInc);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initPctIncrease : " + e.getMessage());
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
            }
        }
    }

    private void initExtManagement() {
        String line = Token.getStringAfter(this.statement, "EXTENT MANAGEMENT");
        if (!line.isEmpty()) {
            if (Token.getFirstToken(line).equalsIgnoreCase("LOCAL")) {
                this.tableSpace.setExtentManagement("LOCAL");
                String localSubType = Token.getTokenAfter(line, "LOCAL").trim();
                if (localSubType.equalsIgnoreCase("UNIFORM")) {
                    this.tableSpace.setEMLocalSubtype("UNIFORM");
                    String sizeStr = this.getNumberOnly(Token.getTokenAfter(line, "SIZE").trim());
                    if (!sizeStr.equals("")) {
                        try {
                            int size = Integer.parseInt(sizeStr);
                            this.tableSpace.setEMUniformSize(size);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initExtManagement : " + e.getMessage());
                            this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                        }
                    }
                }
            } else if (Token.getFirstToken(line).equalsIgnoreCase("DICTIONARY")) {
                this.tableSpace.setExtentManagement("DICTIONARY");
            }
        }
    }

    private void initSegmentManagement() {
        String line = Token.getStringAfter(this.statement, "SEGMENT SPACE MANAGEMENT");
        if (!line.isEmpty()) {
            this.tableSpace.setSegmentManagement(Token.getFirstToken(line).toUpperCase(Locale.ROOT));
        }
    }
}

