/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.MethodProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StructuredTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TypeElementProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTypeOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTypeOraclev10g.class);
    private StorageDesignOracle storageDesign;

    public SHCreateTypeOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        this.statement = SHCreateTypeOraclev10g.clearCR(line);
        if (Token.getFirstToken(this.statement).equalsIgnoreCase("CREATE")) {
            String firstToken;
            String restOfText = Token.cutTokenFromFront(this.statement, "CREATE");
            if (Token.startsWithString(restOfText, "OR REPLACE")) {
                restOfText = Token.cutTokenFromFront(restOfText, "OR REPLACE");
            }
            if ((firstToken = Token.getFirstToken(restOfText)).equalsIgnoreCase("EDITIONABLE") || firstToken.equalsIgnoreCase("NONEDITIONABLE")) {
                restOfText = Token.cutTokenFromFront(restOfText, firstToken);
            }
            if (Token.getFirstToken(restOfText).equalsIgnoreCase("TYPE")) {
                restOfText = Token.cutTokenFromFront(restOfText, "TYPE");
                try {
                    RDBMSSite site = this.design.getSelectedRDBMSSite();
                    this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
                    if (Token.getFirstToken(restOfText).equalsIgnoreCase("BODY")) {
                        this.parseTypeBody();
                    } else {
                        this.parseType();
                    }
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception e) {
                    LOGGER.error(" Parsing " + this.statement + " for Oracle failed!", e);
                    this.importLog.addFailedStatement(SHCreateTypeOraclev10g.FormatCR(line, "\n"));
                }
            } else {
                this.nextHandler(line);
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseType() {
        if (this.storageDesign != null) {
            StructuredTypeProxyOraclev10g typeProxy;
            StructuredType type;
            String afterType = Token.getStringAfter(this.statement, "TYPE");
            String longName = Token.getFirstName(afterType, '\"', '\"');
            String owner = null;
            String name = longName;
            int posPoint = longName.indexOf(46);
            if (posPoint > 0) {
                owner = longName.substring(0, posPoint);
                name = longName.substring(posPoint + 1);
            }
            if ((type = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(name)) != null) {
                this.storageDesign.getStructuredTypeProxySet().add(type);
                typeProxy = (StructuredTypeProxyOraclev10g)this.storageDesign.getStructuredTypeProxySet().getProxy(type.getObjectID());
            } else {
                type = this.design.getDataTypesDesign().createStructuredType();
                type.setName(name);
                this.design.getRelationalDesign().stampModelObjectDDL(type);
                typeProxy = (StructuredTypeProxyOraclev10g)this.storageDesign.getProxy(type);
                if (typeProxy != null && owner != null) {
                    UserOraclev10g user = (UserOraclev10g)this.storageDesign.getUserSet().getByName(owner);
                    if (user == null) {
                        user = (UserOraclev10g)this.storageDesign.getUserSet().createUser();
                        user.setName(owner);
                        this.design.getRelationalDesign().stampModelObjectDDL(user);
                    }
                    typeProxy.setOwner(user);
                }
            }
            if (typeProxy != null) {
                int nameIndex = afterType.indexOf(name, posPoint);
                String afterName = afterType.substring(nameIndex + name.length());
                if (afterName.startsWith("\"")) {
                    if (!name.equals(name.toUpperCase())) {
                        type.setNameHasQuotes(true);
                    }
                    afterName = afterName.substring(1);
                }
                if (Token.getFirstToken(afterName).equalsIgnoreCase("FORCE")) {
                    typeProxy.setForceReplace("YES");
                }
                this.initInvokerRights(typeProxy);
                this.initOid(typeProxy);
                this.initElementList(type, typeProxy);
            }
        }
    }

    private void initInvokerRights(StructuredTypeProxyOracle typeProxy) {
        String rights;
        if (Token.hasToken(this.statement, "AUTHID") && !"".equalsIgnoreCase(rights = Token.getTokenAfter(this.statement, "AUTHID"))) {
            if (rights.equalsIgnoreCase("CURRENT_USER")) {
                typeProxy.setInvokerRights("CURRENT_USER");
            } else if (rights.equalsIgnoreCase("DEFINER")) {
                typeProxy.setInvokerRights("DEFINER");
            }
        }
    }

    private void initOid(StructuredTypeProxyOraclev10g typeProxy) {
        String oid;
        if (Token.hasToken(this.statement, "OID") && (oid = Token.getStringAfterToken(this.statement, "OID")).startsWith("'")) {
            oid = Token.getValBetweenQuotes(oid);
            typeProxy.setGlobalOid(oid);
        }
    }

    private String initMethod(StructuredType type, String methodString, String[] match) {
        String overriding = "NO";
        String isFinal = "NO";
        String instantiable = "YES";
        boolean isConstructor = false;
        boolean isMapOrder = false;
        String isStatic = "NO";
        StructuredTypeProxyOraclev10g typeProxy = (StructuredTypeProxyOraclev10g)this.storageDesign.getStructuredTypeProxySet().getProxy(type.getObjectID());
        boolean hasInherClause = true;
        while (hasInherClause) {
            String methodStringUC;
            String notValue = "YES";
            if (methodString.toUpperCase().startsWith("NOT")) {
                methodString = Token.cutFirstToken2(methodString);
                notValue = "NO";
            }
            if ((methodStringUC = methodString.toUpperCase()).startsWith("OVERRIDING")) {
                methodString = Token.cutFirstToken2(methodString);
                overriding = notValue;
                continue;
            }
            if (methodStringUC.startsWith("FINAL")) {
                methodString = Token.cutFirstToken2(methodString);
                isFinal = notValue;
                continue;
            }
            if (methodStringUC.startsWith("INSTANTIABLE")) {
                methodString = Token.cutFirstToken2(methodString);
                instantiable = notValue;
                continue;
            }
            hasInherClause = false;
        }
        if (Token.startsWithString(methodString, "STATIC")) {
            isStatic = "YES";
            methodString = Token.cutFirstToken2(methodString);
        } else {
            if (methodString.toUpperCase().startsWith("MAP")) {
                typeProxy.setMapOrderType("MAP");
                isMapOrder = true;
                methodString = Token.cutFirstToken2(methodString);
            } else if (methodString.toUpperCase().startsWith("ORDER")) {
                typeProxy.setMapOrderType("ORDER");
                isMapOrder = true;
                methodString = Token.cutFirstToken2(methodString);
            }
            if (Token.startsWithString(methodString, "MEMBER")) {
                methodString = Token.cutFirstToken2(methodString);
            }
        }
        if (Token.getFirstToken(methodString).equalsIgnoreCase("CONSTRUCTOR")) {
            isConstructor = true;
            methodString = Token.cutFirstToken(methodString);
        }
        if (Token.getFirstToken(methodString).equalsIgnoreCase("PROCEDURE")) {
            methodString = Token.cutFirstToken(methodString);
        } else if (Token.getFirstToken(methodString).equalsIgnoreCase("FUNCTION")) {
            methodString = Token.cutFirstToken(methodString);
        }
        String methodDef = Token.getStringToFirstMatch(methodString, match);
        String nextMethod = Token.getStringAfter(methodString, methodDef);
        if (methodDef.endsWith(",")) {
            methodString = methodDef.substring(0, methodDef.length() - 1);
        } else if (methodDef.length() > 0) {
            methodString = methodDef;
        }
        String name = Token.getFirstName(methodString, '\"', '\"');
        if (Token.hasString(name, "(")) {
            name = Token.getStringBefore(name, "(");
        }
        Method m = new Method(type.getDesignPart(), type);
        m.setName(name);
        m.setDesign(type.getDesign());
        type.addMethod(m);
        m.setConstructor(isConstructor);
        MethodProxyOraclev10g methodProxy = (MethodProxyOraclev10g)this.storageDesign.getProxy(m);
        methodProxy.setIsStatic(isStatic);
        methodProxy.setOverriding(overriding);
        methodProxy.setIsFinal(isFinal);
        methodProxy.setInstantiable(instantiable);
        if (isMapOrder) {
            typeProxy.setMapOrderFunction(methodProxy);
        }
        String afterParams = "";
        if ((methodString = Token.getStringAfter(methodString, name)).startsWith("\"")) {
            methodString = methodString.substring(1).trim();
        }
        if (methodString.startsWith("(")) {
            String params = Token.getValBetweenBrackets(methodString, 1).trim();
            afterParams = Token.getValAfterBrackets(methodString, 1);
            StringTokenizer tokenizer = new StringTokenizer(params, ",");
            String column = null;
            while (tokenizer.hasMoreTokens()) {
                column = tokenizer.nextToken().trim();
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                String argName = Token.getFirstName(column, '\"', '\"');
                String datatype = Token.getStringAfter(column, argName);
                if (datatype.startsWith("\" ")) {
                    datatype = datatype.substring(2).trim();
                }
                String direction = "IN";
                if (datatype.toUpperCase().startsWith("IN OUT ")) {
                    direction = "IN OUT";
                    datatype = Token.cutTokenFromFront(datatype, direction);
                } else if (Token.getFirstToken(datatype).equalsIgnoreCase("IN")) {
                    direction = "IN";
                    datatype = Token.cutFirstToken(datatype);
                } else if (Token.getFirstToken(datatype).equalsIgnoreCase("OUT")) {
                    direction = "OUT";
                    datatype = Token.cutFirstToken(datatype);
                }
                String copy = "YES";
                if (Token.getFirstToken(datatype).equalsIgnoreCase("NOCOPY")) {
                    copy = "NO";
                    datatype = Token.cutFirstToken(datatype);
                }
                String defaultValue = Token.getStringAfter(datatype, "DEFAULT");
                MethodParam param = new MethodParam(m.getDesignPart());
                param.setName(argName);
                param.setDesign(m.getDesign());
                m.addParameter(param);
                this.initDatatype(datatype, param);
                param.setDefaultValue(defaultValue);
                MethodParamProxyOracle paramProxy = (MethodParamProxyOracle)this.storageDesign.getProxy(param);
                if (paramProxy == null) continue;
                paramProxy.setDirectionType(direction);
                paramProxy.setCopyArgument(copy);
            }
        } else {
            afterParams = methodString;
        }
        if (Token.getFirstToken(afterParams).equalsIgnoreCase("RETURN")) {
            String datatype = Token.cutFirstToken(afterParams);
            MethodParam param = new MethodParam(m.getDesignPart());
            param.setName("RETURN");
            param.setDesign(m.getDesign());
            this.initDatatype(datatype, param);
            m.setReturnValue(param);
        }
        if (Token.hasToken(methodString, "PARALLEL_ENABLE")) {
            methodProxy.setParallel("YES");
            String parallel = Token.getStringAfter(methodString, "PARALLEL_ENABLE");
            if (Token.hasToken(parallel, "AGGREGATE")) {
                parallel = Token.getStringBeforeToken(parallel, "AGGREGATE");
            } else if (Token.hasToken(parallel, "PIPELINED")) {
                parallel = Token.getStringBeforeToken(parallel, "PIPELINED");
            }
            methodProxy.setPartitioningAndStreaming(parallel);
        }
        if (Token.hasToken(methodString, "DETERMINISTIC")) {
            methodProxy.setDeterministic("YES");
        }
        if (Token.hasString(methodString, "AGGREGATE USING")) {
            methodProxy.setPipeliningAndAggregation("Aggregate Using");
        } else if (Token.hasString(methodString, "PIPELINED USING")) {
            methodProxy.setPipeliningAndAggregation("Pipelined Using");
        } else if (Token.hasString(methodString, "PIPELINED")) {
            methodProxy.setPipeliningAndAggregation("Pipelined");
            String pipelinedImpl = Token.getStringAfter(methodString, "PIPELINED");
            afterParams = Token.cutFirstToken(pipelinedImpl);
            afterParams = Token.cutFirstToken(afterParams);
            pipelinedImpl = Token.getStringBeforeToken(pipelinedImpl, "AS");
            methodProxy.setPipeliningAndAggregationImpl(pipelinedImpl);
            if (Token.getFirstToken(afterParams).equalsIgnoreCase("LANGUAGE")) {
                if (Token.getFirstToken(afterParams = Token.cutFirstToken(afterParams)).equalsIgnoreCase("JAVA")) {
                    methodProxy.setImplLanguage("Java");
                    afterParams = Token.cutFirstToken(afterParams);
                    afterParams = Token.getValBetweenQuotes(afterParams);
                    methodProxy.setJavaName(afterParams);
                } else if (Token.getFirstToken(afterParams).equalsIgnoreCase("C")) {
                    String library;
                    methodProxy.setImplLanguage("C");
                    afterParams = Token.cutFirstToken(afterParams);
                    if (Token.getFirstToken(afterParams).equalsIgnoreCase("NAME")) {
                        afterParams = Token.cutFirstToken(afterParams);
                        methodProxy.setCName(Token.getFirstToken(afterParams));
                        afterParams = Token.cutFirstToken(afterParams);
                    }
                    if (!"".equalsIgnoreCase(library = Token.getTokenAfter(afterParams, "LIBRARY"))) {
                        methodProxy.setCLibrary(library);
                    }
                    if (Token.hasString(afterParams, "AGENT IN")) {
                        String agent = Token.getStringAfter(afterParams, "AGENT IN");
                        agent = Token.getValBetweenBrackets(agent, 1);
                        methodProxy.setAgentArguments(agent);
                    }
                    if (Token.hasString(afterParams, "WITH CONTEXT")) {
                        methodProxy.setWithContext("YES");
                    }
                    if (Token.hasString(afterParams, "PARAMETERS")) {
                        afterParams = Token.cutFirstToken(afterParams);
                        afterParams = Token.getValBetweenBrackets(afterParams, 1);
                        methodProxy.setCPartemeters(afterParams);
                    }
                }
            }
        }
        methodString = this.initPragma(methodProxy, methodString);
        return nextMethod;
    }

    private String initPragma(MethodProxyOracle methodProxy, String methodString) {
        if (Token.hasString(methodString, "PRAGMA RESTRICT_REFERENCES") && Token.hasCloseAndOpenBrackets(methodString = Token.getStringAfter(methodString, "RESTRICT_REFERENCES").trim())) {
            StringBuffer pragma = new StringBuffer("PRAGMA RESTRICT_REFERENCES (");
            pragma.append(Token.getValBetweenBrackets(methodString));
            pragma.append(")");
            methodProxy.setPragmaClause(pragma.toString());
            methodString = Token.getValAfterBrackets(methodString, 1);
        }
        return methodString;
    }

    private void initDatatype(String datatypeString, DataTypeObject datatypeObject) {
        datatypeString = datatypeString.toUpperCase();
        String datatypeName = null;
        boolean isRef = Token.getFirstToken(datatypeString).equalsIgnoreCase("REF");
        if (isRef) {
            datatypeString = Token.cutFirstToken(datatypeString);
        } else {
            String firstToken = Token.getFirstToken(datatypeString);
            if (firstToken.equals("TIMESTAMP")) {
                datatypeName = datatypeString.indexOf("WITH LOCAL TIME ZONE") >= 0 ? "TIMESTAMP WITH LOCAL TIME ZONE" : (datatypeString.indexOf("WITH TIME ZONE") >= 0 ? "TIMESTAMP WITH TIME ZONE" : "TIMESTAMP");
            } else if (datatypeString.startsWith("INTERVAL YEAR")) {
                datatypeName = "INTERVAL YEAR TO MONTH";
            } else if (datatypeString.startsWith("INTERVAL DAY")) {
                datatypeName = "INTERVAL DAY TO SECOND";
            } else if (datatypeString.startsWith("DOUBLE PRECISION")) {
                datatypeName = "DOUBLE PRECISION";
            } else {
                String[] names = StandardDatatypeNames.getAllPossibleDatatypes(this.getStorageDesign().getRDBMSType().getName());
                for (int number = 0; number < names.length; ++number) {
                    String name = names[number];
                    if (!datatypeString.startsWith(name)) continue;
                    int nameLength = name.length();
                    if (datatypeString.length() != nameLength && datatypeString.charAt(nameLength) != ' ' && datatypeString.charAt(nameLength) != '(') continue;
                    datatypeName = name;
                    break;
                }
            }
        }
        if (datatypeName != null) {
            int sizeOrPrecision = 0;
            int scale = 0;
            String units = "";
            if (datatypeName.startsWith("TIMESTAMP")) {
                sizeOrPrecision = 6;
                String afterTimestamp = Token.cutTokenFromFront(datatypeString, "TIMESTAMP");
                if (afterTimestamp.startsWith("(")) {
                    String yearPrecision = Token.getValBetweenBrackets(afterTimestamp, 1).trim();
                    try {
                        sizeOrPrecision = Integer.parseInt(yearPrecision);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Wrong precision format " + sizeOrPrecision);
                        this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                    }
                }
            } else if (datatypeName.equals("INTERVAL YEAR TO MONTH")) {
                sizeOrPrecision = 2;
                String afterYear = Token.getStringAfterToken(datatypeString, "YEAR");
                if (afterYear.startsWith("(")) {
                    String yearPrecision = Token.getValBetweenBrackets(afterYear, 1).trim();
                    try {
                        sizeOrPrecision = Integer.parseInt(yearPrecision);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Wrong precision format " + sizeOrPrecision);
                        this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                    }
                }
            } else if (datatypeName.equals("INTERVAL DAY TO SECOND")) {
                String afterSecond;
                sizeOrPrecision = 2;
                scale = 6;
                String afterDay = Token.getStringAfterToken(datatypeString, "DAY");
                if (afterDay.startsWith("(")) {
                    String dayPrecision = Token.getValBetweenBrackets(afterDay, 1).trim();
                    try {
                        sizeOrPrecision = Integer.parseInt(dayPrecision);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Wrong precision format " + sizeOrPrecision);
                        this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                    }
                }
                if ((afterSecond = Token.getStringAfterToken(afterDay, "SECOND")).startsWith("(")) {
                    String secondsPrecision = Token.getValBetweenBrackets(afterSecond, 1).trim();
                    try {
                        scale = Integer.parseInt(secondsPrecision);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Wrong precision format " + secondsPrecision);
                        this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                    }
                }
            } else {
                String afterDatatypeName = Token.cutTokenFromFront(datatypeString, datatypeName);
                if (afterDatatypeName.startsWith("(")) {
                    String params = Token.getValBetweenBrackets(datatypeString, 1);
                    int positionKomma = params.indexOf(44);
                    if (positionKomma > -1) {
                        try {
                            sizeOrPrecision = Integer.parseInt(params.substring(0, positionKomma).trim());
                            scale = Integer.parseInt(params.substring(positionKomma + 1).trim());
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong format in SHCreateTypeOracle.initDatatype : " + e.getMessage());
                            this.importLog.addWarning("Wrong Precision/Scale value in statement " + this.statement);
                        }
                    } else {
                        if ((params = params.trim().toUpperCase()).endsWith("BYTE") || params.endsWith("CHAR")) {
                            units = params.substring(params.length() - 4);
                            params = params.substring(0, params.length() - 4).trim();
                        }
                        try {
                            sizeOrPrecision = Integer.parseInt(params);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong format in SHCreateTypeOracle.initDatatype : " + e.getMessage());
                            this.importLog.addWarning("Wrong Size value in statement " + this.statement);
                        }
                    }
                }
            }
            String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatypeName);
            usedDatatype = StandardDatatypeNames.getTransformedDatatypeName(usedDatatype, this.getStorageDesign().getRDBMSType());
            LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
            if (logicalDT != null) {
                datatypeObject.setType(logicalDT);
                if (sizeOrPrecision > 0) {
                    if (usedDatatype.indexOf("CHAR") >= 0 || usedDatatype.equals("RAW") || usedDatatype.equals("UROWID")) {
                        datatypeObject.setSize(Integer.toString(sizeOrPrecision));
                        if (datatypeObject instanceof TypeElement) {
                            ((TypeElement)datatypeObject).setUnits(units);
                        }
                    } else {
                        datatypeObject.setPrecision(sizeOrPrecision);
                    }
                }
                if (scale != 0) {
                    datatypeObject.setScale(scale);
                }
            }
        } else {
            DesignObject structOrCollType;
            datatypeName = Token.getFirstName(datatypeString, '\"', '\"');
            int dotIndex = datatypeName.indexOf(46);
            if (dotIndex > -1) {
                datatypeName = datatypeName.substring(dotIndex + 1);
            }
            if ((structOrCollType = datatypeObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(datatypeName)) != null) {
                if (isRef) {
                    datatypeObject.setReference(true);
                }
            } else {
                structOrCollType = datatypeObject.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(datatypeName);
            }
            if (structOrCollType != null) {
                datatypeObject.setType(structOrCollType);
            }
        }
    }

    private void parseTypeBody() {
        if (this.storageDesign != null) {
            StructuredTypeProxyOracle typeProxy;
            StructuredType type;
            String longName;
            String name = longName = Token.getNameAfterToken(this.statement, "BODY", '\"', '\"').trim();
            String owner = null;
            int posPoint = name.indexOf(46);
            if (posPoint > 0) {
                owner = Token.getValBeforeCharacter(longName, '.');
                name = Token.getValAfterCharacter(longName, '.');
            }
            if (this.design.getDataTypesDesign().getStructuredTypeSet().getByName(name) != null) {
                type = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(name);
                this.storageDesign.getStructuredTypeProxySet().add(type);
                typeProxy = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getProxy(type.getObjectID());
            } else {
                LOGGER.error("Type " + name + " does not exist!");
                type = this.design.getDataTypesDesign().createStructuredType();
                type.setName(name);
                this.design.getRelationalDesign().stampModelObjectDDL(type);
                typeProxy = (StructuredTypeProxyOracle)this.storageDesign.getProxy(type);
                if (typeProxy != null && owner != null) {
                    UserOraclev10g user = (UserOraclev10g)this.storageDesign.getUserSet().getByName(owner);
                    if (user == null) {
                        user = (UserOraclev10g)this.storageDesign.getUserSet().createUser();
                        user.setName(owner);
                        this.design.getRelationalDesign().stampModelObjectDDL(user);
                    }
                    typeProxy.setOwner(user);
                }
            }
            String bodyString = this.statement;
            while (bodyString.length() > 0) {
                String firstToken = Token.getFirstToken(bodyString);
                bodyString = Token.cutTokenFromFront(bodyString, firstToken);
                if (!firstToken.equalsIgnoreCase("IS") && !firstToken.equalsIgnoreCase("AS")) continue;
                this.initMethods(bodyString, typeProxy);
                break;
            }
        }
    }

    private void initMethods(String methodString, StructuredTypeProxyOracle typeProxy) {
        if (methodString != null) {
            String methodBody = "";
            String[] match = new String[]{"OVERRIDING", "FINAL", "INSTANTIABLE", "MEMBER", "STATIC", "PROCEDURE", "CONSTRUCTOR", "FUNCTION"};
            if (Token.startsWithString(methodString.toUpperCase(), "IS") || Token.startsWithString(methodString.toUpperCase(), "AS")) {
                methodString = Token.cutFirstToken2(methodString);
            }
            while (Token.hasToken(methodString, "MEMBER") || Token.hasToken(methodString, "STATIC") || Token.hasToken(methodString, "CONSTRUCTOR") || Token.hasToken(methodString, "PROCEDURE") || Token.hasToken(methodString, "FUNCTION")) {
                MethodProxy methodProxy;
                String name;
                String currentString = methodString.trim();
                if (currentString.startsWith("OVERRIDING")) {
                    currentString = Token.cutFirstToken2(currentString);
                }
                if (currentString.startsWith("FINAL")) {
                    currentString = Token.cutFirstToken2(currentString);
                }
                if (currentString.startsWith("INSTANTIABLE")) {
                    currentString = Token.cutFirstToken2(currentString);
                }
                if (currentString.startsWith("MAP") || currentString.startsWith("ORDER")) {
                    currentString = Token.cutFirstToken2(currentString);
                }
                if (currentString.startsWith("STATIC") || currentString.startsWith("MEMBER")) {
                    currentString = Token.cutFirstToken2(currentString);
                }
                if (currentString.startsWith("CONSTRUCTOR")) {
                    currentString = Token.cutFirstToken2(currentString);
                }
                if (Token.hasString(name = Token.getFirstName(currentString = Token.cutFirstToken2(currentString), '\"', '\"'), "(")) {
                    name = Token.getStringBefore(name, "(");
                }
                if ((methodBody = Token.getStringToFirstMatch(currentString, match)).equals("")) {
                    methodBody = currentString;
                }
                if ((methodString = currentString.substring(methodBody.length())).length() == 0) {
                    if ((methodBody = Token.trimRight(methodBody)).endsWith(";")) {
                        methodBody = methodBody.substring(0, methodBody.length() - 1).trim();
                    }
                    if (methodBody.toUpperCase().endsWith(" END")) {
                        methodBody = methodBody.substring(0, methodBody.length() - 4);
                    }
                }
                ArrayList parameterNames = new ArrayList();
                ArrayList parameterDatatypes = new ArrayList();
                while (methodBody.length() > 0) {
                    if (methodBody.startsWith("(")) {
                        this.getMethodParams(methodBody, parameterNames, parameterDatatypes);
                        methodBody = Token.getValAfterBrackets(methodBody, 1).trim();
                        continue;
                    }
                    if (methodBody.toUpperCase().startsWith("RETURN SELF AS RESULT")) {
                        methodBody = Token.getStringAfter(methodBody, "RETURN SELF AS RESULT");
                        continue;
                    }
                    String firstToken = Token.getFirstToken(methodBody);
                    methodBody = Token.cutTokenFromFront(methodBody, firstToken);
                    if (!firstToken.equalsIgnoreCase("IS") && !firstToken.equalsIgnoreCase("AS")) continue;
                    break;
                }
                if ((methodProxy = this.storageDesign.getMethodProxySet().getMethodByNameAndParams(typeProxy, name, parameterNames, parameterDatatypes)) == null) continue;
                methodProxy.getMethod().setBody(methodBody);
            }
        }
    }

    private void getMethodParams(String methodBody, List paramNames, List paramDatatypes) {
        String methodParams;
        if (Token.hasCloseAndOpenBrackets(methodBody) && !(methodParams = Token.getValBetweenBrackets(methodBody, 1)).trim().equals("")) {
            StringTokenizer tokens = new StringTokenizer(methodParams, ",");
            String token = "";
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (Token.startsWithString(token.toUpperCase(), "SELF IN OUT")) continue;
                String paramName = Token.getFirstName(token, '\"', '\"');
                String paramType = Token.getStringAfter(token, paramName);
                if (paramType.startsWith("\" ")) {
                    paramType = paramType.substring(2).trim();
                }
                if (Token.hasToken(paramType, "OUT")) {
                    paramType = Token.getStringAfterToken(paramType, "OUT");
                } else if (Token.hasToken(paramType, "IN")) {
                    paramType = Token.getStringAfterToken(paramType, "IN");
                }
                if (Token.hasToken(paramType, "NOCOPY")) {
                    paramType = Token.getStringAfterToken(paramType, "NOCOPY");
                }
                if (paramType.startsWith("\"")) {
                    paramType = Token.getFirstName(paramType, '\"', '\"');
                } else if (Token.hasToken(paramType, "DEFAULT")) {
                    paramType = Token.getStringBeforeToken(paramType, "DEFAULT");
                }
                paramNames.add(paramName);
                paramDatatypes.add(paramType);
            }
        }
    }

    private void initElementList(StructuredType type, StructuredTypeProxyOraclev10g typeProxy) {
        String elementList = "";
        if (Token.hasString(this.statement.toUpperCase(), "IS OBJECT")) {
            elementList = Token.getStringAfter(this.statement, "IS OBJECT");
        } else if (Token.hasString(this.statement.toUpperCase(), "AS OBJECT")) {
            elementList = Token.getStringAfter(this.statement, "AS OBJECT");
        } else if (Token.hasToken(this.statement, "UNDER")) {
            elementList = Token.getStringAfterToken(this.statement, "UNDER");
            String name = Token.getFirstName(elementList, '\"', '\"');
            int posPoint = name.indexOf(46);
            if (posPoint > 0) {
                name = name.substring(posPoint + 1);
            }
            if (!"".equalsIgnoreCase(name)) {
                StructuredType superType = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(name);
                type.setParentType(superType, false);
            }
            if ((elementList = elementList.substring(elementList.indexOf(name, posPoint + 1) + name.length())).startsWith("\"")) {
                elementList = elementList.substring(1);
            }
            elementList = elementList.trim();
        }
        if (Token.hasString(elementList, "LANGUAGE JAVA USING")) {
            String javaClass = Token.getStringAfter(elementList, "EXTERNAL NAME");
            typeProxy.setJavaClass(Token.getFirstToken(javaClass));
            typeProxy.setMapToJavaClass("YES");
            String javaInstance = Token.getStringAfter(elementList, "LANGUAGE JAVA USING");
            javaInstance = Token.getFirstToken(javaInstance);
            typeProxy.setJavaInstanceUsing(javaInstance);
            elementList = Token.getStringAfterToken(this.statement, javaInstance);
        }
        if (!elementList.equals("")) {
            String afterElementList = Token.getValAfterBrackets(elementList, 1).toUpperCase();
            elementList = Token.getValBetweenBrackets(elementList, 1);
            String[] match = new String[]{"NOT OVERRIDING", "OVERRIDING", "NOT FINAL", "FINAL", "NOT INSTANTIABLE", "INSTANTIABLE", "MEMBER", "STATIC", "PROCEDURE", "CONSTRUCTOR", "FUNCTION", "MAP", "ORDER"};
            String methods = elementList;
            String elements = Token.getStringToFirstMatch(elementList, match).trim();
            if (!"".equalsIgnoreCase(elements)) {
                methods = Token.getStringAfter(elementList, elements);
                StringTokenizer tokenizer = new StringTokenizer(elements, ",");
                String sqljAttr = "";
                while (tokenizer.hasMoreTokens()) {
                    Object el = tokenizer.nextToken();
                    while (Token.hasOpenBracketNoClose((String)el) && tokenizer.hasMoreTokens()) {
                        el = (String)el + ", " + tokenizer.nextToken();
                    }
                    String name = Token.getFirstName((String)el, '\"', '\"');
                    boolean nameInQuotes = false;
                    String datatype = Token.getStringAfter((String)el, name);
                    if (datatype.startsWith("\" ")) {
                        nameInQuotes = true;
                        datatype = datatype.substring(2).trim();
                    }
                    if (Token.hasString(datatype, "EXTERNAL NAME")) {
                        sqljAttr = Token.getStringAfter(datatype, "EXTERNAL NAME");
                        sqljAttr = Token.getValBetweenQuotes(sqljAttr);
                    }
                    TypeElement element = null;
                    element = type.getElementByName(name);
                    if (element == null) {
                        element = new TypeElement(type.getDesignPart(), type);
                        element.setName(name);
                        if (nameInQuotes && !name.equals(name.toUpperCase())) {
                            element.setNameHasQuotes(true);
                        }
                        element.setDesign(type.getDesign());
                        type.add(element);
                    }
                    this.initDatatype(datatype, element);
                    element.updateReferenceNew();
                    TypeElementProxyOraclev10g typeElementProxy = (TypeElementProxyOraclev10g)this.storageDesign.getProxy(element);
                    if (typeElementProxy == null) continue;
                    typeElementProxy.setSqlJAttr(sqljAttr);
                }
            }
            if (!methods.equals("")) {
                while (Token.hasToken(methods, "MEMBER") || Token.hasToken(methods, "STATIC") || Token.hasToken(methods, "CONSTRUCTOR") || Token.hasToken(methods, "PROCEDURE") || Token.hasToken(methods, "FUNCTION")) {
                    methods = this.initMethod(type, methods.trim(), match);
                }
            }
            boolean continueCheck = true;
            while (continueCheck) {
                boolean valueToStore = true;
                if (afterElementList.startsWith("NOT")) {
                    valueToStore = false;
                    afterElementList = Token.cutFirstToken2(afterElementList);
                }
                if (afterElementList.startsWith("FINAL")) {
                    type.setFinal(valueToStore);
                    afterElementList = Token.cutFirstToken2(afterElementList);
                    continue;
                }
                if (afterElementList.startsWith("INSTANTIABLE")) {
                    type.setInstantiable(valueToStore);
                    afterElementList = Token.cutFirstToken2(afterElementList);
                    continue;
                }
                continueCheck = false;
            }
        }
    }
}

