/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHColumnElementsOraclev10g;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class DomainHandlerReadDDLOraclev10g
implements StatementsConstants,
SectionConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;

    public DomainHandlerReadDDLOraclev10g(Design design) {
        this.design = design;
    }

    public void createDomains(LinkedList statements, RDBMSType dbType) {
        Iterator itStat = statements.iterator();
        while (itStat.hasNext()) {
            String statement = DDLStatementHandler.clearCR((String)itStat.next());
            if (!Token.startsWithString(statement, "CREATE TABLE") && !Token.startsWithString(statement, "CREATE GLOBAL TEMPORARY TABLE") && !Token.startsWithString(statement, "CREATE BLOCKCHAIN TABLE") && (!Token.startsWithString(statement, "ALTER TABLE") || statement.toUpperCase().indexOf(" ADD (") <= -1 && statement.toUpperCase().indexOf(" MODIFY (") <= -1)) continue;
            ArrayList columns = this.getColumns(statement);
            for (String oneColumn : columns) {
                this.createOneDomain(oneColumn, dbType);
            }
        }
    }

    private ArrayList getColumns(String statement) {
        ArrayList<String> tableColumns = new ArrayList<String>();
        String columnStatement = Token.getValBetweenBrackets(statement, 1);
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracket(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracket(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString();
                }
            }
            tableColumns.add(oneColumn.trim());
        }
        return tableColumns;
    }

    private void createOneDomain(String statement, RDBMSType dbType) {
        SHColumnElementsOraclev10g columnElements = new SHColumnElementsOraclev10g();
        Map elements = columnElements.getElementsColumn(statement, dbType);
        String columnName = (String)elements.get("columnname");
        if (!"".equalsIgnoreCase(columnName)) {
            String datatype = (String)elements.get("datatype");
            String[] parameters = new String[]{(String)elements.get("precision"), (String)elements.get("scale"), (String)elements.get("size")};
            if (datatype != null) {
                String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                nameDatatype = StandardDatatypeNames.getTransformedDatatypeName(nameDatatype, dbType);
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbType, nameDatatype);
                this.factory.getInstance(this.design, logicalDT, null, 2, parameters, null);
            }
        }
    }
}

