/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateUserOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateUserOracle.class);

    public SHCreateUserOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateUserOracle.clearCR(line);
        if (Token.startsWithString(statement, "CREATE USER")) {
            try {
                this.parseUser(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateUserOracle.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseUser(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        boolean userExists = false;
        if (stoDesign != null) {
            UserOracle user2;
            String name = Token.getQuotedNameAfterToken(this.statement, "USER").trim();
            for (UserOracle user2 : stoDesign.getUserSet()) {
                if (!user2.getName().equals(name)) continue;
                userExists = true;
                break;
            }
            if (!userExists && (user2 = stoDesign.getUserSet().createUser()) != null) {
                this.initName(user2);
                this.initIdentified(user2);
                this.initDefTableSpace(user2, stoDesign);
                this.initTempTableSpace(user2, stoDesign);
                this.initQuotaItems(user2, stoDesign);
                this.initProfile(user2);
                this.initPasswordExpire(user2);
                this.initAccountLock(user2);
                this.initSchemaObject(user2);
                this.design.getRelationalDesign().stampModelObjectDDL(user2);
            }
        }
    }

    private void initName(UserOracle user) {
        String name = Token.getQuotedNameAfterToken(this.statement, "USER").trim();
        user.setName(name);
    }

    private void initIdentified(UserOracle user) {
        if (Token.hasToken(this.statement, "IDENTIFIED")) {
            String str = Token.getTokenAfter(this.statement, "IDENTIFIED").trim();
            if ("BY".equalsIgnoreCase(str)) {
                Object pass = Token.getTokenAfter(this.statement, "BY").trim();
                if ("VALUES".equalsIgnoreCase((String)pass)) {
                    String pass2 = Token.getNameAfterToken(this.statement, "VALUES", '\'', '\'').trim();
                    pass = (String)pass + " '" + pass2 + "'";
                }
                user.setAuthType(UserOracle.getAuthTypes()[0]);
                user.encodeIdentifier((String)pass);
            } else if ("GLOBALLY".equalsIgnoreCase(str)) {
                String identifier = Token.getNameAfterToken(this.statement, "AS", '\'', '\'').trim();
                user.setAuthType(UserOracle.getAuthTypes()[2]);
                user.encodeIdentifier("'" + identifier + "'");
            } else {
                user.setAuthType(UserOracle.getAuthTypes()[1]);
            }
        }
    }

    private void initDefTableSpace(UserOracle user, StorageDesignOracle stoDesign) {
        String line;
        if (Token.hasToken(this.statement, "DEFAULT") && Token.getFirstToken(line = Token.getStringAfter(this.statement, "DEFAULT")).equalsIgnoreCase("TABLESPACE")) {
            String tsName = Token.getQuotedNameAfterToken(line, "TABLESPACE");
            TableSpaceOracle ts = (TableSpaceOracle)stoDesign.getTableSpaceSet().getByName(tsName);
            if (ts == null && tsName.length() > 0 && !"SYSTEM".equalsIgnoreCase(tsName)) {
                ts = stoDesign.getTableSpaceSet().createTableSpace();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
            user.setDefTableSpace(ts);
        }
    }

    private void initTempTableSpace(UserOracle user, StorageDesignOracle stoDesign) {
        String line;
        if (Token.hasToken(this.statement, "TEMPORARY") && Token.getFirstToken(line = Token.getStringAfter(this.statement, "TEMPORARY")).equalsIgnoreCase("TABLESPACE")) {
            line = Token.cutFirstToken(line);
            String tsName = Token.getFirstToken(line).trim();
            tsName = Token.getName(tsName);
            TemporaryTablespaceOracle ts = (TemporaryTablespaceOracle)stoDesign.getTemporaryTablespaceSet().getByName(tsName);
            if (ts != null) {
                user.setTempTableSpace(ts);
            }
        }
    }

    private void initQuotaItems(UserOracle user, StorageDesignOracle stoDesign) {
        String line = this.statement;
        while (Token.hasToken(line, "QUOTA")) {
            line = Token.getStringAfter(line, "QUOTA");
            QuotaItemOracle quotaItem = stoDesign.getQuotaItemSet().createQuotaItem();
            quotaItem.setUser(user);
            quotaItem.setSize(Token.getStringBeforeToken(line, "ON"));
            String tsName = Token.getQuotedNameAfterToken(line, "ON");
            TableSpaceOracle ts = (TableSpaceOracle)stoDesign.getTableSpaceSet().getByName(tsName);
            if (ts == null && tsName.length() > 0 && !"SYSTEM".equalsIgnoreCase(tsName)) {
                ts = stoDesign.getTableSpaceSet().createTableSpace();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
            quotaItem.setTableSpace(ts);
            line = Token.getStringAfter(line, tsName);
        }
    }

    private void initProfile(UserOracle user) {
        if (Token.hasToken(this.statement, "PROFILE")) {
            String profile = Token.getTokenAfter(this.statement, "PROFILE").trim();
            user.setProfile(profile);
        }
    }

    private void initPasswordExpire(UserOracle user) {
        if (Token.hasToken(this.statement, "EXPIRE")) {
            user.setPasswordExpire("YES");
        } else {
            user.setPasswordExpire("NO");
        }
    }

    private void initAccountLock(UserOracle user) {
        if (Token.hasToken(this.statement, "ACCOUNT")) {
            String account = Token.getTokenAfter(this.statement, "ACCOUNT").trim();
            if ("LOCK".equalsIgnoreCase(account)) {
                user.setAccountLock("YES");
            } else {
                user.setAccountLock("NO");
            }
        }
    }

    private void initSchemaObject(UserOracle user) {
        SchemaObject so;
        boolean soExists = false;
        SchemaObjectSet sos = this.design.getRelationalDesign().getSchemaObjectSet();
        Iterator it = sos.iterator();
        while (it.hasNext()) {
            so = (SchemaObject)it.next();
            if (!so.getName().equals(user.getName())) continue;
            user.setSchemaObject(so);
            soExists = true;
            break;
        }
        if (!soExists) {
            so = sos.createSchemaObject(null);
            so.setName(user.getName());
            user.setSchemaObject(so);
            this.design.getRelationalDesign().stampModelObjectDDL(so);
        }
    }
}

