/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTriggerOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTriggerOracle.class);
    private TriggerOracle trigger;
    private StorageDesignOracle storageDesign;
    private String body = "";

    public SHCreateTriggerOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        boolean canHandle = false;
        String statement = SHCreateTriggerOracle.clearCR(line);
        if (Token.getFirstToken(statement).equalsIgnoreCase("CREATE")) {
            String firstToken;
            String restOfText = Token.cutTokenFromFront(statement, "CREATE");
            if (Token.startsWithString(restOfText, "OR REPLACE")) {
                restOfText = Token.cutTokenFromFront(restOfText, "OR REPLACE");
            }
            if ((firstToken = Token.getFirstToken(restOfText)).equalsIgnoreCase("EDITIONABLE") || firstToken.equalsIgnoreCase("NONEDITIONABLE")) {
                restOfText = Token.cutTokenFromFront(restOfText, firstToken);
            }
            if (Token.getFirstToken(restOfText).equalsIgnoreCase("TRIGGER")) {
                canHandle = true;
            }
        }
        if (canHandle) {
            this.parseTrigger(statement, line);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseTrigger(String statement, String line) {
        String fullStatement = statement;
        try {
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
            if (this.storageDesign != null) {
                this.trigger = this.storageDesign.getTriggerSet().createTrigger();
                if (this.trigger != null) {
                    statement = this.initTriggerName(statement);
                    this.initTriggeringTime(statement);
                    String afterTableOrView = this.initOnTable(statement, line);
                    this.initAction(statement);
                    statement = this.initReferencing(afterTableOrView);
                    statement = this.initScope(statement);
                    this.initCrossEdition(statement);
                    this.initState(statement);
                    this.initCondition(statement);
                    this.initBody();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.trigger);
                    this.checkAutoIncTrigger();
                    this.body = "";
                    this.trigger = null;
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + fullStatement + " for Oracle failed", e);
            this.importLog.addError("Parsing " + fullStatement + " for Oracle failed");
            this.importLog.addFailedStatement(SHCreateTriggerOracle.FormatCR(line, "\n"));
        }
    }

    private String initTriggerName(String statement) {
        boolean success;
        UserOracle owner = null;
        String str = Token.getStringAfterToken(statement, "TRIGGER");
        String name = Token.getFirstName(str, '\"', '\"');
        int dotIndex = name.indexOf(46);
        if (dotIndex > -1) {
            String ownerName = name.substring(0, dotIndex);
            owner = (UserOracle)this.storageDesign.getUserSet().getByName(ownerName);
            if (owner == null) {
                owner = this.storageDesign.getUserSet().createUser();
                owner.setName(ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            this.trigger.setOwner(owner);
            name = name.substring(dotIndex + 1);
        }
        if (!(success = this.trigger.setName(name))) {
            for (TriggerOracle trig : this.storageDesign.getTriggerSet()) {
                if (!trig.getName().equals(name) || trig.getOwner() != owner) continue;
                trig.remove();
                this.trigger.setName(name);
                break;
            }
        }
        if (dotIndex > -1) {
            str = str.substring(str.indexOf(46) + 1);
        }
        if ((str = str.substring(str.indexOf(name) + name.length())).startsWith("\"")) {
            str = str.substring(1);
            if (!name.equals(name.toUpperCase())) {
                this.trigger.setNameHasQuotes(true);
            }
        }
        return str.trim();
    }

    private void initTriggeringTime(String statement) {
        String triggerTime = Token.getFirstToken(statement);
        if (triggerTime.equalsIgnoreCase("BEFORE")) {
            this.trigger.setTriggerTime("BEFORE");
        } else if (triggerTime.equalsIgnoreCase("AFTER")) {
            this.trigger.setTriggerTime("AFTER");
        } else if (triggerTime.equalsIgnoreCase("INSTEAD")) {
            this.trigger.setTriggerTime("INSTEAD OF");
        } else if (triggerTime.equalsIgnoreCase("FOR")) {
            this.trigger.setTriggerTime("COMPOUND");
        } else {
            this.importLog.addError("Unknown triggering time for trigger " + this.trigger.getName());
        }
    }

    private void initAction(String statement) {
        String trTime = this.trigger.getTriggerTime();
        if (trTime != null) {
            String str;
            String actions;
            if (trTime.equals("COMPOUND")) {
                trTime = "FOR";
            }
            if (Token.hasToken(actions = Token.getStringBeforeToken(str = Token.getStringAfter(statement, trTime), "ON"), "INSERT")) {
                this.trigger.setActions("INSERT");
            }
            if (Token.hasToken(actions, "DELETE")) {
                this.trigger.setActions("DELETE");
            }
            if (Token.hasToken(actions, "UPDATE")) {
                this.trigger.setActions("UPDATE");
                String afterUpdate = Token.getStringAfterToken(actions, "UPDATE");
                if (Token.getFirstToken(afterUpdate).equalsIgnoreCase("OF")) {
                    String columnList = Token.cutTokenFromFront(afterUpdate, "OF");
                    TableProxyOracle table = this.trigger.getTable();
                    if (table != null) {
                        String[] cols = columnList.split(",");
                        for (int i = 0; i < cols.length; ++i) {
                            String columnName = Token.getFirstName(cols[i], '\"', '\"');
                            ColumnProxy cp = table.getColumnProxyByName(columnName);
                            if (cp == null) continue;
                            this.trigger.setColumns(cp.getObjectID());
                        }
                    }
                }
            }
        }
    }

    private String initOnTable(String statement, String rawText) throws ParseException {
        String str = Token.getStringAfterToken(statement, "ON");
        boolean onNestedTable = str.toUpperCase().startsWith("NESTED TABLE");
        if (onNestedTable) {
            str = Token.getStringAfterToken(str, "OF");
        }
        String tableName = Token.getFirstName(str, '\"', '\"');
        String schemaName = "";
        int dotIndex = tableName.indexOf(46);
        if (dotIndex > -1) {
            schemaName = tableName.substring(0, dotIndex);
            tableName = tableName.substring(dotIndex + 1);
        }
        Table table = null;
        TableView tableView = null;
        if (schemaName != "") {
            if (!onNestedTable) {
                table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(schemaName, tableName);
            }
            if (table == null) {
                tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(schemaName, tableName);
            }
        }
        if (table == null && tableView == null) {
            if (!onNestedTable) {
                table = (Table)this.design.getRelationalDesign().getTableSet().getByName(tableName);
            }
            if (table == null) {
                tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(tableName);
            }
        }
        if (table != null) {
            this.trigger.setTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID()));
        } else if (tableView != null) {
            this.trigger.setView((TableViewProxyOracle)this.storageDesign.getTableViewProxySet().getProxy(tableView.getObjectID()));
        } else {
            String message = "Specified table or view on trigger " + this.trigger.getName() + " does not exist ";
            if (onNestedTable) {
                message = "Specified view on trigger " + this.trigger.getName() + " does not exist ";
            }
            this.importLog.addError(message);
            throw new ParseException(message);
        }
        rawText = Token.getStringAfter(rawText, "TRIGGER");
        String trTime = this.trigger.getTriggerTime();
        if (trTime != null) {
            if (trTime.equals("INSTEAD OF")) {
                trTime = "INSTEAD";
            } else if (trTime.equals("COMPOUND")) {
                trTime = "FOR";
            }
            rawText = Token.getStringAfter(rawText, trTime);
        }
        rawText = Token.getStringAfter(rawText, "ON");
        if (onNestedTable) {
            rawText = Token.getStringAfter(rawText, "OF");
        }
        if (dotIndex > -1) {
            rawText = rawText.substring(rawText.indexOf(46) + 1);
        }
        if ((rawText = rawText.substring(rawText.indexOf(tableName) + tableName.length())).startsWith("\"")) {
            rawText = rawText.substring(1);
        }
        this.body = rawText.trim();
        if (dotIndex > -1) {
            str = str.substring(str.indexOf(46) + 1);
        }
        if ((str = str.substring(str.indexOf(tableName) + tableName.length())).startsWith("\"")) {
            str = str.substring(1);
        }
        return str.trim();
    }

    private String initReferencing(String statement) {
        if (Token.hasToken(statement, "REFERENCING")) {
            String refer = Token.getStringAfter(statement, "REFERENCING");
            while (true) {
                statement = refer;
                String option = Token.getFirstToken(refer);
                String value = Token.getFirstToken(refer = Token.cutTokenFromFront(refer, option));
                boolean hasAs = value.equalsIgnoreCase("AS");
                if (hasAs) {
                    refer = Token.cutTokenFromFront(refer, "AS");
                    value = Token.getFirstToken(refer);
                }
                if (value.equals("")) break;
                refer = Token.cutTokenFromFront(refer, value);
                if (option.equalsIgnoreCase("OLD")) {
                    this.trigger.setRef_OLD_AS(value);
                } else if (option.equalsIgnoreCase("NEW")) {
                    this.trigger.setRef_NEW_AS(value);
                } else {
                    if (!option.equalsIgnoreCase("PARENT")) break;
                    this.trigger.setRef_PARENT_AS(value);
                }
                this.body = Token.getStringAfter(this.body, option);
                if (hasAs) {
                    this.body = Token.getStringAfter(this.body, "AS");
                }
                this.body = Token.getStringAfter(this.body, value);
            }
        }
        return statement;
    }

    private String initScope(String statement) {
        String str = statement;
        if (Token.getFirstToken(str).equalsIgnoreCase("FOR") && Token.getFirstToken(str = Token.cutTokenFromFront(str, "FOR")).equalsIgnoreCase("EACH") && Token.getFirstToken(str = Token.cutTokenFromFront(str, "EACH")).equalsIgnoreCase("ROW")) {
            str = Token.cutTokenFromFront(str, "ROW");
            this.trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
            this.body = Token.getStringAfter(this.body, "ROW");
            return str;
        }
        this.trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
        return statement;
    }

    private void initCrossEdition(String statement) {
        if (Token.hasToken(statement, "CROSSEDITION")) {
            if (Token.getStringBeforeToken(statement, "CROSSEDITION").toUpperCase().endsWith("REVERSE")) {
                this.trigger.setCrossEdition("REVERSE");
            } else {
                this.trigger.setCrossEdition("FORWARD");
            }
            this.body = Token.getStringAfter(this.body, "CROSSEDITION");
        }
    }

    private void initState(String statement) {
        if (Token.hasToken(statement, "DISABLE")) {
            this.trigger.setState("DISABLE");
            this.body = Token.getStringAfter(this.body, "DISABLE");
        } else if (Token.hasToken(statement, "ENABLE")) {
            this.trigger.setState("ENABLE");
            this.body = Token.getStringAfter(this.body, "ENABLE");
        }
    }

    private void initCondition(String statement) {
        String afterWhen;
        String beforeBegin = Token.getStringBeforeToken(statement, "BEGIN");
        if (beforeBegin.isEmpty()) {
            beforeBegin = statement;
        }
        if ((afterWhen = Token.getStringAfter(beforeBegin, "WHEN")).startsWith("(")) {
            this.trigger.setCondition(Token.getValBetweenBrackets(afterWhen, 1).trim());
            this.body = Token.getStringAfter(this.body, "WHEN");
            this.body = Token.getValAfterBrackets(this.body, 1).trim();
        }
    }

    private void initBody() {
        this.trigger.setBody(this.body);
    }

    private void checkAutoIncTrigger() {
        TriggerOracle.AutoIncDetails autoIncDetails = this.trigger.checkAutoIncTrigger();
        if (autoIncDetails != null) {
            Column column = null;
            Table table = null;
            TableProxyOracle tableProxy = this.trigger.getTable();
            if (tableProxy != null && (table = (Table)tableProxy.getObject()) != null) {
                column = (Column)table.getElementByName(autoIncDetails.getColumnName());
            }
            if (column != null) {
                TableProxy syncTableProxy;
                RDBMSSite rdbmsSite;
                StorageDesign syncSD;
                String sequenceLongName;
                String autoIncSequenceName = autoIncDetails.getSequenceName();
                String sequenceName = sequenceLongName = Token.removeQuotes(autoIncSequenceName);
                String sequenceUser = null;
                int dotIndex = sequenceLongName.indexOf(46);
                if (dotIndex > -1) {
                    sequenceUser = Token.removeQuotes(sequenceLongName.substring(0, dotIndex));
                    sequenceName = sequenceLongName.substring(dotIndex + 1);
                }
                column.setAutoIncrementColumn(true);
                column.setAutoIncrementSequenceName(sequenceName);
                column.setAutoIncrementTriggerName(this.trigger.getName());
                ColumnProxyOracle columnProxy = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
                if (columnProxy != null) {
                    UserOracle triggerOwner;
                    columnProxy.setAutoIncrementDDL("TRIGGER");
                    if (sequenceUser == null && (triggerOwner = this.trigger.getOwner()) != null) {
                        sequenceUser = triggerOwner.getName();
                    }
                    if (sequenceUser != null && !sequenceUser.equalsIgnoreCase(table.getSchema())) {
                        UserOracle user = (UserOracle)this.storageDesign.getUserSet().getByName(sequenceUser);
                        columnProxy.setAutoIncrementUser(user);
                    }
                }
                boolean triggerInModel = false;
                RelationalDesign syncModel = table.getRelationalModel().getRelatedSyncModel();
                if (syncModel != null && (syncSD = syncModel.getStorageDesign(rdbmsSite = this.storageDesign.getRDBMSSite())) != null && (syncTableProxy = syncSD.getTableProxyBySchemaAndName(table.getSchema(), table.getName())) != null && syncTableProxy.getTriggers().getByName(this.trigger.getName()) != null) {
                    triggerInModel = true;
                }
                if (!triggerInModel) {
                    this.trigger.remove();
                }
            }
        }
    }
}

