/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DDLFilesInDirectoryCollector {
    public static boolean accept(File file) {
        String fn = file.getName().toLowerCase();
        return fn.endsWith(".ddl") || fn.endsWith(".pls") || fn.endsWith(".plb") || fn.endsWith(".sql") || fn.endsWith(".pks");
    }

    public static List<File> getSQLFiles(File rootDir) {
        ArrayList<File> files = new ArrayList<File>();
        DDLFilesInDirectoryCollector.scanForFiles(rootDir, files);
        return files;
    }

    public static void scanForFiles(File rootDir, List<File> files) {
        if (rootDir.isDirectory()) {
            for (File file : rootDir.listFiles()) {
                DDLFilesInDirectoryCollector.scanForFiles(file, files);
            }
        } else if (DDLFilesInDirectoryCollector.accept(rootDir)) {
            files.add(rootDir);
        }
    }

    public static void main(String[] args) {
        File file = new File("D:\\tmp5\\sql3\\Relational_1_20200217_141937");
        for (File f : DDLFilesInDirectoryCollector.getSQLFiles(file)) {
            System.out.println(f.getAbsolutePath());
        }
    }
}

