/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.cwddesigner.CWDDesignObj;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDPrefixObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.cwddesign.DesignHandler;
import oracle.dbtools.crest.model.design.compare.cwddesign.MergingCWDDesigns;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.cwddesign.CompareCWDDesignsDialog;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class CWDExtractionController {
    private static final Logger LOGGER = new Logger(CWDExtractionController.class);
    private ApplicationView view;
    private Design tempDesign;
    private Design design;
    private CWDPrefixObject prefix;
    private ProgressDialog monitor;
    private DesignHandler designHandler;

    public CWDExtractionController(ApplicationView view) {
        this.view = view;
        this.design = view.getCurrentDesign();
    }

    public CWDExtractionHandler getExtractionHandler() {
        return CWDExtractionHandler.getInstance(this.view, this.getOldDesign());
    }

    public void initDesignHandler(List lsModels, List lsSubViews) {
        this.designHandler = new DesignHandler(this.getTempDesign(), this.getOldDesign());
        for (CWDDesignObj obj : lsModels) {
            if (!obj.isSelected()) continue;
            if (obj.getModel() instanceof RelationalDesign) {
                if (obj.getImportTo() instanceof RelationalDesign) {
                    this.designHandler.addRelationalModelMap((RelationalDesign)obj.getModel(), (RelationalDesign)obj.getImportTo());
                    continue;
                }
                this.designHandler.addNewRelational((RelationalDesign)obj.getModel());
                continue;
            }
            if (!(obj.getModel() instanceof LogicalDesign)) continue;
            this.designHandler.setLogicalIsSelected(true);
        }
        for (CWDDesignObj obj : lsSubViews) {
            if (!obj.isSelected()) continue;
            this.designHandler.addSubView((DesignPartViewPlaceHolder)obj.getObject());
        }
    }

    public void insertDesign() {
        new Thread(new Runner2()).start();
    }

    public void insertDesign(List list) {
        new Thread(new Runner(list)).start();
    }

    private void resetAutoRoute(DesignPartView dpv) {
        if (dpv.isAutoRoute()) {
            dpv.getWorkSpace().updateSettings();
        }
    }

    public void showRelationalSubViews() {
        for (RelationalDesign pDesign : this.design.getRelationalDesigns()) {
            if (!pDesign.isLoaded()) continue;
            pDesign.setMainViewVisible(true);
            this.resetAutoRoute(pDesign.getMainView());
            Iterator itsv = pDesign.getDesignSubviews().iterator();
            while (itsv.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)itsv.next();
                if (!ph.getDesignPartView().mustBeVisible()) continue;
                ph.setVisible(true);
                this.resetAutoRoute(ph.getDesignPartView());
            }
        }
    }

    public Design getOldDesign() {
        return this.design;
    }

    public ApplicationView getApplicationView() {
        return this.view;
    }

    public void setApplicationView(ApplicationView view) {
        this.view = view;
    }

    public List loadDesign(List lsModels) throws Exception {
        this.getExtractionHandler().clearCWDHObjects();
        return this.getExtractionHandler().getODObjects(lsModels);
    }

    public void loadTempDesign(File importFile) throws Exception {
        String ext = ".dmd";
        String designPath = importFile.getParentFile().getAbsolutePath();
        String fileName = importFile.getName();
        int pos = fileName.lastIndexOf(".");
        if (pos > -1) {
            ext = fileName.substring(pos);
        }
        String choice = FileUtils.removeExt(importFile.getName());
        ApplicationView view = this.getApplicationView();
        this.tempDesign = new Design(view, view.getCurrentDesign());
        this.tempDesign.setOldRepositoryType(".xml".equalsIgnoreCase(ext));
        this.tempDesign.setCompressedDesign(".dmdz".equalsIgnoreCase(ext));
        this.tempDesign.setFileName(choice);
        this.tempDesign.setDesignPath(designPath);
        ProgressDialog monitor = null;
        this.tempDesign.getBusinessInfoDesign().setLoaded(false);
        this.tempDesign.getLogicalDesign().setLoaded(false);
        view.setCurrentDesign(this.tempDesign);
        view.setDesignName(String.valueOf(choice));
        view.getPersistenceManager().setAppView(view);
        if (this.tempDesign.isOldRepositoryType()) {
            view.getPersistenceManager().read((Object)choice, this.tempDesign, monitor);
            view.getPersistenceManager().readSystemInit(this.tempDesign);
            this.tempDesign.loadDomainFiles();
            this.tempDesign.loadRDBMSSites();
        } else {
            view.getXMLTransformationManager().openDesign(this.tempDesign, importFile);
            view.getPersistenceManager().readSystemInit(this.tempDesign);
            view.getXMLTransformationManager().loadDomains(this.tempDesign);
        }
    }

    public List getDPObject() {
        ArrayList<CWDDesignObj> list = new ArrayList<CWDDesignObj>();
        LogicalDesign logical = this.tempDesign.getLogicalDesign();
        CWDDesignObj obj = new CWDDesignObj(false, logical, this.getOldDesign().getLogicalDesign(), "Logical Model");
        list.add(obj);
        for (int i = 0; i < this.tempDesign.getRelationalDesigns().size(); ++i) {
            RelationalDesign physical = (RelationalDesign)this.tempDesign.getRelationalDesigns().getElement(i);
            obj = new CWDDesignObj(false, physical, "New Relational", "Relational Model");
            list.add(obj);
        }
        return list;
    }

    public void removeTempDesign() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CWDExtractionController.this.tempDesign = null;
                CWDExtractionController.this.getApplicationView().setCurrentDesign(CWDExtractionController.this.design);
                System.gc();
            }
        });
        thread.start();
    }

    public Design getTempDesign() {
        return this.tempDesign;
    }

    public void setTempDesign(Design tempDesign) {
        this.tempDesign = tempDesign;
    }

    public CWDPrefixObject getPrefix() {
        if (this.prefix == null) {
            this.prefix = new CWDPrefixObject();
            this.prefix.setForEntity(this.view.getSettings().getEntityPrefix());
            this.prefix.setForTable(this.view.getSettings().getTablePrefix());
            this.prefix.setForView(this.view.getSettings().getTableViewPrefix());
        }
        return this.prefix;
    }

    public void setPrefix(CWDPrefixObject prefix) {
        if (prefix != null) {
            this.view.getSettings().setEntityPrefix(prefix.getForEntity());
            this.view.getSettings().setTablePrefix(prefix.getForTable());
            this.view.getSettings().setTableViewPrefix(prefix.getForView());
        }
    }

    public String getCustomPrefix() {
        return this.view.getSettings().getCustomPrefix();
    }

    public void setCustomPrefix(String customPrefix) {
        this.view.getSettings().setCustomPrefix(customPrefix);
    }

    private void importRDBMSSites(Design dsn) {
        String designName = dsn.getName();
        StringBuffer buffer = new StringBuffer();
        buffer.append(designName).append("_RDBMSSites");
        String fileName = buffer.toString();
        RDBMSSiteSet rdbmsSiteSet = (RDBMSSiteSet)dsn.getAppView().getPersistenceManager().read((Object)fileName, dsn, false);
        Iterator it = rdbmsSiteSet.iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            this.getOldDesign().getRDBMSSiteSet().add(site);
        }
    }

    private class Runner2
    implements Runnable {
        private Runner2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CWDExtractionController.this.design.closeAllDiagrams();
                CWDExtractionController.this.design.setDisableTreeUpdate(true);
                try {
                    CWDExtractionController.this.monitor = new ProgressDialog(CWDExtractionController.this.view, "", 0, 100);
                    try {
                        CWDExtractionController.this.design.setPropagatePKChahges(false);
                        CWDExtractionController.this.design.setDisableTreeUpdate(true);
                        try {
                            CompareCWDDesignsDialog dialog;
                            RMDeletedMap dxmap;
                            RMExtendedMap rxmap;
                            RelationalDesign targetDes;
                            CWDExtractionController.this.monitor.setProgress(5);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.GenerateDesign"));
                            CWDExtractionController.this.getApplicationView().enableControls(false);
                            boolean result = false;
                            CWDExtractionController.this.designHandler.getModelsToDeleteOnCancel().clear();
                            for (RelationalDesign sourceDes : CWDExtractionController.this.designHandler.getNewRelationals()) {
                                targetDes = CWDExtractionController.this.designHandler.getTargetDesign().addRelationalDesign(sourceDes.getName());
                                CWDExtractionController.this.designHandler.addRelationalModelMap(sourceDes, targetDes);
                                if (!targetDes.isLoaded()) {
                                    if (targetDes.getDesign().isOldRepositoryType()) {
                                        targetDes.load();
                                    } else {
                                        CWDExtractionController.this.getApplicationView().getXMLTransformationManager().openDesignPart(targetDes);
                                        rxmap = targetDes.getRMExtendedMap();
                                        targetDes.getAppView().getXMLTransformationManager().transformFromXMLToObject(rxmap, new File(rxmap.getStorageName()), targetDes.getDesign().isCompressedDesign());
                                        dxmap = targetDes.getRMDeletedMap();
                                        targetDes.getAppView().getXMLTransformationManager().transformFromXMLToObject(dxmap, new File(dxmap.getStorageName()), targetDes.getDesign().isCompressedDesign());
                                    }
                                    targetDes.getDesign().getExtendedMap().distributenMappings(targetDes);
                                }
                                CWDExtractionController.this.designHandler.getModelsToDeleteOnCancel().add(targetDes);
                            }
                            for (String id : CWDExtractionController.this.designHandler.getTargetRelationalModels()) {
                                targetDes = (RelationalDesign)CWDExtractionController.this.designHandler.getTargetDesign().getRelationalDesigns().getById(id);
                                if (targetDes == null || targetDes.isLoaded()) continue;
                                if (targetDes.getDesign().isOldRepositoryType()) {
                                    targetDes.load();
                                } else {
                                    CWDExtractionController.this.getApplicationView().getXMLTransformationManager().openDesignPart(targetDes);
                                    rxmap = targetDes.getRMExtendedMap();
                                    targetDes.getAppView().getXMLTransformationManager().transformFromXMLToObject(rxmap, new File(rxmap.getStorageName()), targetDes.getDesign().isCompressedDesign());
                                    dxmap = targetDes.getRMDeletedMap();
                                    targetDes.getAppView().getXMLTransformationManager().transformFromXMLToObject(dxmap, new File(dxmap.getStorageName()), targetDes.getDesign().isCompressedDesign());
                                }
                                targetDes.getDesign().getExtendedMap().distributenMappings(targetDes);
                            }
                            if ((CWDExtractionController.this.designHandler.isLogicalIsSelected() || CWDExtractionController.this.designHandler.getSourceRelationalModels().size() > 0) && (result = (dialog = new CompareCWDDesignsDialog(CWDExtractionController.this.getApplicationView(), CWDExtractionController.this.designHandler, CWDExtractionController.this.monitor)).showDialog()) && dialog.getObjectsMap() != null && dialog.getComparatorsMap() != null) {
                                new MergingCWDDesigns().execute(CWDExtractionController.this.designHandler, dialog.getComparatorsMap(), dialog.getObjectsMap(), CWDExtractionController.this.monitor);
                            }
                            CWDExtractionController.this.getApplicationView().enableControls(true);
                            ApplicationView.loading = false;
                            CWDExtractionController.this.view.setCurrentDesign(CWDExtractionController.this.design);
                            CWDExtractionController.this.design.getLogicalDesign().setMainViewVisible(false);
                            for (int i = 0; i < CWDExtractionController.this.design.getRelationalDesigns().size(); ++i) {
                                RelationalDesign ph = (RelationalDesign)CWDExtractionController.this.design.getRelationalDesigns().getElement(i);
                                ph.setMainViewVisible(false);
                            }
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeTypes"));
                            CWDExtractionController.this.monitor.setProgress(90);
                            CWDExtractionController.this.importRDBMSSites(CWDExtractionController.this.tempDesign);
                            CWDExtractionController.this.design.setDirty(true);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.ClearTemporaryObjects"));
                            CWDExtractionController.this.monitor.setProgress(100);
                            CWDExtractionController.this.view.synchronizeTitle();
                        }
                        finally {
                            if (CWDExtractionController.this.design != null) {
                                CWDExtractionController.this.design.setPropagatePKChahges(true);
                                CWDExtractionController.this.design.setDisableTreeUpdate(false);
                            }
                        }
                    }
                    finally {
                        CWDExtractionController.this.getExtractionHandler().clearCWDHObjects();
                        try {
                            CWDExtractionController.this.tempDesign.clearAll(false);
                        }
                        catch (Exception e) {
                            Logger.error_("Import of DM design - Error wqhile clearing temp objects", e);
                        }
                        CWDExtractionController.this.monitor.close();
                        CWDExtractionController.this.view.clearTree();
                        System.gc();
                    }
                    CWDExtractionController.this.removeTempDesign();
                }
                catch (Throwable throwable) {
                    CWDExtractionController.this.removeTempDesign();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CWDExtractionController.this.design.getLogicalDesign().setMainViewVisible(true);
                            CWDExtractionController.this.resetAutoRoute(CWDExtractionController.this.design.getLogicalDesign().getMainView());
                            Iterator it = CWDExtractionController.this.design.getLogicalDesign().getDesignSubviews().iterator();
                            while (it.hasNext()) {
                                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
                                if (!ph.getDesignPartView().mustBeVisible()) continue;
                                ph.setVisible(true);
                                CWDExtractionController.this.resetAutoRoute(ph.getDesignPartView());
                            }
                            CWDExtractionController.this.showRelationalSubViews();
                            CWDExtractionController.this.design.setDisableTreeUpdate(false);
                            CWDExtractionController.this.view.centerDesign();
                            for (int i = 0; i < CWDExtractionController.this.design.getRelationalDesigns().size(); ++i) {
                                RelationalDesign ph = (RelationalDesign)CWDExtractionController.this.design.getRelationalDesigns().getElement(i);
                                if (ph.getTableSet().size() > 0) {
                                    CWDExtractionController.this.view.setCurrentDPV(ph.getMainView());
                                    break;
                                }
                                CWDExtractionController.this.view.setCurrentDPV(CWDExtractionController.this.design.getLogicalDesign().getMainView());
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception e) {
                CWDExtractionController.this.design.destroyAll(false);
                CWDExtractionController.this.design = null;
                LOGGER.error("Error Generate Design: " + CWDExtractionController.this.view.getDesignName(), e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CWDExtractionController.UnableToGenerateDesign"), Messages.getString("CWDExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }

    private class Runner
    implements Runnable {
        List selectedObjects;

        public Runner(List selectedObjects) {
            this.selectedObjects = selectedObjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CWDExtractionController.this.design.closeAllDiagrams();
                CWDExtractionController.this.design.setDisableTreeUpdate(true);
                ImportLogger importLog = new ImportLogger();
                try {
                    CWDExtractionController.this.monitor = new ProgressDialog(CWDExtractionController.this.view, "", 0, 100);
                    try {
                        CWDExtractionController.this.design.setPropagatePKChahges(false);
                        CWDExtractionController.this.design.setDisableTreeUpdate(true);
                        try {
                            CWDExtractionController.this.monitor.setProgress(5);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.GenerateDesign"));
                            CWDExtractionController.this.monitor.setProgress(10);
                            CWDExtractionController.this.getApplicationView().enableControls(false);
                            CWDExtractionController.this.importRDBMSSites(CWDExtractionController.this.tempDesign);
                            CWDExtractionController.this.getExtractionHandler().generateDesign(this.selectedObjects, importLog);
                            if (CWDExtractionController.this.design.getStorageDesign(CWDExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign) {
                                String msg = CWDExtractionController.this.design.getStorageDesign(CWDExtractionController.this.design.getSelectedRDBMSSite()).getName();
                                LOGGER.error("Error Generate Design: " + msg);
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CWDExtractionController.UnableToGenerateDesign"), msg, 0);
                            }
                            CWDExtractionController.this.design.fixGeneratorIds(CWDExtractionController.this.getTempDesign());
                            CWDExtractionController.this.getApplicationView().enableControls(true);
                            ApplicationView.loading = false;
                            CWDExtractionController.this.view.setCurrentDesign(CWDExtractionController.this.design);
                            CWDExtractionController.this.design.getLogicalDesign().setMainViewVisible(false);
                            for (int i = 0; i < CWDExtractionController.this.design.getRelationalDesigns().size(); ++i) {
                                RelationalDesign ph = (RelationalDesign)CWDExtractionController.this.design.getRelationalDesigns().getElement(i);
                                ph.setMainViewVisible(false);
                            }
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeTypes"));
                            CWDExtractionController.this.monitor.setProgress(80);
                            try {
                                CWDExtractionController.this.design.getDataTypesDesign().rearrangeTypes();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Types", e);
                            }
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeEntities"));
                            CWDExtractionController.this.monitor.setProgress(85);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeTables"));
                            CWDExtractionController.this.monitor.setProgress(90);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeViews"));
                            CWDExtractionController.this.monitor.setProgress(93);
                            CWDExtractionController.this.monitor.setProgress(95);
                            CWDExtractionController.this.design.setDirty(true);
                            CWDExtractionController.this.monitor.setProgress(100);
                            CWDExtractionController.this.view.synchronizeTitle();
                            System.gc();
                        }
                        finally {
                            CWDExtractionController.this.getExtractionHandler().clearCWDHObjects();
                            if (CWDExtractionController.this.design != null) {
                                CWDExtractionController.this.design.setPropagatePKChahges(true);
                                CWDExtractionController.this.design.setDisableTreeUpdate(false);
                            }
                        }
                    }
                    finally {
                        CWDExtractionController.this.tempDesign.clearAll(false);
                        CWDExtractionController.this.monitor.close();
                        CWDExtractionController.this.view.clearTree();
                    }
                    CWDExtractionController.this.removeTempDesign();
                }
                catch (Throwable throwable) {
                    CWDExtractionController.this.removeTempDesign();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CWDExtractionController.this.design.getLogicalDesign().setMainViewVisible(true);
                            CWDExtractionController.this.resetAutoRoute(CWDExtractionController.this.design.getLogicalDesign().getMainView());
                            Iterator it = CWDExtractionController.this.design.getLogicalDesign().getDesignSubviews().iterator();
                            while (it.hasNext()) {
                                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
                                if (!ph.getDesignPartView().mustBeVisible()) continue;
                                ph.setVisible(true);
                                CWDExtractionController.this.resetAutoRoute(ph.getDesignPartView());
                            }
                            CWDExtractionController.this.showRelationalSubViews();
                            CWDExtractionController.this.design.setDisableTreeUpdate(false);
                            CWDExtractionController.this.view.centerDesign();
                            for (int i = 0; i < CWDExtractionController.this.design.getRelationalDesigns().size(); ++i) {
                                RelationalDesign ph = (RelationalDesign)CWDExtractionController.this.design.getRelationalDesigns().getElement(i);
                                if (ph.getTableSet().size() > 0) {
                                    CWDExtractionController.this.view.setCurrentDPV(ph.getMainView());
                                    break;
                                }
                                CWDExtractionController.this.view.setCurrentDPV(CWDExtractionController.this.design.getLogicalDesign().getMainView());
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (CWDExtractionController.this.view.getSettings().showImportLog()) {
                    LogReport logPanel = new LogReport(CWDExtractionController.this.view);
                    logPanel.setLog(importLog.generateDDLReport(CWDExtractionController.this.view, this.selectedObjects.size()));
                    logPanel.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception e) {
                CWDExtractionController.this.design.destroyAll(false);
                CWDExtractionController.this.design = null;
                LOGGER.error("Error Generate Design: " + CWDExtractionController.this.view.getDesignName(), e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CWDExtractionController.UnableToGenerateDesign"), Messages.getString("CWDExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }
}

