/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cubeviews;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.cubeviews.CVConstants;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsImporter;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CubeViewsImporter_8_1
extends CubeViewsImporter
implements CVConstants {
    private ArrayList attributes = new ArrayList();
    private ArrayList measures = new ArrayList();
    private ArrayList hierarchies = new ArrayList();
    private ArrayList dimensions = new ArrayList();
    private ArrayList joins = new ArrayList();
    private ArrayList cubemodels = new ArrayList();
    private DomainFactory factory = new DomainFactory();
    private LogicalDatatypeFactory factoryLogical = new LogicalDatatypeFactory();
    static int COLUMN = 0;
    static int ATTRIBUTE = 1;
    static int MEASURE = 2;

    public CubeViewsImporter_8_1(Design design) {
        super(design);
    }

    @Override
    public void parseXMLDocument(Document doc) {
        Element root = doc.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("attribute");
        this.processAttributes(nodes);
        nodes = root.getElementsByTagName("measure");
        this.processMeasures(nodes);
        nodes = root.getElementsByTagName("join");
        this.processJoins(nodes);
        nodes = root.getElementsByTagName("facts");
        this.processFacts(nodes);
        nodes = root.getElementsByTagName("hierarchy");
        this.processHierarchies(nodes);
        nodes = root.getElementsByTagName("dimension");
        this.processDimensions(nodes);
        nodes = root.getElementsByTagName("cubeModel");
        this.processCubeModel(nodes);
    }

    public static Element getFirstChildByTagName(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !((Element)child).getTagName().equals(tagName)) continue;
            return (Element)child;
        }
        return null;
    }

    private void processAttributes(NodeList nodes) {
        this.attributes.clear();
        int count = nodes.getLength();
        EntitySet entSet = this.getDesign().getLogicalDesign().getEntitySet();
        for (int i = 0; i < count; ++i) {
            Element dtype;
            Attribute attribute;
            Element elem = (Element)nodes.item(i);
            String bname = elem.getAttribute("businessName");
            String name = elem.getAttribute("name");
            String schema = elem.getAttribute("schema");
            NodeList sqlExpr = elem.getElementsByTagName("sqlExpression");
            Element sqlexprElem = (Element)sqlExpr.item(0);
            String template = sqlexprElem.getAttribute("template");
            Element column = (Element)sqlexprElem.getElementsByTagName("column").item(0);
            String colName = column.getAttribute("name");
            String tableName = column.getAttribute("tableName");
            Entity ent = (Entity)entSet.getByName(tableName);
            if (ent == null) {
                ent = this.getDesign().getLogicalDesign().createEntity(tableName);
            }
            if ((attribute = (Attribute)ent.getElementByName(colName)) == null) {
                attribute = ent.createAttribute(colName);
            }
            if (attribute.getLogicalDatatype().getName().equalsIgnoreCase("unknown") && template.equalsIgnoreCase("{$$1}") && (dtype = (Element)elem.getElementsByTagName("datatype").item(0)) != null) {
                String dtName = dtype.getAttribute("name");
                String dtLength = dtype.getAttribute("length");
                String dtScale = dtype.getAttribute("scale");
                String dtNullable = dtype.getAttribute("nullable");
                if (dtNullable.equalsIgnoreCase("no")) {
                    attribute.setNullsAllowed(false);
                } else {
                    attribute.setNullsAllowed(true);
                }
                Domain dom = this.createDomain(dtName, "DB2/UDB 8.1", dtLength, dtScale);
                attribute.setDomain(dom);
            }
            HelpNode hn = new HelpNode(name);
            hn.bName = bname;
            hn.colName = colName;
            hn.tableName = tableName;
            hn.schema = schema;
            hn.attribute = attribute;
            this.attributes.add(hn);
        }
    }

    private KeyObject getKey(Entity entity, List attributes) {
        ContainedObject[] attrs;
        KeyObject pkey = entity.getPK();
        if (pkey != null && (attrs = pkey.getElements()).length == attributes.size()) {
            int k = 0;
            for (int i = 0; i < attributes.size() && attrs[i] == attributes.get(i); ++i) {
                ++k;
            }
            if (k == attrs.length) {
                return pkey;
            }
        }
        KeyObject[] keys = entity.getKeys();
        for (int j = 0; j < keys.length; ++j) {
            ContainedObject[] attrs2;
            KeyObject key = keys[j];
            if (pkey == key || (attrs2 = key.getElements()).length != attributes.size()) continue;
            int k = 0;
            for (int i = 0; i < attributes.size() && attrs2[i] == attributes.get(i); ++i) {
                ++k;
            }
            if (k != attrs2.length) continue;
            return key;
        }
        return null;
    }

    private void processJoins(NodeList nodes) {
        this.joins.clear();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            int j;
            int rcount;
            Element elem = (Element)nodes.item(i);
            String bname = elem.getAttribute("businessName");
            String name = elem.getAttribute("name");
            String schema = elem.getAttribute("schema");
            String cardinality = elem.getAttribute("cardinality");
            String[] cards = cardinality.split(":");
            String lcard = cards[0];
            String rcard = cards[1];
            NodeList leftAttrs = elem.getElementsByTagName("leftAttributeRef");
            NodeList rightAttrs = elem.getElementsByTagName("rightAttributeRef");
            int lcount = leftAttrs.getLength();
            if (lcount != (rcount = rightAttrs.getLength()) || lcount <= 0) continue;
            Relation relation = null;
            HelpNode hn = new HelpNode(name);
            KeyObject lkey = null;
            KeyObject rkey = null;
            Entity lent = null;
            Entity rent = null;
            Element lelem = (Element)leftAttrs.item(0);
            Element relem = (Element)rightAttrs.item(0);
            Attribute lattr = this.findAttributeByName(lelem.getAttribute("name"));
            lent = (Entity)lattr.getContainer();
            Attribute rattr = this.findAttributeByName(relem.getAttribute("name"));
            rent = (Entity)rattr.getContainer();
            boolean rcreated = false;
            relation = this.getDesign().getLogicalDesign().getRelationSet().getRelationBetween(lent, rent);
            if (relation == null) {
                relation = this.getDesign().getLogicalDesign().createRelation();
                rcreated = true;
            }
            if (lcard.equalsIgnoreCase("n") && rcard.equalsIgnoreCase("1")) {
                hn.chEntity = lent;
                hn.parEntity = rent;
            }
            if (lcard.equalsIgnoreCase("1") && rcard.equalsIgnoreCase("n")) {
                hn.chEntity = rent;
                hn.parEntity = lent;
            }
            ArrayList<Attribute> lattrs = new ArrayList<Attribute>();
            ArrayList<Attribute> rattrs = new ArrayList<Attribute>();
            for (j = 0; j < lcount; ++j) {
                lelem = (Element)leftAttrs.item(j);
                relem = (Element)rightAttrs.item(j);
                lattr = this.findAttributeByName(lelem.getAttribute("name"));
                rattr = this.findAttributeByName(relem.getAttribute("name"));
                if (lattr != null) {
                    lattrs.add(lattr);
                }
                if (rattr == null) continue;
                rattrs.add(rattr);
            }
            if (lcard.equalsIgnoreCase("1") && (lkey = this.getKey(lent, lattrs)) == null) {
                lkey = lent.createCandidateKey();
            }
            if (rcard.equalsIgnoreCase("1") && (rkey = this.getKey(rent, rattrs)) == null) {
                rkey = rent.createCandidateKey();
            }
            for (j = 0; j < lcount; ++j) {
                rattr = (Attribute)rattrs.get(j);
                if (lcard.equalsIgnoreCase("1")) {
                    lkey.add(lattr);
                }
                if (rcard.equalsIgnoreCase("1")) {
                    rkey.add(rattr);
                }
                if (lcard.equalsIgnoreCase("n") && rcard.equalsIgnoreCase("1")) {
                    lattr.setReferedAttribute(rattr.getObjectID());
                    lattr.setGeneratorID(relation.getObjectID());
                }
                if (!lcard.equalsIgnoreCase("1") || !rcard.equalsIgnoreCase("n")) continue;
                rattr.setReferedAttribute(lattr.getObjectID());
                rattr.setGeneratorID(relation.getObjectID());
            }
            if (lcard.equalsIgnoreCase("1") && rcard.equalsIgnoreCase("n")) {
                lkey.setPK(true);
                lkey.setName(lkey.getContainerWithKeyObject().getName() + "_PK");
            }
            if (lcard.equalsIgnoreCase("n") && rcard.equalsIgnoreCase("1")) {
                rkey.setPK(true);
                rkey.setName(rkey.getContainerWithKeyObject().getName() + "_PK");
            }
            if (rcreated) {
                relation.setTargetEntity(rent);
                relation.setSourceEntity(lent);
                relation.setSourceTV((TVEntity)lent.getTopView());
                relation.setTargetTV((TVEntity)rent.getTopView());
                relation.setFireCardinalityChange(false);
                relation.setOptionalSource(false);
                relation.setOptionalTarget(false);
                if (lcard.equalsIgnoreCase("n")) {
                    relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[0]);
                } else {
                    relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
                }
                relation.setFireCardinalityChange(true);
                if (rcard.equalsIgnoreCase("n")) {
                    relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
                } else {
                    relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[1]);
                }
                ((TVRelation)relation.getTopView()).addConnection();
            }
            hn.bName = bname;
            hn.relation = relation;
            hn.schema = schema;
            this.joins.add(hn);
        }
    }

    private Attribute findAttributeByName(String name) {
        HelpNode hna = this.findNodeByName(this.attributes, name);
        if (hna != null) {
            Entity ent = (Entity)this.getDesign().getLogicalDesign().getEntitySet().getByName(hna.tableName);
            return (Attribute)ent.getElementByName(hna.colName);
        }
        return null;
    }

    private void processMeasures(NodeList nodes) {
        this.measures.clear();
        int count = nodes.getLength();
        EntitySet entSet = this.getDesign().getLogicalDesign().getEntitySet();
        for (int i = 0; i < count; ++i) {
            Element elem = (Element)nodes.item(i);
            String bname = elem.getAttribute("businessName");
            String name = elem.getAttribute("name");
            String schema = elem.getAttribute("schema");
            NodeList sqlExpr = elem.getElementsByTagName("sqlExpression");
            Element sqlexprElem = (Element)sqlExpr.item(0);
            List nameList = this.getNameList(sqlexprElem);
            String template = sqlexprElem.getAttribute("template");
            Element column = (Element)sqlexprElem.getElementsByTagName("column").item(0);
            String colName = "";
            String tableName = "";
            if (column != null) {
                colName = column.getAttribute("name");
                tableName = column.getAttribute("tableName");
                Entity ent = (Entity)entSet.getByName(tableName);
                if (ent == null) {
                    ent = this.getDesign().getLogicalDesign().createEntity(tableName);
                }
                if (colName != null) {
                    Element dtype;
                    Attribute attribute = (Attribute)ent.getElementByName(colName);
                    if (attribute == null) {
                        attribute = ent.createAttribute(colName);
                    }
                    if (attribute.getLogicalDatatype().getName().equalsIgnoreCase("unknown") && template.equalsIgnoreCase("{$$1}") && (dtype = (Element)elem.getElementsByTagName("datatype").item(0)) != null) {
                        String dtName = dtype.getAttribute("name");
                        String dtLength = dtype.getAttribute("length");
                        String dtScale = dtype.getAttribute("scale");
                        String dtNullable = dtype.getAttribute("nullable");
                        if (dtNullable.equalsIgnoreCase("no")) {
                            attribute.setNullsAllowed(false);
                        } else {
                            attribute.setNullsAllowed(true);
                        }
                        Domain dom = this.createDomain(dtName, "DB2/UDB 8.1", dtLength, dtScale);
                        attribute.setDomain(dom);
                    }
                }
            }
            HelpNode hn = new HelpNode(name);
            NodeList functions = elem.getElementsByTagName("aggregation");
            int fcount = functions.getLength();
            for (int p = 0; p < fcount; ++p) {
                Element funcElem = (Element)functions.item(p);
                String funcName = "";
                if (funcElem == null) continue;
                funcName = funcElem.getAttribute("function");
                hn.aggrFunctions.add(funcName);
            }
            hn.bName = bname;
            hn.colName = colName;
            hn.tableName = tableName;
            hn.schema = schema;
            hn.helpNode2List = nameList;
            hn.template = template;
            this.measures.add(hn);
        }
    }

    private List getNameList(Element sqlexprElem) {
        ArrayList<HelpNode2> names = new ArrayList<HelpNode2>();
        NodeList list = sqlexprElem.getChildNodes();
        int count = list.getLength();
        for (int i = 0; i < count; ++i) {
            HelpNode2 hn;
            String name;
            Node child = list.item(i);
            if (child.getNodeType() == 1 && ((Element)child).getTagName().equals("column")) {
                name = ((Element)child).getAttribute("name");
                hn = new HelpNode2(name, COLUMN);
                hn.tablename = ((Element)child).getAttribute("tableName");
                names.add(hn);
                continue;
            }
            if (child.getNodeType() != 1 || !((Element)child).getTagName().equals("measureRef")) continue;
            name = ((Element)child).getAttribute("name");
            hn = new HelpNode2(name, MEASURE);
            names.add(hn);
        }
        return names;
    }

    private void processFacts(NodeList nodes) {
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Entity ent;
            String entname;
            HelpNode hn;
            Element elem = (Element)nodes.item(i);
            String name = elem.getAttribute("name");
            Cube cube = this.getDesign().getMultidimensionalDesign().createCube();
            cube.setName(name);
            NodeList attrs = elem.getElementsByTagName("attributeRef");
            Element elat = (Element)attrs.item(0);
            if (elat != null && (hn = this.findNodeByName(this.attributes, entname = elat.getAttribute("name"))) != null && hn.tableName != null && (ent = (Entity)this.getDesign().getLogicalDesign().getEntitySet().getByName(hn.tableName)) != null) {
                cube.setFactEntity(ent);
            }
            NodeList meas = elem.getElementsByTagName("measureRef");
            int mcount = meas.getLength();
            for (int j = 0; j < mcount; ++j) {
                Element el = (Element)meas.item(j);
                String mname = el.getAttribute("name");
                HelpNode hn2 = this.findNodeByName(this.measures, mname);
                if (hn2 == null) continue;
                Measure measure = this.getDesign().getMultidimensionalDesign().createMeasure();
                measure.setName(hn2.name);
                this.addAggrFunctions(measure, hn2.aggrFunctions);
                cube.addMeasure(measure);
                this.processSQLExpr(measure, hn2.helpNode2List, hn2.template, cube.getFactEntity());
            }
        }
    }

    private void addAggrFunctions(Measure measure, List functions) {
        for (String fname : functions) {
            Measure.AggregateFunction af = measure.createAggregateFunction(fname);
            af.measureAlias = measure.getName();
            measure.getAggregateFunctions().add(af);
        }
        if (functions.size() > 0) {
            measure.setDefaultAggregationFunction((Measure.AggregateFunction)measure.getAggregateFunctions().get(0));
        }
    }

    private void processSQLExpr(Measure measure, List hn2List, String template, ContainerObject ent) {
        for (int i = 0; i < hn2List.size(); ++i) {
            HelpNode2 hn = (HelpNode2)hn2List.get(i);
            if (i == 0 && hn.type == COLUMN && hn2List.size() == 1) {
                ContainedObject attribute;
                if (ent != null && (attribute = ent.getElementByName(hn.name)) != null) {
                    measure.getAttributes().add(attribute);
                }
                return;
            }
            String search = "{$$" + Integer.toString(i + 1) + "}";
            String name = this.noBrackets(hn.name);
            template = this.replace(template, search, name);
        }
        measure.setFormula(true);
        measure.setFormula(template);
    }

    private String replace(String origin, String str1, String str2) {
        Object result = origin;
        int lstr1 = str1.length();
        int ind = ((String)result).indexOf(str1);
        while (ind > -1) {
            String tresult = ind == 0 ? "" : ((String)result).substring(0, ind);
            result = tresult + str2 + ((String)result).substring(ind + lstr1);
            ind = ((String)result).indexOf(str1);
        }
        return result;
    }

    private void processHierarchies(NodeList nodes) {
        this.hierarchies.clear();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Element elem = (Element)nodes.item(i);
            String bname = elem.getAttribute("businessName");
            String name = elem.getAttribute("name");
            String schema = elem.getAttribute("schema");
            NodeList attrs = elem.getElementsByTagName("attributeRelationshipRef");
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<Level> levels = new ArrayList<Level>();
            ArrayList<Link> links = new ArrayList<Link>();
            int cc = attrs.getLength();
            for (int k = cc - 1; k > -1; --k) {
                Element el = (Element)attrs.item(k);
                String relshname = el.getAttribute("name");
                list.add(relshname);
            }
            NodeList meas = elem.getElementsByTagName("attributeRef");
            int mcount = meas.getLength();
            Level lastLevel = null;
            for (int j = mcount - 1; j > -1; --j) {
                Element el = (Element)meas.item(j);
                String mname = el.getAttribute("name");
                HelpNode hn = this.findNodeByName(this.attributes, mname);
                if (hn == null) continue;
                Level level = (Level)this.getDesign().getMultidimensionalDesign().getLevelSet().getByName(hn.name);
                Entity ent = (Entity)this.getDesign().getLogicalDesign().getEntitySet().getByName(hn.tableName);
                if (level == null) {
                    level = this.getDesign().getMultidimensionalDesign().createLevel();
                    if (ent != null) {
                        level.setLevelEntity(ent);
                        Attribute attr = (Attribute)ent.getElementByName(mname);
                        level.addToLevelKey(attr);
                    }
                    level.setName(hn.name);
                }
                levels.add(level);
                for (String relsh : list) {
                    Attribute attr;
                    String[] rel = relsh.split("--");
                    if (rel.length <= 1 || !hn.name.equalsIgnoreCase(rel[0])) continue;
                    String atname = rel[1];
                    if (ent == null || (attr = (Attribute)ent.getElementByName(atname)) == null) continue;
                    level.addDescriptiveAttribute(new SlowChangingAttribute(level, attr));
                }
                if (lastLevel != null) {
                    Link link = lastLevel.getFirstLinkToTarget(level);
                    if (link == null) {
                        AbstractMDTV tv1 = (AbstractMDTV)lastLevel.getTopView();
                        AbstractMDTV tv2 = (AbstractMDTV)level.getTopView();
                        if (tv1 != null && tv2 != null) {
                            link = this.getDesign().getMultidimensionalDesign().createLink();
                            link.setSourceTV(tv1);
                            link.setTargetTV(tv2);
                            ((TVLink)link.getTopView()).addConnection();
                            links.add(link);
                        }
                    } else {
                        links.add(link);
                    }
                }
                lastLevel = level;
            }
            HelpNode hn = new HelpNode(name);
            hn.bName = bname;
            hn.levels = levels;
            hn.links = links;
            hn.schema = schema;
            this.hierarchies.add(hn);
        }
    }

    private void processDimensions(NodeList nodes) {
        this.dimensions.clear();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Element elem = (Element)nodes.item(i);
            String bname = elem.getAttribute("businessName");
            String name = elem.getAttribute("name");
            String schema = elem.getAttribute("schema");
            String type = elem.getAttribute("type");
            Dimension dim = this.getDesign().getMultidimensionalDesign().createDimension();
            dim.setName(name);
            if (type.equalsIgnoreCase("time")) {
                dim.setTimeDimension(true);
            }
            NodeList hiers = elem.getElementsByTagName("hierarchyRef");
            HelpNode hn = new HelpNode(name);
            hn.dimension = dim;
            int hcount = hiers.getLength();
            ArrayList<ArrayList> hlist = new ArrayList<ArrayList>();
            for (int j = 0; j < hcount; ++j) {
                Element helem = (Element)hiers.item(j);
                String hname = helem.getAttribute("name");
                HelpNode hnh = this.findNodeByName(this.hierarchies, hname);
                hlist.add(hnh.levels);
            }
            Level lowestLevel = this.findLowestLevel(hlist);
            Link link = dim.getFirstLinkToTarget(lowestLevel);
            if (link == null && lowestLevel != null) {
                AbstractMDTV tv1 = (AbstractMDTV)dim.getTopView();
                AbstractMDTV tv2 = (AbstractMDTV)lowestLevel.getTopView();
                if (tv1 != null && tv2 != null) {
                    link = this.getDesign().getMultidimensionalDesign().createLink();
                    link.setSourceTV(tv1);
                    link.setTargetTV(tv2);
                    ((TVLink)link.getTopView()).addConnection();
                }
            }
            for (int j = 0; j < hcount; ++j) {
                Link link2;
                Element helem = (Element)hiers.item(j);
                String hname = helem.getAttribute("name");
                HelpNode hnh = this.findNodeByName(this.hierarchies, hname);
                Level level = (Level)hnh.levels.get(0);
                if (level != lowestLevel && (link2 = lowestLevel.getFirstLinkToTarget(level)) == null) {
                    AbstractMDTV tv1 = (AbstractMDTV)lowestLevel.getTopView();
                    AbstractMDTV tv2 = (AbstractMDTV)level.getTopView();
                    if (tv1 != null && tv2 != null) {
                        link2 = this.getDesign().getMultidimensionalDesign().createLink();
                        link2.setSourceTV(tv1);
                        link2.setTargetTV(tv2);
                        ((TVLink)link2.getTopView()).addConnection();
                    }
                }
                NodeList joinlist = elem.getElementsByTagName("joinRef");
                int jcount = joinlist.getLength();
                for (int k = 0; k < jcount; ++k) {
                    Element jelem = (Element)joinlist.item(k);
                    String jname = jelem.getAttribute("name");
                    HelpNode hnj = this.findNodeByName(this.joins, jname);
                    if (hnj == null) continue;
                    for (Link nlink : hnh.links) {
                        Level sLevel = (Level)nlink.getSourceMDObject();
                        Level tLevel = (Level)nlink.getTargetMDObject();
                        if (sLevel.getLevelEntity() != hnj.chEntity || tLevel.getLevelEntity() != hnj.parEntity) continue;
                        List klist = tLevel.getLevelKey();
                        List dlist = tLevel.getDescriptiveAttributes();
                        for (int p = 0; p < klist.size(); ++p) {
                            dlist.add(p, klist.get(p));
                        }
                        klist.clear();
                        klist.addAll(hnj.parEntity.getPK().getElementsCollection());
                        List chpList = nlink.getRollupLink().getChildToParentAttributes();
                        chpList.clear();
                        for (Attribute attr : hnj.chEntity.getAttributes()) {
                            if (!attr.getGeneratorID().equalsIgnoreCase(hnj.relation.getObjectID())) continue;
                            chpList.add(attr);
                        }
                    }
                }
            }
            hn.bName = bname;
            hn.schema = schema;
            this.dimensions.add(hn);
        }
    }

    private Level findLowestLevel(List list) {
        Level level = null;
        int lsize = list.size();
        for (int i = 0; i < lsize; ++i) {
            List tlist = (List)list.get(i);
            level = (Level)tlist.get(0);
            for (int j = 0; j < lsize; ++j) {
                List t2list;
                if (i == j || (t2list = (List)list.get(j)).indexOf(level) <= 0) continue;
                level = null;
                break;
            }
            if (level == null) continue;
            return level;
        }
        return level;
    }

    private void processCubeModel(NodeList nodes) {
        this.cubemodels.clear();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Element elem = (Element)nodes.item(i);
            String bname = elem.getAttribute("businessName");
            String name = elem.getAttribute("name");
            String schema = elem.getAttribute("schema");
            NodeList factsref = elem.getElementsByTagName("factsRef");
            if (factsref.getLength() == 1) {
                Element fact = (Element)factsref.item(0);
                String cubeName = fact.getAttribute("name");
                Cube cube = (Cube)this.getDesign().getMultidimensionalDesign().getCubeSet().getByName(cubeName);
                if (cube != null) {
                    NodeList dimInfos = elem.getElementsByTagName("dimensionInfo");
                    int diCount = dimInfos.getLength();
                    for (int j = 0; j < diCount; ++j) {
                        Element dimInfo = (Element)dimInfos.item(j);
                        NodeList dRefs = dimInfo.getElementsByTagName("dimensionRef");
                        Element dimRef = (Element)dRefs.item(0);
                        NodeList jRefs = dimInfo.getElementsByTagName("joinRef");
                        Element joinRef = (Element)jRefs.item(0);
                        HelpNode hnd = this.findNodeByName(this.dimensions, dimRef.getAttribute("name"));
                        HelpNode hnj = this.findNodeByName(this.joins, joinRef.getAttribute("name"));
                        if (hnj == null || hnd == null) continue;
                        Link link = cube.getFirstLinkToTarget(hnd.dimension);
                        if (link == null) {
                            AbstractMDTV tv1 = (AbstractMDTV)cube.getTopView();
                            AbstractMDTV tv2 = (AbstractMDTV)hnd.dimension.getTopView();
                            if (tv1 != null && tv2 != null) {
                                link = this.getDesign().getMultidimensionalDesign().createLink();
                                link.setSourceTV(tv1);
                                link.setTargetTV(tv2);
                                ((TVLink)link.getTopView()).addConnection();
                            }
                        } else {
                            List chpList = link.getRollupLink().getChildToParentAttributes();
                            chpList.clear();
                            if (cube.getFactEntity() != null) {
                                ContainedObject[] elms = cube.getFactEntity().getElements();
                                for (int e = 0; e < elms.length; ++e) {
                                    ContainedObject attr = elms[e];
                                    if (!attr.getGeneratorID().equalsIgnoreCase(hnj.relation.getObjectID())) continue;
                                    chpList.add(attr);
                                }
                            }
                        }
                        this.setLevelKeys(hnd.dimension, hnj.parEntity);
                    }
                }
            }
            HelpNode hn = new HelpNode(name);
            hn.bName = bname;
            hn.schema = schema;
            this.cubemodels.add(hn);
        }
    }

    private void setLevelKeys(Dimension dim, Entity baseEntity) {
        for (Hierarchy hier : dim.getHierarchies()) {
            Level level;
            if (hier.getLevels().size() <= 0 || (level = (Level)hier.getLevels().get(0)).getLevelEntity() != baseEntity) continue;
            List klist = level.getLevelKey();
            List dlist = level.getDescriptiveAttributes();
            for (int p = 0; p < klist.size(); ++p) {
                dlist.add(p, klist.get(p));
            }
            klist.clear();
            klist.addAll(baseEntity.getPK().getElementsCollection());
            return;
        }
    }

    private String noBrackets(String name) {
        int ind = name.indexOf(40);
        if (ind > -1) {
            return name.substring(0, ind);
        }
        return name;
    }

    private HelpNode findNodeByName(ArrayList col, String name) {
        for (HelpNode hn : col) {
            if (!hn.name.equalsIgnoreCase(name)) continue;
            return hn;
        }
        return null;
    }

    private Domain createDomain(String nativeDataType, String rdbmsSite, String size, String scale) {
        String[] parameters = new String[3];
        if (nativeDataType != null) {
            String nativeDataTypeUpperCased = nativeDataType.toUpperCase();
            if (scale.equalsIgnoreCase("0") && (nativeDataTypeUpperCased.indexOf("CHAR") > -1 || nativeDataTypeUpperCased.indexOf("GRAPHIC") > -1 || nativeDataTypeUpperCased.indexOf("BLOB") > -1)) {
                parameters[2] = size;
            } else {
                parameters[0] = size;
                parameters[1] = scale;
            }
            String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(nativeDataType);
            LogicalDatatype logicalDT = this.factoryLogical.searchLogicalDatatype(this.getDesign(), nameLogDT);
            return this.factory.getInstance(this.getDesign(), logicalDT, null, 3, parameters, null);
        }
        return null;
    }

    class HelpNode {
        String name;
        String colName;
        String tableName;
        String funcName;
        String bName;
        String schema;
        ArrayList levels = new ArrayList();
        ArrayList links = new ArrayList();
        List helpNode2List = new ArrayList();
        String template = "";
        Relation relation;
        Level level;
        Cube cube;
        List aggrFunctions = new ArrayList();
        boolean calculatedAttribute = false;
        Attribute attribute;
        Entity chEntity;
        Entity parEntity;
        Dimension dimension;

        HelpNode(String name) {
            this.name = name;
        }
    }

    class HelpNode2 {
        int type = -1;
        String name;
        String tablename;

        HelpNode2(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

