/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.git;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DMGitCellRenderer;
import oracle.dbtools.crest.swingui.DMGitStringCellRenderer;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationRevert;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class DMGITOperationRevert
extends GITOperationRevert {
    VCSStatus[] status = null;
    Locatable[] items = null;
    URL[] urls = null;

    public DMGITOperationRevert() {
    }

    protected DMGITOperationRevert(String id) {
        super(id);
    }

    protected boolean isAvailableImpl() throws Exception {
        return super.isAvailableImpl();
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        String hint = this.getDialogHint();
        JEWTDialog dialog = this.createOperationDialogImpl(nodes, customizer, commandState);
        if (hint != null && !hint.isEmpty()) {
            DialogHeader header = new DialogHeader();
            header.setHeaderDescription(hint);
            dialog.setDialogHeader((Component)header);
        }
        return dialog;
    }

    protected JEWTDialog createOperationDialogImpl(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        VersionOperationPanel vop = VCSComponents.createFileListerComponent((Collection)nodes, (TableCellRenderer)this.createFileListerRenderer());
        vop.setDefaultRenderer(String.class, (TableCellRenderer)new DMGitStringCellRenderer());
        vop.setDefaultRenderer(Displayable.class, (TableCellRenderer)((Object)new DMGitCellRenderer()));
        JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), null, (Component)vop, (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
        return dialog;
    }

    protected VCSDirectoryInvokable createDirectoryInvokable(VCSProfile profile, CommandState commandState, Map options) {
        ArrayList<URL> list = new ArrayList<URL>();
        for (Locatable l : this.items = commandState.getLocatables()) {
            list.add(l.getURL());
        }
        this.urls = list.toArray(new URL[0]);
        try {
            this.status = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getStatus(this.urls);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DMDirectoryInvokable(commandState.getInvokableState());
    }

    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        try {
            super.postInvoke(profile, commandState);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GitClientHelper.postProcessRevert(this.urls, this.status);
    }

    protected class DMDirectoryInvokable
    extends VCSDirectoryInvokable {
        DMDirectoryInvokable(VCSDirectoryInvokableState state) {
            super((VCSInvokableState)state, 10, false);
        }

        protected boolean doInvocation(URL parent, URL[] children) throws Exception {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get((String)"REVERT_OPERATION"));
            GitClient client = null;
            monitor.setLog(true);
            try {
                client = GITClientAdaptor.getClient((URL)parent);
                if (children.length > 0) {
                    URL url = children[0];
                    Design d = ApplicationView.getInstance().getDesignForURL(url);
                    if (d != null) {
                        client.addNotificationListener((NotificationListener)d.getDelegateListener());
                    }
                }
                Collection files = GITUtil.convertURLToFile((URL[])children);
                client.checkout(files.toArray(new File[0]), "HEAD", true, (ProgressMonitor)monitor);
                if (monitor.getError() != null) {
                    throw new GITProcessException(Resource.get((String)"PROCESS_EXCEPTION_REVERT_ERROR"), monitor.getError());
                }
            }
            catch (GitException ge) {
                GITProfile.getQualifiedLogger((String)GITOperationRevert.class.getName()).warning(ge.getMessage());
                throw new GITProcessException(Resource.get((String)"PROCESS_EXCEPTION_REVERT_ERROR"), (Exception)((Object)ge));
            }
            finally {
                monitor.logCompleted();
                if (client != null) {
                    client.release();
                }
            }
            return true;
        }
    }
}

