/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.git;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.util.TimeLog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationMerge;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class DMGITOperationMerge
extends GITOperationMerge {
    private Collection<File> failures;
    private Collection<File> conflicts;
    private GitMergeResult.MergeStatus status;
    Map<File, GitClientHelper.FileDescriptor> updated;

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        String revision = (String)options.get("Git-use-revision");
        Collection<URL> processed = this.merge(revision, (URL)options.get("Git-local-root"));
        this.setProcessedUrls(commandState, processed.toArray(new URL[0]));
        return true;
    }

    private Collection<URL> merge(String revision, URL root) throws GITProcessException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get((String)"MERGE_OPERATION"));
        GitClient client = null;
        HashSet<URL> urls = new HashSet<URL>();
        HashSet<File> reloadFiles = new HashSet<File>();
        monitor.setLog(true);
        try {
            client = GITClientAdaptor.getClient((URL)root);
            GitMergeResult result = client.merge(revision, (ProgressMonitor)monitor);
            this.updated = this.getProcessedFiles(client, result);
            if (this.updated != null && this.updated.size() > 0) {
                for (File file : this.updated.keySet()) {
                    URL url = URLFactory.newFileURL((File)file);
                    urls.add(url);
                }
                GitClientHelper.logUpdatedFiles(this.updated.values());
                reloadFiles.addAll(this.updated.keySet());
            }
            GitMergeResult.MergeStatus ms = result.getMergeStatus();
            GitClientHelper.log(TimeLog.getTime() + "  Merge result - " + ms.name() + "\n");
            GitClientHelper.log("For commits: " + result.getMergedCommits()[0] + " , " + result.getMergedCommits()[1] + "\n");
            GitClientHelper.logMergeConflicts(result.getConflicts());
            GitClientHelper.logMergeFailures(result.getFailures());
            this.failures = result.getFailures();
            this.conflicts = result.getConflicts();
            this.status = result.getMergeStatus();
            this.setFailures(Collections.EMPTY_LIST);
            this.setConflicts(Collections.EMPTY_LIST);
            this.postUpdate(reloadFiles);
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger((String)DMGITOperationMerge.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.get((String)"PROCESS_EXCEPTION_MERGE_ERROR"), e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return urls;
    }

    private Collection<File> fileToUpdate(GitClient client, GITCommandProgressMonitor monitor, GitTransportUpdate update) throws GitException, GitException.MissingObjectException {
        return GITUtil.getModifiedFiles((GitClient)client, (String)update.getOldObjectId(), (String)update.getNewObjectId(), (GITCommandProgressMonitor)monitor);
    }

    private void postUpdate(Collection<File> reloadFiles) {
        if (reloadFiles.isEmpty()) {
            return;
        }
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (this.updated != null && this.updated.size() > 0) {
            GitClientHelper.updateChangedDesigns(this.updated.values());
        }
        for (File file : reloadFiles) {
            urls.add(URLFactory.newFileURL((File)file));
        }
        profile.getPolicyStatusCache().clear(urls.toArray(new URL[0]));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VCSBufferUtils.reloadBuffer((URL[])urls.toArray(new URL[0]));
            }
        });
    }

    private Map<File, GitClientHelper.FileDescriptor> getProcessedFiles(GitClient client, GitMergeResult result) throws GitException, GitException.MissingObjectException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
        HashMap<File, GitClientHelper.FileDescriptor> modifiedFiles = new HashMap<File, GitClientHelper.FileDescriptor>();
        monitor.setLog(false);
        for (String commit : result.getMergedCommits()) {
            GitRevisionInfo info = client.log(commit, (ProgressMonitor)monitor);
            Map m = info.getModifiedFiles();
            long commitTime = info.getCommitTime();
            for (File f : m.keySet()) {
                GitRevisionInfo.GitFileInfo gfi = (GitRevisionInfo.GitFileInfo)m.get(f);
                GitClientHelper.FileDescriptor fd = (GitClientHelper.FileDescriptor)modifiedFiles.get(f);
                if (fd == null) {
                    fd = new GitClientHelper.FileDescriptor();
                    fd.file = f;
                    modifiedFiles.put(f, fd);
                }
                fd.setOperation(gfi.getStatus(), commitTime);
            }
        }
        return modifiedFiles;
    }

    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
        try {
            if (this.conflicts != null && this.conflicts.size() > 0) {
                List<GitStatus> list = GitClientHelper.getConflictsForFiles(this.conflicts.toArray(new File[0]));
                GitClientHelper.fixBrokenFiles(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GitClientHelper.reportMergeFailures(this.failures);
        GitClientHelper.reportMergeConflicts(this.conflicts);
    }

    protected boolean saveDirtyNodes(Locatable[] contextLocatables) throws Exception {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        URL[] urls = VCSContextUtils.getVersionEditorUrls((VCSProfile)profile);
        Node[] nodes = this.getNodes(urls);
        URLFilter filter = this.getProfile().getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
        Collection ns = VCSCommandUtils.getDirtyNodesFrom((URLFilter)filter, (Locatable[])nodes);
        for (Node n : ns) {
            String s;
            if (!(n instanceof Workspace) || (s = ((Workspace)n).getProperty(GitClientHelper.MODELER_PATHS)) == null || s.isEmpty()) continue;
            n.markDirty(false);
        }
        return VCSCommandUtils.saveDirtyNodes((Locatable[])nodes);
    }
}

