/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelPhysicalDB2Preferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelPhysicalDB2PP";
    private static final String DO = "db2_owner";
    private static final String DD = "db2_database";
    private static final String NR_T = "naming_rule_tablespace_db2";
    private static final String NR_ST_T = "naming_rule_st_tablespace_db2";
    private static final String NR_ST_IDX = "naming_rule_st_index_db2";
    private static final String NEW_T_T = "new_db2_tablespace_per_table";
    private static final String NEW_ST_T = "new_db2_storagetemplate_per_tablesapce";
    private static final String NEW_ST_IDX = "new_db2_storagetemplate_per_index";
    private static final String ONE_ST_TS = "one_db2_storagetemplate_per_ts";
    private static final String ONE_ST_IDX = "one_db2_storagetemplate_per_index";
    private static final String DEF_TS_ST_NAME = "default_ts_storagetemplate_name";
    private static final String DEF_I_ST_NAME = "default_index_storagetemplate_name";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelPhysicalDB2Preferences(HashStructure hash) {
        super(hash);
    }

    public static ModelPhysicalDB2Preferences getInstance(PropertyStorage prefs) {
        return new ModelPhysicalDB2Preferences(ModelPhysicalDB2Preferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public String getDefaultDB2Owner() {
        return this._hash.getString(DO);
    }

    public void setDefaultDB2Owner(String defaultDB2Owner) {
        this._hash.putString(DO, defaultDB2Owner);
    }

    public String getDefaultDB2Database() {
        return this._hash.getString(DD);
    }

    public void setDefaultDB2Database(String defaultDB2Database) {
        this._hash.putString(DD, defaultDB2Database);
    }

    public String getNamingRuleTablespaceDB2() {
        return this._hash.getString(NR_T);
    }

    public void setNamingRuleTablespaceDB2(String namingRuleTablespaceDB2) {
        this._hash.putString(NR_T, namingRuleTablespaceDB2);
    }

    public String getNamingRuleStTablespaceDB2() {
        return this._hash.getString(NR_ST_T);
    }

    public void setNamingRuleStTablespaceDB2(String namingRuleStTablespaceDB2) {
        this._hash.putString(NR_ST_T, namingRuleStTablespaceDB2);
    }

    public String getNamingRuleStIndexDB2() {
        return this._hash.getString(NR_ST_IDX);
    }

    public void setNamingRuleStIndexDB2(String namingRuleStIndexDB2) {
        this._hash.putString(NR_ST_IDX, namingRuleStIndexDB2);
    }

    public String getDefaultTSStorageTemplateName() {
        return this._hash.getString(DEF_TS_ST_NAME);
    }

    public void setDefaultTSStorageTemplateName(String stName) {
        this._hash.putString(DEF_TS_ST_NAME, stName);
    }

    public String getDefaultIndexStorageTemplateName() {
        return this._hash.getString(DEF_I_ST_NAME);
    }

    public void setDefaultIndexStorageTemplateName(String stName) {
        this._hash.putString(DEF_I_ST_NAME, stName);
    }

    public boolean isNewStorageTemplatePerTS() {
        return this._hash.getBoolean(NEW_ST_T);
    }

    public void setNewStorageTemplatePerTS(boolean newStorageTemplatePerTS) {
        this._hash.putBoolean(NEW_ST_T, newStorageTemplatePerTS);
    }

    public boolean isNewStorageTemplatePerIndex() {
        return this._hash.getBoolean(NEW_ST_IDX);
    }

    public void setNewStorageTemplatePerIndex(boolean newStorageTemplatePerIndex) {
        this._hash.putBoolean(NEW_ST_IDX, newStorageTemplatePerIndex);
    }

    public boolean isOneStorageTemplateForTS() {
        return this._hash.getBoolean(ONE_ST_TS);
    }

    public void setOneStorageTemplateForTS(boolean oneStorageTemplateForTS) {
        this._hash.putBoolean(ONE_ST_TS, oneStorageTemplateForTS);
    }

    public boolean isOneStorageTemplateForIndex() {
        return this._hash.getBoolean(ONE_ST_IDX);
    }

    public void setOneStorageTemplateForIndex(boolean oneStorageTemplateForIndex) {
        this._hash.putBoolean(ONE_ST_IDX, oneStorageTemplateForIndex);
    }

    public boolean isNewTSPerTable() {
        return this._hash.getBoolean(NEW_T_T);
    }

    public void setNewTSPerTable(boolean newTSPerTable) {
        this._hash.putBoolean(NEW_T_T, newTSPerTable);
    }

    public String getDefaultDB2TriggerName() {
        return this._hash.getString("db2_trigger_name");
    }

    public void setDefaultDB2TriggerName(String defaultDB2TriggerName) {
        this._hash.putString("db2_trigger_name", defaultDB2TriggerName);
    }

    public String getDefaultDB2SequenceName() {
        return this._hash.getString("db2_sequence_name");
    }

    public void setDefaultDB2SequenceName(String defaultDB2SequenceName) {
        this._hash.putString("db2_sequence_name", defaultDB2SequenceName);
    }

    public String getDefaultDB2AutoIncDDL() {
        return this._hash.getString("db2_auto_inc_ddl");
    }

    public void setDefaultDB2AutoIncDDL(String defaultDB2AutoIncDDL) {
        this._hash.putString("db2_auto_inc_ddl", defaultDB2AutoIncDDL);
    }

    public String getDefaultDB2IdentityDDL() {
        return this._hash.getString("db2_identity_ddl");
    }

    public void setDefaultDB2IdentityDDL(String defaultDB2IdentityDDL) {
        this._hash.putString("db2_identity_ddl", defaultDB2IdentityDDL);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(DO)) {
            settings.setDefaultDB2Owner(this.getDefaultDB2Owner());
        }
        if (this.contains(DD)) {
            settings.setDefaultDB2Database(this.getDefaultDB2Database());
        }
        if (this.contains(NR_T)) {
            settings.setNamingRuleTablespaceDB2(this.getNamingRuleTablespaceDB2());
        }
        if (this.contains(NR_ST_T)) {
            settings.setNamingRuleStTablespaceDB2(this.getNamingRuleStTablespaceDB2());
        }
        if (this.contains(NR_ST_IDX)) {
            settings.setNamingRuleStIndexDB2(this.getNamingRuleStIndexDB2());
        }
        if (this.contains(NEW_T_T)) {
            settings.setNewDB2TableSpacePerTable(this.isNewTSPerTable());
        }
        if (this.contains(NEW_ST_T)) {
            settings.setNewDB2StorageTemplatePerTableSpace(this.isNewStorageTemplatePerTS());
        }
        if (this.contains(NEW_ST_IDX)) {
            settings.setNewDB2StorageTemplatePerIndex(this.isNewStorageTemplatePerIndex());
        }
        if (this.contains(ONE_ST_TS)) {
            settings.setOneDB2StorageTemplatePerTS(this.isOneStorageTemplateForTS());
        }
        if (this.contains(ONE_ST_IDX)) {
            settings.setOneDB2StorageTemplatePerIndex(this.isOneStorageTemplateForIndex());
        }
        if (this.contains(DEF_TS_ST_NAME)) {
            settings.setDefaultTSStorageTemplateName(this.getDefaultTSStorageTemplateName());
        }
        if (this.contains(DEF_I_ST_NAME)) {
            settings.setDefaultIndexStorageTemplateName(this.getDefaultIndexStorageTemplateName());
        }
        if (this.contains("db2_trigger_name")) {
            settings.setDefaultDB2TriggerName(this.getDefaultDB2TriggerName());
        }
        if (this.contains("db2_sequence_name")) {
            settings.setDefaultDB2SequenceName(this.getDefaultDB2SequenceName());
        }
        if (this.contains("db2_auto_inc_ddl")) {
            settings.setDefaultDB2AutoIncDDL(this.getDefaultDB2AutoIncDDL());
        }
        if (this.contains("db2_identity_ddl")) {
            settings.setDefaultDB2IdentityDDL(this.getDefaultDB2IdentityDDL());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setDefaultDB2Database(settings.getDefaultDB2Database());
        this.setDefaultDB2Owner(settings.getDefaultDB2Owner());
        this.setNamingRuleTablespaceDB2(settings.getNamingRuleTablespaceDB2());
        this.setNamingRuleStTablespaceDB2(settings.getNamingRuleStTablespaceDB2());
        this.setNamingRuleStIndexDB2(settings.getNamingRuleStIndexDB2());
        this.setNewTSPerTable(settings.newDB2TableSpacePerTable());
        this.setNewStorageTemplatePerTS(settings.newDB2StorageTemplatePerTableSpace());
        this.setNewStorageTemplatePerIndex(settings.newDB2StorageTemplatePerIndex());
        this.setOneStorageTemplateForTS(settings.oneDB2StorageTemplatePerTS());
        this.setOneStorageTemplateForIndex(settings.oneDB2StorageTemplatePerIndex());
        this.setDefaultTSStorageTemplateName(settings.getDefaultTSStorageTemplateName());
        this.setDefaultIndexStorageTemplateName(settings.getDefaultIndexStorageTemplateName());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

